if (typeof _editor_url == "string"){

 _editor_url = _editor_url.replace(/\x2f*$/, '/');
}else{
 alert("WARNING: _editor_url is not set! You should set this variable to the editor files path; it should preferably be an absolute path, like in '/htmlarea', but it can be relative if you prefer. Further we will try to load the editor files correctly but we'll probably fail.");
 _editor_url = '';
}
if (typeof _editor_lang == "string"){
 _editor_lang = _editor_lang.toLowerCase();
}else{
 _editor_lang = "en";
}
HTMLArea.checkSupportedBrowser = function(){
 if (HTMLArea.is_gecko){
 if (navigator.productSub < 20021201){
 alert("You need at least Mozilla-1.3 Alpha.\n" +
 "Sorry, your Gecko is not supported.");
 return false;
}
 if (navigator.productSub < 20030210){
 alert("Mozilla < 1.3 Beta is not supported!\n" +
 "I'll try, though, but it might not work.");
}
}
 return HTMLArea.is_gecko || HTMLArea.is_ie;
};
function HTMLArea(textarea, config){
 if (HTMLArea.checkSupportedBrowser()){
 if (typeof config == "undefined"){
 this.config = new HTMLArea.Config();
}else{
 this.config = config;
}
 this._htmlArea = null;
 this._textArea = textarea;
 this._editMode = "wysiwyg";
 this.plugins ={};
 this._timerToolbar = null;
 this._timerUndo = null;
 this._undoQueue = new Array(this.config.undoSteps);
 this._undoPos = -1;
 this._customUndo = false;
 this._mdoc = document;
 this.doctype = '';
}
};
var scripts = HTMLArea._scripts = [_editor_url + "htmlarea.js"];
HTMLArea.RE_tagName = /(<\/|<)\s*([^ \t\n>]+)/ig;
HTMLArea.RE_doctype = /(<!doctype((.|\n)*?)>)\n?/i;
HTMLArea.RE_head = /<head>((.|\n)*?)<\/head>/i;
HTMLArea.RE_body = /<body>((.|\n)*?)<\/body>/i;
HTMLArea.Config = function (){
 this.version = "3.0";
 this.width = "auto";
 this.height = "auto";

 this.statusBar = false;

 this.undoSteps = 20;

 this.undoTimeout = 500;


 this.sizeIncludesToolbar = true;


 this.fullPage = false;

 this.pageStyle = "";

 this.killWordOnPaste = false;

 this.baseURL = document.baseURI || document.URL;
 if (this.baseURL && this.baseURL.match(/(.*)\/([^\/]+)/))
 this.baseURL = RegExp.$1 + "/";

 this.imgURL = "images/";
 this.popupURL = "popups/";
 this.toolbar = [
 [ "fontname", "space",
 "fontsize", "space",
 "formatblock", "space",
 "bold", "italic", "underline", "strikethrough", "separator",
 "subscript", "superscript", "separator",
 "copy", "cut", "paste", "space", "undo", "redo" ],
 [ "justifyleft", "justifycenter", "justifyright", "justifyfull", "separator",
 "lefttoright", "righttoleft", "separator",
 "insertorderedlist", "insertunorderedlist", "outdent", "indent", "separator",
 "forecolor", "hilitecolor", "separator",
 "inserthorizontalrule", "insertimage", "separator"/*, "smile"*/]];
 this.fontname ={
 "Arial": 'arial,helvetica,sans-serif',
 "Courier New": 'courier new,courier,monospace',
 "Georgia": 'georgia,times new roman,times,serif',
 "Tahoma": 'tahoma,arial,helvetica,sans-serif',
 "Times New Roman": 'times new roman,times,serif',
 "Verdana": 'verdana,arial,helvetica,sans-serif',
 "impact": 'impact',
 "WingDings": 'wingdings'
};
 this.fontsize ={
 "1 (8 pt)": "1",
 "2 (10 pt)": "2",
 "3 (12 pt)": "3",
 "4 (14 pt)": "4",
 "5 (18 pt)": "5",
 "6 (24 pt)": "6",
 "7 (36 pt)": "7"
};
 this.formatblock ={
 "Heading 1": "h1",
 "Heading 2": "h2",
 "Heading 3": "h3",
 "Heading 4": "h4",
 "Heading 5": "h5",
 "Heading 6": "h6",
 "Normal": "p",
 "Address": "address",
 "Formatted": "pre"
};
 this.customSelects ={};
 function cut_copy_paste(e, cmd, obj){
 e.execCommand(cmd);
};
 this.btnList ={
 bold: [ "Bold", "ed_format_bold.gif", false, function(e){e.execCommand("bold");}],
 italic: [ "Italic", "ed_format_italic.gif", false, function(e){e.execCommand("italic");}],
 underline: [ "Underline", "ed_format_underline.gif", false, function(e){e.execCommand("underline");}],
 strikethrough: [ "Strikethrough", "ed_format_strike.gif", false, function(e){e.execCommand("strikethrough");}],
 subscript: [ "Subscript", "ed_format_sub.gif", false, function(e){e.execCommand("subscript");}],
 superscript: [ "Superscript", "ed_format_sup.gif", false, function(e){e.execCommand("superscript");}],
 justifyleft: [ "Justify Left", "ed_align_left.gif", false, function(e){e.execCommand("justifyleft");}],
 justifycenter: [ "Justify Center", "ed_align_center.gif", false, function(e){e.execCommand("justifycenter");}],
 justifyright: [ "Justify Right", "ed_align_right.gif", false, function(e){e.execCommand("justifyright");}],
 justifyfull: [ "Justify Full", "ed_align_justify.gif", false, function(e){e.execCommand("justifyfull");}],
 insertorderedlist: [ "Ordered List", "ed_list_num.gif", false, function(e){e.execCommand("insertorderedlist");}],
 insertunorderedlist: [ "Bulleted List", "ed_list_bullet.gif", false, function(e){e.execCommand("insertunorderedlist");}],
 outdent: [ "Decrease Indent", "ed_indent_less.gif", false, function(e){e.execCommand("outdent");}],
 indent: [ "Increase Indent", "ed_indent_more.gif", false, function(e){e.execCommand("indent");}],
 forecolor: [ "Font Color", "ed_color_fg.gif", false, function(e){e.execCommand("forecolor");}],
 hilitecolor: [ "Background Color", "ed_color_bg.gif", false, function(e){e.execCommand("hilitecolor");}],
 inserthorizontalrule: [ "Horizontal Rule", "ed_hr.gif", false, function(e){e.execCommand("inserthorizontalrule");}],
 insertimage: [ "Insert/Modify Image", "ed_image.gif", false, function(e){e.execCommand("insertimage");}],
 //smile: [ "Insert Smile", "insert_smile.gif", false, function(e){e.execCommand("smile");}],
 about: [ "About this editor", "ed_about.gif", true, function(e){e.execCommand("about");}],
 showhelp: [ "Help using editor", "ed_help.gif", true, function(e){e.execCommand("showhelp");}],
 undo: [ "Undoes your last action", "ed_undo.gif", false, function(e){e.execCommand("undo");}],
 redo: [ "Redoes your last action", "ed_redo.gif", false, function(e){e.execCommand("redo");}],
 cut: [ "Cut selection", "ed_cut.gif", false, cut_copy_paste ],
 copy: [ "Copy selection", "ed_copy.gif", false, cut_copy_paste ],
 paste: [ "Paste from clipboard", "ed_paste.gif", false, cut_copy_paste ],
 lefttoright: [ "Direction left to right", "ed_left_to_right.gif", false, function(e){e.execCommand("lefttoright");}],
 righttoleft: [ "Direction right to left", "ed_right_to_left.gif", false, function(e){e.execCommand("righttoleft");}]
};

 for (var i in this.btnList){
 var btn = this.btnList[i];
 btn[1] = _editor_url + this.imgURL + btn[1];
 if (typeof HTMLArea.I18N.tooltips[i] != "undefined"){
 btn[0] = HTMLArea.I18N.tooltips[i];
}
}
};
HTMLArea.Config.prototype.registerButton = function(id, tooltip, image, textMode, action, context){
 var the_id;
 if (typeof id == "string"){
 the_id = id;
}else if (typeof id == "object"){
 the_id = id.id;
}else{
 alert("ERROR [HTMLArea.Config::registerButton]:\ninvalid arguments");
 return false;
}

 if (typeof this.customSelects[the_id] != "undefined"){

}
 if (typeof this.btnList[the_id] != "undefined"){

}
 switch (typeof id){
 case "string": this.btnList[id] = [ tooltip, image, textMode, action, context ]; break;
 case "object": this.btnList[id.id] = [ id.tooltip, id.image, id.textMode, id.action, id.context ]; break;
}
};
HTMLArea.Config.prototype.registerDropdown = function(object){

 if (typeof this.customSelects[object.id] != "undefined"){

}
 if (typeof this.btnList[object.id] != "undefined"){

}
 this.customSelects[object.id] = object;
};
HTMLArea.Config.prototype.hideSomeButtons = function(remove){
 var toolbar = this.toolbar;
 for (var i in toolbar){
 var line = toolbar[i];
 for (var j = line.length; --j >= 0; ){
 if (remove.indexOf(" " + line[j] + " ") >= 0){
 var len = 1;
 if (/separator|space/.test(line[j + 1])){
 len = 2;
}
 line.splice(j, len);
}
}
}
};
HTMLArea.replaceAll = function(config){
 var tas = document.getElementsByTagName("textarea");
 for (var i = tas.length; i > 0; (new HTMLArea(tas[--i], config)).generate());
};
HTMLArea.replace = function(id, config){
 var ta = HTMLArea.getElementById("textarea", id);
 return ta ? (new HTMLArea(ta, config)).generate() : null;
};
HTMLArea.prototype._createToolbar = function (){
 var editor = this;
 var toolbar = document.createElement("div");
 this._toolbar = toolbar;
 toolbar.className = "toolbar";
 toolbar.unselectable = "1";
 var tb_row = null;
 var tb_objects = new Object();
 this._toolbarObjects = tb_objects;

 function newLine(){
 var table = document.createElement("table");
 table.border = "0px";
 table.cellSpacing = "0px";
 table.cellPadding = "0px";
 toolbar.appendChild(table);


 var tb_body = document.createElement("tbody");
 table.appendChild(tb_body);
 tb_row = document.createElement("tr");
 tb_body.appendChild(tb_row);
};

 newLine();
 function setButtonStatus(id, newval){
 var oldval = this[id];
 var el = this.element;
 if (oldval != newval){
 switch (id){
 case "enabled":
 if (newval){
 HTMLArea._removeClass(el, "buttonDisabled");
 el.disabled = false;
}else{
 HTMLArea._addClass(el, "buttonDisabled");
 el.disabled = true;
}
 break;
 case "active":
 if (newval){
 HTMLArea._addClass(el, "buttonPressed");
}else{
 HTMLArea._removeClass(el, "buttonPressed");
}
 break;
}
 this[id] = newval;
}
};
 function createSelect(txt){
 var options = null;
 var el = null;
 var cmd = null;
 var customSelects = editor.config.customSelects;
 var context = null;
 switch (txt){
 case "fontsize":
 case "fontname":
 case "formatblock":
 options = editor.config[txt];
 cmd = txt;
 break;
 default:

 cmd = txt;
 var dropdown = customSelects[cmd];
 if (typeof dropdown != "undefined"){
 options = dropdown.options;
 context = dropdown.context;
}else{
 alert("ERROR [createSelect]:\nCan't find the requested dropdown definition");
}
 break;
}
 if (options){
 el = document.createElement("select");
 var obj ={
 name : txt,
 element : el,
 enabled : true,
 text : false,
 cmd : cmd,
 state : setButtonStatus,
 context : context
};
 tb_objects[txt] = obj;
 for (var i in options){
 var op = document.createElement("option");
 op.appendChild(document.createTextNode(i));
 op.value = options[i];
 el.appendChild(op);
}
 HTMLArea._addEvent(el, "change", function (){
 editor._comboSelected(el, txt);
});
}
 return el;
};

 function createButton(txt){

 var el = null;
 var btn = null;
 switch (txt){
 case "separator":
 el = document.createElement("div");
 el.className = "separator";
 break;
 case "space":
 el = document.createElement("div");
 el.className = "space";
 break;
 case "linebreak":
 newLine();
 return false;
 case "textindicator":
 el = document.createElement("div");
 el.appendChild(document.createTextNode("A"));
 el.className = "indicator";
 el.title = HTMLArea.I18N.tooltips.textindicator;
 var obj ={
 name : txt,
 element : el,
 enabled : true,
 active : false,
 text : false,
 cmd : "textindicator",
 state : setButtonStatus
};
 tb_objects[txt] = obj;
 break;
 default:
 btn = editor.config.btnList[txt];
}
 if (!el && btn){
 el = document.createElement("div");
 el.title = btn[0];
 el.className = "button";
 var obj ={
 name : txt,
 element : el,
 enabled : true,
 active : false,
 text : btn[2],
 cmd : btn[3],
 state : setButtonStatus,
 context : btn[4] || null
};
 tb_objects[txt] = obj;

 HTMLArea._addEvent(el, "mouseover", function (){
 if (obj.enabled){
 HTMLArea._addClass(el, "buttonHover");
}
});
 HTMLArea._addEvent(el, "mouseout", function (){
 if (obj.enabled) with (HTMLArea){
 _removeClass(el, "buttonHover");
 _removeClass(el, "buttonActive");
 (obj.active) && _addClass(el, "buttonPressed");
}
});
 HTMLArea._addEvent(el, "mousedown", function (ev){
 if (obj.enabled) with (HTMLArea){
 _addClass(el, "buttonActive");
 _removeClass(el, "buttonPressed");
 _stopEvent(is_ie ? window.event : ev);
}
});

 HTMLArea._addEvent(el, "click", function (ev){
 if (obj.enabled) with (HTMLArea){
 _removeClass(el, "buttonActive");
 _removeClass(el, "buttonHover");
 obj.cmd(editor, obj.name, obj);
 _stopEvent(is_ie ? window.event : ev);
}
});
 var img = document.createElement("img");
 img.src = btn[1];
 img.style.width = "18px";
 img.style.height = "18px";
 el.appendChild(img);
}else if (!el){
 el = createSelect(txt);
}
 if (el){
 var tb_cell = document.createElement("td");
 tb_row.appendChild(tb_cell);
 tb_cell.appendChild(el);
}else{
 alert("FIXME: Unknown toolbar item: " + txt);
}
 return el;
};
 var first = true;
 for (var i in this.config.toolbar){
 if (!first){
 createButton("linebreak");
}else{
 first = false;
}
 var group = this.config.toolbar[i];
 for (var j in group){
 var code = group[j];
 if (/^([IT])\[(.*?)\]/.test(code)){

 var l7ed = RegExp.$1 == "I";
 var label = RegExp.$2;
 if (l7ed){
 label = HTMLArea.I18N.custom[label];
}
 var tb_cell = document.createElement("td");
 tb_row.appendChild(tb_cell);
 tb_cell.className = "label";
 tb_cell.innerHTML = label;
}else{
 createButton(code);
}
}
}
 this._htmlArea.appendChild(toolbar);
};
HTMLArea.prototype._createStatusBar = function(){
 var statusbar = document.createElement("div");
 statusbar.className = "statusBar";
 this._htmlArea.appendChild(statusbar);
 this._statusBar = statusbar;
 div = document.createElement("span");
 div.className = "statusBarTree";
 div.innerHTML = HTMLArea.I18N.msg["Path"] + ": ";
 this._statusBarTree = div;
 this._statusBar.appendChild(div);
 if (!this.config.statusBar){

 statusbar.style.display = "none";
}
};
HTMLArea.prototype.generate = function (){
 var editor = this;

 var textarea = this._textArea;
 if (typeof textarea == "string"){

 this._textArea = textarea = HTMLArea.getElementById("textarea", textarea);
}
 this._ta_size ={
 w: textarea.offsetWidth,
 h: textarea.offsetHeight
};
 textarea.style.display = "none";

 var htmlarea = document.createElement("div");
 htmlarea.className = "htmlarea";
 this._htmlArea = htmlarea;

 textarea.parentNode.insertBefore(htmlarea, textarea);
 if (textarea.form){


 var f = textarea.form;
 if (typeof f.onsubmit == "function"){
 var funcref = f.onsubmit;
 if (typeof f.__msh_prevOnSubmit == "undefined"){
 f.__msh_prevOnSubmit = [];
}
 f.__msh_prevOnSubmit.push(funcref);
}
 f.onsubmit = function(){
 editor._textArea.value = editor.getHTML();
 var a = this.__msh_prevOnSubmit;

 if (typeof a != "undefined"){
 for (var i in a){
 a[i]();
}
}
};
}


 window.onunload = function(){
 editor._textArea.value = editor.getHTML();
};

 this._createToolbar();

 var iframe = document.createElement("iframe");
 iframe.src="empty.html";
 htmlarea.appendChild(iframe);
 this._iframe = iframe;

 this._createStatusBar();

 var height = (this.config.height == "auto" ? (this._ta_size.h + "px") : this.config.height);
 height = parseInt(height);
 if (!HTMLArea.is_ie) height -= 2;
 width = "100%";
 iframe.style.width = width;
 if (this.config.sizeIncludesToolbar){

 height -= this._toolbar.offsetHeight;
 height -= this._statusBar.offsetHeight;
}
 if (height < 0){
 height = 0;
}
 iframe.style.height = height + "px";


 textarea.style.width = iframe.style.width;
 textarea.style.height = iframe.style.height;


 function initIframe(){
 var doc = editor._iframe.contentWindow.document;
 if (!doc){



 if (HTMLArea.is_gecko){
 setTimeout(initIframe, 100);
 return false;
}else{
 alert("ERROR: IFRAME can't be initialized.");
}
}
 if (HTMLArea.is_gecko){

 doc.designMode = "on";
}
 editor._doc = doc;
 if (!editor.config.fullPage){
 doc.open();
 var html = "<html>\n";
 html += "<head>\n";
 if (editor.config.baseURL)
 html += '<base href="' + editor.config.baseURL + '" />';
 html += "<style> html,body{border: 0px;}" +
 editor.config.pageStyle + "</style>\n";
 html += "</head>\n";
 html += "<body>\n";
 html += editor._textArea.value;
 html += "</body>\n";
 html += "</html>";
 doc.write(html);
 doc.close();
}else{
 var html = editor._textArea.value;
 if (html.match(HTMLArea.RE_doctype)){
 editor.setDoctype(RegExp.$1);
 html = html.replace(HTMLArea.RE_doctype, "");
}
 doc.open();
 doc.write(html);
 doc.close();
}
 if (HTMLArea.is_ie){



 doc.body.contentEditable = true;
}

 HTMLArea._addEvents
 (doc, ["keydown", "keypress", "mousedown", "mouseup", "drag"],
 function (event){
 return editor._editorEvent(HTMLArea.is_ie ? editor._iframe.contentWindow.event : event);
});

 for (var i in editor.plugins){
 var plugin = editor.plugins[i].instance;
 if (typeof plugin.onGenerate == "function")
 plugin.onGenerate();
}
 setTimeout(function(){
 editor.updateToolbar();
}, 250);
 if (typeof editor.onGenerate == "function")
 editor.onGenerate();
};
 setTimeout(initIframe, 100);
};
HTMLArea.prototype.setMode = function(mode){
 if (typeof mode == "undefined"){
 mode = ((this._editMode == "textmode") ? "wysiwyg" : "textmode");
}
 switch (mode){
 case "textmode":
 this._textArea.value = this.getHTML();
 this._iframe.style.display = "none";
 this._textArea.style.display = "block";
 if (this.config.statusBar){
 this._statusBar.innerHTML = HTMLArea.I18N.msg["TEXT_MODE"];
}
 break;
 case "wysiwyg":
 if (HTMLArea.is_gecko){

 try{
 this._doc.designMode = "off";
}catch(e){};
}
 if (!this.config.fullPage)
 this._doc.body.innerHTML = this.getHTML();
 else
 this.setFullHTML(this.getHTML());
 this._iframe.style.display = "block";
 this._textArea.style.display = "none";
 if (HTMLArea.is_gecko){

 try{
 this._doc.designMode = "on";
}catch(e){};
}
 if (this.config.statusBar){
 this._statusBar.innerHTML = '';
 this._statusBar.appendChild(document.createTextNode(HTMLArea.I18N.msg["Path"] + ": "));
 this._statusBar.appendChild(this._statusBarTree);
}
 break;
 default:
 alert("Mode <" + mode + "> not defined!");
 return false;
}
 this._editMode = mode;
 this.focusEditor();
};
HTMLArea.prototype.setFullHTML = function(html){
 var save_multiline = RegExp.multiline;
 RegExp.multiline = true;
 if (html.match(HTMLArea.RE_doctype)){
 this.setDoctype(RegExp.$1);
 html = html.replace(HTMLArea.RE_doctype, "");
}
 RegExp.multiline = save_multiline;
 if (!HTMLArea.is_ie){
 if (html.match(HTMLArea.RE_head))
 this._doc.getElementsByTagName("head")[0].innerHTML = RegExp.$1;
 if (html.match(HTMLArea.RE_body))
 this._doc.getElementsByTagName("body")[0].innerHTML = RegExp.$1;
}else{
 var html_re = /<html>((.|\n)*?)<\/html>/i;
 html = html.replace(html_re, "$1");
 this._doc.open();
 this._doc.write(html);
 this._doc.close();
 this._doc.body.contentEditable = true;
 return true;
}
};
HTMLArea.prototype.registerPlugin2 = function(plugin, args){
 if (typeof(plugin) == "string"){
 plugin = eval(plugin);
}
 var obj = new plugin(this, args);
 if (obj){
 var clone ={};
 var info = plugin._pluginInfo;
 for (var i in info)
 clone[i] = info[i];
 clone.instance = obj;
 clone.args = args;
 this.plugins[plugin._pluginInfo.name] = clone;
}else
 alert("Can't register plugin " + plugin.toString() + ".");
};
HTMLArea.prototype.registerPlugin = function(){
 var plugin = arguments[0];
 var args = [];
 for (var i = 1; i < arguments.length; ++i)
 args.push(arguments[i]);
 this.registerPlugin2(plugin, args);
};
HTMLArea.loadPlugin = function(pluginName){
 var dir = _editor_url + "plugins/" + pluginName;
 var plugin = pluginName.replace(/([a-z])([A-Z])([a-z])/g,
 function (str, l1, l2, l3){
 return l1 + "-" + l2.toLowerCase() + l3;
}).toLowerCase() + ".js";
 var plugin_file = dir + "/" + plugin;
 var plugin_lang = dir + "/lang/" + _editor_lang + ".js";
 HTMLArea._scripts.push(plugin_file, plugin_lang);
 var tmpapn = [plugin_file,plugin_lang];
 appendscript(tmpapn);


};
HTMLArea.loadStyle = function(style, plugin){
 var url = _editor_url || '';
 if (typeof plugin != "undefined"){
 url += "plugins/" + plugin + "/";
}
 url += style;
 document.write("<style type='text/css'>@import url(" + url + ");</style>");
};

HTMLArea.prototype._wordClean = function(){
 var D = this.getInnerHTML();
 if (D.indexOf('class=Mso') >= 0){

 D = D.replace(/\r\n/g, ' ').
 replace(/\n/g, ' ').
 replace(/\r/g, ' ').
 replace(/\&nbsp\;/g,' ');

 D = D.replace(/ class=[^\s|>]*/gi,'').

 replace(/ style=\"[^>]*\"/gi,'').
 replace(/ align=[^\s|>]*/gi,'');

 D = D.replace(/<b [^>]*>/gi,'<b>').
 replace(/<i [^>]*>/gi,'<i>').
 replace(/<li [^>]*>/gi,'<li>').
 replace(/<ul [^>]*>/gi,'<ul>');

 D = D.replace(/<b>/gi,'<strong>').
 replace(/<\/b>/gi,'</strong>');

 D = D.replace(/<em>/gi,'<i>').
 replace(/<\/em>/gi,'</i>');

 D = D.replace(/<\?xml:[^>]*>/g, '').
 replace(/<\/?st1:[^>]*>/g,'').
 replace(/<\/?[a-z]\:[^>]*>/g,'').
 replace(/<\/?font[^>]*>/gi,'').
 replace(/<\/?span[^>]*>/gi,' ').
 replace(/<\/?div[^>]*>/gi,' ').
 replace(/<\/?pre[^>]*>/gi,' ').
 replace(/<\/?h[1-6][^>]*>/gi,' ');





 oldlen = D.length + 1;
 while(oldlen > D.length){
 oldlen = D.length;

 D = D.replace(/<([a-z][a-z]*)> *<\/\1>/gi,' ').
 replace(/<([a-z][a-z]*)> *<([a-z][^>]*)> *<\/\1>/gi,'<$2>');
}
 D = D.replace(/<([a-z][a-z]*)><\1>/gi,'<$1>').
 replace(/<\/([a-z][a-z]*)><\/\1>/gi,'<\/$1>');

 D = D.replace(/ */gi,' ');
 this.setHTML(D);
 this.updateToolbar();
}
};
HTMLArea.prototype.forceRedraw = function(){
 this._doc.body.style.visibility = "hidden";
 this._doc.body.style.visibility = "visible";

};
HTMLArea.prototype.focusEditor = function(){
 switch (this._editMode){
 case "wysiwyg" : this._iframe.contentWindow.focus(); break;
 case "textmode": this._textArea.focus(); break;
 default : alert("ERROR: mode " + this._editMode + " is not defined");
}
 return this._doc;
};
HTMLArea.prototype._undoTakeSnapshot = function(){
 ++this._undoPos;
 if (this._undoPos >= this.config.undoSteps){

 this._undoQueue.shift();
 --this._undoPos;
}

 var take = true;
 var txt = this.getInnerHTML();
 if (this._undoPos > 0)
 take = (this._undoQueue[this._undoPos - 1] != txt);
 if (take){
 this._undoQueue[this._undoPos] = txt;
}else{
 this._undoPos--;
}
};
HTMLArea.prototype.undo = function(){
 if (this._undoPos > 0){
 var txt = this._undoQueue[--this._undoPos];
 if (txt) this.setHTML(txt);
 else ++this._undoPos;
}
};
HTMLArea.prototype.redo = function(){
 if (this._undoPos < this._undoQueue.length - 1){
 var txt = this._undoQueue[++this._undoPos];
 if (txt) this.setHTML(txt);
 else --this._undoPos;
}
};
HTMLArea.prototype.updateToolbar = function(noStatus){
 var doc = this._doc;
 var text = (this._editMode == "textmode");
 var ancestors = null;
 if (!text){
 ancestors = this.getAllAncestors();
 if (this.config.statusBar && !noStatus){
 this._statusBarTree.innerHTML = HTMLArea.I18N.msg["Path"] + ": ";
 for (var i = ancestors.length; --i >= 0;){
 var el = ancestors[i];
 if (!el){




 continue;
}
 var a = document.createElement("a");
 a.href = "#";
 a.el = el;
 a.editor = this;
 a.onclick = function(){
 this.blur();
 this.editor.selectNodeContents(this.el);
 this.editor.updateToolbar(true);
 return false;
};
 a.oncontextmenu = function(){

 this.blur();
 var info = "Inline style:\n\n";
 info += this.el.style.cssText.split(/;\s*/).join(";\n");
 alert(info);
 return false;
};
 var txt = el.tagName.toLowerCase();
 a.title = el.style.cssText;
 if (el.id){
 txt += "#" + el.id;
}
 if (el.className){
 txt += "." + el.className;
}
 a.appendChild(document.createTextNode(txt));
 this._statusBarTree.appendChild(a);
 if (i != 0){
 this._statusBarTree.appendChild(document.createTextNode(String.fromCharCode(0xbb)));
}
}
}
}
 for (var i in this._toolbarObjects){
 var btn = this._toolbarObjects[i];
 var cmd = i;
 var inContext = true;
 if (btn.context && !text){
 inContext = false;
 var context = btn.context;
 var attrs = [];
 if (/(.*)\[(.*?)\]/.test(context)){
 context = RegExp.$1;
 attrs = RegExp.$2.split(",");
}
 context = context.toLowerCase();
 var match = (context == "*");
 for (var k in ancestors){
 if (!ancestors[k]){

 continue;
}
 if (match || (ancestors[k].tagName.toLowerCase() == context)){
 inContext = true;
 for (var ka in attrs){
 if (!eval("ancestors[k]." + attrs[ka])){
 inContext = false;
 break;
}
}
 if (inContext){
 break;
}
}
}
}
 btn.state("enabled", (!text || btn.text) && inContext);
 if (typeof cmd == "function"){
 continue;
}

 var dropdown = this.config.customSelects[cmd];
 if ((!text || btn.text) && (typeof dropdown != "undefined")){
 dropdown.refresh(this);
 continue;
}
 switch (cmd){
 case "fontname":
 case "fontsize":
 case "formatblock":
 if (!text) try{
 var value = ("" + doc.queryCommandValue(cmd)).toLowerCase();
 if (!value){

 break;
}




 var options = this.config[cmd];
 var k = 0;

 for (var j in options){

 if ((j.toLowerCase() == value) ||
 (options[j].substr(0, value.length).toLowerCase() == value)){
 btn.element.selectedIndex = k;
 break;
}
 ++k;
}
}catch(e){};
 break;
 case "textindicator":
 if (!text){
 try{with (btn.element.style){
 backgroundColor = HTMLArea._makeColor(
 doc.queryCommandValue(HTMLArea.is_ie ? "backcolor" : "hilitecolor"));
 if (/transparent/i.test(backgroundColor)){

 backgroundColor = HTMLArea._makeColor(doc.queryCommandValue("backcolor"));
}
 color = HTMLArea._makeColor(doc.queryCommandValue("forecolor"));
 fontFamily = doc.queryCommandValue("fontname");
 fontWeight = doc.queryCommandState("bold") ? "bold" : "normal";
 fontStyle = doc.queryCommandState("italic") ? "italic" : "normal";
}}catch (e){

}
}
 break;
 case "lefttoright":
 case "righttoleft":
 var el = this.getParentElement();
 while (el && !HTMLArea.isBlockElement(el))
 el = el.parentNode;
 if (el)
 btn.state("active", (el.style.direction == ((cmd == "righttoleft") ? "rtl" : "ltr")));
 break;
 default:
 try{
 btn.state("active", (!text && doc.queryCommandState(cmd)));
}catch (e){}
}
}

 if (this._customUndo && !this._timerUndo){
 this._undoTakeSnapshot();
 var editor = this;
 this._timerUndo = setTimeout(function(){
 editor._timerUndo = null;
}, this.config.undoTimeout);
}

 for (var i in this.plugins){
 var plugin = this.plugins[i].instance;
 if (typeof plugin.onUpdateToolbar == "function")
 plugin.onUpdateToolbar();
}
};
HTMLArea.prototype.insertNodeAtSelection = function(toBeInserted){
 if (!HTMLArea.is_ie){
 var sel = this._getSelection();
 var range = this._createRange(sel);

 sel.removeAllRanges();
 range.deleteContents();
 var node = range.startContainer;
 var pos = range.startOffset;
 switch (node.nodeType){
 case 3:

 if (toBeInserted.nodeType == 3){

 node.insertData(pos, toBeInserted.data);
 range = this._createRange();
 range.setEnd(node, pos + toBeInserted.length);
 range.setStart(node, pos + toBeInserted.length);
 sel.addRange(range);
}else{
 node = node.splitText(pos);
 var selnode = toBeInserted;
 if (toBeInserted.nodeType == 11
){
 selnode = selnode.firstChild;
}
 node.parentNode.insertBefore(toBeInserted, node);
 this.selectNodeContents(selnode);
 this.updateToolbar();
}
 break;
 case 1:
 var selnode = toBeInserted;
 if (toBeInserted.nodeType == 11
){
 selnode = selnode.firstChild;
}
 node.insertBefore(toBeInserted, node.childNodes[pos]);
 this.selectNodeContents(selnode);
 this.updateToolbar();
 break;
}
}else{
 return null;
}
};
HTMLArea.prototype.getParentElement = function(){
 var sel = this._getSelection();
 var range = this._createRange(sel);
 if (HTMLArea.is_ie){
 switch (sel.type){
 case "Text":
 case "None":





 return range.parentElement();
 case "Control":
 return range.item(0);
 default:
 return this._doc.body;
}
}else try{
 var p = range.commonAncestorContainer;
 if (!range.collapsed && range.startContainer == range.endContainer &&
 range.startOffset - range.endOffset <= 1 && range.startContainer.hasChildNodes())
 p = range.startContainer.childNodes[range.startOffset];
 /*
 alert(range.startContainer + ":" + range.startOffset + "\n" +
 range.endContainer + ":" + range.endOffset);
 */
 while (p.nodeType == 3){
 p = p.parentNode;
}
 return p;
}catch (e){
 return null;
}
};
HTMLArea.prototype.getAllAncestors = function(){
 var p = this.getParentElement();
 var a = [];
 while (p && (p.nodeType == 1) && (p.tagName.toLowerCase() != 'body')){
 a.push(p);
 p = p.parentNode;
}
 a.push(this._doc.body);
 return a;
};
HTMLArea.prototype.selectNodeContents = function(node, pos){
 this.focusEditor();
 this.forceRedraw();
 var range;
 var collapsed = (typeof pos != "undefined");
 if (HTMLArea.is_ie){
 range = this._doc.body.createTextRange();
 range.moveToElementText(node);
 (collapsed) && range.collapse(pos);
 range.select();
}else{
 var sel = this._getSelection();
 range = this._doc.createRange();
 range.selectNodeContents(node);
 (collapsed) && range.collapse(pos);
 sel.removeAllRanges();
 sel.addRange(range);
}
};
HTMLArea.prototype.insertHTML = function(html){
 var sel = this._getSelection();
 var range = this._createRange(sel);
 if (HTMLArea.is_ie){
 range.pasteHTML(html);
}else{

 var fragment = this._doc.createDocumentFragment();
 var div = this._doc.createElement("div");
 div.innerHTML = html;
 while (div.firstChild){

 fragment.appendChild(div.firstChild);
}

 var node = this.insertNodeAtSelection(fragment);
}
};
HTMLArea.prototype.surroundHTML = function(startTag, endTag){
 var html = this.getSelectedHTML();

 this.insertHTML(startTag + html + endTag);
};
HTMLArea.prototype.getSelectedHTML = function(){
 var sel = this._getSelection();
 var range = this._createRange(sel);
 var existing = null;
 if (HTMLArea.is_ie){
 existing = range.htmlText;
}else{
 existing = HTMLArea.getHTML(range.cloneContents(), false, this);
}
 return existing;
};
HTMLArea.prototype.hasSelectedText = function(){

 return this.getSelectedHTML() != '';
};
HTMLArea.prototype._createLink = function(link){
 var editor = this;
 var outparam = null;
 if (typeof link == "undefined"){
 link = this.getParentElement();
 if (link && !/^a$/i.test(link.tagName))
 link = null;
}
 if (link) outparam ={
 f_href : HTMLArea.is_ie ? editor.stripBaseURL(link.href) : link.getAttribute("href"),
 f_title : link.title,
 f_target : link.target
};
 this._popupDialog("link.html", function(param){
 if (!param)
 return false;
 var a = link;
 if (!a){
 editor._doc.execCommand("createlink", false, param.f_href);
 a = editor.getParentElement();
 var sel = editor._getSelection();
 var range = editor._createRange(sel);
 if (!HTMLArea.is_ie){
 a = range.startContainer;
 if (!/^a$/i.test(a.tagName))
 a = a.nextSibling;
}
}else a.href = param.f_href.trim();
 if (!/^a$/i.test(a.tagName))
 return false;
 a.target = param.f_target.trim();
 a.title = param.f_title.trim();
 editor.selectNodeContents(a);
 editor.updateToolbar();
}, outparam);
};
HTMLArea.prototype._insertImage = function(image){
 var editor = this;
 var outparam = null;
 if (typeof image == "undefined"){
 image = this.getParentElement();
 if (image && !/^img$/i.test(image.tagName))
 image = null;
}
 if (image) outparam ={
 f_url : HTMLArea.is_ie ? editor.stripBaseURL(image.src) : image.getAttribute("src"),
 f_alt : image.alt,
 f_border : image.border,
 f_align : image.align,
 f_vert : image.vspace,
 f_horiz : image.hspace
};
 this._popupDialog("insert_image.html", function(param){
 if (!param){
 return false;
}
 var img = image;
 if (!img){
 var sel = editor._getSelection();
 var range = editor._createRange(sel);
 editor._doc.execCommand("insertimage", false, param.f_url);
 if (HTMLArea.is_ie){
 img = range.parentElement();

 if (img.tagName.toLowerCase() != "img"){
 img = img.previousSibling;
}
}else{
 img = range.startContainer.previousSibling;
}
}else{
 img.src = param.f_url;
}
 for (field in param){
 var value = param[field];
 switch (field){
 case "f_alt" : img.alt = value; break;
 case "f_border" : img.border = parseInt(value || "0"); break;
 case "f_align" : img.align = value; break;
 case "f_vert" : img.vspace = parseInt(value || "0"); break;
 case "f_horiz" : img.hspace = parseInt(value || "0"); break;
}
}
}, outparam);
};

HTMLArea.prototype._smile = function(image){
 var editor = this;
 var outparam = null;
 if (typeof image == "undefined"){
 image = this.getParentElement();
 if (image && !/^img$/i.test(image.tagName))
 image = null;
}
 if (image) outparam ={
 f_url : HTMLArea.is_ie ? editor.stripBaseURL(image.src) : image.getAttribute("src"),
 f_alt : image.alt,
 f_border : image.border,
 f_align : image.align,
 f_vert : image.vspace,
 f_horiz : image.hspace
};
 this._popupDialog("insert_smile.html", function(param){
 if (!param){
 return false;
}
 var img = image;
 if (!img){
 var sel = editor._getSelection();
 var range = editor._createRange(sel);
 editor._doc.execCommand("insertimage", false, param.f_url);
 if (HTMLArea.is_ie){
 img = range.parentElement();

 if (img.tagName.toLowerCase() != "img"){
 img = img.previousSibling;
}
}else{
 img = range.startContainer.previousSibling;
}
}else{
 img.src = param.f_url;
}
 for (field in param){
 var value = param[field];
 switch (field){
 case "f_alt" : img.alt = value; break;
 case "f_border" : img.border = parseInt(value || "0"); break;
 case "f_align" : img.align = value; break;
 case "f_vert" : img.vspace = parseInt(value || "0"); break;
 case "f_horiz" : img.hspace = parseInt(value || "0"); break;
}
}
}, outparam);
};
/***************************************************
 * Category: EVENT HANDLERS
 ***************************************************/
HTMLArea.prototype._comboSelected = function(el, txt){
 this.focusEditor();
 var value = el.options[el.selectedIndex].value;
 switch (txt){
 case "fontname":
 case "fontsize": this.execCommand(txt, false, value); break;
 case "formatblock":
 (HTMLArea.is_ie) && (value = "<" + value + ">");
 this.execCommand(txt, false, value);
 break;
 default:

 var dropdown = this.config.customSelects[txt];
 if (typeof dropdown != "undefined"){
 dropdown.action(this);
}else{
 alert("FIXME: combo box " + txt + " not implemented");
}
}
};
HTMLArea.prototype.execCommand = function(cmdID, UI, param){
 var editor = this;
 this.focusEditor();
 cmdID = cmdID.toLowerCase();
 switch (cmdID){
 case "hilitecolor":
 (HTMLArea.is_ie) && (cmdID = "backcolor");
 case "forecolor":
 this._popupDialog("select_color.html", function(color){
 if (color){
 editor._doc.execCommand(cmdID, false, "#" + color);
}
}, HTMLArea._colorToRgb(this._doc.queryCommandValue(cmdID)));
 break;
 case "createlink":
 this._createLink();
 break;

 HTMLArea._object = this;
 window.open(this.popupURL("fullscreen.html"), "ha_fullscreen",
 "toolbar=no,menubar=no,personalbar=no,width=640,height=480," +
 "scrollbars=no,resizable=yes");
 break;
 case "undo":
 case "redo":
 if (this._customUndo)
 this[cmdID]();
 else
 this._doc.execCommand(cmdID, UI, param);
 break;
 case "smile": this._smile(); break;
 case "insertimage": this._insertImage(); break;
 case "about" : this._popupDialog("about.html", null, this); break;
 case "showhelp" : window.open(_editor_url + "reference.html", "ha_help"); break;
 case "killword": this._wordClean(); break;
 case "cut":
 case "copy":
 case "paste":
 try{
 if (this.config.killWordOnPaste)
 this._wordClean();
 this._doc.execCommand(cmdID, UI, param);
}catch (e){
 if (HTMLArea.is_gecko){
 if (confirm("Unprivileged scripts cannot access Cut/Copy/Paste programatically " +
 "for security reasons. Click OK to see a technical note at mozilla.org " +
 "which shows you how to allow a script to access the clipboard."))
 window.open("http://mozilla.org/editor/midasdemo/securityprefs.html");
}
}
 break;
 case "lefttoright":
 case "righttoleft":
 var dir = (cmdID == "righttoleft") ? "rtl" : "ltr";
 var el = this.getParentElement();
 while (el && !HTMLArea.isBlockElement(el))
 el = el.parentNode;
 if (el){
 if (el.style.direction == dir)
 el.style.direction = "";
 else
 el.style.direction = dir;
}
 break;
 default: this._doc.execCommand(cmdID, UI, param);
}
 this.updateToolbar();
 return false;
};
HTMLArea.prototype._editorEvent = function(ev){
 var editor = this;
 var keyEvent = (HTMLArea.is_ie && ev.type == "keydown") || (ev.type == "keypress");
 if (keyEvent){
 for (var i in editor.plugins){
 var plugin = editor.plugins[i].instance;
 if (typeof plugin.onKeyPress == "function") plugin.onKeyPress(ev);
}
}
 if (keyEvent && ev.ctrlKey){
 var sel = null;
 var range = null;
 var key = String.fromCharCode(HTMLArea.is_ie ? ev.keyCode : ev.charCode).toLowerCase();
 var cmd = null;
 var value = null;
 switch (key){
 case 'a':
 if (!HTMLArea.is_ie){

 sel = this._getSelection();
 sel.removeAllRanges();
 range = this._createRange();
 range.selectNodeContents(this._doc.body);
 sel.addRange(range);
 HTMLArea._stopEvent(ev);
}
 break;

 case 'b': cmd = "bold"; break;
 case 'i': cmd = "italic"; break;
 case 'u': cmd = "underline"; break;
 case 's': cmd = "strikethrough"; break;
 case 'l': cmd = "justifyleft"; break;
 case 'e': cmd = "justifycenter"; break;
 case 'r': cmd = "justifyright"; break;
 case 'j': cmd = "justifyfull"; break;
 case 'z': cmd = "undo"; break;
 case 'y': cmd = "redo"; break;
 case 'v': cmd = "paste"; break;
 case '0': cmd = "killword"; break;
}
 if (cmd){

 this.execCommand(cmd, false, value);
 HTMLArea._stopEvent(ev);
}
}

 if (editor._timerToolbar){
 clearTimeout(editor._timerToolbar);
}
 editor._timerToolbar = setTimeout(function(){
 editor.updateToolbar();
 editor._timerToolbar = null;
}, 50);
};
HTMLArea.prototype.getHTML = function(){
 switch (this._editMode){
 case "wysiwyg" :
 if (!this.config.fullPage){
 return HTMLArea.getHTML(this._doc.body, false, this);
}else
 return this.doctype + "\n" + HTMLArea.getHTML(this._doc.documentElement, true, this);
 case "textmode" : return this._textArea.value;
 default : alert("Mode <" + mode + "> not defined!");
}
 return false;
};
HTMLArea.prototype.getInnerHTML = function(){
 switch (this._editMode){
 case "wysiwyg" :
 if (!this.config.fullPage)
 return this._doc.body.innerHTML;
 else
 return this.doctype + "\n" + this._doc.documentElement.innerHTML;
 case "textmode" : return this._textArea.value;
 default : alert("Mode <" + mode + "> not defined!");
}
 return false;
};
HTMLArea.prototype.setHTML = function(html){
 switch (this._editMode){
 case "wysiwyg" :
 if (!this.config.fullPage)
 this._doc.body.innerHTML = html;
 else

 this._doc.body.innerHTML = html;
 break;
 case "textmode" : this._textArea.value = html; break;
 default : alert("Mode <" + mode + "> not defined!");
}
 return false;
};
HTMLArea.prototype.setDoctype = function(doctype){
 this.doctype = doctype;
};
HTMLArea.agt = navigator.userAgent.toLowerCase();
HTMLArea.is_ie = ((HTMLArea.agt.indexOf("msie") != -1) && (HTMLArea.agt.indexOf("opera") == -1));
HTMLArea.is_opera = (HTMLArea.agt.indexOf("opera") != -1);
HTMLArea.is_mac = (HTMLArea.agt.indexOf("mac") != -1);
HTMLArea.is_mac_ie = (HTMLArea.is_ie && HTMLArea.is_mac);
HTMLArea.is_win_ie = (HTMLArea.is_ie && !HTMLArea.is_mac);
HTMLArea.is_gecko = (navigator.product == "Gecko");
HTMLArea._object = null;
HTMLArea.cloneObject = function(obj){
 var newObj = new Object;

 if (obj.constructor.toString().indexOf("function Array(") == 1){
 newObj = obj.constructor();
}

 if (obj.constructor.toString().indexOf("function Function(") == 1){
 newObj = obj;
}else for (var n in obj){
 var node = obj[n];
 if (typeof node == 'object'){newObj[n] = HTMLArea.cloneObject(node);}
 else{newObj[n] = node;}
}
 return newObj;
};
HTMLArea.prototype._getSelection = function(){
 if (HTMLArea.is_ie){
 return this._doc.selection;
}else{
 return this._iframe.contentWindow.getSelection();
}
};
HTMLArea.prototype._createRange = function(sel){
 if (HTMLArea.is_ie){
 return sel.createRange();
}else{
 this.focusEditor();
 if (typeof sel != "undefined"){
 try{
 return sel.getRangeAt(0);
}catch(e){
 return this._doc.createRange();
}
}else{
 return this._doc.createRange();
}
}
};
HTMLArea._addEvent = function(el, evname, func){
 if (HTMLArea.is_ie){
 el.attachEvent("on" + evname, func);
}else{
 el.addEventListener(evname, func, true);
}
};
HTMLArea._addEvents = function(el, evs, func){
 for (var i in evs){
 HTMLArea._addEvent(el, evs[i], func);
}
};
HTMLArea._removeEvent = function(el, evname, func){
 if (HTMLArea.is_ie){
 el.detachEvent("on" + evname, func);
}else{
 el.removeEventListener(evname, func, true);
}
};
HTMLArea._removeEvents = function(el, evs, func){
 for (var i in evs){
 HTMLArea._removeEvent(el, evs[i], func);
}
};
HTMLArea._stopEvent = function(ev){
 if (HTMLArea.is_ie){
 ev.cancelBubble = true;
 ev.returnValue = false;
}else{
 ev.preventDefault();
 ev.stopPropagation();
}
};
HTMLArea._removeClass = function(el, className){
 if (!(el && el.className)){
 return;
}
 var cls = el.className.split(" ");
 var ar = new Array();
 for (var i = cls.length; i > 0;){
 if (cls[--i] != className){
 ar[ar.length] = cls[i];
}
}
 el.className = ar.join(" ");
};
HTMLArea._addClass = function(el, className){

 HTMLArea._removeClass(el, className);
 el.className += " " + className;
};
HTMLArea._hasClass = function(el, className){
 if (!(el && el.className)){
 return false;
}
 var cls = el.className.split(" ");
 for (var i = cls.length; i > 0;){
 if (cls[--i] == className){
 return true;
}
}
 return false;
};
HTMLArea.isBlockElement = function(el){
 var blockTags = " body form textarea fieldset ul ol dl li div " +
 "p h1 h2 h3 h4 h5 h6 quote pre table thead " +
 "tbody tfoot tr td iframe address ";
 return (blockTags.indexOf(" " + el.tagName.toLowerCase() + " ") != -1);
};
HTMLArea.needsClosingTag = function(el){
 var closingTags = " head script style div span tr td tbody table em strong font a title ";
 return (closingTags.indexOf(" " + el.tagName.toLowerCase() + " ") != -1);
};
HTMLArea.htmlEncode = function(str){

 str = str.replace(/&/ig, "&amp;");
 str = str.replace(/</ig, "&lt;");
 str = str.replace(/>/ig, "&gt;");
 str = str.replace(/\x22/ig, "&quot;");


 return str;
};
HTMLArea.getHTML = function(root, outputRoot, editor){
 var html = "";
 switch (root.nodeType){
 case 1:
 case 11:
 var closed;
 var i;
 var root_tag = (root.nodeType == 1) ? root.tagName.toLowerCase() : '';
 if (HTMLArea.is_ie && root_tag == "head"){
 if (outputRoot)
 html += "<head>";

 var save_multiline = RegExp.multiline;
 RegExp.multiline = true;
 var txt = root.innerHTML.replace(HTMLArea.RE_tagName, function(str, p1, p2){
 return p1 + p2.toLowerCase();
});
 RegExp.multiline = save_multiline;
 html += txt;
 if (outputRoot)
 html += "</head>";
 break;
}else if (outputRoot){
 closed = (!(root.hasChildNodes() || HTMLArea.needsClosingTag(root)));
 html = "<" + root.tagName.toLowerCase();
 var attrs = root.attributes;
 for (i = 0; i < attrs.length; ++i){
 var a = attrs.item(i);
 if (!a.specified){
 continue;
}
 var name = a.nodeName.toLowerCase();
 if (/_moz|contenteditable|_msh/.test(name)){

 continue;
}
 var value;
 if (name != "style"){










 if (typeof root[a.nodeName] != "undefined" && name != "href" && name != "src"){
 value = root[a.nodeName];
}else{
 value = a.nodeValue;



 if (HTMLArea.is_ie && (name == "href" || name == "src")){
 value = editor.stripBaseURL(value);
}
}
}else{

 value = root.style.cssText;
}
 if (/(_moz|^$)/.test(value)){


 continue;
}
 html += " " + name + '="' + value + '"';
}
 html += closed ? " />" : ">";
}
 for (i = root.firstChild; i; i = i.nextSibling){
 html += HTMLArea.getHTML(i, true, editor);
}
 if (outputRoot && !closed){
 html += "</" + root.tagName.toLowerCase() + ">";
}
 break;
 case 3:


 if ( !root.previousSibling && !root.nextSibling && root.data.match(/^\s*$/i) ) html = '&nbsp;';
 else html = HTMLArea.htmlEncode(root.data);
 break;
 case 8:
 html = "<!--" + root.data + "-->";
 break;
}
 return html;
};
HTMLArea.prototype.stripBaseURL = function(string){
 var baseurl = this.config.baseURL;

 baseurl = baseurl.replace(/[^\/]+$/, '');
 var basere = new RegExp(baseurl);
 string = string.replace(basere, "");

 baseurl = baseurl.replace(/^(https?:\/\/[^\/]+)(.*)$/, '$1');
 basere = new RegExp(baseurl);
 return string.replace(basere, "");
};
String.prototype.trim = function(){
 a = this.replace(/^\s+/, '');
 return a.replace(/\s+$/, '');
};
HTMLArea._makeColor = function(v){
 if (typeof v != "number"){

 return v;
}

 var r = v & 0xFF;
 var g = (v >> 8) & 0xFF;
 var b = (v >> 16) & 0xFF;
 return "rgb(" + r + "," + g + "," + b + ")";
};
HTMLArea._colorToRgb = function(v){
 if (!v)
 return '';

 function hex(d){
 return (d < 16) ? ("0" + d.toString(16)) : d.toString(16);
};
 if (typeof v == "number"){

 var r = v & 0xFF;
 var g = (v >> 8) & 0xFF;
 var b = (v >> 16) & 0xFF;
 return "#" + hex(r) + hex(g) + hex(b);
}
 if (v.substr(0, 3) == "rgb"){

 var re = /rgb\s*\(\s*([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9]+)\s*\)/;
 if (v.match(re)){
 var r = parseInt(RegExp.$1);
 var g = parseInt(RegExp.$2);
 var b = parseInt(RegExp.$3);
 return "#" + hex(r) + hex(g) + hex(b);
}


 return null;
}
 if (v.substr(0, 1) == "#"){

 return v;
}

 return null;
};
HTMLArea.prototype._popupDialog = function(url, action, init){
 Dialog(this.popupURL(url), action, init);
};
HTMLArea.prototype.imgURL = function(file, plugin){
 if (typeof plugin == "undefined")
 return _editor_url + file;
 else
 return _editor_url + "plugins/" + plugin + "/img/" + file;
};
HTMLArea.prototype.popupURL = function(file){
 var url = "";
 if (file.match(/^plugin:\/\/(.*?)\/(.*)/)){
 var plugin = RegExp.$1;
 var popup = RegExp.$2;
 if (!/\.html$/.test(popup))
 popup += ".html";
 url = _editor_url + "plugins/" + plugin + "/popups/" + popup;
}else
 url = _editor_url + this.config.popupURL + file;
 return url;
};
HTMLArea.getElementById = function(tag, id){
 var el, i, objs = document.getElementsByTagName(tag);
 for (i = objs.length; --i >= 0 && (el = objs[i]);)
 if (el.id == id)
 return el;
 return null;
};
 function Dialog(url, action, init){
 if (typeof init == "undefined"){
 init = window;
}
 Dialog._geckoOpenModal(url, action, init);
};
 Dialog._parentEvent = function(ev){
 if (Dialog._modal && !Dialog._modal.closed){
 Dialog._modal.focus();
 HTMLArea._stopEvent(ev);
}
};
 Dialog._return = null;
 Dialog._modal = null;
 Dialog._arguments = null;
 Dialog._geckoOpenModal = function(url, action, init){
 var dlg = window.open(url, "hadialog",
 "toolbar=no,menubar=no,personalbar=no,width=10,height=10," +
 "scrollbars=no,resizable=yes");
 Dialog._modal = dlg;
 Dialog._arguments = init;

 function capwin(w){
 HTMLArea._addEvent(w, "click", Dialog._parentEvent);
 HTMLArea._addEvent(w, "mousedown", Dialog._parentEvent);
 HTMLArea._addEvent(w, "focus", Dialog._parentEvent);
};

 function relwin(w){
 HTMLArea._removeEvent(w, "click", Dialog._parentEvent);
 HTMLArea._removeEvent(w, "mousedown", Dialog._parentEvent);
 HTMLArea._removeEvent(w, "focus", Dialog._parentEvent);
};
 capwin(window);

 for (var i = 0; i < window.frames.length; capwin(window.frames[i++]));

 Dialog._return = function (val){
 if (val && action){
 action(val);
}
 relwin(window);

 for (var i = 0; i < window.frames.length; relwin(window.frames[i++]));
 Dialog._modal = null;
};
};
 function PopupWin(editor, title, handler, initFunction){
 this.editor = editor;
 this.handler = handler;
 var dlg = window.open("", "__ha_dialog",
 "toolbar=no,menubar=no,personalbar=no,width=600,height=600,left=20,top=40" +
 "scrollbars=no,resizable=no");
 this.window = dlg;
 var doc = dlg.document;
 this.doc = doc;
 var self = this;
 var base = document.baseURI || document.URL;
 if (base && base.match(/(.*)\/([^\/]+)/)){
 base = RegExp.$1 + "/";
}
 base = _editor_url;
 if (!/\/$/.test(base)){

 base += '/';
}
 this.baseURL = base;
 doc.open();
 var html = "<html><head><title>" + title + "</title>\n";

 html += "<style type='text/css'>@import url(" + base + "htmlarea.css);</style></head>\n";
 html += "<body class='dialog popupwin' id='--HA-body'></body></html>";
 doc.write(html);
 doc.close();

 function init2(){
 var body = doc.body;
 if (!body){
 setTimeout(init2, 25);
 return false;
}
 dlg.title = title;
 doc.documentElement.style.padding = "0px";
 doc.documentElement.style.margin = "0px";
 var content = doc.createElement("div");
 content.className = "content";
 self.content = content;
 body.appendChild(content);
 self.element = body;
 initFunction(self);
 dlg.focus();
};
 init2();
};
 PopupWin.prototype.callHandler = function(){
 var tags = ["input", "textarea", "select"];
 var params = new Object();
 for (var ti in tags){
 var tag = tags[ti];
 var els = this.content.getElementsByTagName(tag);
 for (var j = 0; j < els.length; ++j){
 var el = els[j];
 var val = el.value;
 if (el.tagName.toLowerCase() == "input"){
 if (el.type == "checkbox"){
 val = el.checked;
}
}
 params[el.name] = val;
}
}
 this.handler(this, params);
 return false;
};
 PopupWin.prototype.close = function(){
 this.window.close();
};
 PopupWin.prototype.addButtons = function(){
 var self = this;
 var div = this.doc.createElement("div");
 this.content.appendChild(div);
 div.className = "buttons";
 for (var i = 0; i < arguments.length; ++i){
 var btn = arguments[i];
 var button = this.doc.createElement("button");
 div.appendChild(button);
 button.innerHTML = HTMLArea.I18N.buttons[btn];
 switch (btn){
 case "ok":
 button.onclick = function(){
 self.callHandler();
 self.close();
 return false;
};
 break;
 case "cancel":
 button.onclick = function(){
 self.close();
 return false;
};
 break;
}
}
};
 PopupWin.prototype.showAtElement = function(){
 var self = this;

 setTimeout(function(){
 var w = self.content.offsetWidth + 4;
 var h = self.content.offsetHeight + 4;




 var el = self.content;
 var s = el.style;
 s.position = "absolute";
 s.left = (w - el.offsetWidth) / 2 + "px";
 s.top = (h - el.offsetHeight) / 2 + "px";
 if (HTMLArea.is_gecko){
 self.window.innerWidth = w;
 self.window.innerHeight = h;
}else{
 self.window.resizeTo(w + 8, h + 35);
}
}, 25);
};
 HTMLArea.I18N ={
 lang: "en",
 tooltips:{
 bold: "Bold",
 italic: "Italic",
 underline: "Underline",
 strikethrough: "Strikethrough",
 subscript: "Subscript",
 superscript: "Superscript",
 justifyleft: "Justify Left",
 justifycenter: "Justify Center",
 justifyright: "Justify Right",
 justifyfull: "Justify Full",
 orderedlist: "Ordered List",
 unorderedlist: "Bulleted List",
 outdent: "Decrease Indent",
 indent: "Increase Indent",
 forecolor: "Font Color",
 hilitecolor: "Background Color",
 horizontalrule: "Horizontal Rule",
 insertimage: "Insert/Modify Image",
 //smile: "Insert Smile",
 about: "About this editor",
 showhelp: "Help using editor",
 textindicator: "Current style",
 undo: "Undoes your last action",
 redo: "Redoes your last action",
 cut: "Cut selection",
 copy: "Copy selection",
 paste: "Paste from clipboard",
 lefttoright: "Direction left to right",
 righttoleft: "Direction right to left"
},
 buttons:{
 "ok": "OK",
 "cancel": "Cancel"
},
 msg:{
 "Path": "Path",
 "TEXT_MODE": "You are in TEXT MODE. Use the [<>] button to switch back to WYSIWYG.",
 "IE-sucks-full-screen" :
 "The full screen mode is known to cause problems with Internet Explorer, " +
 "due to browser bugs that we weren't able to workaround. You might experience garbage " +
 "display, lack of editor functions and/or random browser crashes. If your system is Windows 9x " +
 "it's very likely that you'll get a 'General Protection Fault' and need to reboot.\n\n" +
 "You have been warned. Please press OK if you still want to try the full screen editor."
},
 dialogs:{
 "Cancel" : "Cancel",
 "Insert/Modify Link" : "Insert/Modify Link",
 "New window (_blank)" : "New window (_blank)",
 "None (use implicit)" : "None (use implicit)",
 "OK" : "OK",
 "Other" : "Other",
 "Same frame (_self)" : "Same frame (_self)",
 "Target:" : "Target:",
 "Title (tooltip):" : "Title (tooltip):",
 "Top frame (_top)" : "Top frame (_top)",
 "URL:" : "URL:",
 "You must enter the URL where this link points to" : "You must enter the URL where this link points to"
}
};
 ContextMenu.I18N ={



 "Cut" : "Cut",
 "Copy" : "Copy",
 "Paste" : "Paste",
 "Image Properties" : "_Image Properties...",
 "Modify Link" : "_Modify Link...",
 "Check Link" : "Chec_k Link...",
 "Remove Link" : "_Remove Link...",
 "Cell Properties" : "C_ell Properties...",
 "Row Properties" : "Ro_w Properties...",
 "Insert Row Before" : "I_nsert Row Before",
 "Insert Row After" : "In_sert Row After",
 "Delete Row" : "_Delete Row",
 "Table Properties" : "_Table Properties...",
 "Insert Column Before" : "Insert _Column Before",
 "Insert Column After" : "Insert C_olumn After",
 "Delete Column" : "De_lete Column",
 "Justify Left" : "Justify Left",
 "Justify Center" : "Justify Center",
 "Justify Right" : "Justify Right",
 "Justify Full" : "Justify Full",
 "Remove the" : "Remove the",
 "Element" : "Element...",

 "Please confirm that you want to remove this element:" : "Please confirm that you want to remove this element:",
 "Remove this node from the document" : "Remove this node from the document",
 "How did you get here? (Please report!)" : "How did you get here? (Please report!)",
 "Show the image properties dialog" : "Show the image properties dialog",
 "Modify URL" : "Modify URL",
 "Current URL is" : "Current URL is",
 "Opens this link in a new window" : "Opens this link in a new window",
 "Please confirm that you want to unlink this element." : "Please confirm that you want to unlink this element.",
 "Link points to:" : "Link points to:",
 "Unlink the current element" : "Unlink the current element",
 "Show the Table Cell Properties dialog" : "Show the Table Cell Properties dialog",
 "Show the Table Row Properties dialog" : "Show the Table Row Properties dialog",
 "Insert a new row before the current one" : "Insert a new row before the current one",
 "Insert a new row after the current one" : "Insert a new row after the current one",
 "Delete the current row" : "Delete the current row",
 "Show the Table Properties dialog" : "Show the Table Properties dialog",
 "Insert a new column before the current one" : "Insert a new column before the current one",
 "Insert a new column after the current one" : "Insert a new column after the current one",
 "Delete the current column" : "Delete the current column",
 "Create a link" : "Create a link"
};
 CSS.I18N ={};
 function CSS(editor, params){
 this.editor = editor;
 var cfg = editor.config;
 var toolbar = cfg.toolbar;
 var self = this;
 var i18n = CSS.I18N;
 var plugin_config = params[0];
 var combos = plugin_config.combos;
 var first = true;
 for (var i = combos.length; --i >= 0;){
 var combo = combos[i];
 var id = "CSS-class" + i;
 var css_class ={
 id : id,
 options : combo.options,
 action : function(editor){self.onSelect(editor, this, combo.context, combo.updatecontextclass);},
 refresh : function(editor){self.updateValue(editor, this);},
 context : combo.context
};
 cfg.registerDropdown(css_class);

 toolbar[1].splice(0, 0, first ? "separator" : "space");
 toolbar[1].splice(0, 0, id);
 if (combo.label)
 toolbar[1].splice(0, 0, "T[" + combo.label + "]");
 first = false;
}
};
 CSS._pluginInfo ={
                      name          : "CSS",
                      version       : "1.0",
                      developer     : "Mihai Bazon",
                      developer_url : "http://dynarch.com/mishoo/",
                      c_owner       : "Mihai Bazon",
                      sponsor       : "Miro International",
                      sponsor_url   : "http://www.miro.com.au",
                      license       : "htmlArea"
};
 CSS.prototype.onSelect = function(editor, obj, context, updatecontextclass){
 var tbobj = editor._toolbarObjects[obj.id];
 var index = tbobj.element.selectedIndex;
 var className = tbobj.element.value;

 var parent = editor.getParentElement();
 var surround = true;
 var is_span = (parent && parent.tagName.toLowerCase() == "span");
 var update_parent = (context && updatecontextclass && parent && parent.tagName.toLowerCase() == context);
 if (update_parent){
 parent.className = className;
 editor.updateToolbar();
 return;
}
 if (is_span && index == 0 && !/\S/.test(parent.style.cssText)){
 while (parent.firstChild){
 parent.parentNode.insertBefore(parent.firstChild, parent);
}
 parent.parentNode.removeChild(parent);
 editor.updateToolbar();
 return;
}
 if (is_span){

 if (parent.childNodes.length == 1){
 parent.className = className;
 surround = false;


 editor.updateToolbar();
}
}


 if (surround){



 editor.surroundHTML("<span class='" + className + "'>", "</span>");
}
};
 CSS.prototype.updateValue = function(editor, obj){
 var select = editor._toolbarObjects[obj.id].element;
 var parent = editor.getParentElement();
 if (typeof parent.className != "undefined" && /\S/.test(parent.className)){
 var options = select.options;
 var value = parent.className;
 for (var i = options.length; --i >= 0;){
 var option = options[i];
 if (value == option.value){
 select.selectedIndex = i;
 return;
}
}
}
 select.selectedIndex = 0;
};
 function ContextMenu(editor){
 this.editor = editor;
};
 ContextMenu._pluginInfo ={
                      name          : "CSS",
                      version       : "1.0",
                      developer     : "Mihai Bazon",
                      developer_url : "http://dynarch.com/mishoo/",
                      c_owner       : "Mihai Bazon",
                      sponsor       : "Miro International",
                      sponsor_url   : "http://www.miro.com.au",
                      license       : "htmlArea"
};
 ContextMenu.prototype.onGenerate = function(){
 var self = this;
 var doc = this.editordoc = this.editor._iframe.contentWindow.document;
 HTMLArea._addEvents(doc, ["contextmenu"],
 function (event){
 return self.popupMenu(HTMLArea.is_ie ? self.editor._iframe.contentWindow.event : event);
});
 this.currentMenu = null;
};
 ContextMenu.prototype.getContextMenu = function(target){
 var self = this;
 var editor = this.editor;
 var config = editor.config;
 var menu = [];
 var tbo = this.editor.plugins.TableOperations;
 if (tbo) tbo = tbo.instance;
 var i18n = ContextMenu.I18N;
 var selection = editor.hasSelectedText();
 if (selection)
 menu.push([ i18n["Cut"], function(){editor.execCommand("cut");}, null, config.btnList["cut"][1] ],
 [ i18n["Copy"], function(){editor.execCommand("copy");}, null, config.btnList["copy"][1] ]);
 menu.push([ i18n["Paste"], function(){editor.execCommand("paste");}, null, config.btnList["paste"][1] ]);
 var currentTarget = target;
 var elmenus = [];
 var link = null;
 var table = null;
 var tr = null;
 var td = null;
 var img = null;
 function tableOperation(opcode){
 tbo.buttonPress(editor, opcode);
};
 for (; target; target = target.parentNode){
 var tag = target.tagName;
 if (!tag)
 continue;
 tag = tag.toLowerCase();
 switch (tag){
 case "img":
 img = target;
 elmenus.push(null,
 [ i18n["Image Properties"],
 function(){
 editor._insertImage(img);
},
 i18n["Show the image properties dialog"],
 config.btnList["insertimage"][1] ]
 );
 break;
 case "a":
 link = target;
 elmenus.push(null,
 [ i18n["Modify Link"],
 function(){editor.execCommand("createlink", true);},
 i18n["Current URL is"] + ': ' + link.href,
 config.btnList["createlink"][1] ],
 [ i18n["Check Link"],
 function(){window.open(link.href);},
 i18n["Opens this link in a new window"] ],
 [ i18n["Remove Link"],
 function(){
 if (confirm(i18n["Please confirm that you want to unlink this element."] + "\n" +
 i18n["Link points to:"] + " " + link.href)){
 while (link.firstChild)
 link.parentNode.insertBefore(link.firstChild, link);
 link.parentNode.removeChild(link);
}
},
 i18n["Unlink the current element"] ]
 );
 break;
 case "td":
 td = target;
 if (!tbo) break;
 elmenus.push(null,
 [ i18n["Cell Properties"],
 function(){tableOperation("TO-cell-prop");},
 i18n["Show the Table Cell Properties dialog"],
 config.btnList["TO-cell-prop"][1] ]
 );
 break;
 case "tr":
 tr = target;
 if (!tbo) break;
 elmenus.push(null,
 [ i18n["Row Properties"],
 function(){tableOperation("TO-row-prop");},
 i18n["Show the Table Row Properties dialog"],
 config.btnList["TO-row-prop"][1] ],
 [ i18n["Insert Row Before"],
 function(){tableOperation("TO-row-insert-above");},
 i18n["Insert a new row before the current one"],
 config.btnList["TO-row-insert-above"][1] ],
 [ i18n["Insert Row After"],
 function(){tableOperation("TO-row-insert-under");},
 i18n["Insert a new row after the current one"],
 config.btnList["TO-row-insert-under"][1] ],
 [ i18n["Delete Row"],
 function(){tableOperation("TO-row-delete");},
 i18n["Delete the current row"],
 config.btnList["TO-row-delete"][1] ]
 );
 break;
 case "table":
 table = target;
 if (!tbo) break;
 elmenus.push(null,
 [ i18n["Table Properties"],
 function(){tableOperation("TO-table-prop");},
 i18n["Show the Table Properties dialog"],
 config.btnList["TO-table-prop"][1] ],
 [ i18n["Insert Column Before"],
 function(){tableOperation("TO-col-insert-before");},
 i18n["Insert a new column before the current one"],
 config.btnList["TO-col-insert-before"][1] ],
 [ i18n["Insert Column After"],
 function(){tableOperation("TO-col-insert-after");},
 i18n["Insert a new column after the current one"],
 config.btnList["TO-col-insert-after"][1] ],
 [ i18n["Delete Column"],
 function(){tableOperation("TO-col-delete");},
 i18n["Delete the current column"],
 config.btnList["TO-col-delete"][1] ]
 );
 break;
 case "body":
 elmenus.push(null,
 [ i18n["Justify Left"],
 function(){editor.execCommand("justifyleft");}, null,
 config.btnList["justifyleft"][1] ],
 [ i18n["Justify Center"],
 function(){editor.execCommand("justifycenter");}, null,
 config.btnList["justifycenter"][1] ],
 [ i18n["Justify Right"],
 function(){editor.execCommand("justifyright");}, null,
 config.btnList["justifyright"][1] ],
 [ i18n["Justify Full"],
 function(){editor.execCommand("justifyfull");}, null,
 config.btnList["justifyfull"][1] ]
 );
 break;
}
}
 for (var i in elmenus)
 menu.push(elmenus[i]);
 menu.push(null,
 [ i18n["Remove the"] + " &lt;" + currentTarget.tagName + "&gt; " + i18n["Element"],
 function(){
 if (confirm(i18n["Please confirm that you want to remove this element:"] + " " + currentTarget.tagName)){
 var el = currentTarget;
 var p = el.parentNode;
 p.removeChild(el);
 if (HTMLArea.is_gecko){
 if (p.tagName.toLowerCase() == "td" && !p.hasChildNodes())
 p.appendChild(editor._doc.createElement("br"));
 editor.forceRedraw();
 editor.focusEditor();
 editor.updateToolbar();
 if (table){
 var save_collapse = table.style.borderCollapse;
 table.style.borderCollapse = "collapse";
 table.style.borderCollapse = "separate";
 table.style.borderCollapse = save_collapse;
}
}
}
},
 i18n["Remove this node from the document"] ]);
 return menu;
};
 ContextMenu.prototype.popupMenu = function(ev){
 var self = this;
 var i18n = ContextMenu.I18N;
 if (this.currentMenu)
 this.currentMenu.parentNode.removeChild(this.currentMenu);
 function getPos(el){
 var r ={x: el.offsetLeft, y: el.offsetTop};
 if (el.offsetParent){
 var tmp = getPos(el.offsetParent);
 r.x += tmp.x;
 r.y += tmp.y;
}
 return r;
};
 function documentClick(ev){
 ev || (ev = window.event);
 if (!self.currentMenu){
 alert(i18n["How did you get here? (Please report!)"]);
 return false;
}
 var el = HTMLArea.is_ie ? ev.srcElement : ev.target;
 for (; el != null && el != self.currentMenu; el = el.parentNode);
 if (el == null)
 self.closeMenu();


};
 var keys = [];
 function keyPress(ev){
 ev || (ev = window.event);
 HTMLArea._stopEvent(ev);
 if (ev.keyCode == 27){
 self.closeMenu();
 return false;
}
 var key = String.fromCharCode(HTMLArea.is_ie ? ev.keyCode : ev.charCode).toLowerCase();
 for (var i = keys.length; --i >= 0;){
 var k = keys[i];
 if (k[0].toLowerCase() == key)
 k[1].__msh.activate();
}
};
 self.closeMenu = function(){
 self.currentMenu.parentNode.removeChild(self.currentMenu);
 self.currentMenu = null;
 HTMLArea._removeEvent(document, "mousedown", documentClick);
 HTMLArea._removeEvent(self.editordoc, "mousedown", documentClick);
 if (keys.length > 0)
 HTMLArea._removeEvent(self.editordoc, "keypress", keyPress);
 if (HTMLArea.is_ie)
 self.iePopup.hide();
};
 var target = HTMLArea.is_ie ? ev.srcElement : ev.target;
 var ifpos = getPos(self.editor._iframe);
 var x = ev.clientX + ifpos.x;
 var y = ev.clientY + ifpos.y;
 var div;
 var doc;
 if (!HTMLArea.is_ie){
 doc = document;
}else{

 var popup = this.iePopup = window.createPopup();
 doc = popup.document;
 doc.open();
 doc.write("<html><head><style type='text/css'>@import url(" + _editor_url + "plugins/ContextMenu/menu.css); html, body{padding: 0px; margin: 0px; overflow: hidden; border: 0px;}</style></head><body unselectable='yes'></body></html>");
 doc.close();
}
 div = doc.createElement("div");
 if (HTMLArea.is_ie)
 div.unselectable = "on";
 div.oncontextmenu = function(){return false;};
 div.className = "htmlarea-context-menu";
 if (!HTMLArea.is_ie)
 div.style.left = div.style.top = "0px";
 doc.body.appendChild(div);
 var table = doc.createElement("table");
 div.appendChild(table);
 table.cellSpacing = 0;
 table.cellPadding = 0;
 var parent = doc.createElement("tbody");
 table.appendChild(parent);
 var options = this.getContextMenu(target);
 for (var i = 0; i < options.length; ++i){
 var option = options[i];
 var item = doc.createElement("tr");
 parent.appendChild(item);
 if (HTMLArea.is_ie)
 item.unselectable = "on";
 else item.onmousedown = function(ev){
 HTMLArea._stopEvent(ev);
 return false;
};
 if (!option){
 item.className = "separator";
 var td = doc.createElement("td");
 td.className = "icon";
 var IE_IS_A_FUCKING_SHIT = '>';
 if (HTMLArea.is_ie){
 td.unselectable = "on";
 IE_IS_A_FUCKING_SHIT = " unselectable='on' style='height=1px'>&nbsp;";
}
 td.innerHTML = "<div" + IE_IS_A_FUCKING_SHIT + "</div>";
 var td1 = td.cloneNode(true);
 td1.className = "label";
 item.appendChild(td);
 item.appendChild(td1);
}else{
 var label = option[0];
 item.className = "item";
 item.__msh ={
 item: item,
 label: label,
 action: option[1],
 tooltip: option[2] || null,
 icon: option[3] || null,
 activate: function(){
 self.closeMenu();
 self.editor.focusEditor();
 this.action();
}
};
 label = label.replace(/_([a-zA-Z0-9])/, "<u>$1</u>");
 if (label != option[0])
 keys.push([ RegExp.$1, item ]);
 label = label.replace(/__/, "_");
 var td1 = doc.createElement("td");
 if (HTMLArea.is_ie)
 td1.unselectable = "on";
 item.appendChild(td1);
 td1.className = "icon";
 if (item.__msh.icon)
 td1.innerHTML = "<img align='middle' src='" + item.__msh.icon + "' />";
 var td2 = doc.createElement("td");
 if (HTMLArea.is_ie)
 td2.unselectable = "on";
 item.appendChild(td2);
 td2.className = "label";
 td2.innerHTML = label;
 item.onmouseover = function(){
 this.className += " hover";
 self.editor._statusBarTree.innerHTML = this.__msh.tooltip || '&nbsp;';
};
 item.onmouseout = function(){this.className = "item";};
 item.oncontextmenu = function(ev){
 this.__msh.activate();
 if (!HTMLArea.is_ie)
 HTMLArea._stopEvent(ev);
 return false;
};
 item.onmouseup = function(ev){
 var timeStamp = (new Date()).getTime();
 if (timeStamp - self.timeStamp > 500)
 this.__msh.activate();
 if (!HTMLArea.is_ie)
 HTMLArea._stopEvent(ev);
 return false;
};
}
}
 if (!HTMLArea.is_ie){
 var dx = x + div.offsetWidth - window.innerWidth + 4;
 var dy = y + div.offsetHeight - window.innerHeight + 4;
 if (dx > 0) x -= dx;
 if (dy > 0) y -= dy;
 div.style.left = x + "px";
 div.style.top = y + "px";
}else{

 var foobar = document.createElement("div");
 foobar.className = "htmlarea-context-menu";
 foobar.innerHTML = div.innerHTML;
 document.body.appendChild(foobar);
 var w = foobar.offsetWidth;
 var h = foobar.offsetHeight;
 document.body.removeChild(foobar);
 this.iePopup.show(ev.screenX, ev.screenY, w, h);
}
 this.currentMenu = div;
 this.timeStamp = (new Date()).getTime();
 HTMLArea._addEvent(document, "mousedown", documentClick);
 HTMLArea._addEvent(this.editordoc, "mousedown", documentClick);
 if (keys.length > 0)
 HTMLArea._addEvent(this.editordoc, "keypress", keyPress);
 HTMLArea._stopEvent(ev);
 return false;
};
var HTMLArea_load=1;