<?php
class NewsBox {
	var $cfg;				// Seperate config data
	var $_CurrentNews;		// Hold the current news snippet
	var $_News = array();	// Array of news snippets
	function NewsBox($cfgFile='')
	{
		if($cfgFile == "") { $cfgFile = "newsbox.config.php"; }
		$this->cfg = include($cfgFile);
		$this->ReadTextFromFile();
		return true;
	}
	function ReadTextFromFile()
	{
		$Txt = file_get_contents ($this->cfg['common']['NewsboxSource'], "r");
		$Txt = str_replace("  "," &nbsp;",$Txt);
		$Txt = nl2br($Txt);
		$Txt = strip_tags($Txt,"<img><a><br>");
		$Txt = stripslashes($Txt);
		$this->_News = explode("@@",$Txt);
	}
	function NewsBoxStyle()
	{
		if($this->cfg['common']['NewsboxStyle'] == "1") {
			$Tags = "border: 5px outset ";
		} else {
			$Tags = "border: 1px solid ";
		}
		$Tags .= $this->cfg['style']['BorderColor'] ."; padding:0; background-color:". $this->cfg['style']['BackgroundColor'] ."; font-size:". $this->cfg['style']['TextSize'] ."pt; font-family:". $this->cfg['common']['Font'] .";";
		return $Tags;
	}
	function GetNews()
	{
		srand((float) microtime() * 10000000);
		$News = array_rand($this->_News);
		$this->_CurrentNews = $this->_News[$News];
	}
	function ProcessText($Txt)
	{
		$Txt = str_replace("  "," &nbsp;",$Txt);
		$Txt = nl2br($Txt);		
		$Txt = strip_tags($Txt,"<br>");
		return $Txt;
	}
	function NewsBoxHeadingStyle()
	{
		$Tags = " font-size:". $this->cfg['common']['NewsboxHeadingSize'] ."pt; color:". $this->cfg['common']['NewsboxHeadingColor'] ."; font-weight:bold; text-align:center;";
		return $Tags;
	}
	function NewsBoxSubStyle($box,$x=0)
	{
		switch ($x) {
			case 0: // heading text
				$Tags = "font-size:". $this->cfg[$box]['HeadingTextSize'] ."pt; color:". $this->cfg[$box]['HeadingTextColor'] ."; font-weight:bold; text-align:center;";
			break;
			case 1: // normal text
				$Tags = "font-size:". $this->cfg[$box]['TextSize'] ."pt; color:". $this->cfg[$box]['TextColor'] ."; font-weight:normal; text-align:center;";
			break;
			default:
		}
		return $Tags;
	}
	function DisplayNewsbox()
	{
		$this->GetNews();
		$Tags = "<table style=\"". $this->NewsBoxStyle() ."\" width=\"". $this->cfg['common']['NewsboxWidth'] ."\" title=\"NewsBox created by Evil Wizard\"><tr>
<td colspan=\"3\" style=\"". $this->NewsBoxHeadingStyle() ."\">
". $this->cfg['common']['NewsboxHeading'] ."</td></tr>
<tr>
<td width=\"25%\" align=\"center\" valign=\"top\">
<span style=\"". $this->NewsBoxSubStyle('left','0') ."\">". $this->ProcessText($this->cfg['left']['HeadingText']) ."</span>
<br /><br style=\"font-size:4pt\" />
<span style=\"". $this->NewsBoxSubStyle('left','1') ."\">". $this->ProcessText($this->cfg['left']['Text']) ."</span>
<td width=\"50%\">
<marquee height=\"100\" onmouseover=\"this.stop()\" onmouseout=\"this.start()\" scrollamount=\"1\" direction=\"up\">
". $this->_CurrentNews ."</marquee></td>
<td width=\"25%\" align=\"center\" valign=\"top\">
<span style=\"". $this->NewsBoxSubStyle('right','0') ."\">". $this->ProcessText($this->cfg['right']['HeadingText']) ."</span>
<br /><br style=\"font-size:4pt\" />
<span style=\"". $this->NewsBoxSubStyle('right','1') ."\">". $this->ProcessText($this->cfg['right']['Text']) ."</span></td></tr>
<tr>
<td colspan=\"3\" style=\"font-size:8pt;\">
<marquee height=\"20\" scrollamount=\"2\" direction=\"left\">
". $this->cfg['common']['CopyWrite'] ."
</marquee></td></tr></table>
";
	return $Tags;
	}
}
?>