<?php

class RSSParser
{
    var $cache_contents;
    # (string) - URL of feed
   
    var $page;
    # (string) - Raw file contents of RSS Feed
   
    var $xml;
    # (object) - Object data of RSS Feed
   
    var $channel;
    # (object) - Channel Object containing feed information and items
   
    var $items;
    # (array) - RSS Items
   
    var $feed;
    # (array) - Feed Information ( title, desc, publish date )
   
    /*
        Class Constrictor
        Arguements:
            url: Feed URL, can be a local file, or online ( http:// )
            - url is required in order to execute the constrictor
    */
   
    function __construct ()
    {
        /*
            Do we have PHP5 Installed?
            If we do not have it installed,
            Kill the script immediately.
        */
        if ( intval( phpversion() ) < 5 )
        {
            die ( 'PHP5 is required to execute this class.' );
        }
        /*
            Does the extention class exist?
            Since it is an internal class
            Compiled into PHP5, we can check
            Whether it is installed or not.
        */
        else if ( !class_exists ( 'SimpleXMLElement' ) )
        {
            die ( 'Please re-compile PHP5 with the simpleXmlElement extention.' );
        }
        // Set the URL of the feed internally.       
       //$this->setRSS ( $cache_contents );
       
        // Get the page contents of that feed.
        //$this->getRSS ();
       
        // Parse RSS information
        //$this->parseRSS ();
    }
   
    /*
        Function: setRSS
        Arguements:
            url - RSS Feed url which is set interally
            - url is required to run this function
    */

	function set_content($cache_contents)
	{
		$this->feed = $cache_contents;
	}

	function parse()
	{
        // Since the extention is loaded, lets create a new
        // instance of this class.

		unset($this->items);

        $this->xml = new SimpleXMLElement ( $this->feed );
       
        // The XML Object has another child called channel.
        // It holds the RSS details as well as items
        $this->channel = $this->xml->channel;
       
        // Lets set the feed details
        // - Information about the RSS Feed

        $this->feed = array
        (
            'title' => $this->clean ( $this->channel->title ),
            'description' => $this->clean ( $this->channel->description ),
            'link' => $this->clean ( $this->channel->link ),
            'date' => $this->clean ( $this->channel->pubDate ),
            'image' => ( $this->channel->image->url ) ? $this->clean ( $this->channel->image->url ) : false,
        );
       
        // Checks if we have any items present.
        // Yes, it is possible that a feed is empty =/

        if ( is_object ( $this->channel->item ) && count( $this->channel->item ) )
        {
            // Lets loop through all the <item> objects
            foreach ( $this->channel->item as $item )
            {
	
				// print_r($item);
	
                // Add an item to the array
                $this->items[] = array
                (
                    'title' => $this->clean ( $item->title ),
                    'link' => $this->clean ( $item->link ),
                    'description' => $this->clean ( $item->description ),
                    'category' => $this->clean ( $item->category ),
                    'image' => ( $item->enclosure['url'] ) ? $this->clean ( $item->enclosure['url'] ) : false,
					'pubdate' => $this->clean ( $item->pubDate )
                );
            }
        }	
	}

	function set_content_and_parse( $cache_contents )
	{
        $this->feed = $cache_contents;
	}
   
    function setRSS ( $cache_contents )
    {
        $this->feed = $cache_contents;
    }
   
    /*
        Function getRSS
        - Get the feed source of the rss feed
    */
   
    /*
        Function: parseRSS
        - Parses the rss source
        - Places feed items in array: $this->items
        - Places feed details in array: $this->feed
    */
   
    function parseRSS ($new_content)
    {
        // Since the extention is loaded, lets create a new
        // instance of this class.
        $this->xml = new SimpleXMLElement ( $this->feed );
       
        // The XML Object has another child called channel.
        // It holds the RSS details as well as items
        $this->channel = $this->xml->channel;
       
        // Lets set the feed details
        // - Information about the RSS Feed
        $this->feed = array
        (
            'title' => $this->clean ( $this->channel->title ),
            'description' => $this->clean ( $this->channel->description ),
            'link' => $this->clean ( $this->channel->link ),
            'date' => $this->clean ( $this->channel->pubDate ),
            'image' => ( $this->channel->image->url ) ? $this->clean ( $this->channel->image->url ) : false,
        );
       
        // Checks if we have any items present.
        // Yes, it is possible that a feed is empty =/
       
        if ( is_object ( $this->channel->item ) && count( $this->channel->item ) )
        {
            // Lets loop through all the <item> objects
            foreach ( $this->channel->item as $item )
            {
                // Add an item to the array
                $this->items[] = array
                (
                    'title' => $this->clean ( $item->title ),
                    'link' => $this->clean ( $item->link ),
                    'description' => $this->clean ( $item->description ),
                    'category' => $this->clean ( $item->category ),
                    'image' => ( $item->enclosure['url'] ) ? $this->clean ( $item->enclosure['url'] ) : false,
                );
            }
        }
    }
   
    /*
        Function clean
        Argueuemts:
            i - string in which to clean.
                Cleans off the object tag from an object variable.
    */
   
    function clean ( $i )
    {
        return (string) htmlspecialchars ( html_entity_decode ( $i ) );
    }
}

?>