<link rel="stylesheet" type="text/css" media="all" href="./magic-rss-widget/style.css" />
<link rel="stylesheet" type="text/css" media="all" href="./magic-rss-widget/jscrollpane.css" />

<script type="text/javascript">

function addJavascript(jsname,pos) {
	var th = document.getElementsByTagName(pos)[0];
	var s = document.createElement('script');
	s.setAttribute('type','text/javascript');
	s.setAttribute('src',jsname);
	th.appendChild(s);
}

if ( typeof jQuery == 'undefined' ) {
	addJavascript('./magic-rss-widget/jquery-1.4.2.min.js','head'); 
}

</script>
<script type="text/javascript" src="./magic-rss-widget/jquery.mousewheel.js"></script>
<script type="text/javascript" src="./magic-rss-widget/jquery.em.js"></script>
<script type="text/javascript" src="./magic-rss-widget/jscrollpane.js"></script>

<?php

require_once("./magic-rss-widget/config.php");
require_once("./magic-rss-widget/parser.php");

?>

<div class="magic_rss_widget">

	<div class="header"><b><?php echo $widget_title; ?></b><img src="./magic-rss-widget/images/header_left.png" class="left" /><img src="./magic-rss-widget/images/header_right.png" class="right" /></div>
	
	<div class="body">
	
		<div class="tabs">
				
			<?php
		
			foreach ( $feeds as $feed ) {
				print "
				<div class='tab' rel='" . md5($feed['name']) . "'>
					<b>" . $feed['name'] . "</b>
				</div>
				";
			}
		
			?>

		</div>
		
		<?php
		
		$RSSParser = new RSSParser();
	
		foreach ( $feeds as $feed ) {

			print "<div class='category' id='" . md5($feed['name']) . "'><div class='category_content' style='height: {$widget_height}'>";
			
			$cache_file = "./magic-rss-widget/cache/" . md5($feed['url']);
			
			if ( ( date("U") - filemtime($cache_file) ) > 1800 ) {
				
				$ch = curl_init();
				$timeout = 5;
				curl_setopt($ch,CURLOPT_URL,$feed['url']);
				curl_setopt($ch,CURLOPT_RETURNTRANSFER,1);
				curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,$timeout);
				$data = curl_exec($ch);
				curl_close($ch);
				
				$fh = fopen($cache_file, 'w');
				fwrite($fh, $data);
				fclose($fh);
				
			}
			
			$rss_content = file_get_contents($cache_file);
			
			$counter = 0;

			$RSSParser->set_content($rss_content);
			$RSSParser->parse();
			
			$page_counter = 0;
			$entry_counter = 0;

			foreach ( $RSSParser->items as $entry ) {
			
				$counter++;
				$entry_counter++;

				$summary = $entry['description'];
				$summary = strip_tags($summary);
				$summary = str_replace('"', '&quot;', $summary);
				
				// October 8, 2010 - 2:30 PM
				$entry_date = date("F j, Y - g:i A", strtotime($entry['pubdate']));
				
				print "
					<div class='entry'>
						<span class='text'>
							<a href='" . $entry['link'] . "' class='entry_link' target='" . $target . "'>" . $entry['title'] . "</a><br />
							<span class='byline'><a href='" . $RSSParser->feed['link'] . "'>" . $RSSParser->feed['title'] . "</a> - " . $entry_date . "</span>
						</span>
					</div>
				";
				
				if ( $entry_counter == sizeof($RSSParser->items) ) {

					print "<div class='pagination'><a href='http://www.mightypromos.com/promotional-mini-plastic-football-61773' title='promotional mini footballs'>promotional mini footballs</a></div>";

				}
				
			}

			$counter = 1;
			
			print "</div></div>";

		}
	
		?>
	
	</div>

</div>

<script type="text/javascript">

	$.noConflict();
	
	jQuery(document).ready(function() {

		jQuery(".tab:first").addClass("active");
		jQuery(".category").hide();
		jQuery(".category:first").show();
		
		jQuery(".magic_rss_widget .body .category").each(function() {
			jQuery(".entry:even", this).addClass("even");
			jQuery(".entry:odd", this).addClass("odd");
		});

		jQuery(".tab").click(function() {
			jQuery(".tab").removeClass("active");
			jQuery(this).addClass("active");
			jQuery(".category").hide();
			var rel = jQuery(this).attr("rel");
			jQuery("#" + rel).show();
			jQuery(".category_content:visible").jScrollPane();
		});
		
		jQuery(".category_content:visible").jScrollPane();
			
	});

</script>