<?php
//Get info about your installation at Newanz.com. Is it registered?
	//So far, no register function is attached to this checkup and the information send (your installation key) is not saved on our webserver.
	$openReg = new newanz_nzr('http://newsoffice.newanz.com/register_keys.php?newsoffice_register_key='.install_id);
	if($openReg->result==true)
	{
		if(substr_count($openReg->original,'<html')>0) //Getting a html page. This isn't generated by the register state check script. So you are catching the Newanz.com error page.
		{
			$register_result = 'Register checkup could not be preformed. Server returned an error.';
		}
		else
		{
			//Replace, in the returned answer, a unique value with your installation key.
			$register_result = str_replace('<!--newsoffice-install-id-->',install_id,$openReg->original);
		}
	}
	else
	{
		$register_result = 'Unable to verify your register state. Server gave back no answer.';
	}
	$openReg->close();

$page_content = "<h1>NewsOffice System status</h1>
This is the system status checkup. This runs a test on this NewsOffice installation to see if everything is configured correctly.<br>
<br>
<h2>Installation information</h2>
Use this information when you need to get help from Newanz.
<div class='block'>
	<h3>Version information</h3>
	<table>
		<tr>
			<td class='subject'>
				Version:
			</td>
			<td>
				".app_version_full."
			</td>
		</tr>
		<tr>
			<td class='subject'>
				Application id:
			</td>
			<td>
				".$no_config['acp_version_id']."
			</td>
		</tr>
		<tr>
			<td class='subject'>
				Install id:
			</td>
			<td>
				".install_id."
			</td>
		</tr>
		<tr>
			<td class='subject'>
				Registered
			</td>
			<td>
				".$register_result."
			</td>
		</tr>
		<tr>
			<td class='subject'>
				URL:
			</td>
			<td>
				".$no_config['acp_url']."
			</td>
		</tr>
	</table>
</div>
<div class='block'>
	<h3>Other information</h3>
	<table>
		<tr>
			<td class='subject'>
				Unix Path:
			</td>
			<td>
				<div>".realpath('./')."</div>
				<div class='less_important'>This path is generated by the PHP <a href='http://nl.php.net/realpath'>function realpath();</a></div>
			</td>
		</tr>
	";
	
	if(realpath('./')!==newsoffice_directory)
	{
		$page_content .= "
		<tr>
			<td class='subject'>
				Used Unix Path:
			</td>
			<td>
				<div>".newsoffice_directory."</div>
				<div class='less_important'>NewsOffice is currently using this path.</div>
			</td>
		</tr>
		";
	}
	$install_size = no_dir_size(newsoffice_directory,'sub_directories');
	$page_content .= "
		<tr>
			<td class='subject'>
				Installation size:
			</td>
			<td>
				<div>".$install_size['size_size']." ".$install_size['size_type']."</div>";
		if(!empty($install_size['message']))
		{
			$page_content .= $install_size['message'];
		}
		$page_content .= "
			</td>
		</tr>";
	$install_size = no_dir_size(newsoffice_directory.$no_config['dir_uploads']);
	$page_content .= "
		<tr>
			<td class='subject'>
				Upload(s) size:
			</td>
			<td>
				<div>".$install_size['size_size']." ".$install_size['size_type']."</div>";
		if(!empty($install_size['message']))
		{
			$page_content .= $install_size['message'];
		}
		$page_content .= "
			</td>
		</tr>
	</table>
</div>
<br>
<h2>System status</h2>
<div class='block'>
<h3>System directories</h3>
These directories contain important files to use NewsOffice.<br>";

if($_POST['system-status_recheck'])
{
	$messages = system_status_result;
	if(defined('system_status_errors')==true)
	{
		$errors = system_status_errors;
	}
}
else
{
	$sstatus = new noSystemStatus();
		$sstatus->checkup();
		$messages  = $sstatus->result();			
		$errors = $sstatus->get_errors();
}
	if(!empty($errors))
	{
		$page_content .= "</div>".$errors."<div class='block'>";
	}
	else
	{//Unset if no errors occur
		unset($_SESSION[install_id]['system-status']['errors']);
	}
	$page_content .= $messages."</div>";
	if($_POST['system-status_recheck'])
	{
		$page_content .= "<div class='important'>Latest checkup done on: ".date($no_config['format_date']).' at '.date($no_config['format_time'])."</div>";
	}
	else
	{
		$page_content .= "<div class='important'>The system status (displayed here) is in realtime.</div>";
	}
$page_content .= "<input type='submit' name='system-status_recheck' value='Recheck system status'>";

//Check if you are using a supported PHP version
$page_content .= "<div class='block'><h3>PHP information</h3>
PHP version installed: <span class='status_";
if(version_compare(PHP_VERSION, '5.0.0','>')) //Version lower than PHP 5 are not good
{
	$page_content .= "ok";
	$version_status = 'Ok';
}
else
{
	$page_content .= "false";
	$version_status = "Not ok (issues might arise, if so or if not: <a href='http://newanz.com/contact/' target='_blank'>inform us</a>)";
}
$page_content .= "'>".PHP_VERSION."</span> = ".$version_status."<br>
<br>
<table>
	<col style='width: 200px;'>
	<tr>
		<th>
			Required extensions
		</th>
		<th>
			Status
		</th>
	</tr>";
//All required libaries installed and active?
	$required_libraries = array('zip');
	$loaded_libraries = get_loaded_extensions();
foreach($required_libraries as $required_library)
{
	$page_content .= "
	<tr>
		<td class='subject'>
			<ul><li>".$required_library."</li></ul>
		</td>
		<td>
	";
	if(in_array($required_library,$loaded_libraries)==true)
	{
		$page_content .= "<span class='status_ok'>Loaded</span>";
	}
	else
	{
		$page_content .= "<span class='status_false'>Not loaded!</span>";
	}
	$page_content .= "</td>
	</tr>";
}
$page_content .= "</table></div>";
?>