<?php
$page_content = "<h1>Integration</h1>";
if($_POST['generate'])
{
	$extra_text = '<h2>Options</h2>';
	$extra = '';
	//Category
	if($_POST['category']!=='all')
	{
		$openC = new newanz_nzr(newsoffice_directory.$no_config['dir_info'].'categories.nzr','READ_ONLY');
			$openC->readfile();
			$openC->search(array('id'=>$_POST['category']),false,1);
			$category = $openC->content[0];
			$extra_text .= "You have selected to only show the news from category <span class='important'>".$category['name']."</span>.<br>";
			$extra .= "\n".'$selected_category = "'.$_POST['category'].'";';
		$openC->close();
	}
	//Theme
	$openT = new newanz_nzr(newsoffice_directory.$no_config['dir_themes'].$_POST['theme'].'.nzr','READ_ONLY');
		$openT->readfile();
		$theme = $openT->content[0];
		$extra_text .= "You have selected to use the <span class='important'>".$theme['value']."</span> theme.<br>";
		$extra .= "\n".'$theme_selected = "'.$_POST['theme'].'";';
	$openT->close();

	$unix_dir = $_POST['real-dir'];
	if(substr_count($unix_dir,"'")>0)
	{
		$unix_dir = str_replace("'","\'",$unix_dir);
	}

	$page_content .= $extra_text."<br><h2>PHP code</h2>Place the code below in a .php file or a file that is executed as a PHP file to show your news page.<div class='block'>".highlight_string('<?php'.$extra."\n".'include(\''.$unix_dir.'/news_show.php\');'."\n".'?>',true)."</div>
	<br>
	<a href='".url_build('settings-integration')."'>&laquo; Go back</a>";
}
else
{
	//On this page you can generate multiple NewsOffice include codes for your website.
	$page_content .= "
	<h2>News page code</h2>
	This is the integration code generator. This generator generates the code you will have to include in your website where you want to display your news page(s). Make sure you add it in a .php file. If you are not sure what to change in this form, leave the default. It will display all your published news with the default theme.
	Select your settings for you news page(s) in the <a href='".url_build('settings-main')."'>Settings</a> section.<br>
	<div class='block'>
	<h2>NewsOffice directory</h2>
	In which directory is your NewsOffice installation located? (Unix path)<br>
	<div class='inside'><input type='text' name='real-dir' value='".htmlentities(realpath(newsoffice_directory), ENT_QUOTES)."' style='width: 100%;'><br>
	<div class='less_important'>The default directory is generated by the PHP <a href='http://php.net/realpath' target='_blank'>function realpath();</a></div></div>
	<h2>Category</h2>
	Selecting a category will only display news posts added to that category.<br>
	<div class='inside'>Category: <select name='category'>
		<option value='all'>All</option>";

	//Load categories
	$openCat = new newanz_nzr(newsoffice_directory.$no_config['dir_info'].'categories.nzr','READ_ONLY');
		$openCat->readfile();
	//Load newsposts-category links
	$openClink = new newanz_nzr(newsoffice_directory.$no_config['dir_info'].'categories-link.nzr','READ_ONLY');
		$openClink->readfile();
	
	if($openCat->amount_rows>0)
	{
		if($openClink->amount_rows>0)
		{
			foreach($openClink->content as $link)
			{
				$link_stats[$link['cat-id']]++;
			}
		}
		foreach($openCat->content as $category)
		{
			$page_content .= "<option value='".$category['id']."'>".$category['name']." ";
			if(!empty($link_stats[$category['id']]))
			{
				$page_content .= "(".$link_stats[$category['id']].")";
			}
			else
			{
				$page_content .= "(0)";
			}
			$page_content .= "</option>";
		}
	}
	$openCat->close();
	$openClink->close();
	
	$page_content .= "</select>
		<div class='less_important'>The number after the name of the category is the number of news posts currently added to the category.</div>
	</div>
	<h2>Theme</h2>
	Select the theme to use to display your news:<br>
	<div class='inside'>Theme: <select name='theme'>";

	$themes = glob(newsoffice_directory.$no_config['dir_themes']."*.nzr");
	if(!empty($themes))
	{
		foreach($themes as $theme)
		{
			$openT = new newanz_nzr($theme,'READ_ONLY');
				$openT->readfile();
				$openT->rekey(array('object'));
				$info = $openT->content;
				if(!empty($info['name']['value']))
				{
					$theme_file = preg_replace("#".newsoffice_directory.$no_config['dir_themes']."(.*?).nzr#",'\\1', $theme);
					$page_content .= "<option value='".$theme_file."'>".$info['name']['value']."</option>";
				}
			$openT->close();
		}
	}
	
	$page_content .= "</select></div>
	<br>
	<input type='submit' value='Generate code' name='generate'>
	</div>";
	/* //! For new release! version: 2.0.2+
	$page_content .= "<h2>Category browser code</h2>
	This code will display all your avaliable categories in NewsOffice. Include this on the same page as your news page to let your visitors read the news posts in that category.
	<div class='block'>
		Generate category browser code<br><br>
		<input type='submit' value='Generate code' name='generate'>
	</div>";
	*/
}
?>