<?php
/*
+---------------------------------------------------------------+
|	Stash News						|
|								|
|	 2007-2008 Mike Barlow & Rick Mills			|
|	www.webmasterstash.com					|
|								|
|	Released under the terms and conditions of the		|
|	GNU General Public License (http://gnu.org).		|
|	Created: 22:14 30/09/2007				|
+---------------------------------------------------------------+
*/

# Function used to get rid of NULL elements and elements with just whitespace from an array
function clean_array($array)
{
	# Remove any blank elements i.e. ""
	$search = array_keys($array, "");
	$num_array = count($search);

	if($num_array == '1')
	{
		array_splice($array, $search[0], 1);
	} else
	{
		$i = '0';
		
		while($i < $num_array)
		{
			array_keys($array, $search[$i], 1);
		
			$i++;
		}
	}

	# Remove any elements with just whitespace i.e. " "
	$search = array_keys($array, " ");
	$num_array = count($search);

	if($num_array == '1')
	{
		array_splice($array, $search[0], 1);
	} else
	{
		$i = '0';
		
		while($i < $num_array)
		{
			array_keys($array, $search[$i], 1);
		
			$i++;
		}
	}

	return $array;
}
######################################################
# Function used to write data to a file
# Made to help with code reuseage

function data_write($filename, $new_data, $old_data)
{
	global $lang;

	$outcome = array();
	$outcome[0] = FALSE;
	
	$fo = fopen($filename, "w");
	if(!$fo)
	{
		$outcome[1] = $lang[7]." ".$filename;
	} else
	{
		$fw = fwrite($fo, $new_data);
		if(!$fw)
		{
			$outcome[1] = $lang[8]." ".$filename;

			# It failed to write.
			# As the handle was opened with "w" it will truncate the length to zero before writing the new data
			# So if it fails we need to try and write the old data back in
	
			fwrite($fo, $old_data);
		} else
		{
			#Set the outcome of the writing so we can test it outside of the function
			$outcome[0] = TRUE;
			$outcome[1] = "";
		}
	}
	
	@fclose($fo); 

	return $outcome;
}

######################################################
# Used to get a count on how many files are in a directory
# Primarly used for counting number of news posts

function scan_dir($dir)
{
	$scan = scandir($dir);
	
	$key = array_search(".", $scan);	
	array_splice($scan, $key, 1);

	$key = array_search("..", $scan);
	array_splice($scan, $key, 1);

	$key = array_search("index.html", $scan);
	array_splice($scan, $key, 1);

	return $scan;
}	
########################################################
# Used to count the number of news posts

function count_news($inadmin)
{
	if($inadmin == '1')
	{
		$path = "../";
	}

	$scan = scan_dir($path."news/");
	# array of news dir should be free of unwanted counts.
	# array count should now return just the news files

	return count($scan);

}
########################################################
# Used to check whether there are any comments in a file

function check_comments($comment)
{
	if(strpos($comment, "|<->|<->|") === FALSE)
	{
		return FALSE;
	} else
	{
		return TRUE;
	}
}
########################################################
# Counts the comments in a file

function count_comments($post, $inadmin)
{
	global $lang;
	
	if($inadmin == '1')
	{
		$path = "../";
	}
	# @ sign is used to supress errors
	# There shouldn't be a need but its mainly just incase
	# As comments files are created and deleted with the news posts

	$comm = @file_get_contents($path."comments/".$post.".php");

	if(!check_comments($comm))
	{
		$count = "0";
	} else
	{
		$ex = explode("|<->|<->|", $comm);

		$ex = clean_array($ex);

		$count = count($ex);
	}

	
	$comm_count = $count." ".$lang[3];

	return $comm_count;
}

########################################################
# gets the page / makes sure no unwanted things are passed and that only numbers are passed

function get_page($page_get)
{
	if(empty($page_get))
	{
		$page = '1';
	} else
	{
		if(is_numeric($page_get))
		{
			$page = $page_get;
		} else
		{
			$page = '1';
		}
	}

	return $page;
}
#########################################################
# Get the first ID number that needs to be displayed on the current page

function get_first_id($page, $nopp, $inadmin)
{
	if($inadmin == '1')
	{
		$path = "../";
	}

	$scan = scan_dir($path."news/");
	
	arsort($scan);

	if($page > '1')
	{
		$remove = ($page - 1) * $nopp;
	
		$scan = array_slice($scan, $remove);
	} 
	
	$first_post = array_shift($scan);
	$ex = explode(".", $first_post);
	
	return $ex[0];
}
#########################################################
# Get the first ID number that needs to be displayedon the comments

function get_first_comment($page, $nopp, $postid, $inadmin)
{
	if($inadmin == '1')
	{
		$path = "../";
	}

	$file = @file_get_contents($path."comments/".$postid.".php");

	$ex = explode("|<->|<->|", $file);
	$ex = clean_array($ex);
	$num_array = count($ex);

	if($page == '1')
	{
		$id = "0";
	} else
	{
		$id = ($page - 1) * $nopp;
	}

	return $id;
}
#########################################################
# Used to generate the pageination links

function gen_page_links($page, $nopp, $count, $prev, $next, $link)
{

	# Work out if we need a previous page link
	if($page > '1')
	{
		$prev_page = $page - 1;
		$prev_link = "<a href='?".$link."=".$prev_page."'>".$prev."</a>&nbsp;";
	}

	# Work out if we need a next page link
	if(($count - ($nopp * $page)) > '0')
	{
		$next_page = $page + 1;
		$next_link = "<a href='?".$link."=".$next_page."'>".$next."</a>";
	}
	
	# Work out how many full pages there should be
	$fullpages = $count / $nopp;	

	# Work out the page numbers and which one is the current page
	$i = '1';
	$pagenums = "";
	while($i <= $fullpages)
	{
		if($i == $page)
		{
			$pagenums .= "<strong>".$i."</strong>&nbsp;";
		} else
		{
			$pagenums .= "<a href='?".$link."=".$i."'>".$i."</a>&nbsp;";
		}
		$i++;
	}
	
	# Work out if there are any none full pages (i.e. only 2 posts when there is a 5 post limit)
	if(($count % $nopp) > '0')
	{
		if($i == $page)
		{
			$pagenums .= "<strong>".$i."</strong>&nbsp;";
		} else
		{
			$pagenums .= "<a href='?".$link."=".$i."'>".$i."</a>&nbsp;";
		}
	}	

		
	$pagelinks = $prev_link . $pagenums . $next_link;

	if(strpos($pagelinks, '2') === FALSE)
	{
		$pagelinks = "";
	}

	return $pagelinks;

}
#################################################################################
# Used to build the post comment link or the list of comments depend which page you are on

function build_comments($postid, $type, $inadmin)
{
	global $lang, $com_date, $bbcoms, $smilescoms, $comspp, $com_temp;

	if($inadmin == '1')
	{
		$path = "../";
	}

	if($type == "postlink")
	{
		$comments = "<a href='?ncomments=".$postid."'>".$lang[4]."</a>";
	
	} elseif($type == "commentlist")
	{
		$file = @file_get_contents($path."comments/".$postid.".php");

		if(!check_comments($file))
		{
			$comments = $lang[5];
		} else
		{

			$ex = explode("|<->|<->|", $file);
		
			$ex = clean_array($ex);
				
			$page = get_page($_GET['cpage']);
			$com_count = count_comments($postid, $inadmin);			
			$fc = get_first_comment($page, $comspp, $postid, $inadmin);

			$i = '0';

			$comments = "";
				
			while($i < $comspp)
			{
				if($inadmin == '1')
				{
					$temp = $com_temp;
				} else
				{
					$temp = file_get_contents($path."templates/comment_display.html");
				}

				$com = $ex[$fc];

				if($com == '')
				{
					break;
				}

				$com = explode("|<->|", $com);
				$com = clean_array($com);
			
				$poster = $com[0];
				$dateline = $com[1];
				$body = $com[2];
				$date = date($com_date, $dateline);
					
				if($bbcoms == '1')
				{
					if($smilescoms == '1')
					{
						$bb = new Simple_BB_Code(true, true, true, false);
						$body = $bb->parse($body);
					} else
					{
						$bb = new Simple_BB_Code(true, false, true, false);
						$body = $bb->parse($body);
					}
				} else
				{
					if($smilescoms == '1')
					{
						$bb = new Simple_BB_Code(true, true, true, true);
						$body = $bb->parse($body);
					}
				}
	
			
				$temp = str_replace("{COMPOSTER}", $poster, $temp);	
				$temp = str_replace("{COMDATE}", $date, $temp);
				$temp = str_replace("{COMBODY}", $body, $temp);
				$temp = str_replace("{CID}", $fc, $temp);

				$comments .= $temp;

				$i++;
				$fc++;
			}

			if($inadmin == '1')
			{
				$pagelink = "action=comments&manage=".$postid."&cpage";
			} else
			{
				$pagelink = "ncomments=".$postid."&cpage";
			}
		
			$pageination = gen_page_links($page, $comspp, $com_count, $lang[1], $lang[2], $pagelink);
		}

		$comments .= "<br />".$pageination;	
	}	

	return $comments;
}


#################################################################################
# Builds the news posts + extras such as calling the build comments functions

function build_news($temp, $post, $postid, $type, $inadmin)
{
	global $lang, $news_date, $bbnews, $smilesnews, $bbcoms, $smilescoms;

	$ex = explode("|<->|", $post);
	$title = trim($ex[1]);
	$author = trim($ex[2]);
	$dateline = trim($ex[3]);
	$body = trim($ex[4]);	
	$date = date($news_date, $dateline);

	if($inadmin == '1')
	{
		$path = "../";
	}
	
	if($bbnews == '1')
	{
		if($smilesnews == '1')
		{
			$bb = new Simple_BB_Code(true, true, true, false);
			$body = $bb->parse($body);
		} else
		{
			$bb = new Simple_BB_Code(true, false, true, false);
			$body = $bb->parse($body);
		}
	} else
	{
		if($smilesnews == '1')
		{
			$bb = new Simple_BB_Code(true, true, true, true);
			$body = $bb->parse($body);
		}
	}
	
	if($type == "main")
	{
		$com_count = count_comments($postid, $inadmin);
		$com_link = build_comments($postid, "postlink", $inadmin);
		$temp = str_replace("{COMLINK}", $com_link, $temp);
		$temp = str_replace("{COMCOUNT}", $com_count, $temp);

		if(strpos($body, "[fullnews]") > '1')
		{
			$ex = explode("[fullnews]", $body);
			$body = $ex[0];
		
			$readmore = $lang[10];
			$readmore = str_replace("{ID}", $postid, $readmore);

			$body .= $readmore;
		}
	} elseif($type == "full")
	{
		$com_form = file_get_contents($path."templates/comment_form.html");
		if($bbcoms == '1')
		{
			$com_form = str_replace("{BBCODE}", "<script type='text/javascript' src='includes/buttons.js'></script>", $com_form);
		} else
		{
			$com_form = str_replace("{BBCODE}", "", $com_form);
		}

		if($smilescoms == '1')
		{
			$com_form = str_replace("{SMILIES}", "<script type='text/javascript' src='includes/smileys.js'></script>", $com_form);
		} else
		{
			$com_form = str_replace("{SMILIES}", "", $com_form);
		}

		$comments = build_comments($postid, "commentlist", $inadmin);
		$temp = str_replace("{COMMENTS}", $comments, $temp);	
		$temp = str_replace("{POSTCOMMENT}", $com_form, $temp);

		if(strpos($body, "[fullnews]") > '1')
		{
			$ex = explode("[fullnews]", $body);
			$body = $ex[0].$ex[1];
		}
	}

	$temp = str_replace("{TITLE}", $title, $temp);
	$temp = str_replace("{POSTER}", $author, $temp);
	$temp = str_replace("{DATE}", $date, $temp);
	$temp = str_replace("{NEWS}", $body, $temp);
	$temp = str_replace("{NID}", $postid, $temp);

	return $temp;
}

################################################################################
# Used to validate the input from a comment form then to post it to the comment file

function post_comment($poster, $body, $postid)
{
	global $lang, $bbcoms, $smilescoms;

	$dateline = time();

	if($bbcoms == '1')
	{
		$body = nl2br($body);
		$body = str_replace("<br />", "*lbrr*", $body);
	}

	$array = array("0" => $poster,
		       "1" => $dateline,
		       "2" => $body);

	$new_comm = implode("|<->|", $array);

	$new_comm = trim($new_comm);
	$new_comm .= "|<->|<->|";

	$filename = "comments/".$postid.".php";
	$body_old = @file_get_contents($filename);
	
	$body = $body_old . $new_comm;

	$write = data_write($filename, $body, $body_old);
	if($write[0] == FALSE)
	{
		return $write[1];

	} elseif($write[0] == TRUE)
	{
		$output = $lang[9];
		$output = str_replace("{ID}", $postid, $output);

		return $output;
	}
}

################################################################################
# Used to encrypt admin user passwords

function password_encrypt($pass, $salt)
{
	$encrypt = md5($pass).$salt;
	$encrypt = sha1($encrypt);
	$encrypt = str_rot13($encrypt);

	return $encrypt;
}

################################################################################
# Used to retrieve the admins password so we can compare it with the cookie

function get_details($username, $userdb)
{
	if(is_int(strpos($userdb, $username)))
	{
		$ex = explode("|<->|<->|", $userdb);
		$ex = clean_array($ex);

		$num_array = count($ex);
		$i = '0';
	
		while($i < $num_array)
		{
			if(is_int(strpos($ex[$i], $username)))
			{
				$ex1 = explode("|<->|", $ex[$i]);
				$ex1 = clean_array($ex1);

				if($i == '0')
				{
					$user = explode("?>", $ex1[0]);
					$user1 = $user[1];
				} else
				{
					$user1 = $ex1[0];
				}

				if($user1 == $username)
				{
					# 0 = password - 1 = level - 2 = salt - 3 = email
					return array("0" => $ex1[1], "1" => $ex1[2], "2" => $ex1[3], "3" => $ex1[4]);
				} else
				{
					$i++;
					continue;
				}
			} else
			{
				$i++;
				continue;
			}

			$i++;
		}
		
		# Return false here as if the password was found the function would have finished and returned the password in $pass
		# If the function gets this far it means something went wrong and it couldn't find the password.

		return false;
	} else
	{
		return false;
	}
}

################################################################################
# Used to split cookies values to get username and password

function split_cookie($c)
{
	$ex = explode("||", $c);

	return array("0" => $ex[0], "1" => $ex[1]);
}

################################################################################
# Used to generate the admin menu based on which "level" the user is

function generate_menu($level)
{
	global $$level;

	$menu = "";
	
	if(in_array("settings", $$level))
	{
		$menu .= "<li><a href='#'>Script Configuration</a>
				<ul>
				<li><a href='index.php?action=settings'>Settings</a></li>
				<li><a href='index.php?action=permissions'>Permissions</a></li>
				</ul>
			 </li>";
	}

	if(in_array("users", $$level))
	{
		$menu .= "<li><a href='#'>User Administration</a>
				<ul>
				<li><a href='index.php?action=users&act=add'>Add User</a></li>
				<li><a href='index.php?action=users&act=manage'>Edit User</a></li>
				<li><a href='index.php?action=users&act=manage'>Delete User</a></li>
				</ul>		
			 </li>";
	}

	if(in_array("news", $$level))
	{
		$menu .= "<li><a href='#'>News Management</a>
				<ul>
				<li><a href='index.php?action=news&act=add'>Add News</a></li>
				<li><a href='index.php?action=news&act=manage'>Edit News</a></li>
				<li><a href='index.php?action=news&act=manage'>Delete News</a></li>
				</ul>		
			 </li>";
	}

	if(in_array("comments", $$level))
	{
		$menu .= "<li><a href='#'>Comments Management</a>
				<ul>
				<li><a href='index.php?action=comments'>Edit Comments</a></li>
				<li><a href='index.php?action=comments'>Delete Comments</a></li>
				</ul>		
			 </li>";
	}

	if(in_array("templates", $$level))
	{
		$menu .= "<li><a href='#'>Template Administration</a>
				<ul>
				<li><a href='index.php?action=templates&act=manage'>Modify Templates</a></li>
				<li><a href='index.php?action=templates&act=reset'>Reset Templates</a></li>
				</ul>			
			 </li>";
	}

	return $menu;
}


################################################################################
# Used to check if a folder and contents are all writable

function is_writable_dir($dir)
{
	if(is_writable($dir))
	{
		$handle = opendir($dir);
  		while($file = readdir($handle))
		{
			if($file == "." || $file == ".." || $file == "index.html")
			{
				continue;
			}

			if(!is_writable($dir.$file))
			{
				return false;	
			}
		}
		
		closedir($handle);
		return true;
	} else
	{
		return false;
	}
}

################################################################################
# Used to check the status of important files / folders

function sysinfo_check($install)
{
	global $lang, $version;
	$sysinfo = "";
	$error = '0';
	
	if($install == '0')
	{
		$sysinfo .= "<strong>Version:</strong> ".$version."<br />";
	}

	if(is_writable("../includes/config.php"))
	{
		$sysinfo .= "<span class='good'>".$lang[18][1]."</span><br />";
	} else
	{
		$sysinfo .= "<span class='bad'>".$lang[18][0]."</span><br />";

		$error++; # Error var used on install scripted
	}

	if(is_writable("../includes/user.db.php"))
	{
		$sysinfo .= "<span class='good'>".$lang[19][1]."</span><br />";
	} else
	{
		$sysinfo .= "<span class='bad'>".$lang[19][0]."</span><br />";

		$error++; # Error var used on install scripted
	}

	if(is_writable("../includes/permissions.db.php"))
	{
		$sysinfo .= "<span class='good'>".$lang[19][3]."</span><br />";
	} else
	{
		$sysinfo .= "<span class='bad'>".$lang[19][2]."</span><br />";

		$error++; # Error var used on install scripted
	}

	if(is_writable_dir("../news/"))
	{
		$sysinfo .= "<span class='good'>".$lang[20][1]."</span><br />";
	} else
	{
		$sysinfo .= "<span class='bad'>".$lang[20][0]."</span><br />";

		$error++; # Error var used on install scripted
	}
	
	if(is_writable_dir("../comments/"))
	{
		$sysinfo .= "<span class='good'>".$lang[21][1]."</span><br />";
	} else
	{
		$sysinfo .= "<span class='bad'>".$lang[21][0]."</span><br />";

		$error++; # Error var used on install scripted
	}

	if(is_writable_dir("../templates/"))
	{
		$sysinfo .= "<span class='good'>".$lang[22][1]."</span><br />";
	} else
	{
		$sysinfo .= "<span class='bad'>".$lang[22][0]."</span><br />";
		$error++; # Error var used on install scripted

	}

	if($install == '0')
	{
		return $sysinfo;
	} else
	{
		return array($sysinfo, $error);
	}
}

########################################################
# Counts ALL the comments

function count_all_comments($news_count, $inadmin)
{
	$ccount = "0";
	$i = '1';
	$postID = '1';
	while($i <= $news_count)
	{
		if(!file_exists("../comments/".$postID.".php"))
		{
			$postID++;
			continue;
		}

		$comm = @file_get_contents("../comments/".$postID.".php");

		if(check_comments($comm) == FALSE)
		{
			$count = "0";
		} else
		{
			$ex = explode("|<->|<->|", $comm);

			$ex = clean_array($ex);

			$count = count($ex);
		}

	
		$ccount += $count;

		$i++;
		$postID++;	
	}

	return $ccount;
}	

########################################################
# Counts the users

function count_users($inadmin)
{
	if($inadmin == '1')
	{
		$path = "../";
	}
	
	$file = file_get_contents($path."includes/user.db.php");
	
	$ex = explode("|<->|<->|", $file);
	$ex = clean_array($ex);
	
	$users = count($ex);
	$file = "";

	return $users;
}
########################################################
# used to make sure the user has permissions to access that page

function perm_check($level, $page, $type)
{
	global $$level;

	if(!in_array($page, $$level))
	{
		if($type == 'page')
		{
			return FALSE;
		} else
		{
			return "";
		}
	} else
	{
		if($type == 'page')
		{
			return TRUE;
		} else
		{
			return "checked='checked'";
		}
	}
}


########################################################
# returns checked string if a value == '1'

function checkbox($value, $type)
{
	if($value == '1')
	{
		if($type == 'tick')
		{
			$str = "checked='checked'";
		} else
		{
			$str = "1";
		}
	} else
	{
		if($type == 'tick')
		{
			$str = "";
		} else
		{
			$str = "0";
		}
	}

	return $str;
}

####################################################################################
# checks to make sure the admin doesn't input |<->| as this could break the script

function input_check($str)
{
	if(strpos($str, "|<->|<->|"))
	{
		return FALSE;
	}

	if(strpos($str, "|<->|"))
	{
		return FALSE;
	}

	return TRUE;
}

##########################################################################################################
# performs the neccessary checks on inputted data then returns the data for use or increments the error

function input_process($var, $error)
{
	if(!input_check($var))
	{
		$error++;
		$out2 = $error;
	} else
	{
		$out1 = $var;		
	}

	return array($out1, $out2);
}

#####################################################
# builds the new permissions array ready for writing

function build_new_permissions($var)
{
	$i = '0';
	$num_array = count($var);
	$str = array();

	while($i < $num_array)
	{
		$str[$i] = "\"".$i."\" => \"".$var[$i]."\"";
	
		$i++;
	}
	
	$perm = implode(",", $str);

	$new_perm = "array(".$perm.");";

	return $new_perm;
}

#####################################################
# sanitise function to remove php tags and custom seperator

function clean_input($str)
{
	if(strpos($str, "|<->|") || strpos($str, "|<->|<->|"))
	{
		return FALSE;
	}

	$str = strip_tags($str);	
	return $str;
}

#####################################################
# checks for a valid email address - credit to www.ilovejackdaniels.com

function check_email_address($email) 
{
	if(!ereg("^[^@]{1,64}@[^@]{1,255}$", $email)) 
	{
		return FALSE;
	}

	$email_array = explode("@", $email);
	$local_array = explode(".", $email_array[0]);
	for ($i = 0; $i < sizeof($local_array); $i++)
	{
		if(!ereg("^(([A-Za-z0-9!#$%&'*+/=?^_`{|}~-][A-Za-z0-9!#$%&'*+/=?^_`{|}~\.-]{0,63})|(\"[^(\\|\")]{0,62}\"))$", $local_array[$i])) 
		{
			return FALSE;
		}
	}

	if(!ereg("^\[?[0-9\.]+\]?$", $email_array[1])) 
	{ 
		$domain_array = explode(".", $email_array[1]);
		if(sizeof($domain_array) < 2) 
		{
			return FALSE;
		}
		
		for ($i = 0; $i < sizeof($domain_array); $i++) 
		{
			if(!ereg("^(([A-Za-z0-9][A-Za-z0-9-]{0,61}[A-Za-z0-9])|([A-Za-z0-9]+))$", $domain_array[$i])) 
			{
				return FALSE;	
			}
		}
	}
	return $email;
}







?>