<?php

header ('Content-Type: text/xml');

$basepath = str_replace ('\\', '/', dirname (__FILE__)) . '/';
include $basepath . 'config.php';
include $basepath . 'functions.php';

if ( $enable_rss )
{
	exit;
}

$fn_category = ( isset ($_GET['fn_category']) ) ? intval ($_GET['fn_category']) : 0;

$file = arrange_by_date();

$total_posts = sizeof ($file);
if ( $total_posts <= 0 )
{
	exit;
}

$current_date = date ('r');

echo <<< rss
<?xml version="1.0" encoding="$rss_encoding"?>
<rss version="2.0">

<channel>
	<title>$rss_title</title>
	<link>$hurl</link>
	<description>$rss_description</description>
	<pubDate>$current_date</pubDate>
	<lastBuildDate>$current_date</lastBuildDate>
	<generator>Fusion News</generator>

rss;

if ( $fn_category > 0 )
{
	$file = file ($basepath . 'categories.php');
	array_shift ($file);

	$category_exists = false;
	foreach ( $file as $value )
	{
		$category = explode ('|<|', $value);
		if ( $category[0] == $fn_category )
		{
			$category_exists = true;
			echo "\t" . '<category>' . $category[1] . '</category>' . "\n";
		}
	}
	
	if ( !$category_exists )
	{
		// Fall back
		$fn_category = 0;
	}
}

$file = arrange_by_date();
foreach ( $file as $newsdata )
{
	list ($id, $timestamp, $writer, $subject, $categories) = explode ('|<|', $newsdata);
	
	if ( file_exists ($basepath . 'news/news.' . $id . '.php') )
	{
		$news_file = file ($basepath . 'news/news.' . $id . '.php');
		array_shift ($news_file);
		
		list ($shortnews, $fullnews, $writer, $subject, $categories, $timestamp, $num_comments, $id) = explode ('|<|', $news_file[0]);
		
		if ( $fn_category === 0 || in_array ($fn_category, explode (',', $categories)) )
		{
			$news_info = parse_news_to_view ($news_file[0]);
			$news_info['date'] = date ('r', $timestamp);
			
			echo <<< rss
	<item>
		<title>{$news_info['subject']}</title>
		<link>{$furl}/fullnews.php?id={$id}</link>
		<description>{$news_info['news']}</description>
		<author>{$news_info['writer']}</author>
		<pubDate>{$news_info['date']}</pubDate>
		<comments>{$furl}/comments.php?id={$id}</comments>
		<guid isPermaLink="false">fus_{$id}</guid>
	</item>

rss;
		}
	}
}

echo <<< rss
</channel>

</rss>
rss;

?>