<?php

/*
||==========================================================
||		Fusion News 3.x
||----------------------------------------------------------
|| File Version	: $Id: check_chmod.php 83 2007-02-11 16:29:23Z xycaleth $
|| Contact	: xycaleth@gmail.com
|| Copyright:	: (c) 2006, FusionNews.net
|| License Info	: http://www.gnu.org/copyleft/gpl.html
||==========================================================
*/

$plugin_link = "<a href=\"./plugins/check_chmod.php\">Check CHMOD plugin</a>";
$plugin_version = 'v0.0.0.3';
$plugin_description = "This plugin allows you to add the capability for the script to check if the critical files can be accessed for reading and writing. It's a test script to show the capabilities of the plugin feature. <br /> Update: Now it also shows the statistics.<br />This plugin is activated by default.";
$plugin_name = "Check CHMOD";

if (!function_exists('add_magic_quotes')) {
	function add_magic_quotes($array) {
		foreach ($array as $k => $v) {
			if (is_array($v)) {
				$array[$k] = add_magic_quotes($v);
			} else {
				$array[$k] = addslashes($v);
			}
		}
		return $array;
	}
}

if(!get_magic_quotes_gpc()) {
	$_GET     = add_magic_quotes($_GET);
	$_POST    = add_magic_quotes($_POST);
	
	if ( isset ($_SESSION) && is_array ($_SESSION) )
	{
		$_SESSION = add_magic_quotes($_SESSION);
	}
}

$id = ( isset ($VARS['id']) ) ? $VARS['id'] : '';

function check_file_access($folder){
	global $cookies, $userdata;

	$data = '<div style="text-align: center">';
	$files = array (
		"news",
		"news/toc.php",
		"badwords.txt",
		"banned.php",
		"categories.php",
		"config.php",
		"flood.php",
		"fusionnews.xml",
		"headlines.php",
		"news.php",
		"sessions.php",
		"smillies.db",
		"users.php",
	);
	
	if ( has_access (1) )
	{
		$data .= 'Welcome, <b>' . $userdata['nick'] . '</b>!';
	}

	$data .= '<table width="100%" border="0" cellpadding="0" cellspacing="0">' . "\n";

	$array = array();

	foreach ( $files as $value )
	{
		if ( !is_writeable ($folder.$value) )
		{
			$array[]= "   <tr>\n
			<td align=\"center\" width=\"50%\">Can not read/write to ".$value."</td>\n
			<td align=\"center\" width=\"50%\"><span style=\"color:red\">please chmod to 777</span></td>
			</tr>\n";
		}
	}

	if ( count($array) === 0 ){
		$data .= "  <tr>\n
		<td align=\"center\" colspan=\"2\"><span style=\"color:green\">Congratulations, all files are accessible!</span></td>
		</tr>\n";
	}else{
		foreach ($array as $value ){
			$data .= $value;
		}
	}

	$data .= "</table><br />\n";

	$count = 0;
	$count_today = 0;
	$count_user = 0;
	if (has_access( 1 ))
	{
		if( file_exists("./news/toc.php") )
		{
			$file = file("./news/toc.php");
			my_array_shift($file);

			$today = strtotime(date("m/d/Y", strtotime("now")));
			
			foreach( $file as $value){
				if ( $value != "" ){
					$count++;
					list($news_id,$news_date,$news_writer,$news_subject) = explode("|<|", $value);
					if ( $news_date > $today && $news_date < $today+86400 )
						$count_today++;
						
					if ( $news_writer == $userdata['user'] )
						$count_user++;
				}
			}
		}

		$data .= 'There are <b>' . $count . '</b> news items in your database. You wrote <b>' . $count_user . '</b> of them.<br />' . "\n";
		$data .= 'There have been <b>' . $count_today . '</b> news item' . (( $count_today === 1 ) ? '' : 's') . ' posted today.<br />';
		return $data . '<br /><b>What do you want to do today:</b></div>';
	}
}

if ( $id == "" ){
  global $plugin_active;
  if ( ! $plugin_active ){
     $example = "";
     //$example = "<p><br /><b>Example</b>:".check_file_access("../")."</p>";
echo <<<html
      <html>

      <head>
      <meta http-equiv="Content-Type" content="text/html; charset=windows-1252">
      <title>Fusion News - Check if critical files are accessible</title>
      <style>
      <!--
      body, td { color: #000000; font: 10pt verdana; font-weight: none; text-decoration: none; }
      -->
      </style>
      </head>

      <body style="font-family: Verdana; font-size: 10pt">
      This plugin adds the capability to check if your files and folders have been
      given the right access rights and shows you it's findings on the main Fusion
      News page.<p><br />
      <br /><b>To activate this plugin, you need to add some code to the index page.</b><br />
      <br /><b>File to edit</b>: index.php (in main installation folder of Fusion News)<br />
      <br /><b>Code that needs to be added</b>:<br />
      </p>
      <table border="1" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#DCDCDC" width="100%">
        <tr>
          <td width="100%"><font color="#000080">&#36;plugin_active</font> =
          <font color="#008000">TRUE</font>;<br />
          include (<font color="#000080">&#36;fpath</font>.<font color="#FF0000">&quot;plugins/check_chmod.php&quot;</font>);<br />
          <font color="#000080">&#36;content</font> = check_file_access(<font color="#FF0000">&quot;./&quot;</font>);<br />
          <font color="#000080">&#36;content</font> .= <font color="#000080">&#36;ind13</font>;</td>
        </tr>
      </table>

      <br />On a clean installation the insertion of the above code should be on
      linenumber <b>47 </b>of &quot;<b>index.php</b>&quot;.<br />
      <br /><b>right after</b>:<br />
      <table border="1" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#DCDCDC" width="100%" id="AutoNumber1">
        <tr>
          <td width="100%">
        <font size="2"><font color="#008000">if</font>(<font color="#000080">&#36;first</font>
          == <font color="#FF0000">&quot;yes&quot;</font>){<br />
          <font color="#000080">&#36;title</font> = <font color="#000080">&#36;ind2</font>;<br />
          <font color="#000080">&#36;content</font> = <font color="#000080">&#36;ind1</font>;<br />
          }<font color="#008000">elseif</font>(has_access( 1 )){<br />
          <font color="#000080">&#36;title</font> = <font color="#000080">&#36;ind9</font>;<br /><td>
        </tr>
      </table>
      <br /><b>and right before</b>:<br />
      <table border="1" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#DCDCDC" width="100%" id="AutoNumber2">
        <tr>
          <td width="100%"><font color="#008000">if</font>(has_access( 3 )){<br />
          <font color="#000080">&#36;content</font> .= <font color="#000080">&#36;ind11</font>;<br />
          }<br />
          i<font color="#008000">f</font>(has_access( 2 )&amp;&amp;(! has_access( 3 ))){<br />
          <font color="#000080">&#36;content</font> .= <font color="#000080">&#36;ind12</font>;<br />
          }</td>
        </tr>
      </table>
      <br /><b>this means that you have to delete 1 line between the &quot;right before&quot; and
      &quot;right after&quot; part.</b>
      <table border="1" cellpadding="0" cellspacing="0" style="border-collapse: collapse" bordercolor="#DCDCDC" width="100%" id="AutoNumber2">
        <tr>
          <td width="100%" style="color: #000000; font-style: normal; font-variant: normal; font-weight: none; font-size: 10pt; font-family: verdana; text-decoration: none">
          <font color="#000080">&#36;content</font> = <font color="#000080">&#36;ind13</font>;</td>
        </tr>
      </table>
      $example
      </body>

      </html>
html;
  }
}

if ( $id == "plugin" ){

}

?>
