<?php

# Edit the line below to align the page list (left, center, right)
$page_align = 'center';

$basepath = str_replace ('\\', '/', dirname (__FILE__)) . '/';
include $basepath . 'config.php';
include $basepath . 'functions.php';

$fn_page = ( isset ($_GET['fn_page']) ) ? intval ($_GET['fn_page']) : 1;
$fn_page = ( $fn_page < 1 ) ? 1 : $fn_page;

$fn_category = ( isset ($fn_category) ) ? intval ($fn_category) : 0;

$file = arrange_by_date();

$total_posts = sizeof ($file);
if ( $total_posts <= 0 )
{
	exit;
}

$valid_posts = array();
for ( $i = 0; $i < $total_posts; $i++ )
{
	list ($id, $timestamp, $writer, $subject, $categories) = explode ('|<|', $file[$i]);
	
	if ( file_exists ($basepath . 'news/news.' . $id . '.php') )
	{
		$news_file = file ($basepath . 'news/news.' . $id . '.php');
		array_shift ($news_file);
		
		list ($shortnews, $fullnews, $writer, $subject, $categories, $timestamp, $num_comments, $id) = explode ('|<|', $news_file[0]);
		
		if ( $fn_category === 0 || in_array ($fn_category, explode (',', $categories)) )
		{
			$valid_posts[] = $news_file[0];
		}
	}
}

$total_posts = sizeof ($valid_posts);

$max_pages = ceil ($total_posts / $numofposts);
$fn_page = ( $fn_page > $max_pages ) ? $max_pages : $fn_page;

$pagination = NULL;
for ( $i = 1; $i <= $max_pages; $i++ )
{
	if ( $i > 1 )
	{
		$pagination .= '&nbsp;';
	}

	if ( $fn_page == $i )
	{
		$pagination .= '<b>' . $i . '</b>';
	}
	else
	{
		$pagination .= '<a href="?fn_page=' . $i;
	
		if ( sizeof ($_GET) > 1 )
		{
			foreach ( $_GET as $key => $value )
			{
				if ( $key != 'fn_page' )
				{
					$pagination .= '&amp;' . $key . '=' . $value;
				}
			}
		}
		
		$pagination .= '">' . $i . '</a>';
	}
}

$end = $fn_page * $numofposts;

$pagination = '<div style="text-align:' . $page_align . '">' . $pagination . '</div>';
echo $pagination;

for ( $i = $end - $numofposts; $i < $end; $i++ )
{
	if ( !isset ($valid_posts[$i]) )
	{
		break;
	}
	
	$news_info = parse_news_to_view ($valid_posts[$i]);
	echo $news_info['display'];
}

echo $pagination;