<?php
/*
||==========================================================
||		Fusion News 3.x
||----------------------------------------------------------
|| File Version	: $Id: install.php 54 2006-12-29 19:28:21Z xycaleth $
|| Contact	: xycaleth@gmail.com
|| Copyright:	: (c) 2006, FusionNews.net
|| License Info	: http://www.gnu.org/copyleft/gpl.html
||==========================================================
*/

if ( file_exists ('./install.lock') )
{
	die ('The installation file has been locked.');
}

include './functions.php';

/**
 * Taken straight from common.php :D
 **/
$VARS = array();
$clean_k = '';

foreach ( $_GET as $k => $v )
{
	if ( is_array ($v) )
	{
		$clean_k = clean_key ($k);
		//$VARS[$clean_k] = $v;
	
		foreach ( $v as $_k => $_v )
		{
			$VARS[$clean_k][clean_key ($_k)] = clean_value ($_v);
		}
	}
	else
	{
		$VARS[clean_key ($k)] = clean_value ($v);
	}
}

foreach ( $_POST as $k => $v )
{
	if ( is_array ($v) )
	{
		$clean_k = clean_key ($k);
		//$VARS[$clean_k] = $v;
	
		foreach ( $v as $_k => $_v )
		{
			$VARS[$clean_k][clean_key ($_k)] = clean_value ($_v);
		}
	}
	else
	{
		$VARS[clean_key ($k)] = clean_value ($v);
	}
}
     
$step = ( isset ($VARS['step']) ) ? intval ($VARS['step']) : 1;

// Creates a random string of numbers and letters, uppercase and lowercase, of the specified length ($length)
function randstr ( $length = 32 )
{
	$str = '';
	mt_srand ((double)microtime() * 10000);
	for ( $i = 0; $i < $length; $i++ )
	{
		$x = mt_rand (1, 3);
		$str .= (($x == 1) ? chr(mt_rand(48,57)) : (($x == 2) ? chr(mt_rand(65,90)) : chr(mt_rand(97,122))));
	}

	return $str;
}

// Returns the URL of the install.php file.
function geturl()
{
	$this_url = 'http://' . $_SERVER['SERVER_NAME'] . substr (str_replace (basename (__FILE__), '', $_SERVER['SCRIPT_NAME']), 0, -1);
	
	return $this_url;
}

// Returns the absolute path of the install.php file.
function getpath()
{
	return str_replace ('\\', '/', dirname (__FILE__)) . '/';
}

$serverurl	= $_SERVER['SERVER_NAME'];
$fullurl	= geturl();
$path		= getpath();
$file		= './install.php';

$curve		= '3.8.0';

$title = 'Fusion News v' . $curve . ' Installation';

// Step 1:
// Introduction
if ( $step == 1 )
{
	$content =
<<< html
<p>Welcome to the Fusion News installation process! Before you can start using Fusion News, you need to follow a few
quick and simple steps.</p>
<div style="text-align:center">
<input type="button" class="mainoption" onclick="document.location='{$file}?step=2'" value="Begin >>>" />
</div>
html;
}

// Step 2:
// Check PHP version and checks if we have GD library installed/enabled.
else if ( $step == 2 )
{
	$yes = '<span style="color:#00BB00; font-weight:bold">Yes</span>';
	$no = '<span style="color:#FF0000; font-weight:bold">No<span>';

	$php_version_check = ( version_compare (phpversion(), '4.1.0', '>=') >= 0 ) ? $yes : $no;
	
	if ( !extension_loaded ('gd') )
	{
		$gd_library_check = $no;
	}
	else
	{
		$gd_info = gd_info();
		preg_match ('/\d/', $gd_info['GD Version'], $match);
		if ( strstr ($gd_info['GD Version'], 'bundled') && $match[0] >= 2 )
		{
			$gd_library_check = $yes;
		}
		else
		{
			$gd_library_check = $no;
		}
	}

	$content =
<<< html
In this step, the installer will check if you have the minimum requirements for Fusion News to run properly.<br />
<div style="width:50%; margin-right:auto; margin-left:auto">
<table style="width:100%">
	<tr>
		<td style="width:50%">PHP 4.1+ Installed?</td>
		<td style="width:50%; text-align:right">$php_version_check</td>
	</tr>
	<tr>
		<td style="width:50%">GD2 Library Installed?</td>
		<td style="width:50%; text-align:right">$gd_library_check</td>
	</tr>
</table>
</div>
html;

	if ( $php_version_check == $yes && $gd_library_check == $yes )
	{
		$content .= '<div style="text-align:center"><input type="button" class="mainoption" onclick="document.location=\'' . $file . '?step=3\'" value="Continue >>>" /></div>';
	}
	else
	{
		$content .= '<span style="color:#FF0000; font-weight:bold">Your webhost/server does not have the minimum requirements needed for Fusion News to run properly.</span>';
	}
}

// Step 3:
// Show user which files should have what file permissions.
else if ( $step == 3 )
{
	$files = array (
		array ('news/fonts/VeraMono.ttf', '0'),
		array ('news/toc.php', '0666'),
		array ('plugins/check_chmod.php', '0'),
		array ('skins/fusion/index.html', '0'),
		array ('skins/fusion/stylesheet.css', '0'),
		array ('skins/fusion/images/header.png', '0'),
		array ('skins/fusion/images/page_background.jpg', '0'),
		array ('skins/fusion/images/table_background.png', '0'),
		array ('skins/fusion/images/table_bottom.png', '0'),
		array ('templates/arch_fullnews_temp.php', '0666'),
		array ('templates/arch_news_temp.php', '0666'),
		array ('templates/com_footer.php', '0666'),
		array ('templates/com_fulltemp.php', '0666'),
		array ('templates/com_header.php', '0666'),
		array ('templates/com_temp.php', '0666'),
		array ('templates/footer.php', '0666'),
		array ('templates/fullnews_temp.php', '0666'),
		array ('templates/header.php', '0666'),
		array ('templates/headline_temp.php', '0666'),
		array ('templates/news_a_day_temp.php', '0666'),
		array ('templates/news_temp.php', '0666'),
		array ('templates/sendtofriend_temp.php', '0666'),
		array ('archive.php', '0'),
		array ('badwords.txt', '0666'),
		array ('banned.php', '0666'),
		array ('comments.php', '0'),
		array ('common.php', '0'),
		array ('config.php', '0666'),
		array ('flood.php', '0666'),
		array ('fullnews.php', '0'),
		array ('functions.php', '0'),
		array ('fusionnews.xml', '0666'),
		array ('headlines.php', '0666'),
		array ('index.php', '0'),
		array ('jsfunc.js', '0'),
		array ('language.db.php', '0'),
		array ('news.php', '0666'),
		array ('rss.php', '0666'),
		array ('search.php', '0'),
		array ('send.php', '0'),
		array ('sessions.php', '0666'),
		array ('smillies.db', '0666'),
		array ('static_news.html', '0666'),
		array ('upload.php', '0'),
		array ('users.php', '0666')
	);
	$num_files = sizeof ($files);
	
	$directory = array (
		array ('', '0777'),
		array ('img', '0'),
		array ('news', '0777'),
		array ('news/fonts', '0'),
		array ('plugins', '0'),
		array ('skins', '0'),
		array ('skins/fusion', '0'),
		array ('smillies', '0777'),
		array ('templates', '0777'),
		array ('uploads', '0777')
	);
	$num_directories = sizeof ($directory);

	$content =
<<< html
<p>Here the installer will first check if all the essential files exist, and then check if the correct file permissions on your files have been
applied. Any files or directories which do not have a CHMOD value can be left as it was when it was uploaded.<br /><br />
If any results dont come out as <font color="#00BB00"><b>Good</b></font>, then you should use a FTP client (such as SmartFTP, FileZilla, WS_FTP,
etc) and correct the problems shown in the results column of the table.</p>
<table class="adminpanel">
	<tr style="background-color:whitesmoke">
		<th style="width:60%">Directory Name</th>
		<th style="width:20%">CHMOD Value</th>
		<th style="width:20%">Result</th>
	</tr>
html;

	$result = '';
	$permission = 0;
	$bad_results = 0;
	
	// Clears all cached information about files and directories
	clearstatcache();

	for ( $i = 0; $i < $num_directories; $i++ )
	{
		$permission = substr ($directory[$i][1], 1);
		$permission = ( !$permission ) ? '-' : substr ($directory[$i][1], 1);
	
		if ( !file_exists ($path . $directory[$i][0]) )
		{
			$result = '<span style="color:#FF0000; font-weight:bold">Doesn\'t Exist</span>';
			$bad_results++;
		}
		else if ( $permission == '0777' && (!is_writable ($path . $directory[$i][0]) || !is_readable ($path . $directory[$i][0])) )
		{
			$result = '<span style="color:#FF0000; font-weight:bold">Incorrect Permission</span>';
			$bad_results++;
		}
		else
		{
			$result = '<span style="color:#00BB00; font-weight:bold">Good</span>';
		}
		
		if ( !$directory[$i][0] )
		{
			$directory[$i][0] = 'Fusion News directory';
		}
		
		$content .=
<<< html
	<tr>
		<td>{$directory[$i][0]}</td>
		<td align="center">$permission</td>
		<td align="center">$result</td>
	</tr>
html;
	}
	
	$content .=
<<< html
</table>
<p></p>
<table class="adminpanel">
	<tr style="background-color:whitesmoke">
		<th style="width:60%">File Name</th>
		<th style="width:20%">CHMOD Value</th>
		<th style="width:20%">Result</th>
	</tr>
html;

	for ( $i = 0; $i < $num_files; $i++ )
	{
		$permission = substr ($files[$i][1], 1);
		$permission = ( !$permission ) ? '-' : substr ($files[$i][1], 1);
	
		if ( !file_exists ($path . $files[$i][0]) )
		{
			$result = '<span style="color:#FF0000; font-weight:bold">Doesn\'t Exist</span>';
			$bad_results++;
		}
		else if ( $permission == '0666' && (!is_writable ($path . $files[$i][0]) || !is_readable ($path . $files[$i][0])) )
		{
			$result = '<span style="color:#FF0000; font-weight:bold">Incorrect Permission</span>';
			$bad_results++;
		}
		else
		{
			$result = '<span style="color:#00BB00; font-weight:bold">Good</span>';
		}
		
		$content .=
<<< html
	<tr>
		<td>{$files[$i][0]}</td>
		<td align="center">$permission</td>
		<td align="center">$result</td>
	</tr>
html;
	}
	
	$content .= '</table>';
	
	if ( $bad_results )
	{
		$content .= '<p><span style="color:#FF0000">The installer found ' . $bad_results . ' problems. Please correct these problems before continuing.</span></p>';
	}
	else
	{
		$content .= '<div style="text-align:center"><br /><input type="button" class="mainoption" onclick="document.location=\'' . $file . '?step=4\'" value="Continue >>>" /></div>';
	}
}

// Step 4:
// Check website path, and enter username/password details
else if ( $step == 4 )
{
	$content =
<<< html
This is the final step which requires you to do work! Simply fill in the fields below and click Continue.<br /><br />
<center>
<form method="post" action="$file?step=5">
<table class="adminpanel">
	<tr>
		<th style="background-color:whitesmoke" colspan="2">Website URL</th>
	</tr>
	<tr>
		<td style="text-align:right">Website URL:&nbsp;&nbsp;</td>
		<td style="width:50%"><input type="text" class="post" name="website_url" value="http://{$serverurl}" size="20" /></td>
	</tr>
	<tr>
		<th style="background-color:whitesmoke" colspan="2">Administrator User</th>
	</tr>
	<tr>
		<td style="text-align:right">Log In Name:&nbsp;&nbsp;</td>
		<td><input type="text" class="post" name="username" size="20" /></td>
	</tr>
	<tr>
		<td style="text-align:right">Nick Name:&nbsp;&nbsp;</td>
		<td><input type="text" class="post" name="nick" size="20" /></td>
	</tr>
	<tr>
		<td style="text-align:right">Email Address:&nbsp;&nbsp;</td>
		<td><input type="text" class="post" name="email" size="20" /></td>
	</tr>
	<tr>
		<td>&nbsp;</td>
		<td><input type="checkbox" class="post" id="hideemail" name="hideemail" /> <label for="hideemail">Hide Email?</label></td>
	</tr>
	<tr>
		<td style="text-align:right">Password:&nbsp;&nbsp;</td>
		<td><input type="password" class="post" name="password" size="20" /></td>
	</tr>
	<tr>
		<td style="text-align:right">Confirm Password:&nbsp;&nbsp;</td>
		<td><input type="password" class="post" name="confirmpass" size="20" /></td>
	</tr>
	<tr>
		<th style="background-color:whitesmoke" colspan="2"><input type="submit" class="mainoption" value="Continue >>>" /></th>
	</tr>
</table>
</form>
html;
}

// Step 5:
// Process the data...write the stuff to files and blam, we're done.
else if ( $step == 5 )
{
	$website_url	= ( isset ($VARS['website_url']) ) ? $VARS['website_url'] : '';
	$username	= ( isset ($VARS['username']) ) ? substr ($VARS['username'], 0, 40) : '';
	$nick		= ( isset ($VARS['nick']) ) ? substr ($VARS['nick'], 0, 40) : '';
	$email		= ( isset ($VARS['email']) ) ? $VARS['email'] : '';
	$password	= ( isset ($VARS['password']) ) ? substr ($VARS['password'], 0, 40) : '';
	$confirmpass	= ( isset ($VARS['confirmpass']) ) ? substr ($VARS['confirmpass'], 0, 40) : '';
	$hideemail	= ( isset ($VARS['hideemail']) ) ? 'checked' : '';
	
	if ( !$website_url || !$username || !$nick || !$email || !$password || !$confirmpass )
	{
		$content = 'One or more of the fields were left blank.';
	}
	else if ( !valid_email ($email) )
	{
		$content = 'You entered an invalid email address.';
	}
	else if ( $password != $confirmpass )
	{
		$content = 'The passwords you entered do not match.';
	}
	else
	{
	
		$username = str_replace ('|', '&#124;', $username);
		$nick = str_replace ('|', '&#124;', $nick);
	
		// Let's start off by creating the new user...
		$data = '<?php die (\'You may not access this file.\'); ?>' . "\n";
		$data .= $username . '|<|' . $nick . '|<|' . $hideemail . '=' . $email . '|<||<|0|<|' . md5 ($password) . '|<|3|<|' . "\n";
		$fp = fopen ($path . 'users.php', 'wb');
		fputs ($fp, $data, strlen ($data));
		fclose ($fp);
		
		// Now we need to write the config.php file. Predefined settings
		// are made to be what (I think) to be what most people would need.
		$fusion_id = randstr();
		
		$config_save =
<<< html
<?php

\$fusion_id = '$fusion_id';
\$site = '$website_url';
\$furl = '$fullurl';
\$hurl = '{$website_url}/';
\$fpath = '$path';
\$datefor = 'Y-m-d H:i:s T';
\$numofposts = 10;
\$numofh = 5;
\$bb = 1;
\$ht = 0;
\$post_per_day = 0;
\$wfpost = 1;
\$wfcom = 1;
\$skin = 'fusion';
\$cbwordwrap = 0;
\$wwwidth = 80;
\$smilies = 1;
\$stfpop = 1;
\$comallowbr = 1;
\$stfwidth = 640;
\$stfheight = 480;
\$fslink = 'read more...';
\$stflink = 'tell a friend';
\$pclink = 'comments';
\$fsnw = 1;
\$cbflood = 1;
\$floodtime = 30;
\$comlength = 300;
\$fullnewsw = 640;
\$fullnewsh = 480;
\$fullnewss = 1;
\$stfresize = 1;
\$stfscrolls = 1;
\$fullnewsz = 1;
\$htc = 0;
\$smilcom = 1;
\$bbc = 1;
\$compop = 1;
\$comscrolls = 1;
\$comresize = 1;
\$comheight = 480;
\$comwidth = 640;
\$uploads_active = 1;
\$uploads_size = 1048576;
\$uploads_ext = 'gif&#124;jpg&#124;jpeg&#124;png&#124;bmp';
\$enable_rss = 1;
\$link_headline_fullstory = 0;
\$flip_news = 0;
\$rss_title = '';
\$rss_description = '';
\$rss_encoding = 'iso-8859-1';
\$com_validation = 1;
\$com_captcha = 1;

?>
html;
		$fp = fopen ($path . 'config.php', 'wb');
		fputs ($fp, $config_save, strlen ($config_save));
		fclose ($fp);
		
		//////////////////////////////////////////////////////////////
		// Now we create the first news post. It's an improvement over the
		// previous way of doing it because you would end up with a post
		// made by a non-existant user. This way we're using the existing
		// user to make the post.
		//////////////////////////////////////////////////////////////
		$current_time	= time();
		$formatted_date	= date ('Y-m-d H:i:s T', $current_time);
		
		// Here's what the subject and news posts are going to be so I can change
		// it in one place, and everything else changes.
		$subject = 'Welcome to Fusion News!';
		$news_story = 'Welcome to Fusion News v' . $curve . '! You may delete this post as it is only a test post.';
		
		// Start off by adding it to the table of contents (toc.php).
		$data = '<?php die (\'You may not access this file.\'); ?>' . "\n";
		$data .= '1|<|' . $current_time . '|<|' . $username . '|<|' . $subject . '|<|1|<|' . "\n";
		
		$fp = fopen ($path . 'news/toc.php', 'w');
		fputs ($fp, $data, strlen ($data));
		fclose ($fp);
		
		// Then we create the actual news file...
		$data = '<?php die (\'You may not access this file.\'); ?>' . "\n";
		$data .= $news_story . '|<||<|' . $username . '|<|' . $subject . '|<|1|<|' . $current_time . '|<|0|<|1|<|' . "\n";
		
		$fp = fopen ($path . 'news/news.1.php', 'w');
		fputs ($fp, $data, strlen ($data));
		fclose ($fp);
		
		// Then the news in news.php...
		$user = ( $hideemail == 'checked' ) ? $nick : '<a href="mailto:' . $email . '">' . $nick . '</a>';
		
		/*
		<div style="width: 95%; margin-left: auto; margin-right: auto">
<h2><a id="fus_5"></a>Test</h2>
<small>Posted by <a href="mailto:xycaleth@gmail.com">Alex</a> on 2007-02-23 10:40:43 GMT</small>
<p>Hello there. </p>
<p><a href="http://localhost/fusionphp/fnews3/send.php?id=5" onclick="window.open(this.href,'','height=480,width=640,toolbar=no,menubar=no,scrollbars=1,resizable=1'); return false">tell a friend</a> :: <a href="http://localhost/fusionphp/fnews3/comments.php?id=5" onclick="window.open(this.href,'','height=480,width=640,toolbar=no,menubar=no,scrollbars=1,resizable=1'); return false">comments</a> 0</p>
</div>
*/
		$data  = '<div style="width: 95%; margin-left: auto; margin-right: auto">';
		$data .= '<h2><a id="fus_1"></a>' . $subject . '</h2>';
		$data .= '<small>Posted by ' . $user . ' on ' . $formatted_date . '</small>';
		$data .= '<p>$news_story</p>';
		$data .= '<p><a href="' . $fullurl . '/send.php?id=1" onclick="window.open(this.href,\'\',\'height=480,width=640,toolbar=no,menubar=no,scrollbars=1,resizable=1\'); return false">tell a friend</a> :: <a href="' . $fullurl . '/comments.php?id=1" onclick="window.open(this.href,\'\',\'height=480,width=640,toolbar=no,menubar=no,scrollbars=1,resizable=1\'); return false">comments</a>: 0</p>';
		$data .= '</div>';
		
		$fp = fopen ($path . 'static_news.html', 'wb');
		fputs ($fp, $data, strlen ($data));
		fclose ($fp);
		
		// And then we have the headlines.php file...
		$data = '<a href="' . $fullurl . '/fullnews.php?id=1">' . $subject . '</a> posted by ' . $user . '</a> on ' . $formatted_date;
		
		$fp = fopen ($path . 'headlines.php', 'w');
		fputs ($fp, $data, strlen ($data));
		fclose ($fp);
		
		// And then write this user's name to the category file.
		$fp = fopen ($path . 'categories.php', 'wb');
		fputs ($fp, '<?php die (\'You may not access this file.\'); ?>' . "\n". '1|<|General|<||<|' . $username . '|<|' . "\n");
		fclose ($fp);
		
		$star_pass = str_repeat ('*', strlen ($password));
		
		if ( !touch ('./install.lock') )
		{
			$fp = fopen ($path . 'install.lock', 'wb');
			fclose ($fp);
		}
		
		$content =
<<< html
<p>And thats it! You have successfully installed Fusion News. You can now log in using the username and password you entered on the previous page</p>
<ul>
<li>Username: $username</li>
<li>Nick: $nick</li>
<li>Password: $star_pass</li>
</ul>
<p>Before logging in though, <b>you should delete the install.php file</b> as there is a chance someone else could reinstall Fusion News.</p>
<p><a href="./index.php">Click here to login!</a></p>
html;
	}
}

?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<title>Fusion News: Step <?php echo $step; ?></title>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<link href="./skins/fusion/stylesheet.css" rel="stylesheet" type="text/css" />
<script type="text/javascript" src="./jsfunc.js"></script>
</head>

<body>
<div id="layout">
	<div id="header">
		<img src="./skins/fusion/images/header.png" alt="Fusion News" title="Fusion News" width="604" height="117" />
		<div id="login">Step <?php echo $step; ?></div>
	</div>
	<div id="content">
		<div id="text">
			&nbsp;<h1><?php echo $title; ?></h1>
			<?php echo $content; ?>
			<br />
		</div>
		<div id="footer">
			<img src="./skins/fusion/images/table_bottom.png" alt="" width="604" height="25" />
			<p>Powered by <a href="http://www.fusionnews.net/" onclick="window.open (this.href); return false;">Fusion News</a> v<?php echo $curve; ?> &copy; 2007, FusionNews.net</p>
		</div>
	</div>
</div>
</body>
</html>
