<?php

/*
||==========================================================
||		Fusion News 3.x
||----------------------------------------------------------
|| File Version	: $Id: functions.php 102 2007-02-25 18:11:42Z xycaleth $
|| Contact	: xycaleth@gmail.com
|| Copyright:	: (c) 2006, FusionNews.net
|| License Info	: http://www.gnu.org/copyleft/gpl.html
||==========================================================
*/

function InsertBBCode($fusnewsm){
	// open tags risk wrong formatting of the whole newspage... open tags should be dealth with
	$bbcodes_open  = array("[move]","[sub]","[tt]","[sup]","[s]","[b]","[i]","[u]","[list]","[quote]","[code]");
	$bbcodes_close = array("[/move]","[/sub]","[/tt]","[/sup]","[/s]","[/b]","[/i]","[/u]","[/list]","[/quote]","[/code]");

	for($i = 0; $i < 11; $i++ )
	{
		$bbcode_open = $bbcodes_open[$i];
		$bbcode_close = $bbcodes_close[$i];

		$open_cnt = substr_count( $fusnewsm, $bbcode_open );
		$close_cnt = substr_count( $fusnewsm, $bbcode_close );
		$div = abs( $open_cnt - $close_cnt );

		if ( $open_cnt > $close_cnt )
		{
			for ($i = 0; $i < $div; $i++ )
			{
				$fusnewsm .= $bbcode_close;
			}
		}
		if ( $open_cnt < $close_cnt )
		{
			for ($i = 0; $i < $div; $i++ )
			{
				$fusnewsm = $bbcode_open.$fusnewsm;
			}
		}
	}
	
	$fusnewsm = str_replace ('[move]', '<marquee>', $fusnewsm);
	$fusnewsm = str_replace ('[/move]', '</marquee>', $fusnewsm);
	$fusnewsm = str_replace ('[sub]', '<sub>', $fusnewsm);
	$fusnewsm = str_replace ('[/sub]', '</sub>', $fusnewsm);
	$fusnewsm = str_replace ('[sup]', '<sup>', $fusnewsm);
	$fusnewsm = str_replace ('[/sup]', '</sup>', $fusnewsm);
	$fusnewsm = str_replace ('[s]', '<s>', $fusnewsm);
	$fusnewsm = str_replace ('[/s]', '</s>', $fusnewsm);
	$fusnewsm = str_replace ('[b]', '<b>', $fusnewsm);
	$fusnewsm = str_replace ('[/b]', '</b>', $fusnewsm);
	$fusnewsm = str_replace ('[i]', '<i>', $fusnewsm);
	$fusnewsm = str_replace ('[/i]', '</i>', $fusnewsm);
	$fusnewsm = str_replace ('[tt]', '<tt>', $fusnewsm);
	$fusnewsm = str_replace ('[/tt]', '</tt>', $fusnewsm);
	$fusnewsm = str_replace ('[u]', '<u>', $fusnewsm);
	$fusnewsm = str_replace ('[/u]', '</u>', $fusnewsm);
	$fusnewsm = str_replace ('[list]', '<ul>', $fusnewsm);
	$fusnewsm = str_replace ('[/list]', '</ul>', $fusnewsm);
	$fusnewsm = str_replace ('[quote]', '<blockquote>quote:<hr size="1" />&quot;', $fusnewsm);
	$fusnewsm = str_replace ('[/quote]', '&quot;<hr size="1" /></blockquote>', $fusnewsm);

	$fusnewsm = preg_replace ('/\[\*\]([^\[]+)/ms', '<li>$1</li>', $fusnewsm);
	
	$fusnewsm = str_replace("[hr]", "<hr />", $fusnewsm);
	
	$fusnewsm = eregi_replace("\\[color=([^\\[]*)\\]([^\\[]*)\\[/color\\]","<span style=\"color:\\1\">\\2</span>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[size=([^\\[]*)\\]([^\\[]*)\\[/size\\]","<span style=\"font-size:\\1\">\\2</span>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[img height=([^\\[]*)\\ width=([^\\[]*)\\]([^\\[]*)\\[/img\\]","<img src=\"\\3\" height=\"\\1\" width=\"\\2\" alt=\"\" />",$fusnewsm);
	$fusnewsm = eregi_replace("\\[img width=([^\\[]*)\\ height=([^\\[]*)\\]([^\\[]*)\\[/img\\]","<img src=\"\\3\" width=\"\\1\" height=\"\\2\" alt=\"\" />",$fusnewsm);
	$fusnewsm = eregi_replace("\\[img]([^\\[]*)\\[/img\\]","<img src=\"\\1\" alt=\"\" />",$fusnewsm);
	$fusnewsm = eregi_replace("\\[flash=([^\\[]*)\\,([^\\[]*)\\]([^\\[]*)\\[/flash\\]","<object classid=\"clsid: D27CDB6E-AE6D-11cf-96B8-444553540000\" width=\"\\1\" height=\"\\2\"><param name=movie value=\\3><param name=play value=true><param name=loop value=true><param name=quality value=high><embed src=\\3 width=\\1 height=\\2 play=true loop=true quality=high></embed></object>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[align=([^\\[]*)\\]([^\\[]*)\\[/align\\]","<div style=\"\\1\">\\2</div>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[shadow=([^\\[]*)\\,([^\\[]*)\\,([^\\[]*)\\]([^\\[]*)\\[/shadow\\]","<span style=\"filter: shadow(color=\\1, direction=\\2); width=\\3px;\">\\4</span>", $fusnewsm);
	$fusnewsm = eregi_replace("\\[glow=([^\\[]*)\\,([^\\[]*)\\,([^\\[]*)\\]([^\\[]*)\\[/glow\\]","<span style=\"filter: glow(color=\\1, strength=\\2); width: \\3px;\">\\4</span>", $fusnewsm);
	$fusnewsm = eregi_replace("\\[email\\]([^\\[]*)\\[/email\\]", "<a href=\"mailto:\\1\">\\1</a>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[email=([^\\[]*)\\]([^\\[]*)\\[/email\\]", "<a href=\"mailto:\\1\">\\2</a>",$fusnewsm);
	$fusnewsm = eregi_replace("(^|[>[:space:]\n])([[:alnum:]]+)://([^[:space:]]*)([[:alnum:]#?/&=])([<[:space:]\n]|$)","\\1<a href=\"\\2://\\3\\4\" onclick=\"window.opon(this.href); return false\">\\2://\\3\\4</a>", $fusnewsm);
	$fusnewsm = preg_replace("/([\n >\(])www((\.[\w\-_]+)+(:[\d]+)?((\/[\w\-_%]+(\.[\w\-_%]+)*)|(\/[~]?[\w\-_%]*))*(\/?(\?[&;=\w\+%]+)*)?(#[\w\-_]*)?)/", "\\1<a href=\"http://www\\2\" onclick=\"window.opon(this.href); return false\">www\\2</a>", $fusnewsm);
	$fusnewsm = eregi_replace("\\[url\\]www.([^\\[]*)\\[/url\\]", "<a href=\"http://www.\\1\" onclick=\"window.open (this.href); return false;\">\\1</a>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[url\\]([^\\[]*)\\[/url\\]","<a href=\"\\1\" onclick=\"window.open (this.href); return false;\">\\1</a>",$fusnewsm);
	$fusnewsm = eregi_replace("\\[url=([^\\[]*)\\]([^\\[]*)\\[/url\\]","<a href=\"\\1\" onclick=\"window.open (this.href); return false;\">\\2</a>",$fusnewsm);
	return $fusnewsm;
}

function InsertSmillies($fusnewsm, $fusurl)
{
	global $fpath;
	
	$file = file ($fpath."smillies.db");
	foreach($file as $value)
	{
		list($rand,$code,$image) = explode("|<|", $value);
		$code = unhtmlentities(stripslashes($code));
		$image = chop ($image);
		$fusnewsm = str_replace ($code, '<img src="' . $fusurl . '/smillies/' . $image . '" alt="' . $code . '" />', $fusnewsm);
	}

	return $fusnewsm;
}

function show_error ( $string )
{
	echo <<< html
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
	<title>Fusion News: Error</title>
	<style type="text/css">
	<!--
	body {
		font-family: "Trebuchet MS", Tahoma, Helvetica, sans-serif;
		font-size: 10pt;
	}
	-->
	</style>
</head>
<body>
<h1>Fusion News Error</h1>
$string
</body>
</html>
html;
}

function get_template ( $template, $php_enabled )
{
	global $fpath;

	$text = '';

	if ( file_exists ($fpath . 'templates/' . $template) )
	{
		if ( $php_enabled )
		{
			ob_start();
			include ($fpath . "templates/" . $template);
			$text = ob_get_contents();
			ob_end_clean();
		}
		else
		{
			$fp = fopen ($fpath."templates/".$template, "r");
			flock ($fp, LOCK_EX);

			while ( !feof ($fp) )
			{
				$buffer = fgets ($fp, 4096);
				$text .= $buffer;
			}

			flock ($fp, LOCK_UN);
			fclose ($fp);
		}
	}
	
	if ( $text )
	{
		$text = str_replace ('&#33;DOCTYPE',	'!DOCTYPE',	$text);
		$text = str_replace ('&#60;&#33;--',	'<!--',		$text);
		$text = str_replace ('--&#62;',		'-->',		$text);
		$text = str_replace ('&#60;script',	'<script',	$text);
	}

	return $text;
}

function arrange_by_date()
{
	global $fpath, $error1;

	$file = file ($fpath . "news/toc.php");
	my_array_shift ($file);

	if ( count ($file) > 0 )
	{
		$array = array();
		foreach ( $file as $value )
		{
			$news_data = explode ('|<|', $value);
			$array[$news_data[1]] = chop (trim ($value));
		}

		if ( sizeof ($array) > 0 )
		{
			krsort ($array);

			$data = array();
			foreach ( $array as $val )
			{
				$data[] = $val;
			}
		}
	}
	
	return $data;
}

function buildnews(){
	global $datefor, $fpath, $numofposts, $numofh, $post_per_day, $flip_news, $enable_rss,
		$months, $curve, $rss_title, $rss_description, $rss_encoding, $hurl;

	$file = arrange_by_date();
	$num_posts = sizeof ($file);

	if ( $num_posts > 0 )
	{
		$ar_post = array();
		$ar_head = array();
	
		for ( $i = 0; $i <= $num_posts; $i++ )
		{
			if ( !isset ($file[$i]) || chop ($file[$i]) == '' )
			{
				continue;
			}

			if ( $i <= $numofposts )
			{
				$ar_post[] = $file[$i];
			}

			if ( $i <= $numofh )
			{
				$ar_head[] = $file[$i];
			}
		}

		if ( $flip_news )
		{
			$ar_post = array_reverse( $ar_post );
			$ar_head = array_reverse( $ar_head );
		}

		if ( $post_per_day )
		{
			$ppp_data = array();
		}

		$news = "";
		$header = "";
		
		if ( $enable_rss )
		{
			$rss_infos = "";
		}

		$cnt = 0;
		foreach ($ar_post as $post){
			$toc = explode("|<|", $post );
			$array = buildnews2 ( $toc[0], $cnt );
			$cnt++;
			if ( $post_per_day )
			{
				if ( !isset($ppp_data[$array["date"]]) )
				{
					$ppp_data[$array["date"]] = $array['temp_short'];
				}
				else
				{
					$ppp_data[$array["date"]] .= $array["temp_short"];
				}
			}
			else
			{
				$news .= $array["temp_short"];
			}
		}

		$cnt = 0;
		foreach ( $ar_head as $post )
		{
			$toc = explode( "|<|", $post );
			$array = buildnews2( $toc[0], $cnt );
			$cnt++;
			$header .= $array["temp_head"]."\n";
			
			if ( $enable_rss )
			{
				$rss_infos .= $array["temp_rss"];
			}
		}

		if ( $post_per_day )
		{
			if ( $flip_news )
			{
				ksort( $ppp_data );
			}
			else
			{
				krsort( $ppp_data );
			}

			$temp = get_template('news_a_day_temp.php', false);
			while (list ($key, $value) = each ($ppp_data))
			{
				//list($year,$month,$day) = explode(",", $key);
				$insert_date = str_replace('{date}', date('l', $key) . ', ' . $months[date ('n', $key)] . '&nbsp;' . date ('d', $key) . '&nbsp;' . date ('Y', $key), $temp);
				$news .= str_replace("{news_a_day}", $value, $insert_date);
			}
		}

		if( $enable_rss )
		{
			$current_date = date ('r');
		
			$rss_info  = '<?xml version="1.0" encoding="' . $rss_encoding .'" ?>' . "\n";
			$rss_info .= '<rss version="2.0">' . "\n\n";
			$rss_info .= '<channel>' . "\n";
			$rss_info .= "\t" . '<title>' . $rss_title . '</title>' . "\n";
			$rss_info .= "\t" . '<link>' . $hurl . '/</link>' . "\n";
			$rss_info .= "\t" . '<description>' . $rss_description . '</description>' . "\n";
			$rss_info .= "\t" . '<pubDate>' . $current_date . '</pubDate>' . "\n";
			$rss_info .= "\t" . '<lastBuildDate>' . $current_date . '</lastBuildDate>' . "\n";
			$rss_info .= "\t" . '<generator>Fusion News ' . $curve . '</generator>' . "\n";
			$rss_info .= $rss_infos;
			$rss_info .= '</channel>' . "\n\n";
			$rss_info .= '</rss>';

			safe_write ('fusionnews.xml', 'wb', $rss_info);
		}

		safe_write ('static_news.html', 'wb', $news);
		safe_write ('headlines.php', 'wb', $header);
	}
}

function buildnews2( $news_item, $item_in_list ){ //builds only the amount of news shown
	global $fpath, $fsnw, $wfpost, $ht, $cbwordwrap, $smilies, $bb, $stfpop, $compop,
		$numofposts, $furl, $fullnewsh, $fullnewsw, $fullnewss, $fullnewsz, $fslink, $datefor,
		$stflink, $stfheight, $stfwidth, $stfscrolls, $stfresize, $pclink, $datefor,
		$link_headline_fullstory, $hurl, $wwwidth, $comheight, $comwidth, $comscrolls,
		$comresize, $enable_rss;

	$file = file( $fpath."news/news.".$news_item.".php" );
	list($news_short,$news_full,$news_writer,$news_subject,$news_categories,$news_date,$news_comment_count) = explode("|<|", $file[1]);
	$news_info = parse_news_to_view ($file[1]);

	$temp_head = get_template('headline_temp.php', false);
	$temp_head = str_replace("{subject}", $news_info['subject'], $temp_head);
	$temp_head = str_replace("{user}", $news_info['writer'], $temp_head);
	$temp_head = str_replace("{icon}", $news_info['icon'], $temp_head);
	$temp_head = str_replace("{date}", $news_info['date'], $temp_head);

	if( ($item_in_list > $numofposts) || $link_headline_fullstory )
	{
		$temp_head = str_replace("{linkstart}", "<a href=\"$furl/fullnews.php?id=".$news_item."\">", $temp_head);
	}
	else
	{
		$temp_head = str_replace("{linkstart}", "<a href=\"{$hurl}#fus_" . $news_item . "\">", $temp_head);
	}

	$temp_head = str_replace ("{linkend}", "</a>", $temp_head);
	
	$array = array (
		'temp_short'	=> $news_info['display'],
		'temp_head'	=> $temp_head,
		'date'		=> mktime (0, 0, 0, date('n', $news_date), date('j', $news_date), date('y', $news_date))
	);

	if ( $enable_rss )
	{
		$rss_info  = '	<item>' . "\n";
		$rss_info .= '		<title>' . $news_info['subject'] . '</title>' . "\n";
		$rss_info .= '		<link>' . $furl . '/fullnews.php?id=' . $news_item . '</link>' . "\n";
		$rss_info .= '		<description>' . strip_tags ($news_info['news']) . '</description>' . "\n";
		if ( $news_writer['showemail'] == '' )
		{
			$rss_info .= '		<author>' . $news_info['email'] . '</author>' . "\n";
		}
		$rss_info .= '		<pubDate>' . date ('r', $news_date) . '</pubDate>' . "\n";
		$rss_info .= '		<comments>' . $furl . '/comments.php?id=' . $news_item . '</comments>' . "\n";
		$rss_info .= '		<guid isPermaLink="false">fus_' . $news_item . '</guid>' . "\n";
		$rss_info .= '	</item>' . "\n";
		
		$array += array (
			'temp_rss'	=> $rss_info
		);
	}

	return $array;
}

function fusion_wordwrap($post, $maxwordlen) {
	if ( $post !== '' )
	{
		$eachword = explode (' ', $post);
		$post = '';
		
		$numlines = ceil (sizeof ($eachword) / $maxwordlen);
		for ( $i = 0; $i < $numlines; $i++ )
		{
			for ( $j = 0; ($j < $maxwordlen) && (isset ($eachword[($i * $maxwordlen) + $j])); $j++ )
			{
				$post .= $eachword[($i * $maxwordlen) + $j] . ' ';
			}
			
			$post .= '<br />' . "\n";
		}
	}

	return $post;
}

function filterbadwords ( $post )
{
	global $fpath;

	$words = array();
	$file = file ($fpath . "badwords.txt");// or die ("Can't open badwords.txt for reading!");

	foreach ( $file as $value )
	{
		$value = trim ($value);
		$words[] = explode ('=', $value);
	}

	if ( sizeof ($words) > 0 )
	{
		foreach ( $words as $value )
		{
			if ( $value[0] != '' && $value[1] != '' )
			{
				$post = preg_replace ('/\b' . $value[0] . '\b/i', $value[1], $post);
			}
		}
	}
	return $post;
}

function findwriter ( $user, $nick = '' ){
	global $fpath;

	if ( !$nick && !$user )
	{
		return false;
	}

	if ( !$nick && $user )
	{
		$nick = $user;
	}

	if ($nick && !$user)
	{
		$user = $nick;
	}

	$file = file($fpath."users.php");
	my_array_shift($file);
	foreach ( $file as $value )
	{
		list($fuser,$fnick,$femail,$ficon,$ftimeoffset,$fpass,$le) = explode("|<|", $value);

		if( ($user == $fuser) or ($nick == $fnick) )
		{
			$email = explode ('=', $femail);

			return array (
				'user'		=> $fuser,
				'nick'		=> $fnick,
				'email'		=> $email[1],
				'showemail'	=> $email[0],
				'icon'		=> $ficon,
				'timeoffset'	=> $ftimeoffset,
				'level'		=> $le
			);
		}
	}

	return false;
}

function calc_size ( $size ){
	if ( $size < 1024 && $size != 0 )
	{ // Bytes
		return $size . ' b';
	}
	else if ( $size < (1024 * 1024) )
	{ // Kilobytes
		return sprintf ('%.2f', ($size / 1024)) . ' Kb';
	}
	else if ( $size < (1024 * 1024 * 1024) )
	{ // Megabytes
		return sprintf ('%.2f', ($size / (1024 * 1024))) . ' Mb';
	}
}

function valid_email($email) {
 // Returns true if email address has a valid form.
 $pattern = "^[-_.[:alnum:]]+@((([[:alnum:]]|[[:alnum:]][[:alnum:]-]*[[:alnum:]])\.)+(ad|ae|aero|af|ag|ai|al|am|an|ao|aq|ar|arpa|as|at|au|aw|az|ba|bb|bd|be|bf|bg|bh|bi|biz|bj|bm|bn|bo|br|bs|bt|bv|bw|by|bz|ca|cc|cd|cf|cg|ch|ci|ck|cl|cm|cn|co|com|coop|cr|cs|cu|cv|cx|cy|cz|de|dj|dk|dm|do|dz|ec|edu|ee|eg|eh|er|es|et|eu|fi|fj|fk|fm|fo|fr|ga|gb|gd|ge|gf|gh|gi|gl|gm|gn|gov|gp|gq|gr|gs|gt|gu|gw|gy|hk|hm|hn|hr|ht|hu|id|ie|il|in|info|int|io|iq|ir|is|it|jm|jo|jp|ke|kg|kh|ki|km|kn|kp|kr|kw|ky|kz|la|lb|lc|li|lk|lr|ls|lt|lu|lv|ly|ma|mc|md|mg|mh|mil|mk|ml|mm|mn|mo|mp|mq|mr|ms|mt|mu|museum|mv|mw|mx|my|mz|na|name|nc|ne|net|nf|ng|ni|nl|no|np|nr|nt|nu|nz|om|org|pa|pe|pf|pg|ph|pk|pl|pm|pn|pr|pro|ps|pt|pw|py|qa|re|ro|ru|rw|sa|sb|sc|sd|se|sg|sh|si|sj|sk|sl|sm|sn|so|sr|st|su|sv|sy|sz|tc|td|tf|tg|th|tj|tk|tm|tn|to|tp|tr|tt|tv|tw|tz|ua|ug|uk|um|us|uy|uz|va|vc|ve|vg|vi|vn|vu|wf|ws|ye|yt|yu|za|zm|zw)|(([0-9][0-9]?|[0-1][0-9][0-9]|[2][0-4][0-9]|[2][5][0-5])\.){3}([0-9][0-9]?|[0-1][0-9][0-9]|[2][0-4][0-9]|[2][5][0-5]))$";
 if(eregi($pattern, $email)) return true;
 else  return false;
}

function checkifflooding($ip, $rand1){
	global $fpath, $floodtime;

	$data = "";
	$file = file($fpath."flood.php");
	my_array_shift($file);
	for($i = 1; $i<= count($file);$i++)
	{
		list($a, $b, $c) = explode('=', trim($file[$i]));
		if($b > time() - $floodtime)
		{
			$data .= "$a=$b=$c\n";
		}
	}

	$data = "<?php die(\"You may not access this file.\"); ?>\n" . $data;

	safe_write ('flood.php', 'wb', $data);

	$time = 0;
	$file = file($fpath."flood.php");
	my_array_shift($file);
	foreach($file as $value){
	list($a, $b, $c) = explode('=', $value);
	if(trim($a) == $ip){$time = $b; $d = trim($c);}
	}
	if($time > "0"){
	if(((time() - $floodtime) <= $time) && ($rand1 == $d)){$result = true;}else{$result = false;}
	}else{$result = false;}
	return $result;
}

function checkifbanned ( $ip )
{
	global $fpath;

	$file = file ($fpath . "banned.php");
	my_array_shift($file);

	foreach ( $file as $value )
	{
		if ( trim ($value) == $ip )
		{
			return true;
		}
	}

	return false;
}

function my_array_shift (&$array){
	reset ($array);
	$temp = each ($array);
	unset ($array[$temp['key']]);
	return $temp['value'];
}

function getip()
{
	$realip = '';

	if ( isset ($_SERVER) )
	{
		if ( isset ( $_SERVER['REMOTE_ADDR']) )
		{
			$realip = $_SERVER['REMOTE_ADDR'];
		}
		else if ( isset($_SERVER["HTTP_CLIENT_IP"]) )
		{
			$realip = $_SERVER["HTTP_CLIENT_IP"];
		}
		else
		{
			$realip = $_SERVER["HTTP_X_FORWARDED_FOR"];
		}
	}
	else
	{
		if ( getenv ('REMOTE_ADDR') )
		{
			$realip = getenv ('REMOTE_ADDR');
		}
		else if ( getenv ('HTTP_CLIENT_IP') )
		{
			$realip = getenv ('HTTP_CLIENT_IP');
		}
		else
		{
			$realip = getenv ('HTTP_X_FORWARDED_FOR');
		}
	}
	
	return $realip;
}

function has_access ( $level )
{
	global $userdata;
	
	return ( $userdata != NULL ) ? ($userdata['level'] >= $level) : false;
}

function buildcomments($news_item){
	global $fpath, $cbwordwrap, $wfcom, $htc, $smilcom, $bbc, $comallowbr, $datefor, $furl, $com12, $wwwidth;

	$cont = "";
	$showemail = "";
	
	$template = get_template('com_temp.php', true);
	
	$file = file( $fpath."news/news.".$news_item.".php" );
	my_array_shift($file);
	my_array_shift($file);
	
	foreach ( $file as $value )
	{
		list($com_ip,$com_validated,$com_post,$com_name,$com_email,$com_datum,$com_unique) = explode("|<|", $value);
		
		if ( $com_validated == 0 )
		{
			continue;
		}
		
		if ( $cbwordwrap )
		{
			$com_post = fusion_wordwrap($com_post, $wwwidth);
		}
		
		if ( $wfcom )
		{
			$com_post = filterbadwords($com_post);
		}
		
		$com_name = str_replace("\\\'", "'", $com_name);
		$com_name = str_replace('\\\"', '"', $com_name);
		$com_name = strip_tags($com_name);
		$com_post = str_replace("\\\'", "'", $com_post);
		$com_post = str_replace('\\\"', '"', $com_post);
		//html tags
		if ( $htc )
		{
			$com_post = unhtmlentities($com_post);
			$com_post = str_replace("<?", "&lt;?", $com_post);
		}
		if ( $smilcom )
		{
			$com_post = InsertSmillies($com_post,$furl);
		}
		//bbcode
		if ( $bbc )
		{
			$com_post = InsertBBCode($com_post);
		}
		
		$com_post = str_replace( "&amp;", "&", $com_post);
		if ( $comallowbr )
		{
			$com_post = str_replace(" &br;", "<br />", $com_post);
			$com_post = str_replace("&br;", "<br />", $com_post);
		}
		else
		{
			$com_post = str_replace(" &br;", "", $com_post);
			$com_post = str_replace("&br;", "<br />", $com_post);
		}
		
		if ( ereg ("=", $com_email) )
		{
			list($showemail, $mail) = explode("=", $com_email);
			if ( $showemail == "" )
			{
				$mail = $mail;
			}
		}else{
			$mail = $com_email;
		}
		
		if($mail != "")
		{
			$com_name = "<a href=\"mailto:$mail\">$com_name</a>";
		}
		
		//replace user variables
		$tem = $template;
		$tem = str_replace("{poster}", $com_name, $tem);
		$tem = str_replace("{comment}", $com_post, $tem);
		$tem = str_replace("{date}", date($datefor, $com_datum), $tem);
		$tem = str_replace("{posterip}", $com_ip, $tem);
		$cont .= $tem;
	}

	if ( !$cont || $cont == '' )
	{
		$cont = $com12;
	}

	return $cont;
}

// Blackshadow - rewritten
function upload_file ( $var_key, $directory, $exts, $maxsize, $name )
{
	global $upld2, $ind252, $ind253, $ind254, $ind255, $ind255a, $ind256, $ind257;

	if ( @ini_get ('file_uploads') == 'off' || @ini_get ('file_uploads') == 0 || @ini_get ('file_uploads') == '' )
	{
		return $upld2;
	}

	$filename = ( isset ($_FILES[$var_key]['name']) ) ? $_FILES[$var_key]['name'] : '';
	$tmpname = ( isset ($_FILES[$var_key]['tmp_name']) ) ? $_FILES[$var_key]['tmp_name'] : '';
	$filesize = ( isset ($_FILES[$var_key]['size']) ) ? intval ($_FILES[$var_key]['size']) : 0;

	if ( !is_dir ($directory) )
	{
		return $ind253;
	}

	if ( !$filename )
	{
		return $ind254;
	}

	$extensions = explode ('&#124;', $exts);
	$num_exts = sizeof ($extensions);
	$valid_ext = 0;

	for ( $i = 0; $i < $num_exts; $i++ )
	{
		if ( substr ($filename, strrpos ($filename, '.') + 1) == $extensions[$i] )
		{
			$valid_ext = 1;
			break;
		}
	}

	if ( !$valid_ext )
	{
		return $ind255 . $exts . $ind255a;
	}

	if ( $filesize == 0 )
	{
		return $ind254;
	}

	if ( $filesize > $maxsize )
	{
		return $ind252;
	}

	$uploaded = 0;

	$origname = $filename;
	$i = 1;

	while ( file_exists ($directory . $filename) )
	{
		$filename = substr ($origname, 0, strrpos ($origname, '.')) . '_' . $i . strrchr ($origname, '.');
		$i++;
	}

	if ( @move_uploaded_file ($tmpname, $directory . $filename) )
	{
		$uploaded = 1;
	}
	else if ( @copy ($tmpname, $directory . $filename) )
	{
		$uploaded = 1;
	}

	if ( !$uploaded )
	{
		return $ind256;
	}

	@chmod ($upload_path . $filename, 0644);
	@unlink ($tmpname);

	return $name . ' ' . $ind257;
}

function clean_key ( $key )
{
	if ( $key != '' )
	{
		$key = preg_replace ('/[^A-Za-z0-9_]+/',	'',	$key);
		$key = preg_replace ("/\.\./",			"",	$key);
		$key = preg_replace ("/\_\_(.+?)\_\_/",		"",	$key);
		$key = preg_replace ("/^([\w\.\-\_]+)$/",	"$1",	$key);
	}
	
	return $key;
}

function clean_value ( $val )
{
	if ( $val != '' )
	{	
		// I think this block of slightly modified code came from IPB.
		$val = str_replace ("&#032;",		" ",		$val);
		$val = str_replace ("&",		"&amp;",	$val);
		$val = str_replace ("<!--",		"&#60;&#33;--",	$val);
		$val = str_replace ("-->",		"--&#62;",	$val);
		$val = preg_replace ("/<script/i",	"&#60;script",	$val);
		$val = str_replace (">",		"&gt;",		$val);
		$val = str_replace ("<",		"&lt;",		$val);
		//$val = str_replace ("\"",		"&quot;",	$val);
		$val = preg_replace ("/\|/",		"&#124;",	$val);
		
		if ( strtolower (ini_get ('magic_quotes_sybase')) == 'on' || ini_get ('magic_quotes_sybase') == 1 )
		{
			$val = str_replace ('\'\'', '\'', $val);
		}
		else if ( get_magic_quotes_gpc() )
		{
			$find = array ('\\"', '\\\\', '\\\'');
			$replace = array ('&quot;', '\\', '\'');
			
			$val = str_replace ($find, $replace, $val);
		}
		
		//$val = preg_replace ("/\\\$/",		"&#036;",	$val);
		$val = str_replace ("\r\n",		"\n",		$val);	// Win32 => new line
		$val = str_replace ("\r",		"\n",		$val);	// Mac => new line
		$val = str_replace ("!",		"&#33;",	$val);
		//$val = preg_replace ("/\\\/",		"&#092;",	$val); // Swap user inputted backslashes
		
		// Multibyte characters fix
		$val = preg_replace ("/&amp;#([0-9]+);/", "&#\\1;", $val);
	}

	return $val;
}

function unhtmlentities ($string)
{
	$trans_tbl = get_html_translation_table (HTML_ENTITIES);
	$trans_tbl = array_flip ($trans_tbl);

	return strtr ($string, $trans_tbl);
}

function config_array()
{
	require './config.php';

	return array(
		"fusion_id"		=> $fusion_id,
		"site"			=> $site,
		"furl"			=> $furl,
		"hurl"			=> $hurl,
		"fpath"			=> $fpath,
		"datefor"		=> $datefor,
		"numofposts"		=> $numofposts,
		"numofh"		=> $numofh,
		"bb"			=> $bb,
		"ht"			=> $ht,
		"post_per_day"		=> $post_per_day,
		"wfpost"		=> $wfpost,
		"wfcom"			=> $wfcom,
		"skin"			=> $skin,
		"cbwordwrap"		=> $cbwordwrap,
		"wwwidth"		=> $wwwidth,
		"smilies"		=> $smilies,
		"stfpop"		=> $stfpop,
		"comallowbr"		=> $comallowbr,
		"stfwidth"		=> $stfwidth,
		"stfheight"		=> $stfheight,
		"fslink"		=> $fslink,
		"stflink"		=> $stflink,
		"pclink"		=> $pclink,
		"fsnw"			=> $fsnw,
		"cbflood"		=> $cbflood,
		"floodtime"		=> $floodtime,
		"comlength"		=> $comlength,
		"fullnewsw"		=> $fullnewsw,
		"fullnewsh"		=> $fullnewsh,
		"fullnewss"		=> $fullnewss,
		"stfresize"		=> $stfresize,
		"stfscrolls"		=> $stfscrolls,
		"fullnewsz"		=> $fullnewsz,
		"htc"			=> $htc,
		"smilcom"		=> $smilcom,
		"bbc"			=> $bbc,
		"compop"		=> $compop,
		"comscrolls"		=> $comscrolls,
		"comresize"		=> $comresize,
		"comheight"		=> $comheight,
		"comwidth"		=> $comwidth,
		"uploads_active"	=> $uploads_active,
		"uploads_size"		=> $uploads_size,
		"uploads_ext"		=> $uploads_ext,
		"enable_rss"		=> $enable_rss,
		"link_headline_fullstory" => $link_headline_fullstory,
		"flip_news"		=> $flip_news,
		"rss_title"		=> $rss_title,
		"rss_description"	=> $rss_description,
		"rss_encoding"		=> $rss_encoding,
		"com_validation"	=> $com_validation,
		"com_captcha"		=> $com_captcha,
	);
}

function save_config ( $configs )
{
	global $curve;

	require './config.php';
	
	// Replace ' with \'
	$find = '\'';
	$replace = '\\\'';
	$variables = array ('site', 'furl', 'hurl', 'datefor', 'skin', 'fslink', 'stflink', 'pclink', 'rss_title', 'rss_description', 'rss_encoding');
	foreach ( $variables as $config_var )
	{
		$configs[$config_var] = str_replace ($find, $replace, $configs[$config_var]);
	}

	$save  = "<?php\n\n";
	$save .= '// Auto generated by Fusion News v' . $curve . "\n\n";
	$save .= "\$fusion_id = '".$configs['fusion_id']."';\n";
	$save .= "\$site = '".$configs['site']."';\n";
	$save .= "\$furl= '".$configs['furl']."';\n";
	$save .= "\$hurl = '".$configs['hurl']."';\n";
	$save .= "\$fpath = '".$configs['fpath']."';\n";
	$save .= "\$datefor = '".$configs['datefor']."';\n";
	$save .= "\$numofposts = ".$configs['numofposts'].";\n";
	$save .= "\$numofh = ".$configs['numofh'].";\n";
	$save .= "\$bb = ".$configs['bb'].";\n";
	$save .= "\$ht = ".$configs['ht'].";\n";
	$save .= "\$post_per_day = ".$configs['post_per_day'].";\n";
	$save .= "\$wfpost = ".$configs['wfpost'].";\n";
	$save .= "\$wfcom = ".$configs['wfcom'].";\n";
	$save .= "\$skin = '".$configs['skin']."';\n";
	$save .= "\$cbwordwrap = ".$configs['cbwordwrap'].";\n";
	$save .= "\$wwwidth = ".$configs['wwwidth'].";\n";
	$save .= "\$smilies = ".$configs['smilies'].";\n";
	$save .= "\$stfpop = ".$configs['stfpop'].";\n";
	$save .= "\$comallowbr = ".$configs['comallowbr'].";\n";
	$save .= "\$stfwidth = ".$configs['stfwidth'].";\n";
	$save .= "\$stfheight = ".$configs['stfheight'].";\n";
	$save .= "\$fslink = '".$configs['fslink']."';\n";
	$save .= "\$stflink = '".$configs['stflink']."';\n";
	$save .= "\$pclink = '".$configs['pclink']."';\n";
	$save .= "\$fsnw = ".$configs['fsnw'].";\n";
	$save .= "\$cbflood = ".$configs['cbflood'].";\n";
	$save .= "\$floodtime = ".$configs['floodtime'].";\n";
	$save .= "\$comlength = ".$configs['comlength'].";\n";
	$save .= "\$fullnewsw = ".$configs['fullnewsw'].";\n";
	$save .= "\$fullnewsh = ".$configs['fullnewsh'].";\n";
	$save .= "\$fullnewss = ".$configs['fullnewss'].";\n";
	$save .= "\$stfresize = ".$configs['stfresize'].";\n";
	$save .= "\$stfscrolls = ".$configs['stfscrolls'].";\n";
	$save .= "\$fullnewsz = ".$configs['fullnewsz'].";\n";
	$save .= "\$htc = ".$configs['htc'].";\n";
	$save .= "\$smilcom = ".$configs['smilcom'].";\n";
	$save .= "\$bbc= ".$configs['bbc'].";\n";
	$save .= "\$compop= ".$configs['compop'].";\n";
	$save .= "\$comscrolls= ".$configs['comscrolls'].";\n";
	$save .= "\$comresize= ".$configs['comresize'].";\n";
	$save .= "\$comheight= ".$configs['comheight'].";\n";
	$save .= "\$comwidth= ".$configs['comwidth'].";\n";
	$save .= "\$uploads_active= ".$configs['uploads_active'].";\n";
	$save .= "\$uploads_size= ".$configs['uploads_size'].";\n";
	$save .= "\$uploads_ext= '".$configs['uploads_ext']."';\n";
	$save .= "\$enable_rss = ".$configs['enable_rss'].";\n";
	$save .= "\$link_headline_fullstory = ".$configs['link_headline_fullstory'].";\n";
	$save .= "\$flip_news = ".$configs['flip_news'].";\n";
	$save .= "\$rss_title = '" . $configs['rss_title'] . "';\n";
	$save .= "\$rss_description = '" . $configs['rss_description'] . "';\n";
	$save .= "\$rss_encoding = '" . $configs['rss_encoding'] . "';\n";
	$save .= '$com_validation = ' . $configs['com_validation'] . ';' . "\n";
	$save .= '$com_captcha = ' . $configs['com_captcha'] . ';' . "\n";
	$save .= '?' . '>';	// Split it up to prevent some editors from thinking it's a real PHP end tag.

	safe_write ('config.php', 'w', $save);
}

function trim2 ( $str, $delim )
{
	$str2 = substr( $str , strlen($str) -1, strlen($str));
	while( $str2 == "\n" || $str2 == "\t" || $str2 == "\r" || $str2 == " " )
	{
	       $str = substr( $str, 0, strlen($str) - 2 );
	       $str2 = substr( $str , strlen($str) -1, strlen($str));
	}
	$str2 = substr( $str , 0, 1);
	while( $str2 == "\n" || $str2 == "\t" || $str2 == "\r" || $str2 == " " )
	{
	       $str = substr( $str, 1, strlen($str) - 1 );
	       $str2 = substr( $str , 0, 1);
	}
	return $str;
}

function check_security_code ( $entered_code, $news_id )
{
	global $fpath, $error1;

	if ( !isset ($_SESSION['fusion_sid']) || $entered_code == '' ||
		strlen ($entered_code) != 5 || !file_exists ($fpath . 'news/news.' . $news_id . '.php') )
	{
		return false;
	}

	$file = file ($fpath . 'sessions.php');
	my_array_shift ($file);

	$valid_code = false;
	$data = '<?php die (\'' . $error1 . '\'); ?>' . "\n";
	foreach ( $file as $value )
	{
		list ($sessid, $code, $newsid, $ip, $timestamp) = explode ('|<|', $value);

		if ( $_SESSION['fusion_sid'] == $sessid )
		{
			if ( $entered_code == $code && $news_id == $newsid &&
				$ip == getip() && ($timestamp + 600 >= time()) )
			{
				$valid_code = true;
				unset ($_SESSION['fusion_sid']);
			}
		}
		else
		{
			if ( $timestamp + 600 >= time() )
			{
				$data .= $value;
			}
		}
	}

	safe_write ('session.php', 'wb', $data);

	return $valid_code;
}

function show_extras ( $form_name, $textbox_name, $show_smilies, $show_bbcode )
{
	global $fpath, $furl;

	$extra_html = '';

	if ( $show_smilies )
	{
		$file = file ($fpath . 'smillies.db');
		foreach ( $file as $smiley )
		{
			list ($rand, $text, $image) = explode ('|<|', $smiley);
			$image = chop (trim ($image));
			$extra_html .= '<a href="javascript:smiley_bbcode(\'' . $form_name . '\', \'' . $textbox_name . '\', \'' . $text . '\');"><img src="' . $furl . '/smillies/' . $image . '" alt=""  /></a>';
		}

		$extra_html .= '<br />' . "\n";
	}

	if ( $show_bbcode )
	{
		$extra_html .=
<<< html
<a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[b]text[/b]');"><img src="img/bold.gif"  alt="Bold" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[i]text[/i]');"><img src="img/italic.gif"  alt="Italic" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[u]text[/u]');"><img src="img/underline.gif"  alt="Underline" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[s]text[/s]');"><img src="img/strike.gif"  alt="Strike Out" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[sub]text[/sub]');"><img src="img/sub.gif" alt="Subscript" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[sup]text[/sup]');"><img src="img/sup.gif" alt="Superscript" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[shadow=red,left,1]TEXT[/shadow]');"><img src="img/shadow.gif"  alt="Shadow Text" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[glow=red,2,1]TEXT[/glow]');"><img src="img/glow.gif"  alt="Glow Text" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[color=red]text[/color]');"><img src="img/color.gif"  alt="Font color" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[font=verdana]text[/font]');"><img src="img/fontface.gif"  alt="Font Family" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[size=2]text[/size]');"><img src="img/fontsize.gif"  alt="Font Size" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[align=left]text[/align]');"><img src="img/fontleft.gif"  alt="Font Alignment" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[tt]text[/tt]');"><img src="img/tele.gif"  alt="Teletype" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[hr]');"><img src="img/hr.gif"  alt="Horizontal Line" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[move]STUFF[/move]');"><img src="img/move.gif"  alt="Marquee" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[quote]text[/quote]');"><img src="img/quote2.gif"  alt="Quote" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[flash=200,200]URL[/flash]');"><img src="img/flash.gif"  alt="Flash Image" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[img]URL[/img]');"><img src="img/img.gif"  alt="Image" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[email=username@site.com]Mail Me[/email]');"><img src="img/email2.gif"  alt="E-mail link" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[url=http://www.url.com]address[/url]');"><img src="img/url.gif"  alt="hyperlink" /></a><a href="javascript:smiley_bbcode('$form_name', '$textbox_name', '[list][*]text1[*]text2[*]text3[/list]');"><img src="img/list.gif"  alt="List" /></a><br />
html;
	}

	return $extra_html;
}

/**
 * $dropdown_type = 0 for multiple selection list
 * $dropdown_type = 1 for dropdown and selected item
 * $dropdown_type = 2 for dropdown and remove items listed in $selected_category
 **/
function build_categories_list ( $user_login, $selected_category = array (1), $dropdown_type = 0 )
{
	global $fpath;
	
	$file = file ($fpath . 'categories.php');
	my_array_shift ($file);
	
	$category_list = '<select class="post" id="category"' . (( $dropdown_type > 0 ) ? ' name="category">' : ' name="category[]" multiple="multiple" size="4">');
	
	foreach ( $file as $category )
	{
		list ($cid, $cname, $cicon, $cusers) = explode ('|<|', $category);
		
		$cusers = explode (',', $cusers);
		if ( $cid == 1 || in_array ((string)$user_login, $cusers) || (string)$user_login === '' )
		{
			if ( in_array ($cid, (array)$selected_category) )
			{
				if ( $dropdown_type >= 0 && $dropdown_type < 2 )
				{
					$category_list .= '<option value="' . $cid . '" selected="selected">' . $cname . '</option>';
				}
			}
			else
			{
				$category_list .= '<option value="' . $cid . '">' . $cname . '</option>';
			}
		}
	}
	
	$category_list .= '</select>';
	
	return $category_list;
}

function check_category_access ( $user_login, $category_array = array(), $type = 0 )
{
	global $fpath;
	
	$file = file ($fpath . 'categories.php');
	my_array_shift ($file);
	
	foreach ( $file as $category )
	{
		list ($cid, $cname, $cicon, $cusers) = explode ('|<|', $category);
		
		if ( $cid == 1 )
		{
			continue;
		}
		
		if ( in_array ($cid, $category_array) )
		{
			$cusers = explode (',', $cusers);
			if ( !in_array ((string)$user_login, $cusers) )
			{
				return $cname;
			}
		}
	}
	
	return NULL;
}

function category_news_count ( $category_id = array (-1) )
{
	global $fpath;

	if ( !is_array ($category_id) )
	{
		return -1;
	}
	
	$file = file ($fpath . 'news/toc.php');
	my_array_shift ($file);
	
	$count = 0;
	foreach ( $file as $news_post )
	{
		list ($news_id, $news_date, $news_writer, $news_subject, $news_categories) = explode ('|<|', $news_post);
		if ( file_exists ($fpath . 'news/news.' . $news_id . '.php') )
		{
			foreach ( explode (',', $news_categories) as $category )
			{
				if ( $category_id == -1 || in_array ((int)$category, $category_id) )
				{
					$count++;
				}
			}
		}
	}
	
	return $count;
}

function category_exists ( $category_id = -1 )
{
	global $fpath;
	
	$category_id = intval ($category_id);
	
	$file = file ($fpath . 'categories.php');
	my_array_shift ($file);
	
	$found = false;
	foreach ( $file as $category )
	{
		list ($cid, $cname, $cicon, $cusers) = explode ('|<|', $category);
		if ( (int)$cid === $category_id )
		{
			$found = true;
		}
	}
	
	return $found;
}

function safe_write ( $filename, $mode, $data )
{
	global $fpath, $error2, $error3;
	
	if ( !($fp = fopen ($fpath . $filename, $mode)) )
	{
		echo sprintf ($error2, $filename);
	}
	else
	{
		if ( !flock ($fp, LOCK_EX) )
		{
			echo sprintf ($error3, $filename);
		}
		else
		{
			fputs ($fp, $data, strlen ($data));
			flock ($fp, LOCK_UN);
			
			fclose ($fp);
			
			return true;
		}
	}
	
	return false;
}

function checkbox_checked ( $value )
{
	return ( $value == 1 ) ? ' checked="checked"' : '';
}

function parse_news_to_view ( $news_string )
{
	global $fpath, $fsnw, $wfpost, $ht, $cbwordwrap, $smilies, $bb, $stfpop, $compop,
		$furl, $fullnewsh, $fullnewsw, $fullnewss, $fullnewsz, $fslink, $datefor,
		$stflink, $stfheight, $stfwidth, $stfscrolls, $stfresize, $pclink, $datefor,
		$link_headline_fullstory, $hurl, $wwwidth, $comheight, $comwidth, $comscrolls,
		$comresize;

	$news_text = array();

	if ( !empty ($news_string) )
	{
		$icon = '';
		$email = '';
		$writer = '';
		$link_full_news = '';
		$link_comments = '';
		$link_tell_friend = '';
	
		list ($short_news, $full_news, $author, $subject, $categories, $timestamp, $num_comments, $news_id) = explode ('|<|', $news_string);
		
		// Get the template HTML
		$news_tmpl = get_template ('news_temp.php', false);
		
		// Make sure the timestamp is numerical
		$timestamp = intval ($timestamp);
		
		// Create the 'read more...' link
		if ( strpos ($news_tmpl, '{fullstory}') !== false && !empty ($full_news) )
		{
			$link_full_news = '<a href="' . $furl . '/fullnews.php?id=' . $news_id . '"' . (( $fsnw ) ? ' onclick="javascript:window.open(this.href,\'\',\'height=' . $fullnewsh . ',width=' . $fullnewsw . ',toolbar=no,menubar=no,scrollbars=' . $fullnewss . ',resizable=' . $fullnewsz . '\'); return false"' : '') . '>' . $fslink . '</a>';
		}
		
		// Create the comments link
		if ( strpos ($news_tmpl, '{comments}') !== false && strpos ($news_tmpl, '{nrc}') !== false )
		{
			$link_comments = '<a href="' . $furl . '/comments.php?id=' . $news_id . '"' . (( $compop ) ? ' onclick="window.open(this.href,\'\',\'height=' . $comheight . ',width=' . $comwidth . ',toolbar=no,menubar=no,scrollbars=' . $comscrolls . ',resizable=' . $comresize . '\'); return false"' : '') . '>' . $pclink . '</a>';
		}
		
		// Create the tell a friend link
		if ( strpos ($news_tmpl, '{send}') !== false )
		{
			$link_tell_friend = '<a href="' . $furl . '/send.php?id=' . $news_id . '"' . (( $stfpop ) ? ' onclick="window.open(this.href,\'\',\'height=' . $stfheight . ',width=' . $stfwidth . ',toolbar=no,menubar=no,scrollbars=' . $stfscrolls . ',resizable=' . $stfresize . '\'); return false"' : '') . '>' . $stflink . '</a>';
		}

		// Make sure the number of comments is 0 or above.
		$num_comments = ( intval ($num_comments) < 0 ) ? 0 : $num_comments;
		
		// Get author information
		$author = findwriter ($author);
		
		// Create the icon
		if ( strpos ($news_tmpl, '{icon}') !== false && !empty ($author['icon']) )
		{
			$icon = '<img src="' . $author['news_icon'] . '" alt="" />';
		}
		
		// Put the writer's name with his email as a link, or in some cases not.
		$email = ( $author['showemail'] == 'checked' ) ? $author['email'] : 'hidden';
		if ( $email == 'hidden' )
		{
			$writer = $author['nick'];
		}
		else
		{
			$writer = '<a href="mailto:' . $author['email'] . '">' . $author['nick'] . '</a>';
		}

		// Do we need to use the word filter?
		if ( $wfpost )
		{
			$subject = filterbadwords ($subject);
			$short_news = filterbadwords ($short_news);
			$full_news = filterbadwords ($full_news);
		}

		// Disable HTML if needed.
		if ( $ht )
		{
			$subject = unhtmlentities ($subject);
			
			$short_news = unhtmlentities ($short_news);
			$short_news = str_replace ('<?', '&lt;?', $short_news);
			
			$full_news = unhtmlentities ($full_news);
			$full_news = str_replace ('<?', '&lt;?', $full_news);
		}
		
		// Get our new lines back
		$short_news = str_replace ('&br;', '<br />', $short_news);
		$full_news = str_replace ('&br;', '<br />', $full_news);

		// Word wrap the news
		if ( $cbwordwrap )
		{
			$short_news = fusion_wordwrap ($short_news, $wwwidth);
			$full_news = fusion_wordwrap ($full_news, $wwwidth);
		}

		// Replace the BBCode
		if ( $bb )
		{
			$subject = InsertBBCode ($subject);
			$short_news = InsertBBCode ($short_news);
			$full_news = InsertBBCode ($full_news);
		}

		// Insert the smilies!
		if ( $smilies )
		{
			$subject = InsertSmillies ($subject, $furl);
			$short_news = InsertSmillies ($short_news, $furl);
			$full_news = InsertSmillies ($full_news, $furl);
		}
		
		$news_text = array (
			'link_tell_friend'	=> $link_tell_friend,
			'link_full_news'	=> $link_full_news,
			'subject'		=> $subject,
			'writer'		=> $writer,
			'email'			=> $email,
			'date'			=> date ($datefor, $timestamp),
			'icon'			=> $icon,
			'news'			=> $short_news,
			'fullnews'		=> $full_news
		);
		
		if ( strpos ($news_tmpl, '{comments}') !== false && strpos ($news_tmpl, '{nrc}') !== false )
		{
			$news_text += array (
				'nrc'		=> $num_comments,
				'link_comments'	=> $link_comments,
			);
		}
		else
		{
			$news_text += array ('nrc' => '', 'link_comments' => '');
		}
		
		// Replace in the values!
		$news_tmpl = str_replace ("{subject}", '<a id="fus_' . $news_id . '"></a>' . $subject, $news_tmpl);
		$news_tmpl = str_replace ("{user}", $writer, $news_tmpl);
		$news_tmpl = str_replace ("{date}", date ($datefor, $timestamp), $news_tmpl);
		$news_tmpl = str_replace ("{news}", $short_news, $news_tmpl);
		$news_tmpl = str_replace ("{fullstory}", $link_full_news, $news_tmpl);
		$news_tmpl = str_replace ("{icon}", $icon, $news_tmpl);
		$news_tmpl = str_replace ('{send}', $link_tell_friend, $news_tmpl);
		$news_tmpl = str_replace ('{nrc}', $news_text['nrc'], $news_tmpl);
		$news_tmpl = str_replace ('{comments}', $news_text['link_comments'], $news_tmpl);
		
		$news_text += array ('display' => $news_tmpl);
	}
	
	return $news_text;
}

// PHP 4.3.2 compatability
if ( !function_exists ('session_regenerate_id') )
{
	function session_regenerate_id()
	{
		$str = '';
		mt_srand ((double)microtime() * 100000);
		for ( $i = 0; $i < 32; $i++ )
		{
			$x = mt_rand (1, 3);
			$str .= ($x == 1) ? chr (mt_rand (48, 57)) : (( $x == 2 ) ? chr (mt_rand (65, 90)) : chr (mt_rand (97, 122)));
		}

		if ( session_id ($str) )
		{
			return true;
		}
		else
		{
			return false;
		}
	}
}

/**
 * Login session functions
 **/
function create_security_id ( $length = 32 )
{
	$str = '';
	mt_srand ((double)microtime() * 100000);
	for ( $i = 0; $i < $length; $i++ )
	{
		$x = mt_rand (1, 3);
		$str .= ($x == 1) ? chr (mt_rand (48, 57)) : (( $x == 2 ) ? chr (mt_rand (65, 90)) : chr (mt_rand (97, 122)));
	}
	
	return $str;
}

function login_session_create ( $uid, $autologin = 0 )
{
	global $fpath;
	
	$file = file ($fpath . 'logins.php');
	$write = my_array_shift ($file);
	
	foreach ( $file as $login_data )
	{
		list ($securityid, $user_id, $ip, $autolog, $timestamp) = explode ('|<|', $login_data);
		
		if ( ((getip() == $ip) || ($user_id == $uid)) && $autolog != 1 )
		{
			// Purge old existing security id
			continue;
		}
		
		if ( time() <= $timestamp )
		{
			$write .= $login_data;
		}
	}
	
	$security_id = create_security_id();
	
	$write .= $security_id . '|<|' . $uid . '|<|' . getip() . '|<|' . $autologin . '|<|' . time() . '|<|' . "\n";
	
	safe_write ('logins.php', 'wb', $write);
	
	setcookie ('fus_uid', $uid, time() + (365 * 86400));
	setcookie ('fus_sid', $security_id, time() + (365 * 86400));
}
 
function login_session_update ( $uid, $sid )
{
	global $fpath;
	
	$file = file ($fpath . 'logins.php');
	$write = my_array_shift ($file);
	
	$valid_sid = false;
	$userdata = NULL;
	foreach ( $file as $login_data )
	{
		list ($securityid, $user_id, $ip, $autologin, $timestamp) = explode ('|<|', $login_data);
		
		if ( (time() >= ($timestamp + 1800)) && $autologin != 1 )
		{
			continue;
		}
		
		if ( $securityid != $sid )
		{
			$write .= $login_data;
			continue;
		}
		
		if ( (getip() != $ip) || ($uid != $user_id) )
		{
			continue;
		}
		
		$userfile = file ($fpath . 'users.php');
		my_array_shift ($userfile);
		
		foreach ( $userfile as $userinfo )
		{
			list ($user, $nick, $email, $icon, $offset, $password, $level) = explode ('|<|', $userinfo);
			
			if ( $user == $uid )
			{
				$valid_sid = true;
				
				$email = explode ('=', $email);
				$userdata = array (
					'user'		=> $user,
					'nick'		=> $nick,
					'showemail'	=> $email[0],
					'email'		=> $email[1],
					'icon'		=> $icon,
					'offset'	=> intval ($offset),
					'password'	=> $password,
					'level'		=> intval ($level)
				);
				
				$write .= $securityid . '|<|' . $user_id . '|<|' . $ip . '|<|' . $autologin . '|<|' . time() . '|<|' . "\n";
			}
		}
	}
	
	safe_write ('logins.php', 'wb', $write);
	
	if ( !$valid_sid || $userdata == NULL )
	{
		setcookie ('fus_sid', '', time() - 86400);
		setcookie ('fus_uid', '', time() - 86400);
	}

	return $userdata;
}

function login_session_destroy ( $sid )
{
	global $fpath;

	$file = file ($fpath . 'logins.php');
	$write = my_array_shift ($file);
	
	$valid_sid = false;
	foreach ( $file as $login_data )
	{
		list ($securityid, $user_id, $ip, $autologin, $timestamp) = explode ('|<|', $login_data);
		
		if ( (time() >= ($timestamp + 1800)) && $autologin != 1 )
		{
			continue;
		}
		
		if ( $securityid == $sid )
		{
			continue;
		}
		
		$write .= $login_data;
	}
	
	safe_write ('logins.php', 'wb', $write);
}

?>
