<?php

/*
||==========================================================
||		Fusion News 3.x
||----------------------------------------------------------
|| File Version	: $Id: comments.php 102 2007-02-25 18:11:42Z xycaleth $
|| Contact	: xycaleth@gmail.com
|| Copyright:	: (c) 2006, FusionNews.net
|| License Info	: http://www.gnu.org/copyleft/gpl.html
||==========================================================
*/

include './common.php';

$news_tmpl = get_template ('news_temp.php', false);
if ( strpos ($news_tmpl, '{nrc}') === false || strpos ($news_tmpl, '{comments}') === false )
{
	exit;
}

// free up some memory
unset ($news_tmpl);

$id = ( isset ($VARS['id']) ) ? intval ($VARS['id']) : 0;
$mid = ( isset ($VARS['mid']) ) ? $VARS['mid'] : '';

session_start();
session_regenerate_id();

header ('Last-Modified: ' . gmdate ('D, d M Y H:i:s') . ' GMT');
header ('Cache-Control: no-cache, must-revalidate');
header ('Pragma: no-cache');

if ( $mid == 'confirm' )
{
	if ( !$id )
	{
		exit;
	}

	header ('Content-Type: image/png');
	header ('Cache-control: no-cache, no-store');
	
	$fusion_sid = ( isset ($_SESSION['fusion_sid']) ) ? $_SESSION['fusion_sid'] : session_id();
	if ( !isset ($_SESSION['fusion_sid']) )
	{
		$_SESSION['fusion_sid'] = $fusion_sid;
	}
	
	$color = array ('black', 'grey', 'white');
	$image = imagecreatetruecolor (175, 80);

	$color['black'] = imagecolorallocate ($image, 0x00, 0x00, 0x00);
	$color['grey']	= imagecolorallocate ($image, 0x4B, 0x4B, 0x4B);
	$color['white'] = imagecolorallocate ($image, 0xFF, 0xFF, 0xFF);

	imagefill ($image, 0, 0, $color['white']);

	$mt = microtime();
	list ($sec, $msec) = explode (' ', $mt);
	mt_srand ($sec * $msec);

	$confirm_code = array();
	for ( $i = 0; $i < 5; $i++ )
	{
		$x = mt_rand (1, 10);
		$confirm_code[] = ( $x % 2 ) ? chr (mt_rand (48, 57)) : chr (mt_rand (65, 90));
	}

	for ( $i = 0; $i < 10; $i++ )
	{
		imageline ($image, mt_rand (5, 80), mt_rand (5, 75), mt_rand (90, 170), mt_rand (5, 75), imagecolorallocate ($image, mt_rand (200, 255), mt_rand(200, 255), mt_rand(200, 255)));
	}

	$i = 10;
	foreach ( $confirm_code as $letter )
	{
		$rand_size = mt_rand (16, 32);
		$rand_angle= mt_rand (-30, 30);
		
		imagettftext ($image,
				$rand_size,
				$rand_angle,
				$i, 50,
				imagecolorallocate ($image, mt_rand (145, 230), mt_rand(145, 230), mt_rand(145, 230)),
				'news/fonts/VeraMono.ttf',
				$letter);
		$i += 30;
	}

	for ( $i = 0; $i < 10; $i++ )
	{
		imageline ($image, mt_rand (5, 80), mt_rand (5, 75), mt_rand (90, 170), mt_rand (5, 75), imagecolorallocate ($image, mt_rand (200, 255), mt_rand(200, 255), mt_rand(200, 255)));
	}
	
	imagepng ($image);
	imagedestroy ($image);
	
	$confirm_code = implode ('', $confirm_code);
	
	$file = file ($fpath . 'sessions.php');
	my_array_shift ($file);
	
	$updated = false;
	$data = '<?php die (\'' . $error1 . '\'); ?>' . "\n";
	foreach ( $file as $value )
	{
		if ( !$value )
		{
			continue;
		}
		
		list ($sessid, $code, $newsid, $ip, $last_visit) = explode ('|<|', $value);
		
		if ( $sessid == $fusion_sid )
		{
			if ( $ip != getip() || $newsid != $id || ($last_visit + 600 < time()) )
			{
				unset ($_SESSION['fusion_sid']);
				unset ($fusion_sid);
				$fusion_sid = $_SESSION['fusion_sid'] = session_id();
			}

			$data .= $fusion_sid . '|<|' . $confirm_code . '|<|' . $id . '|<|' . getip() . '|<|' . time() . '|<|' . "\n";
			$updated = true;
		}
		else if ( $last_visit + 600 >= time() )
		{
			$data .= $value;
		}
	}
	
	if ( !$updated )
	{
		$data .= $fusion_sid . '|<|' . $confirm_code . '|<|' . $id . '|<|' . getip() . '|<|' . time() . '|<|' . "\n";
	}
	
	safe_write ('sessions.php', 'wb', $data);

	return;
}

echo get_template('com_header.php', TRUE);

if ( !$id )
{
	echo $com10;
	echo get_template('com_footer.php', TRUE);
	return;
}

if ( !$mid ){
	if ( !file_exists ($fpath . 'news/news.' . $id . '.php') )
	{
		echo $com11;
		echo get_template('com_footer.php', TRUE);
		return;
	}
	
	$file = file($fpath."news/news.".$id.".php");	
	$news_info = parse_news_to_view ($file[1]);

	//replace user variables
	$temp_short = get_template('com_fulltemp.php', TRUE);
	$temp_short = "<script src=\"./jsfunc.js\" type=\"text/javascript\"></script>".$temp_short;
	$temp_short = str_replace("{subject}", $news_info['subject'], $temp_short);
	$temp_short = str_replace("{user}", $news_info['writer'], $temp_short);
	$temp_short = str_replace("{date}", $news_info['date'], $temp_short);
	$temp_short = str_replace("{news}", $news_info['news'], $temp_short);
	$temp_short = str_replace("{fullstory}", $news_info['fullnews'], $temp_short);
	$temp_short = str_replace("{icon}", $news_info['icon'], $temp_short);
	$temp_short = str_replace("{nrc}", $news_info['nrc'], $temp_short);
	$temp_short = str_replace("{com}", $news_info['link_comments'], $temp_short);

	$extras = show_extras ('newsposting', 'fullnews', $smilcom, $bbc);
	$box = $extras . "<textarea id=\"fullnews\" name=\"comment\" rows=\"\\2\" cols=\"\\1\"></textarea>";
	$comlen  = "";
	$temp_short = str_replace("{comments}", buildcomments($id), $temp_short);
	$temp_short = str_replace("[form]", "<form action=\"$furl/comments.php?mid=post&amp;id=$id\" method=\"post\" id=\"newsposting\">", $temp_short);
	$temp_short = str_replace("[/form]", "</form>", $temp_short);
	$temp_short = str_replace("[buttons]", "<input type=\"submit\" name=\"com_Submit\" value=\"Submit\" />\n<input type=\"reset\" value=\"Reset\" />", $temp_short);
	if($comlength == 0){
		$temp_short = str_replace("[comlen]", "", $temp_short);
	}else{
		$comlen .= "<script type=\"text/javascript\">\n";
		$comlen .= "//<![CDATA[\n";
		$comlen .= "document.getElementById('fullnews').onkeyup = Calcul;\n";
		$comlen .= "document.getElementById('fullnews').onkeydown = Calcul;\n";
		$comlen .= "function Calcul(e)\n";
		$comlen .= "{\n";
		$comlen .= "	var msg = document.getElementById('fullnews');\n";
		$comlen .= "        nbcar = msg.value.length;\n";
		$comlen .= "        if (nbcar > $comlength ) {\n";
		$comlen .= "          msg.value = msg.value.substring (0, $comlength);\n";
		$comlen .= "          alert(\"$ind258\");\n";
		$comlen .= "          valcar = 0;\n";
		$comlen .= "         }\n";
		$comlen .= "        else\n";
		$comlen .= "          valcar = $comlength - nbcar;\n";
		$comlen .= "        document.getElementById('chars').value = valcar;\n";
		$comlen .= "}\n";
		$comlen .= "//]]>\n";
		$comlen .= "</script>\n";
		$temp_short = str_replace("[comlen]", "<input id=\"chars\" name=\"chars\" size=\"5\" value=\"$comlength\" disabled=\"disabled\" />", $temp_short);
	}
	
	$temp_short = preg_replace ('/\[pwfld,\s*([0-9]+)\]/i', '<input type="password" size="$1" name="pass" />', $temp_short);
	$temp_short = preg_replace ('/\[namefld,\s*([0-9]+)\]/i', '<input type="text" size="$1" name="name" />', $temp_short);
	$temp_short = preg_replace ('/\[mailfld,\s*([0-9]+)\]/i', '<input type="text" size="$1" name="email" />', $temp_short);
	$temp_short = preg_replace ('/\[comfld,\s*([0-9]+),\s*([0-9]+)]/i', $box, $temp_short);
	
	// Image verification
	if ( $com_captcha )
	{
		$temp_short = str_replace ('[securityimg]', '<img src="./comments.php?id=' . $id . '&amp;mid=confirm" alt="CAPTCHA" id="captcha" />', $temp_short);
		$temp_short = str_replace ('[securityfld]', '<input type="text" name="code" size="5" maxlength="5" />', $temp_short);
	}
	else
	{
		$temp_short = str_replace ('[securityimg]', '', $temp_short);
		$temp_short = str_replace ('[securityfld]', '', $temp_short);
	}

	$comlen .= "<script type=\"text/javascript\">\n";
	$comlen .= "//<![CDATA[\n";
	$comlen .= "document.newsposting.com_Submit.onclick = Check;\n";
	$comlen .= "function Check(e)\n";
	$comlen .= "{\n";
	$comlen .= "	var msg = document.newsposting.fullnews;\n";
	$comlen .= "        if ((msg.value.length == 0) || (document.newsposting.name.value.length == 0)) {\n";
	$comlen .= "          alert(\"$ind259\");\n";
	$comlen .= "          return false;\n";
	$comlen .= "         }\n";
	$comlen .= "        else {\n";
	if ( $comlength > 0)
	{
		$comlen .= "          if (msg.value.length > $comlength) document.newsposting.fullnews.value = msg.value.substring(0,$comlength); \n";
	}
	$comlen .= "          return true;\n";
	$comlen .= "        }\n";
	$comlen .= "}\n";
	$comlen .= "//]]>\n";
	$comlen .= "</script>\n";

	$temp_short .= $comlen;
	echo $temp_short;
}
//---------------

//Post Comment
elseif($mid == "post")
{  /*id Post comment*/
	$comment= ( isset ($VARS["comment"]) ) ? trim ($VARS['comment']) : '';
	$name	= ( isset ($VARS['name']) ) ? trim(substr( $VARS["name"], 0, 40)) : '';
	$email	= ( isset ($VARS["email"]) ) ? $VARS['email'] : '';
	$pass	= ( isset ($VARS['pass']) ) ? trim (substr ($VARS['pass'], 0, 40)) : '';
	$code	= ( isset ($VARS['code']) ) ? $VARS['code'] : '';

	if ( !check_security_code ($code, $id) && $com_captcha )
	{
		echo $com13;
	}
	else if(!$name || !$comment)
	{
		echo $com1;
	}
	else if ( $comlength > 0 && strlen ($comment) > $comlength )
	{
		printf ($com14, $comlength);
	}
	else if ( !valid_email ($email) && $email != '' )
	{
		echo $com2;
	}
	elseif ( checkifbanned (getip()) )
	{
		echo '<font color="#FF0000">' . $com3 . '</font><br />';
	}
	elseif ( checkifflooding (getip(), $id) )
	{
		echo '<font color="#FF0000">' . $com4 . ' ' . $floodtime . ' ' . $com5 . '</font><br />';
	}
	else
	{
		$news_user = 0;
		$passok   = 0;
	
		$file = file($fpath."users.php");
		my_array_shift($file);
		
		foreach($file as $value)
		{
			list($fuser,$fnick,$femail,$ficon,$ftimeoffset,$fpass,$le) = explode("|<|", $value);
			if(($name == $fuser) || ($name == $fnick))
			{
				$news_user = 1;
				if(md5($pass) == $fpass)
				{
					$name = $fnick;
					$passok = 1;
					if ( !$email )
					{
						$femail = explode ('=', $femail);
						if ( $femail[0] != 'checked' )
						{
							$email = $femail[1];
						}
					}
				}
			}
		}
		
		if ( $passok == $news_user )
		{
			$ip = getip();
			$comment = str_replace ("\\\'", "'", $comment);
			$comment = str_replace('\\\"', '"', $comment);
			$comment = stripslashes($comment);
			$name = str_replace("\\\'", "'", $name);
			$name = str_replace('\\\"', '"', $name);
			$name = str_replace('\\\\', '\\', $name);
			
			if ( $comallowbr )
			{
				$comment = str_replace("\n", "&br;", $comment);
			}
			else
			{
				$comment = str_replace("\n", "&nbsp;", $comment);
			}
			
			$comment = str_replace("\r", "", $comment);
			$time = time();
			mt_srand((double)microtime()*1000000);
			$random = "com" . mt_rand();
			$file = file ($fpath . 'news/news.' . $id . '.php');
			$file[count($file)] = $ip . '|<|' . ($com_validation ? 0 : 1) . '|<|' . $comment . '|<|' . $name . '|<|' . $email . '|<|' . $time . '|<|' . $random . '|<|' . "\n";
			// build ----------
			$numcom = 0;
			list($news_short,$news_full,$news_writer,$news_subject,$news_categories,$news_date,$news_comment_count) = explode("|<|", $file[1]);
			
			if ( !$com_validation )
			{
				$news_comment_count++;
			}
			
			$file[1] = $news_short."|<|".$news_full."|<|".$news_writer."|<|".$news_subject."|<|".$news_categories."|<|".$news_date."|<|".$news_comment_count."|<|$id|<|\n";
			$data = implode ('', $file);
			
			safe_write ('news/news.' . $id . '.php', 'wb', $data);
			safe_write ('flood.php', 'ab', $ip . '=' . $time . '=' . $id);
			
			buildnews();

			echo <<< html
<script type="text/javascript">
//<![CDATA[
setTimeout ('window.location="{$furl}/comments.php?id=$id"', 3000);
//]]>
</script>
html;

			if ( $com_validation )
			{
				echo $com6a;
			}
			else
			{
				echo $com6 . ' <a href="' . $furl . '/comments.php?id=' . $id . '">' . $com7 . '</a>';
			}
		}
		else
		{
			echo $com8;
		}
	}
}

  echo get_template('com_footer.php', TRUE);
?>
