<?php

/*
||==========================================================
||		Fusion News 3.x
||----------------------------------------------------------
|| File Version	: $Id: archive.php 83 2007-02-11 16:29:23Z xycaleth $
|| Contact	: xycaleth@gmail.com
|| Copyright:	: (c) 2006, FusionNews.net
|| License Info	: http://www.gnu.org/copyleft/gpl.html
||==========================================================
*/

// Taken from FN 4.0 code :)
$truepath = str_replace ('\\', '/', dirname (__FILE__)) . '/';

include $truepath . 'common.php';

// Override $fpath variable to always be the directory
// the file is in.
$fpath = $truepath;

$show = ( isset ($VARS['show']) ) ? $VARS['show'] : '';
echo get_template ('header.php', true);

if ( $show == "" )
{ /*id Index*/
	$file = file($fpath."news/toc.php");
	my_array_shift( $file );
	
	if( $flip_news )
	{
		array_flip($file);
	}

	$array = array();
	foreach ( $file as $value )
	{
		list($news_id,$news_date,$news_writer,$news_subject) = explode("|<|", $value);
		$news_date = intval($news_date);
		$time = mktime (0, 0, 0, date ('n', $news_date), 1, date ('y', $news_date));
		$allready_added = FALSE;
		
		foreach ( $array as $val )
		{
			if ( $time == $val )
			{
				$allready_added = TRUE;
			}
		}
		
		if( !$allready_added )
		{
			$array[] = $time;
		}
	}
	foreach ( $array as $val )
	{
		$month = date ('n', $val);
		$year  = date ("Y", $val);
		
		$qs = ( !empty ($_SERVER['QUERY_STRING']) ) ? $_SERVER['QUERY_STRING'] . '&amp;show=month&amp;month=' . $month . '&amp;year=' . $year : 'show=month&amp;month=' . $month . '&amp;year=' . $year;
		
		echo "<a href=\"?" . $qs . "\">".$months[$month]." ".$year."</a><br />\n";
	}
}
else if( $show == "month" )
{ /*id Month*/
	$month = ( isset ($VARS['month']) ) ? intval ($VARS['month']) : '';
	$year = ( isset ($VARS['year']) ) ? intval ($VARS['year']) : '';

	if( !$month || !$year )
	{
		echo $arch0;
	}
	else
	{
		$file = file ($fpath . 'news/toc.php');
		my_array_shift ($file);

		if ( $post_per_day )
		{
			$ppp_data = array();
		}
		
		foreach( $file as $value)
		{
			list($news_id,$news_date,$news_writer,$news_subject) = explode("|<|", $value);
			$time = mktime (0, 0, 0, date ('n', $news_date), 1, date ('y', $news_date));
			if( $time == mktime (0, 0, 0, $month, 1, $year) )
			{
				if ( file_exists ($fpath . 'news/news.' . $news_id . '.php') )
				{
					$file_news = file( $fpath."news/news.".$news_id.".php" );
					list($news_short,$news_full,$news_writer,$news_subject,$news_categories,$news_date,$news_comment_count,$news_item) = explode("|<|", $file_news[1]);

					$news_info = parse_news_to_view ($file_news[1]);

					$tem = get_template('arch_news_temp.php', TRUE);
					$tem = str_replace("{subject}", $news_info['subject'], $tem);
					$tem = str_replace("{user}", $news_info['writer'], $tem);
					$tem = str_replace("{date}", $news_info['date'], $tem);
					$tem = str_replace("{news}", $news_info['news'], $tem);
					$tem = str_replace("{icon}", $news_info['icon'], $tem);
					$tem = str_replace("{fullstory}", $news_info['link_full_news'], $tem);
					$tem = str_replace("{nrc}", $news_info['nrc'], $tem);
					$tem = str_replace("{comments}", $news_info['link_comments'], $tem);
					$tem = str_replace("{send}", $news_info['link_tell_friend'], $tem);
					
					if ( $post_per_day )
					{
						$day_time = mktime (0, 0, 0, date('n', $news_date), date('j', $news_date), date('y', $news_date));
						if( !isset($ppp_data[$day_time]) )
						{
							$ppp_data[$day_time] = '';
						}
						
						$ppp_data[$day_time] .= $tem;
					}
					else
					{
						echo $tem;
					}
				}
			}
		}
		
		if ( $post_per_day )
		{
			krsort( $ppp_data );
			$temp = get_template('news_a_day_temp.php', TRUE);
			foreach ( $ppp_data as $key => $value )
			{
				$insert_date = str_replace('{date}', date('l', $key) . ', ' . $months[date ('n', $key)] . '&nbsp;' . date ('d', $key) . '&nbsp;' . date ('Y', $key), $temp);
				
				echo str_replace('{news_a_day}', $value, $insert_date);
			}
		}
	}
}

echo get_template ('footer.php', true);

?>
