<?

// Timezones support (taken from slashcode)

$tz["Newfoundland Daylight"]           =  -9000;
$tz["Atlantic Daylight"]               = -10800;
$tz["Eastern Daylight"]                = -14400;
$tz["Central Daylight"]                = -18000;
$tz["Mountain Daylight"]               = -21600;
$tz["Pacific Daylight"]                = -25200;
$tz["Yukon Daylight"]                  = -28800;
$tz["Hawaii Daylight"]                 = -32400;
$tz["British Summer"]                  =   3600;
$tz["Middle European Summer"]          =   7200;
$tz["Swedish Summer"]                  =   7200;
$tz["French Summer"]                   =   7200;
$tz["West Australian Daylight"]        =  28800;
$tz["Central Australian Daylight"]     =  37800;
$tz["Eastern Australian Daylight"]     =  39600;
$tz["New Zealand Daylight"]            =  46800;
$tz["Greenwich Mean"]                  =      0;
$tz["Universal (Coordinated)"]         =      0;
$tz["Western European"]                =      0;
$tz["West Africa"]                     =  -3600;
$tz["Azores"]                          =  -7200;
$tz["Greenland Standard"]              = -10800;
$tz["Newfoundland"]                    = -12600;
$tz["Newfoundland Standard"]           = -12600;
$tz["Atlantic Standard"]               = -14400;
$tz["Eastern Standard"]                = -18000;
$tz["Central Standard"]                = -21600;
$tz["Mountain Standard"]               = -25200;
$tz["Pacific Standard"]                = -28800;
$tz["Yukon Standard"]                  = -32400;
$tz["Hawaii Standard"]                 = -36000;
$tz["Central Alaska"]                  = -36000;
$tz["Alaska-Hawaii Standard"]          = -36000;
$tz["Nome"]                            = -39600;
$tz["International Date Line West"]    = -43200;
$tz["Central European"]                =   3600;
$tz["Middle European"]                 =   3600;
$tz["Middle European Winter"]          =   3600;
$tz["Swedish Winter"]                  =   3600;
$tz["French Winter"]                   =   3600;
$tz["Eastern Europe, USSR Zone 1"]     =   7200;
$tz["Baghdad, USSR Zone 2"]            =  10800;
$tz["Iran"]                            =  12600;
$tz["USSR Zone 3"]                     =  14400;
$tz["USSR Zone 4"]                     =  18000;
$tz["Indian Standard"]                 =  19800;
$tz["USSR Zone 5"]                     =  21600;
$tz["West Australian Summer"]          =  25200;
$tz["Java"]                            =  27200;
$tz["China Coast, USSR Zone 7"]        =  28800;
$tz["Japan Standard, USSR Zone 8"]     =  32400;
$tz["Central Australian Standard"]     =  34200;
$tz["Eastern Australian Standard"]     =  36000;
$tz["New Zealand"]                     =  43200;
$tz["New Zealand Standard"]            =  43200;
$tz["International Date Line East"]    =  43200;
$tz["Israel Daylight"]                 =  10800;
$tz["Israel Standard"]                 =   7200;

$tod = gettimeofday();
$secondswest = $tod["minuteswest"]*60;
unset($tod);


$config = array(
   // dir to store the news data files in
   // ******************************************************
   //  newsdir must be absolute path only if news and admin
   //  pages are in different directories. Trailing slash!
   // ******************************************************
   imgdir   => "images/",     // path to directory with topic images
   themedir => "themes/",     // path to dir with themes
   imgattr  => "border=0",    // topic images attributes
   newssuff => ".news",       // file extension for news files
   moresuff => "_more",       // file extension for news details files
   mainpg   => "index.php",   // main news page name
   morepg   => "news.php",    // details news page name
   tzname   => "Japan Standard, USSR Zone 8", // timezone for displaying dates
   pglimit  => 3,             // how many news on one page
   abstrlen => 200            // length for news abstracts (if used)
);

// RSS backend support
$RSS = array(
   rssfile   => "ptnews.rss",
   sitename  => "Your Site Name",
   sitewhat  => "Site Description",
   siteadmin => "Your Name",
   httpbase  => "http://localhost/ptnews/",
   lng       => "en-us"   // language entry in RSS backend file
);

// multi-topic support
$topics=array(
   general => 'General',
   ptnews  => 'PT News',
   humour  => 'Humour'
);

// multi-language support
$lang=array(
   datefmt     => "%d/%m/%Y @ %H:%M",  // dates display format in news
   dateadm     => "%d/%m/%Y %H:%M:%S", // date display format for admin
   more        => "more...",           // link to news details
   pages       => "Pages: ",           // news paging
   allnews     => "All news...",       // all news
   adm_del     => "DEL...",            // delete entry in admin page
   adm_edit    => "EDIT...",           // edit entry in admin page
   adm_delall  => "DEL ALL",           // delete all entry in admin page
   adm_home    => "ADMIN...",          // back to news page
   adm_news    => "HOME...",           // back to news page
   adm_logout  => "LOGOUT",            // admin logout
   msg_dellall => "Delete all: ",      // messages in deleteAll function
   msg_done    => "Done. Deleted files: ",
   // input news form
   frm_title   => "Title:",
   frm_msg     => "News Message:",
   frm_btn     => "Create Entry",
   // search news
   srch_submit => "Search News",       // Search button title
   srch_total  => "Total",
   srch_disp   => "Displaying",
   srch_zero   => "Not found"
);

// search in news files
$sconfig=array(
   action  => "index.php",   // page responsible for searching
   theme   => "stheme.inc",   // theme file for output results
   method  => "POST",          // maybe POST is better? ;0)
   size    => "25",           // query textbox size
   button  => "yes"           // do you want search button or no?
);


//////////////////////////////////////////////////////////////////
// converts server time -> local time

function serverToLocal($timestamp) {
   global $tz, $secondswest,$config;
   $zone=$config[tzname];
   return ($timestamp + $secondswest + $tz[$zone]);
}
   

/////////////////////////////////////////////////////////////////
// This function compiles an ordered array called $newsfile of 
// all news files in the $newsdir 
// It must be run prior to displaying the news 

function buildNewsfile ($newsdir, $topic="") { 
   global $config;
     
   $newsfile = array();
   if ("" == $topic) { $match = 'yes'; }
   else { $match='no'; }
   $td = dir($newsdir); 
   while ($filename = $td->read()) { 
       $s = strtolower($filename); 
       if (('.'.fileExt($s)) == $config[newssuff]) {
           if ("" != $topic) {
              $story = getStory($newsdir.$filename);
              if ($story[Topic] == $topic) { $match='yes'; }
              else { $match='no'; }
           }
           if ('yes' == $match) {
              $lastchanged = filemtime($newsdir.$filename); 
              $newsfile[$filename] = $lastchanged;
           }
       } 
       arsort($newsfile); 
   }
   return $newsfile; 
}


//////////////////////////////////////////////////////////////////
// This function is used internally to display a single news entry 
// Look is managed by theme file
// Different tags are displayed by mod_... functions (see below)

function displayNewsEntry($dr_fn, $theme, $detail="no") { 
   global $config, $topics, $lang, $tz;     
   $story = getStory($dr_fn);
   $fullbox=implode("", file($config[themedir].$theme));
   preg_match_all("/#(.*)#/U",$fullbox,$matches);
   for ($i=0; $i<count($matches[0]); $i++) {
      $func_name="mod_".strtolower($matches[1][$i]);
      if (function_exists($func_name)) {
         $tag=call_user_func($func_name,$story,$dr_fn,$detail);
         $fullbox=str_replace($matches[0][$i],$tag,$fullbox);
      } else {
         echo "Func $func_name not exists<br>\n";
      }
   }
   echo $fullbox;
}


//////////////////////////////////////////////////////////////////
// Modules for displaying News System Tags #...#

function mod_title($story) {
   return $story[Title];
}

function mod_titlelnk($story,$dr_fn) {
   global $config;
   $fn=basename($dr_fn);
   $title_link="<a href=\"$config[morepg]?detail=$fn\">$story[Title]</a>";
   return $title_link;
}

// fn must be full name: dir+ilename
function mod_date($story,$dr_fn,$detail) {
   global $config, $lang, $tz;

   if ("adm" == $detail)
      $dt_fmt = $lang[dateadm];
   else
      $dt_fmt = $lang[datefmt];
   $datestr=strftime($dt_fmt,serverToLocal(filemtime($dr_fn)));
   $zone=$config[tzname];
   $datestr .="&nbsp;(GMT&nbsp;".(($tz[$zone]>0)?"+":"").($tz[$zone]/3600).")";
   return $datestr;
}

function mod_topic($story) {
   global $topics;
   return $topics[$story[Topic]];
}

function mod_topicimg($story) {
   global $config, $topics;
   $img_link='<img src="'.$config[imgdir].$story[Topic].
             '.gif" alt="'.$topics[$story[Topic]].'" '.$config[imgattr].'>';
   return $img_link;
}

function mod_topiclnk($story) {
   global $config, $topics;
   $topic_link='<a href="'.$config[mainpg].'?topic='.$story[Topic].'">'.
               $topics[$story[Topic]].'</a>';
   return $topic_link;
}

function mod_fsize($story) {
   return $story[FSize];
}

// fn is full name: dir+fn
function mod_content($story,$dr_fn,$detail) {
   global $config, $lang;
   $story_txt = nl2br($story[Body]);
   $fn = basename($dr_fn);
   if (0 != file_exists($dr_fn.$config[moresuff])) {
      if ("yes" == $detail) {
         $story_more = implode("", file($dr_fn.$config[moresuff]));
         $story_txt .= "<P>\n".nl2br($story_more);
      } else {
         $story_txt .= "<BR><a href=\"$config[morepg]?detail=$fn\">[ $lang[more] ]</a><P>\n";
      }
   }
   return $story_txt;
}

function mod_abstract($story) {
   global $config;
   $text=substr($story[Body],0,$config[abstrlen]);
   $lastspacepos=strrpos($text,' ');
   return strip_tags(substr($text,0,$lastspacepos))."...";
}


////////////////////////////////////////////////////////////////////////////
// Call this funciton to display the entire news listing, in order of date.
// Inside this function is paging engine.
// First parameter is created with buildNewsfile() array

function displayNews($newsdir, $topic, $theme, $pageNum=1) { 
   global $config, $lang; 

   $news = buildNewsfile($newsdir, $topic);

   $rowResultsArray=array();
   for(reset($news); $key = key($news); next($news)) {  
      $rowResultsArray[] = key($news);
   }

   $output = "";
   $rowsPerPage=$config[pglimit];
    
   // $pageNum starts at 1. 
   $startRow = ($pageNum - 1) * $rowsPerPage; 
   $stopRow = $startRow + $rowsPerPage; 
    
   for ($i = $startRow; ($i < count($rowResultsArray)) && ($i < $stopRow); $i++){
      displayNewsEntry($newsdir.$rowResultsArray[$i],$theme);
   } 
   print   "<P>";  
   if ("" != $topic) $url = $config[mainpg]."?topic=$topic&";
   else $url = $config[mainpg].'?';
   $numPages = ceil(count($rowResultsArray) / $rowsPerPage);
   if ($numPages > 1) {
    
      echo $lang[pages];

      if ($pageNum != 1) 
         $output .= "<a href=\"".$url."pageNum=" . ($pageNum-1) . "\">&lt;&lt;</a>&nbsp;"; 

      for ($i = 1; $i < $numPages+1; $i++){ 
         if ($pageNum == $i) $output .= "<strong>$i</strong>&nbsp;"; 
         else $output .= "<a href=\"".$url."pageNum=" . $i . "\">$i</a>&nbsp;"; 
      } 

      if ($pageNum < (int)$numPages) 
         $output .= "<a href=\"".$url."pageNum=" . ($pageNum+1) . "\">&gt;&gt;</a>"; 
   }

   if ("" != $topic) {
      $output .= "\n<P><a href=\"".$config[mainpg]."\">".
         $lang[allnews]."</a></P>\n";
   }
    
   echo $output; 
}


///////////////////////////////////////////////////////////////////
// Call this funciton to search keywords in news files. 
// inside this function is paging engine.
// Return array

function searchNews($newsdir, $query, $pageNum=1,$extraHTMLParms="") {
   global $config, $matchCnt, $sconfig, $lang;

   if ("" == $query) { echo $lang[srch_zero]."<P>\n"; return;} 

    $matchCnt =0;
    $newsfile = array();
    $td = dir($newsdir); 
    while ($filename = $td->read()) { 
       $s = strtolower($filename); 
       if (('.'.fileExt($s)) == $config[newssuff]) {
          $content = file($newsdir.$filename);
          $content = implode(" ", $content);
          if (0 != file_exists($newsdir.$filename.$config[moresuff])) {
             $more = file($newsdir.$filename.$config[moresuff]);
             $more = implode(" ", $more);
             $content .= $more;
          }
          if (stristr(strip_tags($content),$query) == true) { //Scan for matches
             $lastchanged = filemtime($newsdir.$filename); 
             $newsfile[$filename] = $lastchanged;
             $matchCnt++;
          }
       } 
    }
    arsort($newsfile);
    if (0 == $matchCnt) { echo $lang[srch_zero]."<P>\n"; return;}

    // rowResultsArray - array for paging news
    // format (id=>filename)
    $rowResultsArray=array();
    for(reset($newsfile); $key = key($newsfile); next($newsfile)) {  
       $rowResultsArray[] = key($newsfile);
    }

    $output="";
    $rowsPerPage=$config[pglimit];
    
    // $pageNum starts at 1. 
    $startRow = ($pageNum - 1) * $rowsPerPage; 
    $stopRow = $startRow + $rowsPerPage; 

    $cntResults = count($rowResultsArray);
    echo "<small>$lang[srch_total]: <b>$matchCnt</b> $lang[srch_disp]: <b>".($startRow+1).
         " - ".(($stopRow > $cntResults)?$cntResults:$stopRow)."</b></small><P>\n";
    
    for ($i = $startRow; ($i < $cntResults) && ($i < $stopRow); $i++){ 
       displayNewsEntry($newsdir.$rowResultsArray[$i],$sconfig[theme],"yes");
       print   "<P>";
    } 
    print   "<P>";  
    $url = "$sconfig[action]?first=no&querybox=$query$extraHTMLParms"; 
    $numPages = ceil($cntResults / $rowsPerPage);
    if ($numPages <= 1) return;
    
    echo $lang[pages];

    if ($pageNum != 1) 
      $output .= "<a href=\"$url&pageNum=" . ($pageNum-1) . "\">&lt;&lt;</a>&nbsp;"; 

    for ($i = 1; $i < $numPages+1; $i++){ 
      if ($pageNum == $i) $output .= "<strong>$i</strong>&nbsp;"; 
      else $output .= "<a href=\"$url&pageNum=" . $i . "\">$i</a>&nbsp;"; 
    } 

    if ($pageNum < (int)$numPages) 
      $output .= "<a href=\"$url&pageNum=" . ($pageNum+1) . "\">&gt;&gt;</a>"; 

    echo $output; 
}


///////////////////////////////////////////////////////////////////
// WAP support

///////////////////////////////////////////////////////////////////
// Call this funciton to display the entire WAP news listing, 
// in order of date 
// inside this function is paging engine.

function displayWAP($newsdir, $topic, $pageNum=1,$extraHTMLParms="") { 
   global $config, $lang, $RSS, $SCRIPT_NAME; 

   $news = buildNewsfile($newsdir, $topic);

   $output = "";
   $rowsPerPage=$config[pglimit];

   $rowResultsArray=array();
   for(reset($news); $key = key($news); next($news)) {  
      $rowResultsArray[] = key($news);
   }

   // $pageNum starts at 1. 
   $startRow = ($pageNum - 1) * $rowsPerPage; 
   $stopRow = $startRow + $rowsPerPage; 
    
   for ($i = $startRow; ($i < count($rowResultsArray)) && ($i < $stopRow); $i++){ 
       displayWAPEntry($newsdir.$rowResultsArray[$i]);
   }

   if ("" == $extraHTMLParms) { $extraHTMLParms="extra=no"; }
  
   $url = "$RSS[httpbase]".basename($SCRIPT_NAME)."?$extraHTMLParms"; 
   $numPages = ceil(count($rowResultsArray) / $rowsPerPage);
   if ($numPages <= 1) return;

   echo "<br/>\n";
   if ($pageNum != 1) 
      $output .= "<do type=\"prev\" label=\"&lt;&lt;\">".
                 "<go href=\"$url&page=".($pageNum-1)."\"/></do>\n"; 
   if ($pageNum < (int)$numPages) 
      $output .= "<do type=\"unknown\" label=\"&gt;&gt;\">".
                 "<go href=\"$url&page=".($pageNum+1)."\"/></do>"; 
   echo $output."<br/>\n"; 
}


//////////////////////////////////////////////////////////////////
// display one WAP news entry
// display only date, title and topic

function displayWAPEntry($dr_fn, $detail="no") {
   global $config, $topics, $lang, $RSS, $SCRIPT_NAME;
   $mainpg=basename($SCRIPT_NAME);
   $story = getStory($dr_fn,"yes");
   $fn = basename($dr_fn);
   echo strftime($lang[dateadm],filemtime($dr_fn))."<br/>\n<strong>".$story[Title];
   echo ' ['.$topics[$story[Topic]].']'."</strong><br/>\n";
   echo($story[Body]."<br/>\n");
   if (0 != file_exists($dr_fn.$config[moresuff])) {
      if ("yes" == $detail) {
         $fm = file($dr_fn.$config[moresuff]);
         $n=count($fm);
         for ($i=0; $i<$n; $i=$i+1) {
            $s=chop($fm[$i]);  
            echo($s."<br/>\n");  
         }
      } else {
         echo "<anchor><go href=\"$RSS[httpbase]$mainpg?detail=$fn\"/>[ $lang[more] ]</anchor>\n";
         echo "<br/><br/>\n";
      }
   }
}


///////////////////////////////////////////////////////////////////
// RSS backend support
// the name of file is $RSS[rssfile]

function makeNewsRSS($newsdir) {
   global $RSS, $config; 

   $newsfile = buildNewsfile($newsdir);
    
   $fp = fopen($newsdir.$RSS[rssfile], "w");
   writeRSSHeader($fp, $RSS[sitename], $RSS[sitewhat]);
   for(reset($newsfile); $key = key($newsfile); next($newsfile)) {  
      writeRSSItem($newsdir,$fp,key($newsfile));
   }
   writeRSSFooter($fp);
   fclose($fp);
} 


///////////////////////////////////////////////////////////////////
// Call this funciton from a secure page 
// It allows addition and deletion of news files 

function displayNewsAdmin($newsdir, $theme,$mode) { 
   global $config, $lang, $topics, $context, $SCRIPT_NAME;

   $newsfile = buildNewsfile($newsdir);

   $mainpg=basename($SCRIPT_NAME);
   if ("delall" == $mode || "edit" == $mode) { print $context; }
   elseif ("full" == $mode) {
      for(reset($newsfile); $key = key($newsfile); next($newsfile)) {  
         displayNewsEntry($newsdir.key($newsfile),$theme,"adm");
         print "&nbsp;<a href=\"$mainpg?delete=".key($newsfile)."\">[ $lang[adm_del] ]</a>";
         print "&nbsp;<a href=\"$mainpg?edit=".key($newsfile)."\">[ $lang[adm_edit] ]</a>";
         print "<P>\n";
      }
   } 
   if ($mode != "dellall" && $mode != "edit") {  
      //print news creation form
      print  '<FONT FACE="Helvetica" SIZE="2">'; 
      print  '<FORM METHOD="post" ACTION="'.$mainpg.'">'.$lang[frm_title].'<BR>
<INPUT type="text" NAME="title" size="40" VALUE=""><BR>';
      print array2select($topics,'topic');
      print '<BR>'.$lang[frm_msg].'<BR>
<TEXTAREA NAME="message" ROWS=3 COLS=60></TEXTAREA><BR>
<TEXTAREA NAME="more" ROWS=6 COLS=60></TEXTAREA><BR>
<INPUT type="hidden" NAME="action" VALUE="create">
<INPUT type="submit" NAME="submitButton" VALUE="'.$lang[frm_btn].'"></FORM></FONT>';
   }
   print "\n<P><a href=\"$mainpg?delete=all\">[ $lang[adm_delall] ]</a>";
   print "&nbsp;<a href=\"$config[mainpg]\">[ $lang[adm_news] ]</a>&nbsp;";
   print "&nbsp;<a href=\"$mainpg\">[ $lang[adm_home] ]</a>&nbsp;";
   print "&nbsp;<a href=\"$mainpg?logout=yes\">[ $lang[adm_logout] ]</a><P>";
}


///////////////////////////////////////////////////////////////////
// news file manipulations
// create, delete, edit
// for use from admin

function createNewsEntry($newsdir) { 
   global $config, $HTTP_POST_VARS;
   $fname="n".time();
   $fp = fopen ($newsdir.$fname.$config[newssuff],  "w");
   fwrite($fp, "Title::".stripslashes($HTTP_POST_VARS[title])."\n");
   fwrite($fp, "Topic::".$HTTP_POST_VARS[topic]."\n");
   fwrite ($fp, stripslashes("Body::Start\n".$HTTP_POST_VARS[message])); 
   fclose($fp);
   if (isset($HTTP_POST_VARS[more]) && (strlen($HTTP_POST_VARS[more])>1)) {
      $fp = fopen ($newsdir.$fname.$config[newssuff].$config[moresuff],  "w");     
      fwrite ($fp, stripslashes($HTTP_POST_VARS[more])); 
      fclose($fp); 
   }
} 


function deleteNewsEntry ($dr_fn) { 
   global $config; 
   unlink ($dr_fn);
   if (0 != file_exists($dr_fn.$config[moresuff])) {
      unlink ($dr_fn.$config[moresuff]);
   }
} 


function deleteAll($newsdir,$ext) {
   global $config, $lang;
   $cont = $lang[msg_delall]."[.$ext]<P>\n";
   $count=0;
   $td = dir($newsdir); 
   while ($filename = $td->read()) { 
       $s = strtolower($filename);
       if ('.'.fileExt($s) == $ext) {
          unlink ($newsdir.$s);
          $count++;
          if (0 != file_exists($newsdir.$s.$config[moresuff])) {
             unlink ($newsdir.$s.$config[moresuff]);
          }
       }
   }
   return $cont."<P>".$lang[msg_done]."$count<P>\n";
}


function editNewsEntry($newsdir,$fn) { 
   global $config, $lang, $topics, $SCRIPT_NAME;
   $cont = "";
   $mainpg=basename($SCRIPT_NAME); 
   $story = getStory($newsdir.$fn);
   $fm = "";
   if (0 != file_exists($newsdir.$fn.$config[moresuff])) {
      $fm = implode(file($newsdir.$fn.$config[moresuff]),"");
   }
   //print news creation form
   $cont .= '<FONT FACE="Helvetica" SIZE="2">'; 
   $cont .= '<FORM METHOD="post" ACTION="'.$mainpg.'">'.$lang[frm_title].'<BR>
<INPUT type="text" NAME="title" size="40" VALUE="'.$story[Title].'"><BR>';
   $cont .= array2select($topics,'topic',$story[Topic]);
   $cont .= '<BR>'.$lang[frm_msg].'<BR>
<TEXTAREA NAME="message" ROWS=3 COLS=60>'.$story[Body].'</TEXTAREA><BR>
<TEXTAREA NAME="more" ROWS=6 COLS=60>'.$fm.'</TEXTAREA><BR>
<INPUT type="hidden" NAME="action" VALUE="replace">
<INPUT type="hidden" NAME="file" VALUE="'.$fn.'">
<INPUT type="submit" NAME="submitButton" VALUE="'.$lang[frm_btn].'"></FORM></FONT>';
   return $cont;
}


///////////////////////////////////////////////////////////////////
// internal use

// RSS files write functions
function writeRSSHeader($fp, $title, $desc) {
   global $RSS;
   fwrite($fp, "<?xml version=\"1.0\"?>\n<!DOCTYPE rss PUBLIC \"-//Netscape Communications//DTD RSS 0.91//EN\"\n\"http://my.netscape.com/publish/formats/rss-0.91.dtd\">\n<rss version=\"0.91\">\n\n");
   fwrite($fp, "<channel>\n<title>$title</title>\n<link>" .$RSS[httpbase] .
          "</link>\n<description>$desc</description>\n<language>$RSS[lng]</language>\n\n");
}


function writeRSSItem($newsdir,$fp, $fn) {
   global $config, $RSS, $topics;

   $story = getStory($newsdir.$fn);
   fwrite($fp, "<item>\n<title>[".$topics[$story[Topic]]."] $story[Title]</title>\n<link>".
          $RSS[httpbase]."$config[morepg]?detail=$fn</link>\n<description>".
          $story[Body]."</description>\n</item>\n\n");
}


function writeRSSFooter($fp) {
   global $RSS, $lang;
   fwrite($fp, "<lastBuildDate>" .strftime($lang[dateadm]) ."</lastBuildDate>\n<webMaster>" .
          $RSS[siteadmin] ."</webMaster>\n</channel>\n</rss>\n");
}

// get file extension from filename
function fileExt($filename) {
   $retval="";
   $pt=strpos($filename, ".");
   if ($pt) 
      $retval=substr($filename, $pt+1, strlen($filename) - $pt);
   return ($retval);
}


// Takes one array, with the first array being the "id" or value
// and the array being the text you want displayed
// The second parameter is the name you want assigned to this form element
// The third parameter is optional. Pass the value of the item that should be checked

function array2select($vals,$select_name,$checked_val="xzxz") {
   $cont = '<SELECT NAME="'.$select_name.'">'."\n";
   while (list($opt_val,$opt_txt) = each($vals)) {
      $cont .= '<OPTION VALUE="'.$opt_val.'"';
      if ($opt_val == $checked_val) { $cont .= ' SELECTED'; }
      $cont .= '>'.$opt_txt.'</OPTION>'."\n";
   }
   return $cont.'</SELECT>'."\n";
}

// get all story data from file
// and put them in array
function getStory($fn,$wap="no") {
   $body='no';
   $lines=file($fn);
   for($i=0;$i<=count($lines);$i++) {
      $list=split("::",$lines[$i]);
      if ('Body' == $list[0]) { $body='yes'; }  // start processing of body
      elseif ('yes' == $body) {
         if ("yes" == $wap) {
            $story[Body]=$story[Body]."<br/>\n".chop($lines[$i]);
         } else {
            $story[Body]=$story[Body]."\n".chop($lines[$i]);
         }
      } else {
         $story[$list[0]]=chop($list[1]);
      }
   }
   $story[FSize]=filesize($fn);
   return $story;
}

// display search box
// custumizing by $sconfig global array
function searchBox() {
   global $sconfig, $lang;
   echo "
<FORM METHOD=\"$sconfig[method]\" ACTION=\"$sconfig[action]\">
<INPUT TYPE=\"text\" NAME=\"querybox\" SIZE=\"$sconfig[size]\" TABINDEX=\"1\">&nbsp;";
if ("yes" == $sconfig[button]) {
   echo "<INPUT TYPE=\"submit\" VALUE=\"$lang[srch_submit]\" TABINDEX=\"3\">\n";
}
echo "</FORM>\n";
}

// get names of all files in news dir
// for security checking
function getFileNames($newsdir) {
   global $config;
   $newsfile = array();
   $td = dir($newsdir); 
   while ($filename = $td->read()) {
       $s = strtolower($filename); 
       if (('.'.fileExt($s)) == $config[newssuff]) { 
          $newsfile[] = $filename;
       }
   }
   return $newsfile;
}

///////////////////////////////////////////////////////////////////
// main 


//handle administrator functions 

$files = getFileNames($newsdir);
$context = "";

?>
