<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | user.php                                                             |
// +----------------------------------------------------------------------+


/**
* User Class
*
* Does all the user related functions
* @author Tony Baird
* @version 2.0
* @access public
* @since 07-10-2004
*/
class User
{
/**
* User Constructor
*
* Figures out what user method we should be calling
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function User()
	{
		if ($_REQUEST['action']=="register")
		{
			$this->registerForm();
		}
		elseif (isset($_REQUEST['register']))
		{
			$this->register();
		}
		elseif ($_REQUEST['action']=="edit_profile")
		{
			$this->editProfileForm();
		}
		elseif (isset($_REQUEST['edit_profile']))
		{
			$this->editProfile();
		}
		elseif ($_REQUEST['action']=="logout")
		{
			$this->logOut();
			
		}
		else if ($_REQUEST['action']=="login")
		{
			$this->loginForm();
		}
		else if (isset($_REQUEST['login']))
		{
			$this->login();
			
		}
		else if ($_REQUEST['action']=="profile")
		{
			$this->displayProfile();
		}

	
	}
/**
* Register Form
*
* Creates the register account form
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function registerForm()
	{
		global $mysql,$tpl,$fn;
		$fn->header();
		$tpl->loadTemplate("register_form","templates/register_form.tpl");
		$register_form_array= Array(
			'errors'=>$this->errors,
			'username'=>$_POST['username'],
			'email'=>$_POST['email'],
			'icq'=>$_POST['icq'],
			'aim'=>$_POST['aim'],
			'msn'=>$_POST['msn'],
			'yahoo'=>$_POST['yahoo'],
		);
		$tpl->parseTemplate("register_form",$register_form_array,"No");
		$tpl->printTemplate("register_form");
		$fn->footer();
	}
/**
* Registers Accounts
*
* Registers accounts after checking any standard checks like duplicate accounts ect.
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function register()
	{
		global $mysql,$tpl,$fn;
		if (empty($_POST['username']))
		{
			$error="Username left empty required field<br>";
		}
		else
		{
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."users WHERE username='".$_POST['username']."'");
			$mysql->numRows();
			if ($mysql->num_rows >0)
			{
				$error .="The username ".$_POST['username']." Is already taken please choose another<br>";
			}
		}
		if (empty($_POST['password']))
		{
			$error .="A password is required to register<br>";
		}
		if ($_POST['password'] != $_POST['confirm_password'])
		{
			$error .="Passwords do not match<br>";
		}
		if (empty($_POST['email']))
		{
			$error .="Email is empty and it's required<br>";
		}
		// Checking For a valid email
		if (!preg_match("/[a-zA-Z0-9]*@[a-zA-Z0-9]*.[a-zA-Z0-9]*/",$_POST['email'])) {
			$error .="Your email is invalid<br>";
		}
		if (!empty($error))
		{
			// We're going back to the normal registration page
			$this->errors="There was the following problems with your registration:<br> $error";
			$this->registerForm();
		}
		else
		{
			
			$_POST=$fn->htmlArray($_POST);
			$insert_array = array(
				'username'          => $_POST['username'],
				'password'=> md5($_POST['password']),
				'email'=>	$_POST['email'],
				'icq'	=> $_POST['icq'],
				'msn'   => $_POST['msn'],
				'aim' => $_POST['aim'],
				'yahoo'=> $_POST['yahoo'],
				'last_ip' =>$_SERVER['REMOTE_ADDR'],
				'active'=>1,
				'user_level'=>"@1@2@3@4",
			);
			$mysql->makeInsertString($insert_array);
			$mysql->query("INSERT INTO ".$fn->CONFIG['db_prefix']."users ($mysql->insert_fields) VALUES 	($mysql->insert_values)");
			$fn->redirectionSuccess("news.php",5,"Thank You For Registering ");
			$fn->footer();
		}
	}
/**
* Log Out
*
* Logs a user out of an account
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function logOut()
	{
		global $mysql,$tpl,$fn;
		if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
		{
			// Expiring the Cookies
			setcookie("fn_username","",-1);
			setcookie("fn_password","",-1);
			$fn->header();
			$fn->redirectionSuccess("news.php",5,"You have successfully been logged out you will be redirected to the news page");
		}
		else
		{
			$fn->header();
			$fn->error("You can't logout when you're not logged in");
		}
		$fn->footer();

	}
/**
* Edit Profile Form
*
* Grabs all the users info then displays it in a form to modify
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function editProfileForm()
	{
		global $mysql,$tpl,$fn;
		$fn->header();
		if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
		{
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."users WHERE username='".$_COOKIE['fn_username']."' AND password='".$_COOKIE['fn_password']."'");
			$show_user=mysql_fetch_array($mysql->result_id);
			if (isset($show_user[user_id]))
			{
				$tpl->loadTemplate("edit_profile_form","templates/edit_profile_form.tpl");
				
				$edit_profile_form_array= Array(
					'email'=>$show_user[email],
					'icq'=>$show_user[icq],
					'aim'=>$show_user[aim],
					'msn'=>$show_user[msn],
					'yahoo'=>$show_user[yahoo],
				);
				$tpl->parseTemplate("edit_profile_form",$edit_profile_form_array,"No");
				$tpl->printTemplate("edit_profile_form");
			}
			else
			{
				$fn->error("Your cookie does not match your login details");
			}
		}
		else
		{
			$fn->error("You need to be logged in to modify a profile");
		}
		$fn->footer();
	}
/**
* Edit Profile
*
* Edits a users account
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function editProfile()
	{
		global $mysql,$tpl,$fn;
		if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
		{
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."users WHERE username='".$_COOKIE['fn_username']."' AND password='".$_COOKIE['fn_password']."'");
			$show_user=mysql_fetch_array($mysql->result_id);
			if (isset($show_user[user_id]))
			{
				// Time to actually update the profile

				// First we'll check if they want a new password
				if (!empty($_POST['new_password']))
				{
					if ($_POST['new_password']==$_POST['confirm_new_password'])
					{
						$password=md5($_POST['new_password']);
						// Set new cookie
						setcookie("fn_password",$password,$fn->time+$fn->CONFIG['cookie_time']);
					}
					else
					{
						$fn->error("Passwords do not match please check that");
					}
				}
				else
				{
					$password=$show_user[password];
				}
				if (empty($_POST['email']))
				{
					$fn->error("You must put in an email address");
				}
				$_POST=htmlArray($_POST);
				$update_array= Array(
					'password'			=>$password,
					'email'   => $_POST['email'],
					'aim' => $_POST['aim'],
					'msn' => $_POST['msn'],
					'icq' => $_POST['icq'],
					'yahoo' => $_POST['yahoo'],
				);
				$mysql->makeUpdateString($update_array);
				$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."users SET $mysql->update_string WHERE user_id=".$show_user[user_id]."");
				$fn->redirectionSuccess("news.php",5,"You have successfully updated your profile you will be redirected to the main news page in 5 seconds");
				$fn->footer();
			}
			else
			{
				$fn->header();
				$fn->error("Your cookie does not match your login details");
			}
		}
		else
		{
			$fn->header();
			$fn->error("You need to be logged in to modify a profile");
		}
	}
/**
* Login Form
*
* Login form for users to log into their accounts
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function loginForm()
	{
		global $mysql,$tpl,$fn;
		if (!isset($_COOKIE['fn_username']) || !isset($_COOKIE['fn_password']))
		{
			$this->showLoginForm();
		}
		else
		{
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."users WHERE username='".$_COOKIE['fn_username']."' AND password='".$_COOKIE['fn_password']."'");
			$show_user=mysql_fetch_array($mysql->result_id);
			if (isset($show_user[user_id]))
			{
				$fn->Error("You're already logged in as ".$_COOKIE['fn_username']."");	
			}
			else
			{
				$this->showLoginForm();
			}
			
		}
	}
/**
* Displays Login Form
*
* Displays the login for users to login to their accounts
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function showLoginForm()
	{
		global $mysql,$tpl,$fn;
		$fn->header();
		$tpl->loadTemplate("login_form","templates/login_form.tpl");
		$newstip_form_array= Array(
			'news_id'=>$category_list,
		);
		$tpl->parseTemplate("login_form",$login_form_array,"No");
		$tpl->printTemplate("login_form");
		$fn->footer();
		
	}
/**
* Login
*
* Logs users into their account after making sure they have the login information correct
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function login()
	{
		global $mysql,$tpl,$fn;
		if (!isset($_COOKIE['fn_username']) || !isset($_COOKIE['fn_password']))
		{
			$this->logUserIn();
		}
		else
		{
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."users WHERE username='".$_COOKIE['fn_username']."' AND password='".$_COOKIE['fn_password']."'");
			$show_user=mysql_fetch_array($mysql->result_id);
			if (isset($show_user[user_id]))
			{
				$fn->header();
				$fn->Error("You're already logged in as ".$_COOKIE['fn_username']."");	
				$fn->footer();
			}
			else
			{
				$this->logUserIn();
			}
			
		}
	}
/**
* Logs User in
*
* Actually logs the user into the account
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function logUserIn()
	{
		global $mysql,$tpl,$fn;
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."users WHERE username='".$_POST['username']."' AND password='".md5($_POST['password'])."'");
		$show_user=mysql_fetch_array($mysql->result_id);
		if (isset($show_user[user_id]) && $show_user['username']==$_POST['username'] && $show_user['password']==md5($_POST['password']))
		{
			// Set the magical user cookie isn't it useful?
			setcookie("fn_username",$_POST['username'],$fn->time+$fn->CONFIG['user_cookie_time']);
			setcookie("fn_password",md5($_POST['password']),$fn->time+$fn->CONFIG['user_cookie_time']);
			$fn->header();
			$fn->redirectionSuccess("news.php",5,"You have successfully logged in you'll be redirected to the main page in 5 seconds");
			
			$fn->footer();
		}
		else
		{
			$fn->header();
			$fn->error("The User Information you have given is incorrect please double check it");
			$fn->footer();
		}
		
	}
/**
* Display Profile
*
* Displays the users profile
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function displayProfile()
	{
		global $mysql,$tpl,$fn;
		$fn->header();
		if (!empty($_REQUEST['id']))
		{
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."users WHERE user_id=".$_REQUEST['id']."");
			$show_user=mysql_fetch_array($mysql->result_id);
			$tpl->loadTemplate("profile","templates/profile.tpl");
			$profile_array= Array(
				'username'=>$show_user[username],
				'aim'=>$show_user[aim],
				'msn'=>$show_user[msn],
				'icq'=>$show_user[icq],
				'yahoo'=>$show_user[yahoo],
				'num_comments'=>$show_user[num_comments],
				'num_newstips'=>$show_user[num_newstips],
				'num_ratings'=>$show_user[num_ratings],
				'num_news_posts'=>$show_user[num_news_posts],
			);
			$tpl->parseTemplate("profile",$profile_array,"No");
			$tpl->printTemplate("profile");
			
			
			
		}
		else
		{
			$fn->error("You did not specifify a user id #");
		}
		$fn->footer();
		
	}
}
?>