<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright is    |
// | intact and this is left at the top of every source file              |
// +----------------------------------------------------------------------+
// | index.php                                                            |
// +----------------------------------------------------------------------+
require_once("../config.php");
require_once("../functions/functions.php");
require_once("../functions/mysql.php");
require_once("../functions/template.php");
if (empty($tpl))
{
	$tpl=new Templates;
	$fn=new FNews;
}
$fn->startTimer();
$upgrade=new upgrade;
/**
* Upgrade Class
*
* Does the upgrade from 1.1.6 to 2.0.0
* @author Tony Baird
* @version 2.0
* @access public
* @since 08-11-2004
*/
class Upgrade
{
/**
* upgrade Constructor
*
* Figures out what upgrade methods we're calling
*/
	function Upgrade()
	{
		global $fn;
		$this->header();
		if ($_REQUEST['step']=="1")
		{
			$this->setupConfigForm();	
		}
		else if (isset($_REQUEST['setup_config']))
		{
			$this->setupConfig();
		}
		else if ($_REQUEST['step']=="2")
		{
			$this->setupMysql();
		}
		else if ($_REQUEST['step']=="3")
		{
			$this->setupAccount();
		}
		else if (isset($_REQUEST['setup_account']))
		{
			$this->finishedUpgrade();
			
		}
		else
		{
			$this->startUpgrade();
		}
		$this->footer();
	}
/**
* Start upgrade Page
*
* Tells the user what all is required and what not
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function startupgrade()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("start_upgrade","templates/start_upgrade.tpl");
		$tpl->parseTemplate("start_upgrade",$start_upgrade_array,"No");
		$tpl->printTemplate("start_upgrade");
		// Displays the comments and the comment posting option
	}
/**
* Header
*
* Displays the header that is on the upgradeer pages
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function header()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("header","templates/header.tpl");
		$tpl->parseTemplate("header",$header_array,"No");
		$tpl->printTemplate("header");
		
	}
/**
* Footer
*
* Displays the footer that is on the upgradeer pages
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function footer()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("footer","templates/footer.tpl");
		$fn->stopTimer();
		$footer_array= Array(
			'num_queries'=>$mysql->query_count,
			'generation_time'=>$fn->total_time,
			'version'=>$fn->version,
		);
		$tpl->parseTemplate("footer",$footer_array,"No");
		$tpl->printTemplate("footer");
		
	}
/**
* Setup Config Form
*
* Opens up a form for the user to modify their configuration file to match their settings
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function setupConfigForm()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("setup_config_form","templates/setup_config_form.tpl");
		if ($fn->CONFIG['smilies']==1)
		{
			$smilies="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$smilies="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['gzip']==1)
		{
			$gzip="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$gzip="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['newstips']==1)
		{
			$newstips="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$newstips="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['include_news_php']==1)
		{
			$include_news_php="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$include_news_php="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['one_comments_page']==1)
		{
			$one_comments_page="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$one_comments_page="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['guest_comments']==1)
		{
			$guest_comments="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$guest_comments="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['guest_news_ratings']==1)
		{
			$guest_news_ratings="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$guest_news_ratings="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['search_news']==1)
		{
			$search_news="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$search_news="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['send_to_friend']==1)
		{
			$send_to_friend="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$send_to_friend="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['html_editor']==1)
		{
			$html_editor="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$html_editor="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		//$fn->stripArray($fn->CONFIG);
		$setup_config_form_array= Array(
			'mysql_username'=>$fn->CONFIG['mysql_username'],
			'mysql_password'=>$fn->CONFIG['mysql_password'],
			'mysql_db'=>$fn->CONFIG['mysql_db'],
			'db_prefix'=>$fn->CONFIG['db_prefix'],
			'news_per_page'=>$fn->CONFIG['news_per_page'],
			'num_headlines'=>$fn->CONFIG['num_headlines'],
			'news_order_by'=>$fn->CONFIG['news_order_by'],
			'smilies'=>$smilies,
			'date_format'=>$fn->CONFIG['date_format'],
			'uploads_path'=>$fn->CONFIG['uploads_path'],
			'uploads_url'=>$fn->CONFIG['uploads_url'],
			'time_offset'=>$fn->CONFIG['time_offset'],
			'gzip'=>$gzip,
			'gzip_level'=>$fn->CONFIG['gzip_level'],
			'newstips'=>$newstips,
			'include_news_php'=>$include_news_php,
			'one_comments_page'=>$one_comments_page,
			'comments_per_page'=>$fn->CONFIG['comments_per_page'],
			'guest_comments'=>$guest_comments,
			'guest_user_id'=>$fn->CONFIG['guest_user_id'],
			'user_cookie_time'=>$fn->CONFIG['user_cookie_time'],
			'flood_time'=>$fn->CONFIG['flood_time'],
			'guest_news_ratings'=>$guest_news_ratings,
			'smiley_path'=>$fn->CONFIG['smiley_path'],
			'smiley_url'=>$fn->CONFIG['smiley_url'],
			'search_news'=>$search_news,
			'send_to_friend'=>$send_to_friend,
			'send_to_friend_flood_time'=>$fn->CONFIG['send_to_friend_flood_time'],
			'site_url'=>$fn->CONFIG['site_url'],
			'html_editor'=>$html_editor,
		);
		$tpl->parseTemplate("setup_config_form",$setup_config_form_array,"No");
		$tpl->printTemplate("setup_config_form");	
	}
/**
* Setup Config
*
* Sets up the config file and then gives the user the option to move on to step 2
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function setupConfig()
	{
		global $tpl,$fn,$mysql;
		$fn->slashArray($_POST);
		$new_settings .="<?php\n";
		$new_settings .='$CONFIG[\'mysql_username\']="'.$_POST['mysql_username']."\";\n";
		$new_settings .='$CONFIG[\'mysql_password\']="'.$_POST['mysql_password']."\";\n";
		$new_settings .='$CONFIG[\'mysql_db\']="'.$_POST['mysql_db']."\";\n";
		$new_settings .='$CONFIG[\'db_prefix\']="'.$_POST['db_prefix']."\";\n";
		$new_settings .='$CONFIG[\'news_per_page\']="'.$_POST['news_per_page']."\";\n";
		$new_settings .='$CONFIG[\'num_headlines\']="'.$_POST['num_headlines']."\";\n";
		$new_settings .='$CONFIG[\'news_order_by\']="'.$_POST['news_order_by']."\";\n";
		$new_settings .='$CONFIG[\'smilies\']="'.$_POST['smilies']."\";\n";
		$new_settings .='$CONFIG[\'date_format\']="'.$_POST['date_format']."\";\n";
		$new_settings .='$CONFIG[\'uploads_path\']="'.$_POST['uploads_path']."\";\n";
		$new_settings .='$CONFIG[\'uploads_url\']="'.$_POST['uploads_url']."\";\n";
		$new_settings .='$CONFIG[\'time_offset\']="'.$_POST['time_offset']."\";\n";
		$new_settings .='$CONFIG[\'gzip\']="'.$_POST['gzip']."\";\n";
		$new_settings .='$CONFIG[\'gzip_level\']="'.$_POST['gzip_level']."\";\n";
		$new_settings .='$CONFIG[\'newstips\']="'.$_POST['newstips']."\";\n";
		$new_settings .='$CONFIG[\'include_news_php\']="'.$_POST['include_news_php']."\";\n";
		$new_settings .='$CONFIG[\'one_comments_page\']="'.$_POST['one_comments_page']."\";\n";
		$new_settings .='$CONFIG[\'comments_per_page\']="'.$_POST['comments_per_page']."\";\n";
		$new_settings .='$CONFIG[\'guest_comments\']="'.$_POST['guest_comments']."\";\n";
		$new_settings .='$CONFIG[\'guest_user_id\']="'.$_POST['guest_user_id']."\";\n";
		$new_settings .='$CONFIG[\'user_cookie_time\']="'.$_POST['user_cookie_time']."\";\n";
		$new_settings .='$CONFIG[\'flood_time\']="'.$_POST['flood_time']."\";\n";
		$new_settings .='$CONFIG[\'guest_news_ratings\']="'.$_POST['guest_news_ratings']."\";\n";
		$new_settings .='$CONFIG[\'smiley_path\']="'.$_POST['smiley_path']."\";\n";
		$new_settings .='$CONFIG[\'smiley_url\']="'.$_POST['smiley_url']."\";\n";
		$new_settings .='$CONFIG[\'search_news\']="'.$_POST['search_news']."\";\n";
		$new_settings .='$CONFIG[\'send_to_friend\']="'.$_POST['send_to_friend']."\";\n";
		$new_settings .='$CONFIG[\'send_to_friend_flood_time\']="'.$_POST['send_to_friend_flood_time']."\";\n";
		$new_settings .='$CONFIG[\'site_url\']="'.$_POST['site_url']."\";\n";
		$new_settings .='$CONFIG[\'html_editor\']="'.$_POST['html_editor']."\";\n";
		
		$new_settings .="?>";
		if ($config_file=fopen("../config.php","w+")) 
		{
			if (!fwrite($config_file,$new_settings)) 
			{
				echo "Unable To Write to configuration file please make sure the script has permission to write to the configuration file";
				exit();
			}
		} 
		else 
		{
			echo "Unable to Open Configuration File you need to make sure the script has permission to open it";
			exit();
		}
		$tpl->loadTemplate("setup_config_finished","templates/setup_config_finished.tpl");
		$tpl->parseTemplate("setup_config_finished",$setup_config_finished_array,"No");
		$tpl->printTemplate("setup_config_finished");	
	}
/**
* Sets up Mysql
*
* Sets the Mysql up then gives the user the option to go to step 3
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function setupMysql()
	{
		global $mysql,$fn,$tpl;
		$mysql=new Mysql;
		$mysql->connect();
		/* 
			All this MySQL stuff is extremly messy I didn't want to spend days figuring
			out what all I changed I had kept a text file but it was quite confusing
			so here are all the queries in the order I did them.  It could be more
			organized but oh well upgrade is usually a lot of queries so why not this 
			upgrade to!
		*/
		echo "Now attempting to upgrade MySQL<br>";
		$mysql->query("DROP TABLE fn_comments_users");
		$mysql->query("DROP TABLE fn_admins");
		$mysql->query("DROP TABLE fn_comments");
		$mysql->query("DROP TABLE fn_banned_ips");
		
		echo "Upgrade Successful so far...<br>";
		$mysql->query("CREATE TABLE fnewser_banned_ips (
					  ban_id int(11) NOT NULL auto_increment,
					  ip varchar(255) NOT NULL default '',
					  reason varchar(255) NOT NULL default '',
					  PRIMARY KEY  (ban_id)
					) TYPE=MyISAM");
		$mysql->query("CREATE TABLE `fn_comments` (
					  `comment_id` int(11) NOT NULL auto_increment,
					  `news_comment_id` int(11) NOT NULL default '0',
					  `news_id` int(11) NOT NULL default '0',
					  `user_id` int(11) NOT NULL default '0',
					  `comments_username` varchar(255) NOT NULL default '',
					  `title` varchar(250) NOT NULL default '',
					  `comments` mediumtext NOT NULL,
					  `date` int(11) NOT NULL default '0',
					  `last_modified` int(11) NOT NULL default '0',
					  `ip` varchar(255) NOT NULL default '',
					  `deleted` smallint(6) NOT NULL default '0',
					  PRIMARY KEY  (`comment_id`)
					) TYPE=MyISAM");
		echo "Comments Table Created<br>";
		
		$mysql->query("CREATE TABLE `fn_users` (
					  `user_id` int(11) NOT NULL auto_increment,
					  `username` varchar(255) NOT NULL default '',
					  `password` varchar(255) NOT NULL default '',
					  `user_level` varchar(255) NOT NULL default '',
					  `email` varchar(255) NOT NULL default '',
					  `icq` int(11) NOT NULL default '0',
					  `msn` varchar(255) NOT NULL default '',
					  `aim` varchar(255) NOT NULL default '',
					  `yahoo` varchar(255) NOT NULL default '',
					  `num_comments` int(11) NOT NULL default '0',
					  `num_ratings` int(11) NOT NULL default '0',
					  `num_news_posts` int(11) NOT NULL default '0',
					  `num_newstips` int(11) NOT NULL default '0',
					  `active` tinyint(4) NOT NULL default '0',
					  `last_ip` varchar(255) NOT NULL default '',
					  PRIMARY KEY  (`user_id`)
					) TYPE=MyISAM");
		echo "Creating Users Table<br>";
		
		$mysql->query("ALTER TABLE `fn_news` ADD `avg_rating` DOUBLE NOT NULL AFTER `date` ,
					ADD `num_ratings` INT NOT NULL AFTER `avg_rating` ,
					ADD `total_ratings` INT NOT NULL AFTER `num_ratings`");
		$mysql->query("ALTER TABLE `fn_news` ADD `read_more_news` MEDIUMTEXT NOT NULL AFTER `news` ");
		$mysql->query("ALTER TABLE `fn_news` CHANGE `admin_id` `user_id` INT( 11 ) DEFAULT '0' NOT NULL");
		echo "Modified News Table<br>";
		
		
		$mysql->query("CREATE TABLE `fn_news_ratings` (
					  `ip` varchar(255) NOT NULL default '',
					  `news_id` int(11) NOT NULL default '0',
					  `user_id` int(11) NOT NULL default '0',
					  `date` int(11) NOT NULL default '0',
					  `rating` int(11) NOT NULL default '0'
					) TYPE=MyISAM");
		echo "News Ratings Table Created<br>";
		$mysql->query("ALTER TABLE `fn_smilies` ADD `uploaded_file` TINYINT NOT NULL ,ADD `filename` VARCHAR( 255 ) NOT NULL ");
		$mysql->query("ALTER TABLE `fn_newstips` DROP `name` ");
		$mysql->query("ALTER TABLE `fn_newstips` DROP `email` ");
		$mysql->query("ALTER TABLE `fn_newstips` ADD `user_id` INT NOT NULL AFTER `newstip_id` ");
		$mysql->query("ALTER TABLE `fn_newstips` ADD `source` VARCHAR( 255 ) NOT NULL AFTER `newstip` ");
		$mysql->query("ALTER TABLE `fn_newstips` DROP `category_id`");
		$mysql->query("ALTER TABLE `fn_news` ADD `sticky` SMALLINT NOT NULL ");
		$mysql->query("ALTER TABLE `fn_newstips` ADD `active` TINYINT NOT NULL ");
		$mysql->query("UPDATE fn_news SET num_comments=0");
		$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."news SET user_id=1");
		echo "Nodifying Last Tables<br>";
		echo "<a href=\"index.php?step=3\">Proceed to Step 3</a>";
	}
/**
* Setup Account Form
*
* Sets up the main admin account
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function setupAccount()
	{
		global $tpl,$fn,$mysql;
		$tpl->loadTemplate("setup_account","templates/setup_account.tpl");
		$tpl->parseTemplate("setup_account",$setup_account_array,"No");
		$tpl->printTemplate("setup_account");	
	}
/**
* Tells the User they have finished the upgrade
*
* Creates the user account, guest account and tells the user anything they need to know
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function finishedupgrade()
	{
		global $tpl,$fn,$mysql;
		$mysql=new Mysql;
		$mysql->connect();
		$mysql->query("INSERT INTO `fn_users` VALUES (1, '".$_POST['username']."', '".md5($_POST['password'])."', '@1@2@3@4@5@6@7@8@9@10@11@12@13@14@15@16@17@', 'admin@test.com', 0, '', '', '', 13, 5, 5, 7, 1, '')");
		$mysql->query("INSERT INTO `fn_users` VALUES (2, 'Guest', 'DOIJSOIJXMXK', '@1', 'guest@guest.com', 0, '', '', '', 1, 0, 0, 0, 1, '')");
		$tpl->loadTemplate("finished_upgrade","templates/finished_upgrade.tpl");
		$tpl->parseTemplate("finished_upgrade",$finished_upgrade_array,"No");
		$tpl->printTemplate("finished_upgrade");	
		
	}
}
?>