<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | search.php                                                           |
// +----------------------------------------------------------------------+

/**
* Search Class
*
* Does all the search related functions
* @author Tony Baird
* @version 2.0
* @access public
* @since 07-10-2004
*/
class Search
{
/**
* Search Constructor
*
* Figures out what search method we're using
*/
	function Search()
	{
		if ($_REQUEST['action']=="search")
		{
			$this->searchForm();
		}
		elseif (isset($_REQUEST['search']))
		{
			$this->searchResults();
		}

	
	}
/**
* Search Form
*
* Displays the Search form
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function searchForm()
	{
		global $mysql,$tpl,$fn;
		$fn->header();
		if ($fn->CONFIG['search_news']==1)
		{
			// First we'll grab the category list
			$mysql->query("SELECT category_id,category FROM ".$fn->CONFIG['db_prefix']."categories");
			while ($show_category=mysql_fetch_array($mysql->result_id))
			{
				$category_list .="<option value=\"$show_category[category_id]\">$show_category[category]</option>";
			}
			
			$mysql->query("SELECT user_id,username FROM ".$fn->CONFIG['db_prefix']."users WHERE num_news_posts>0");
			while ($show_user=mysql_fetch_array($mysql->result_id))
			{
				$user_list .="<option value=\"$show_user[user_id]\">$show_user[username]</option>";
			}
			$tpl->loadTemplate("search_form","templates/search_form.tpl");
			$search_form_array= Array(
				'category_list'=>$category_list,
				'user_list'=>$user_list,
			);
			$tpl->parseTemplate("search_form",$search_form_array,"No");
			$tpl->printTemplate("search_form");
		}
		else
		{
			$fn->error("The search function is currently disabled");
		}
		$fn->footer();
	}
/**
* Search Results
*
* Just calls some other methods to generate the search results page
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function searchResults()
	{
		global $mysql,$tpl,$fn;	
		$fn->header();
		$this->displaySearchResults($this->createSearchQuery());
		$fn->footer();
	}
/**
* Creates The Search Query
*
* Creates the search query based on what the user has filled out
* @global object $fn instance of the Fantastic News function class
*/
	function createSearchQuery()
	{
		global $fn;
		$sql="SELECT news.*,users.*, categories.* FROM ".$fn->CONFIG['db_prefix']."news news,".$fn->CONFIG['db_prefix']."users users,".$fn->CONFIG['db_prefix']."categories categories WHERE";
		if (!empty($_POST['subject']))
		{
			if ($_POST['subject_exact']==1)
			{
				$search .=" news.subject='".$_POST['subject']."'";
			}
			else
			{
				$search .=" news.subject LIKE '%".$_POST['subject']."%'";	
			}
		}
		if (!empty($_POST['news']))
		{
			if (!empty($search))
			{
				$search .=" AND";
			}
			$search .=" news.news LIKE '%".$_POST['news']."%'";
		}
		if ($_POST['category'] !=0)
		{
			if (!empty($search))
			{
				$search .=" AND";
			}
			$search .=" news.category_id=".$_POST['category']."";
		}
		if ($_POST['user'] !=0)
		{
			if (!empty($search))
			{
				$search .=" AND";
			}
			$search .=" news.user_id=".$_POST['user']."";
		}
		if (empty($search))
		{
			$sql="1";
		}
		else
		{
			$sql=$sql.$search;
			$sql .=" AND news.user_id=users.user_id AND news.category_id=categories.category_id ORDER BY date DESC";
		}
		return $sql;
	}
/**
* Display Search Results
*
* Creates the search results part of the page
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/	
	function displaySearchResults($sql)
	{
		global $fn,$mysql,$tpl;
		if ($sql=="1")
		{
			$fn->error("You need to specifiy a search field");
		}
		else
		{
			$tpl->loadTemplate("news","templates/news.tpl");
			$mysql->query($sql);
			while ($show_news=mysql_fetch_array($mysql->result_id))
			{
				$read_more_link="";
				$fn->stripArray($show_news);
	
				// Decides if we need a read more news link and if so does the template and such
				if (!empty($show_news[read_more_news]))
				{
					$tpl->loadTemplate("news_read_more_link","templates/news_read_more_link.tpl");
					$news_read_more_link_array= Array(
						'news_id'=>$show_news[news_id],
						'size'=>strlen($show_news[read_more_news]),
					);
					$tpl->parseTemplate("news_read_more_link",$news_read_more_link_array,"Yes");
					$read_more_link=$tpl->saveTemplate("news_read_more_link");
				}
				if ($show_news[upload_file]=="Yes")
				{
					$this->showAttachment($show_news);
				}
				$date=date($fn->CONFIG['date_format'],$show_news[date]+$fn->CONFIG['time_offset']);
				$news_array= Array(
					'subject'=>$show_news[subject],
					'content'=>$show_news[news],
					'category'=>$show_news[category],
					'category_image'=>$show_news[category_image],
					'name'=>$show_news[username],
					'email'=>$show_news[email],
					'user_id'=>$show_news[user_id],
					'attachment'=>$this->attachment,
					'num_comments'=>$show_news[num_comments],
					'news_id'=>$show_news[news_id],
					'date'=>$date,
					'read_more_link'=>$read_more_link,
					'average_rating'=>$show_news[avg_rating],
					'num_ratings'=>$show_news[num_ratings],
				);
				$has_news=1;
				$tpl->parseTemplate("news",$news_array,"Yes");
				$this->attachment="";
			}
			if ($has_news==1)
			{
				$tpl->printTemplate("news");	
			}		
		}
	}
/**
* Displays news item attachments
*
* Displays the news item attachments
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function showAttachment($show_news)
	{
		global $tpl;
		$this->attachment="";
		$tpl->loadTemplate("attachment","templates/attachment.tpl");
		$attachment_array = array(
			'filesize'            => $show_news[filesize],
			'downloads'=>$show_news[downloads],
			'filename'=>$show_news[filename],
			'news_id'=>$show_news[news_id],
		);
		$tpl->parseTemplate("attachment",$attachment_array,"No");
		$this->attachment=$tpl->saveTemplate("attachment");
	}
}
?>