<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on php file                                      |
// +----------------------------------------------------------------------+
// | news.php                                                             |
// +----------------------------------------------------------------------+
//ini_set("register_globals", 0);
unset($CONFIG);
require_once("config.php");
require_once($CONFIG['script_path']."functions/functions.php");
require_once($CONFIG['script_path']."functions/mysql.php");
require_once($CONFIG['script_path']."functions/template.php");
if (empty($tpl))
{
	$tpl=new Templates;
	$mysql=new Mysql;
	$mysql->connect();
	$fn=new FNews;
}
if (file_exists("install") || file_exists("upgrade"))
{
	echo "You need to delete the install and upgrade directories before you can use Fantastic News";
	exit();
}
	$fn->startTimer();
	$news=new News;
/**
* News Class
*
* Does all the news related things for the script
* @author Tony Baird
* @version 2.0
* @access public
* @since 07-10-2004
*/
class News
{
/**
* News Constructor
*
* Figures out what we're doing in the news page
*/
	function News()
	{
		global $CONFIG;
		$this->startGzipCompression();
		
		// Checking if ip banning is enabled then checking the users ip
		$this->checkIpBan($_SERVER['REMOTE_ADDR']);
		if ($_REQUEST['action']=="rate_news")
		{
			$this->rateNewsForm();
		}
		else if ($_REQUEST['action']=="attachment")
		{
			$this->downloadAttachment();
		}
		elseif (isset($_POST['postcomments']) || $_REQUEST['action']=="edit_comments" || isset($_REQUEST['edit_comments']) || $_REQUEST['action']=="delete_comments" || $_REQUEST['action']=="delete_comments_confirm" || $_REQUEST['action']=="undelete_comments" || $_REQUEST['action']=="undelete_comments_confirm")
		{
			// We're going to the comments class so that we can post the comments
			require_once("comments.php");
			$comments=new Comments;
		}
		elseif ($_REQUEST['action']=="sendtofriend" || isset($_REQUEST['sendtofriend']))
		{
			require_once($CONFIG['script_path']."sendtofriend.php");
			$sendtofriend=new SendToFriend;
		}
		else if ($_REQUEST['action']=="newstip" || isset($_REQUEST['newstip']))
		{
			require_once($CONFIG['script_path']."newstip.php");
			$newstip=new Newstip;
		}
		elseif ((isset($_REQUEST['id']) && is_numeric($_REQUEST['id']) && $_REQUEST['action']!="profile") && !empty($_REQUEST['id']))
		{
			$this->displayOneNews();
		}
		elseif ($_REQUEST['action']=="register" || isset($_REQUEST['register']) || $_REQUEST['action']=="profile" || $_REQUEST['action']=="edit_profile" || $_REQUEST['action']=="logout" || isset($_REQUEST['edit_profile']) || $_REQUEST['action']=="login" || isset($_REQUEST['login']))
		{
			require_once($CONFIG['script_path']."user.php");
			$user=new User;
		}
		elseif (isset($_POST['rate_news']))
		{
			$this->rateNews();
		}
		elseif ($_REQUEST['action']=="search" || isset($_REQUEST['search']))
		{
			require_once($CONFIG['script_path']."search.php");
			$search=new Search();			
		}
		else
		{
			$this->displayCategories("news");
			$this->displayNews();
			$this->pageList();
		}
		$this->printGzipCompression();
	}
/**
* Displays one news item
*
* Displays one news item as well as the comments stuff
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function displayOneNews()
	{
		global $mysql,$tpl,$fn;
		$fn->header();
		$tpl->loadTemplate("full_news","templates/full_news.tpl");

		$mysql->query("SELECT ".$fn->CONFIG['db_prefix']."news.*, ".$fn->CONFIG['db_prefix']."categories.*, ".$fn->CONFIG['db_prefix']."users.user_id,username FROM ".$fn->CONFIG['db_prefix']."news, ".$fn->CONFIG['db_prefix']."categories, ".$fn->CONFIG['db_prefix']."users WHERE ".$fn->CONFIG['db_prefix']."news.user_id=".$fn->CONFIG['db_prefix']."users.user_id AND ".$fn->CONFIG['db_prefix']."categories.category_id=".$fn->CONFIG['db_prefix']."news.category_id AND news_id=".$_REQUEST['id']."");
		$show_news=mysql_fetch_array($mysql->result_id);
		$fn->stripArray($show_news);
		$date=date($fn->CONFIG['date_format'],$show_news[date]+$fn->CONFIG['time_offset']);
		if ($show_news[upload_file]=="Yes")
		{
			$this->showAttachment($show_news);
		}
		if (empty($show_news[read_more_news]))
		{
			$show_news[read_more_news]=$show_news[news];
		}
		if (!empty($show_news[category_image]))
		{
			$category_image="<img src=\"$show_news[category_image]\">";
		}
		else
		{
			$category_image="";
		}
		$full_news_array= Array(
			'subject'=>$show_news[subject],
			'content'=>$show_news[news],
			'category'=>$show_news[category],
			'category_image'=>$category_image,
			'name'=>$show_news[username],
			'email'=>$show_news[email],
			'user_id'=>$show_news[user_id],
			'attachment'=>$this->attachment,
			'num_comments'=>$show_news[num_comments],				
			'news_id'=>$show_news[news_id],
			'date'=>$date,
			'read_more_link'=>$read_more_link,
			'average_rating'=>$show_news[avg_rating],
			'num_ratings'=>$show_news[num_ratings],
			'full_content'=>$show_news[read_more_news],
		);
		$tpl->parseTemplate("full_news",$full_news_array,"Yes");
		$tpl->printTemplate("full_news");

		// Displays the comments and the comment posting option
		require_once("comments.php");
		$comments=new Comments;
		if (empty($_REQUEST['page']) || !is_numeric($_REQUEST['page']))
		{
			$_REQUEST['page']=1;
		}
		$comments->displayComments($_REQUEST['id'],$fn->CONFIG['one_comments_page'],$_REQUEST['page']);
		$fn->footer();
	}
/**
* Displays News
*
* Displays the news and can page split it if needed
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function displayNews()
	{
		global $mysql,$tpl,$fn;

		/*
			These figure out what some things like if there is an order by option on
			and page and if we're only viewing one category
		*/
		if (empty($_REQUEST['page']) || !is_numeric($_REQUEST['page'])) 
		{
			$_REQUEST['page']=1;
		}
		if (empty($_REQUEST['order_by']))
		{
			$order_by=$fn->CONFIG['news_order_by']." DESC";
		}
		if (!empty($_REQUEST['category']) && is_numeric($_REQUEST['category'])) 
		{
			$where="WHERE category_id=".$_REQUEST['category']."";
		}
		// Divides news up so we got page stuff
		$fn->divideData("SELECT COUNT(*) AS count FROM ".$fn->CONFIG['db_prefix']."news $where" ,$_REQUEST['page'],$fn->CONFIG['news_per_page']);

		$tpl->loadTemplate("news","templates/news.tpl");
		

		// Now we make a better where statement
		if (!empty($_REQUEST['category']) && is_numeric($_REQUEST['category'])) 
		{
			$where="AND c.category_id=".$_REQUEST['category']."";
		}
		
		
		
		
		$tpl->loadTemplate("sticky_news","templates/news.tpl");
		
		// Display the Sticky News
		$mysql->Query("SELECT n.*, c.*, u.user_id,u.username FROM 
		".$fn->CONFIG['db_prefix']."news n,  
		".$fn->CONFIG['db_prefix']."users u LEFT JOIN 
		".$fn->CONFIG['db_prefix']."categories c
		ON c.category_id=n.category_id WHERE 
		n.user_id=u.user_id AND n.sticky=1 $where  
		ORDER BY $order_by");
		while ($show_news=mysql_fetch_array($mysql->result_id))
		{
			$read_more_link="";
			$fn->stripArray($show_news);
			if (empty($show_news[category_id]))
			{
				$show_news[category]="All";
			}
			// Decides if we need a read more news link and if so does the template and such
			if (!empty($show_news[read_more_news]))
			{
				$tpl->loadTemplate("news_read_more_link","templates/news_read_more_link.tpl");
				$news_read_more_link_array= Array(
					'news_id'=>$show_news[news_id],
					'size'=>strlen($show_news[read_more_news]),
				);
				$tpl->parseTemplate("news_read_more_link",$news_read_more_link_array,"Yes");
				$read_more_link=$tpl->saveTemplate("news_read_more_link");
			}
			if ($show_news[upload_file]=="Yes")
			{
				$this->showAttachment($show_news);
			}
			
			if (!empty($show_news[category_image]))
			{
				$category_image="<img src=\"$show_news[category_image]\">";
			}
			else
			{
				$category_image="";
			}
			
			$date=date($fn->CONFIG['date_format'],$show_news[date]+$fn->CONFIG['time_offset']);
			$sticky_news_array= Array(
				'subject'=>$show_news[subject],
				'content'=>$show_news[news],
				'category'=>$show_news[category],
				'category_image'=>$category_image,
				'name'=>$show_news[username],
				'email'=>$show_news[email],
				'user_id'=>$show_news[user_id],
				'attachment'=>$this->attachment,
				'num_comments'=>$show_news[num_comments],
				'news_id'=>$show_news[news_id],
				'date'=>$date,
				'read_more_link'=>$read_more_link,
				'average_rating'=>$show_news[avg_rating],
				'num_ratings'=>$show_news[num_ratings],
			);
			$tpl->parseTemplate("sticky_news",$sticky_news_array,"Yes");
			$has_sticky_news=1;
			$this->attachment="";
		}
		// Now print sticky news if there is some
		if ($has_sticky_news==1)
		{
			$tpl->loadTemplate("sticky_news_header","templates/sticky_news_header.tpl");
			/*
			$sticky_news_header_array= Array(
				'blah'=>$var,
			);
			*/
			$tpl->parseTemplate("sticky_news_header",$sticky_news_header_array,"No");
			$tpl->printTemplate("sticky_news_header");
			$tpl->printTemplate("sticky_news");
			$tpl->loadTemplate("sticky_news_footer","templates/sticky_news_footer.tpl");
			/*
			$sticky_news_footer_array= Array(
				'blah'=>$var,
			);
			*/
			$tpl->parseTemplate("sticky_news_footer",$sticky_news_footer_array,"No");
			$tpl->printTemplate("sticky_news_footer");
			
		}
		$mysql->Query("SELECT n.*, c.*, u.user_id,u.username FROM 
		".$fn->CONFIG['db_prefix']."news n,  
		".$fn->CONFIG['db_prefix']."users u LEFT JOIN 
		".$fn->CONFIG['db_prefix']."categories c
		ON c.category_id=n.category_id WHERE 
		n.user_id=u.user_id AND n.sticky=0 $where  
		ORDER BY $order_by LIMIT $fn->data_bottom,$fn->data_per_page");
		while ($show_news=mysql_fetch_array($mysql->result_id))
		{
			$read_more_link="";
			$fn->stripArray($show_news);

			// Decides if we need a read more news link and if so does the template and such
			if (!empty($show_news[read_more_news]))
			{
				$tpl->loadTemplate("news_read_more_link","templates/news_read_more_link.tpl");
				$news_read_more_link_array= Array(
					'news_id'=>$show_news[news_id],
					'size'=>strlen($show_news[read_more_news]),
				);
				$tpl->parseTemplate("news_read_more_link",$news_read_more_link_array,"Yes");
				$read_more_link=$tpl->saveTemplate("news_read_more_link");
			}
			if ($show_news[upload_file]=="Yes")
			{
				$this->showAttachment($show_news);
			}
			$date=date($fn->CONFIG['date_format'],$show_news[date]+$fn->CONFIG['time_offset']);
			$news_array= Array(
				'subject'=>$show_news[subject],
				'content'=>$show_news[news],
				'category'=>$show_news[category],
				'category_image'=>$show_news[category_image],
				'name'=>$show_news[username],
				'email'=>$show_news[email],
				'user_id'=>$show_news[user_id],
				'attachment'=>$this->attachment,
				'num_comments'=>$show_news[num_comments],
				'news_id'=>$show_news[news_id],
				'date'=>$date,
				'read_more_link'=>$read_more_link,
				'average_rating'=>$show_news[avg_rating],
				'num_ratings'=>$show_news[num_ratings],
			);
			$tpl->parseTemplate("news",$news_array,"Yes");
			$this->attachment="";
		}
		$tpl->printTemplate("news");
	}
/**
* Displays the Category List
*
* Displays the category list formated and what not
* @param string $action The action that should be in the url
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function displayCategories($action)
	{
		global $mysql,$tpl,$fn;

		// Displays Header if they aren't including the news.php
		if ($fn->CONFIG['include_news_php']==0)
		{
			$fn->header();
		}
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."categories");
		$tpl->loadTemplate("category_list","templates/category_list.tpl");


		while ($show_category=mysql_fetch_array($mysql->result_id))
		{
			$category_list_array= Array(
				'action'=>$action,
				'category_name'=>$show_category[category],
				'category_id'=>$show_category[category_id],
			);
			$tpl->parseTemplate("category_list",$category_list_array,"Yes");
		}
		$category_list=$tpl->saveTemplate("category_list");
		$tpl->loadTemplate("news_top","templates/news_top.tpl");
		$news_top_array= Array(
			'category_list'=>$category_list,
		);
		$tpl->parseTemplate("news_top",$news_top_array,"No");
		$tpl->printTemplate("news_top");
	}
/**
* Displays the page list
*
* Makes the page list and also displays the footer stuff
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function pageList()
	{
		global $mysql,$tpl,$fn;
		$fn->makePages("<a href=\"news.php?page={eachpage}&category=".$_REQUEST['category']."\">{eachpage}</a>&nbsp;","<b>{page}</b>&nbsp;","<a href=\"news.php?page=1&category=".$_REQUEST['category']."\"> First Page</a>&nbsp;","<a href=\"news.php?page={eachpage}&category=".$_REQUEST['category']."\">Last Page </a>",$_REQUEST['page'],$fn->num_pages);
		$tpl->loadTemplate("news_bottom","templates/news_bottom.tpl");
		$news_bottom_array= Array(
			'page_list'=>$fn->pages,
			'num_pages'=>$fn->num_pages,
		);
		$tpl->parseTemplate("news_bottom",$news_bottom_array,"No");
		$tpl->printTemplate("news_bottom");
		if ($fn->CONFIG['include_news_php']==0)
		{
			$fn->footer();
		}
		else
		{
			echo "<P align=\"center\"><FONT face=\"Verdana\"><FONT size=\"1\">Powered by <A href=\"http://fscripts.com/\" target=\"_blank\">Fantastic News</A> v$fn->version  2004 <A href=\"http://fscripts.com\" target=_blank>Fantastic Scripts</A></FONT></P>";
			
			
		}
		
	}
/**
* Displays Attachments
*
* Shows the attachment of the current news item when called
* @global array $show_news the current news item array
* @global object $tpl instance of the template class
*/
	function showAttachment($show_news)
	{
		global $tpl;
		$this->attachment="";
		$tpl->loadTemplate("attachment","templates/attachment.tpl");
		$attachment_array = array(
			'filesize'            => $show_news[filesize],
			'downloads'=>$show_news[downloads],
			'filename'=>$show_news[filename],
			'news_id'=>$show_news[news_id],
		);
		$tpl->parseTemplate("attachment",$attachment_array,"No");
		$this->attachment=$tpl->saveTemplate("attachment");
	}
/**
* Rate News Form
*
* Displays the rate news form
* @global array $show_news the current news item array
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function rateNewsForm()
	{
		global $show_news,$tpl,$fn,$mysql;
		$this->rate_news="";
		if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
		{
			$mysql->query("SELECT * FROM 
			".$fn->CONFIG['db_prefix']."users WHERE 
			username='".$_COOKIE['fn_username']."' 
			AND password='".$_COOKIE['fn_password']."'");
			$show_user=mysql_fetch_array($mysql->result_id);
			if (isset($show_user[user_id]))
			{
				$this->can_rate_news=1;
			}
		}
		if ($this->can_rate_news==1 || $fn->CONFIG['guest_news_ratings']==1)
		{
			$tpl->loadTemplate("rate_news_form","templates/rate_news_form.tpl");
			$rate_news_form_array = array(
				'news_id'            => $_REQUEST['id'],
			);
			$tpl->parseTemplate("rate_news_form",$rate_news_form_array,"No");
			$tpl->printTemplate("rate_news_form");
		}
		else
		{
			$fn->error("You must login to rate news items");
		}
	}
/**
* Rate News
*
* Rates the news item after making sure the user is allowed to rate the news
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function rateNews()
	{
		global $tpl,$fn,$mysql;
		// First run a check to see if they're even allowed to rate news items
		// Seeing if they're a guest or a logged in user
		if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
		{
			$mysql->query("SELECT * 
			FROM ".$fn->CONFIG['db_prefix']."users 
			WHERE username='".$_COOKIE['fn_username']."' 
			AND password='".$_COOKIE['fn_password']."'");
			$show_user=mysql_fetch_array($mysql->result_id);
			if (isset($show_user[user_id]))
			{
				$this->can_rate_news=1;
			}
		}
		if ($this->can_rate_news==1 || $fn->CONFIG['guest_news_ratings']==1)
		{
			// Doing Check to make sure they haven't rated this news item before
			if ($this->can_rate_news==1)
			{
				$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."news_ratings WHERE user_id=".$show_user[user_id]." AND news_id=".$_POST['news_id']."");
				$show_rating=mysql_fetch_array($mysql->result_id);
				if (isset($show_rating[ip]))
				{
					$fn->error("Sorry but you've already rated this news item and gave it a $show_rating[rating]");
				}
			}
			elseif ($fn->CONFIG['guest_news_ratings']==1)
			{
				$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."news_ratings WHERE ip='".$_SERVER['REMOTE_ADDR']."' AND news_id=".$_POST['news_id']."");
				$show_rating=mysql_fetch_array($mysql->result_id);
				if (isset($show_rating[ip]))
				{
					$fn->error("Sorry but you've already rated this news item and gave it a $show_rating[rating]");
				}
			}
			else
			{
				$fn->error("You need to be logged in to make a news rating please login and try again");
			}
			// Now if we got through without errors we move on
			
			// First we're add the user's rating to our database so they can't do duplicate entries

			// Making a global user_id incase they're a guest
			if (empty($show_user[user_id]))
			{
				$user_id=$fn->CONFIG['guest_id'];
			}
			else
			{
				$user_id=$show_user[user_id];
			}
			$insert_array = array(
				'ip'          => $_SERVER['REMOTE_ADDR'],
				'user_id'=>$user_id,
				'news_id'=>$_POST['news_id'],
				'date'=>$fn->time,
				'rating'			=>$_POST['rating'],
			);
			$mysql->makeInsertString($insert_array);
			$mysql->query("INSERT INTO ".$fn->CONFIG['db_prefix']."news_ratings ($mysql->insert_fields) VALUES 	($mysql->insert_values)");

			/*	Now we need to update our news table itself. First we need to actually query 
				it and get the data because we need to change it's average rating.  MySQL
				Doesn't allow us to do the math while we query the database.  This solves the
				problem so we can search news items for specific ratings
			*/
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."news WHERE news_id=".$_REQUEST['news_id']."");
			$show_news=mysql_fetch_array($mysql->result_id);
			$num_ratings=$show_news[num_ratings]+1;
			$total_ratings=$show_news[total_ratings]+$_POST['rating'];
			$avg_rating=round($total_ratings/$num_ratings,2);

			// Update news now
			$update_array= Array(
				'avg_rating'			=>$avg_rating,
				'num_ratings'   => $num_ratings,
				'total_ratings' => $total_ratings,
			);
			$mysql->makeUpdateString($update_array);
			$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."news SET $mysql->update_string WHERE news_id=".$_POST['news_id']."");

			// Updating the user's number of ratings if they're logged in of course
			if (isset($show_user[user_id]))
			{
				$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."users SET num_ratings=num_ratings+1 WHERE user_id=".$show_user[user_id]."");
			}
			$fn->success("Thank you for rating this news item you may now close this window");
				
		}

	}
/**
* Starts Gzip Compression
*
* Starts up the gzip compression
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function startGzipCompression() {
		global $mysql,$tpl,$fn;
		if ($fn->CONFIG['gzip']==1) 
		{
			if (extension_loaded("zlib")) 
			{
				ob_start("ob_gzhandler");
				ob_implicit_flush(0);
			}
		}
	}
/**
* Prints the Gzip Compressed Page
*
* Prints out the gzip compressed page for the user
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function printGzipCompression() {
		global $mysql,$tpl,$fn;
		if ($fn->CONFIG['gzip']==1) 
		{
			if (extension_loaded("zlib")) 
			{
				if(strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip') != false) 
				{
					$encoding = 'gzip';
				}
				else if (strpos($_SERVER['HTTP_ACCEPT_ENCODING'], 'x-gzip') != false)  
				{
					$encoding = 'x-gzip';
				}
				if ($encoding) 
				{
					$contents = ob_get_contents();
					$gzip_data = "x1fx8bx08x00x00x00x00x00";
					$size = strlen($contents);
					$crc = crc32($contents);
					$gzip_data .= gzcompress($contents, $fn->CONFIG['gzip_level']);
					$gzip_data = substr($gzip_data, 0, strlen($gzip_data) - 4);
					$gzip_data .= pack('V', $crc) . pack('V', $size);
					ob_end_clean();
					header('Content-Encoding: ' . $encoding);
					echo $gzip_data;
				}
			}	
		}
	}
	function checkIpBan($ip)
	{
		global $fn,$mysql,$tpl;
		if ($fn->CONFIG['ip_banning']==1)
		{
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."banned_ips WHERE ip='$ip'");
			$show_ban=mysql_fetch_array($mysql->result_id);
			if (!empty($show_ban[ip]))
			{
				$fn->error("You have been banned from this site with the reason $show_ban[reason]");
			}
		}
	}
	function downloadAttachment()
	{
		global $fn,$mysql,$tpl;
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."news WHERE news_id=".$_REQUEST['id']."");
		$show_news=mysql_fetch_array($mysql->result_id);
		$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."news SET downloads=downloads+1");
		header("Location: ".$fn->CONFIG['uploads_url'].$show_news[filename]);
		
	}
	
}
$mysql->close();
?>