<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright is    |
// | intact and this is left at the top of every source file              |
// +----------------------------------------------------------------------+
// | index.php                                                            |
// +----------------------------------------------------------------------+
require_once("../config.php");
require_once("../functions/functions.php");
require_once("../functions/mysql.php");
require_once("../functions/template.php");
if (empty($tpl))
{
	$tpl=new Templates;
	$fn=new FNews;
}
$fn->startTimer();
$install=new Install;
/**
* Install Class
*
* Does the installation for FNews
* @author Tony Baird
* @version 2.0
* @access public
* @since 08-10-2004
*/
class Install
{
/**
* Install Constructor
*
* Figures out what install methods we're calling
*/
	function Install()
	{
		$this->header();
		if ($_REQUEST['step']=="1")
		{
			$this->setupConfigForm();	
		}
		else if (isset($_REQUEST['setup_config']))
		{
			$this->setupConfig();
		}
		else if ($_REQUEST['step']=="2")
		{
			$this->setupMysql();
		}
		else if ($_REQUEST['step']=="3")
		{
			$this->setupAccount();
		}
		else if (isset($_REQUEST['setup_account']))
		{
			$this->finishedInstall();
			
		}
		else
		{
			$this->startInstall();
		}
		$this->footer();
	}
/**
* Start Install Page
*
* Tells the user what all is required and what not
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function startInstall()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("start_install","templates/start_install.tpl");
		$tpl->parseTemplate("start_install",$start_install_array,"No");
		$tpl->printTemplate("start_install");
		// Displays the comments and the comment posting option
	}
/**
* Header
*
* Displays the header that is on the installer pages
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function header()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("header","templates/header.tpl");
		$tpl->parseTemplate("header",$header_array,"No");
		$tpl->printTemplate("header");
		
	}
/**
* Footer
*
* Displays the footer that is on the installer pages
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function footer()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("footer","templates/footer.tpl");
		$fn->stopTimer();
		$footer_array= Array(
			'num_queries'=>$mysql->query_count,
			'generation_time'=>$fn->total_time,
			'version'=>$fn->version,
		);
		$tpl->parseTemplate("footer",$footer_array,"No");
		$tpl->printTemplate("footer");
		
	}
/**
* Setup Config Form
*
* Opens up a form for the user to modify their configuration file to match their settings
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function setupConfigForm()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("setup_config_form","templates/setup_config_form.tpl");
		if ($fn->CONFIG['smilies']==1)
		{
			$smilies="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$smilies="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['gzip']==1)
		{
			$gzip="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$gzip="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['newstips']==1)
		{
			$newstips="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$newstips="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['include_news_php']==1)
		{
			$include_news_php="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$include_news_php="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['one_comments_page']==1)
		{
			$one_comments_page="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$one_comments_page="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['guest_comments']==1)
		{
			$guest_comments="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$guest_comments="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['guest_news_ratings']==1)
		{
			$guest_news_ratings="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$guest_news_ratings="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['search_news']==1)
		{
			$search_news="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$search_news="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['send_to_friend']==1)
		{
			$send_to_friend="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$send_to_friend="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['html_editor']==1)
		{
			$html_editor="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$html_editor="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		if ($fn->CONFIG['xml']==1)
		{
			$xml="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$xml="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		if ($fn->CONFIG['xml_news']==1)
		{
			$xml_news="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$xml_news="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		if ($fn->CONFIG['xml_read_more_news']==1)
		{
			$xml_read_more_news="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$xml_read_more_news="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		//$fn->stripArray($fn->CONFIG);
		$setup_config_form_array= Array(
			'mysql_username'=>$fn->CONFIG['mysql_username'],
			'mysql_password'=>$fn->CONFIG['mysql_password'],
			'mysql_db'=>$fn->CONFIG['mysql_db'],
			'mysql_host'=>$fn->CONFIG['mysql_host'],
			'db_prefix'=>$fn->CONFIG['db_prefix'],
			'news_per_page'=>$fn->CONFIG['news_per_page'],
			'num_headlines'=>$fn->CONFIG['num_headlines'],
			'news_order_by'=>$fn->CONFIG['news_order_by'],
			'smilies'=>$smilies,
			'date_format'=>$fn->CONFIG['date_format'],
			'uploads_path'=>$fn->CONFIG['uploads_path'],
			'uploads_url'=>$fn->CONFIG['uploads_url'],
			'time_offset'=>$fn->CONFIG['time_offset'],
			'gzip'=>$gzip,
			'gzip_level'=>$fn->CONFIG['gzip_level'],
			'newstips'=>$newstips,
			'include_news_php'=>$include_news_php,
			'one_comments_page'=>$one_comments_page,
			'comments_per_page'=>$fn->CONFIG['comments_per_page'],
			'guest_comments'=>$guest_comments,
			'user_cookie_time'=>$fn->CONFIG['user_cookie_time'],
			'flood_time'=>$fn->CONFIG['flood_time'],
			'guest_news_ratings'=>$guest_news_ratings,
			'smiley_path'=>$fn->CONFIG['smiley_path'],
			'smiley_url'=>$fn->CONFIG['smiley_url'],
			'search_news'=>$search_news,
			'send_to_friend'=>$send_to_friend,
			'send_to_friend_flood_time'=>$fn->CONFIG['send_to_friend_flood_time'],
			'site_url'=>$fn->CONFIG['site_url'],
			'html_editor'=>$html_editor,
			'xml'=>$xml,
			'xml_amount'=>$fn->CONFIG['xml_amount'],
			'xml_news'=>$xml_news,
			'xml_read_more_news'=>$xml_read_more_news,
		);
		$tpl->parseTemplate("setup_config_form",$setup_config_form_array,"No");
		$tpl->printTemplate("setup_config_form");	
	}
/**
* Setup Config
*
* Sets up the config file and then gives the user the option to move on to step 2
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function setupConfig()
	{
		global $tpl,$fn,$mysql;
		$fn->slashArray($_POST);
		$new_settings .="<?php\n";
		$new_settings .='$CONFIG[\'mysql_username\']="'.$_POST['mysql_username']."\";\n";
		$new_settings .='$CONFIG[\'mysql_password\']="'.$_POST['mysql_password']."\";\n";
		$new_settings .='$CONFIG[\'mysql_db\']="'.$_POST['mysql_db']."\";\n";
		$new_settings .='$CONFIG[\'mysql_host\']="'.$_POST['mysql_host']."\";\n";
		$new_settings .='$CONFIG[\'db_prefix\']="'.$_POST['db_prefix']."\";\n";
		$new_settings .='$CONFIG[\'news_per_page\']="'.$_POST['news_per_page']."\";\n";
		$new_settings .='$CONFIG[\'num_headlines\']="'.$_POST['num_headlines']."\";\n";
		$new_settings .='$CONFIG[\'news_order_by\']="'.$_POST['news_order_by']."\";\n";
		$new_settings .='$CONFIG[\'smilies\']="'.$_POST['smilies']."\";\n";
		$new_settings .='$CONFIG[\'date_format\']="'.$_POST['date_format']."\";\n";
		$new_settings .='$CONFIG[\'uploads_path\']="'.$_POST['uploads_path']."\";\n";
		$new_settings .='$CONFIG[\'uploads_url\']="'.$_POST['uploads_url']."\";\n";
		$new_settings .='$CONFIG[\'time_offset\']="'.$_POST['time_offset']."\";\n";
		$new_settings .='$CONFIG[\'gzip\']="'.$_POST['gzip']."\";\n";
		$new_settings .='$CONFIG[\'gzip_level\']="'.$_POST['gzip_level']."\";\n";
		$new_settings .='$CONFIG[\'newstips\']="'.$_POST['newstips']."\";\n";
		$new_settings .='$CONFIG[\'include_news_php\']="'.$_POST['include_news_php']."\";\n";
		$new_settings .='$CONFIG[\'one_comments_page\']="'.$_POST['one_comments_page']."\";\n";
		$new_settings .='$CONFIG[\'comments_per_page\']="'.$_POST['comments_per_page']."\";\n";
		$new_settings .='$CONFIG[\'guest_comments\']="'.$_POST['guest_comments']."\";\n";
		$new_settings .='$CONFIG[\'user_cookie_time\']="'.$_POST['user_cookie_time']."\";\n";
		$new_settings .='$CONFIG[\'flood_time\']="'.$_POST['flood_time']."\";\n";
		$new_settings .='$CONFIG[\'guest_news_ratings\']="'.$_POST['guest_news_ratings']."\";\n";
		$new_settings .='$CONFIG[\'smiley_path\']="'.$_POST['smiley_path']."\";\n";
		$new_settings .='$CONFIG[\'smiley_url\']="'.$_POST['smiley_url']."\";\n";
		$new_settings .='$CONFIG[\'search_news\']="'.$_POST['search_news']."\";\n";
		$new_settings .='$CONFIG[\'send_to_friend\']="'.$_POST['send_to_friend']."\";\n";
		$new_settings .='$CONFIG[\'send_to_friend_flood_time\']="'.$_POST['send_to_friend_flood_time']."\";\n";
		$new_settings .='$CONFIG[\'site_url\']="'.$_POST['site_url']."\";\n";
		$new_settings .='$CONFIG[\'html_editor\']="'.$_POST['html_editor']."\";\n";
		$new_settings .='$CONFIG[\'xml\']="'.$_POST['xml']."\";\n";
		$new_settings .='$CONFIG[\'xml_amount\']="'.$_POST['xml_amount']."\";\n";
		$new_settings .='$CONFIG[\'xml_news\']="'.$_POST['xml_news']."\";\n";
		$new_settings .='$CONFIG[\'xml_read_more_news\']="'.$_POST['xml_read_more_news']."\";\n";
		
		
		$new_settings .="?>";
		if ($config_file=fopen("../config.php","w+")) 
		{
			if (!fwrite($config_file,$new_settings)) 
			{
				echo "Unable To Write to configuration file please make sure the script has permission to write to the configuration file";
				exit();
			}
		} 
		else 
		{
			echo "Unable to Open Configuration File you need to make sure the script has permission to open it";
			exit();
		}
		$tpl->loadTemplate("setup_config_finished","templates/setup_config_finished.tpl");
		$tpl->parseTemplate("setup_config_finished",$setup_config_finished_array,"No");
		$tpl->printTemplate("setup_config_finished");	
	}
/**
* Sets up Mysql
*
* Sets the Mysql up then gives the user the option to go to step 3
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function setupMysql()
	{
		global $mysql,$fn,$tpl;
		$mysql=new Mysql;
		$mysql->connect();
		$mysql->query("CREATE TABLE `".$fn->CONFIG['db_prefix']."badwords` (
						  `word_id` int(11) NOT NULL auto_increment,
						  `badword` varchar(255) NOT NULL default '',
						  `newword` varchar(255) NOT NULL default '',
						  PRIMARY KEY  (`word_id`)
						) TYPE=MyISAM");
		echo "Bad Words Table Created<br>";
		
		$mysql->query("CREATE TABLE ".$fn->CONFIG['db_prefix']."banned_ips (
  ban_id int(11) NOT NULL auto_increment,
  ip varchar(255) NOT NULL default '',
  reason varchar(255) NOT NULL default '',
  PRIMARY KEY  (ban_id)
) TYPE=MyISAM");
		echo "Banned Ip's Table Created<br>";
		
		$mysql->query("CREATE TABLE `".$fn->CONFIG['db_prefix']."categories` (
					  `category_id` int(11) NOT NULL auto_increment,
					  `category` varchar(250) NOT NULL default '',
					  `category_image` varchar(255) NOT NULL default '',
					  PRIMARY KEY  (`category_id`)
					) TYPE=MyISAM");
		echo "Categories Table Created<br>";
		
		$mysql->query("CREATE TABLE `".$fn->CONFIG['db_prefix']."comments` (
					  `comment_id` int(11) NOT NULL auto_increment,
					  `news_comment_id` int(11) NOT NULL default '0',
					  `news_id` int(11) NOT NULL default '0',
					  `user_id` int(11) NOT NULL default '0',
					  `comments_username` varchar(255) NOT NULL default '',
					  `title` varchar(250) NOT NULL default '',
					  `comments` mediumtext NOT NULL,
					  `date` int(11) NOT NULL default '0',
					  `last_modified` int(11) NOT NULL default '0',
					  `ip` varchar(255) NOT NULL default '',
					  `deleted` smallint(6) NOT NULL default '0',
					  PRIMARY KEY  (`comment_id`)
					) TYPE=MyISAM");
		echo "Comments Table Created<br>";
		
		$mysql->query("CREATE TABLE `".$fn->CONFIG['db_prefix']."news` (
					  `news_id` int(11) NOT NULL auto_increment,
					  `user_id` int(11) NOT NULL default '0',
					  `subject` varchar(250) NOT NULL default '',
					  `category_id` int(11) NOT NULL default '0',
					  `news` mediumtext NOT NULL,
					  `read_more_news` mediumtext NOT NULL,
					  `num_comments` int(11) NOT NULL default '0',
					  `upload_file` enum('No','Yes') NOT NULL default 'No',
					  `filename` varchar(255) NOT NULL default '',
					  `filesize` int(11) NOT NULL default '0',
					  `downloads` int(11) NOT NULL default '0',
					  `date` int(11) NOT NULL default '0',
					  `avg_rating` double NOT NULL default '0',
					  `num_ratings` int(11) NOT NULL default '0',
					  `total_ratings` int(11) NOT NULL default '0',
					  `actual_date` varchar(250) NOT NULL default '',
					  `date_month` varchar(250) NOT NULL default '',
					  `date_year` varchar(250) NOT NULL default '',
					  `sticky` smallint(6) NOT NULL default '0',
					  PRIMARY KEY  (`news_id`)
					) TYPE=MyISAM");
		echo "News Table Created<br>";
		
		
		$mysql->query("CREATE TABLE `".$fn->CONFIG['db_prefix']."news_ratings` (
					  `ip` varchar(255) NOT NULL default '',
					  `news_id` int(11) NOT NULL default '0',
					  `user_id` int(11) NOT NULL default '0',
					  `date` int(11) NOT NULL default '0',
					  `rating` int(11) NOT NULL default '0'
					) TYPE=MyISAM");
		echo "News Ratings Table Created<br>";
		
		$mysql->query("CREATE TABLE `".$fn->CONFIG['db_prefix']."newstips` (
					  `newstip_id` int(11) NOT NULL auto_increment,
					  `user_id` int(11) NOT NULL default '0',
					  `newstip` mediumtext NOT NULL,
					  `source` varchar(255) NOT NULL default '',
					  `date` int(11) NOT NULL default '0',
					  `ip` varchar(250) NOT NULL default '',
					  `active` tinyint(4) NOT NULL default '0',
					  PRIMARY KEY  (`newstip_id`)
					) TYPE=MyISAM");
		echo "News tips Table Created<br>";
		
		$mysql->query("CREATE TABLE `".$fn->CONFIG['db_prefix']."send_to_friend` (
					  `news_id` int(11) NOT NULL default '0',
					  `ip` varchar(255) NOT NULL default '',
					  `date` int(11) NOT NULL default '0'
					) TYPE=MyISAM");
		echo "Send to Friend Table Created<br>";
		
		$mysql->query("CREATE TABLE `".$fn->CONFIG['db_prefix']."smilies` (
					  `smiley_id` int(11) NOT NULL auto_increment,
					  `symbol` varchar(250) NOT NULL default '',
					  `image_url` varchar(250) NOT NULL default '',
					  `uploaded_file` tinyint(4) NOT NULL default '0',
					  `filename` varchar(255) NOT NULL default '',
					  PRIMARY KEY  (`smiley_id`)
					) TYPE=MyISAM");
		echo "Smiley Table Created<br>";
		
		
		$mysql->query("CREATE TABLE `".$fn->CONFIG['db_prefix']."users` (
					  `user_id` int(11) NOT NULL auto_increment,
					  `username` varchar(255) NOT NULL default '',
					  `password` varchar(255) NOT NULL default '',
					  `user_level` varchar(255) NOT NULL default '',
					  `email` varchar(255) NOT NULL default '',
					  `icq` int(11) NOT NULL default '0',
					  `msn` varchar(255) NOT NULL default '',
					  `aim` varchar(255) NOT NULL default '',
					  `yahoo` varchar(255) NOT NULL default '',
					  `num_comments` int(11) NOT NULL default '0',
					  `num_ratings` int(11) NOT NULL default '0',
					  `num_news_posts` int(11) NOT NULL default '0',
					  `num_newstips` int(11) NOT NULL default '0',
					  `active` tinyint(4) NOT NULL default '0',
					  `last_ip` varchar(255) NOT NULL default '',
					  PRIMARY KEY  (`user_id`)
					) TYPE=MyISAM");
		echo "Users Table Created<br>";
		echo "<a href=\"index.php?step=3\">Proceed to Step 3</a>";
	}
/**
* Setup Account Form
*
* Sets up the main admin account
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function setupAccount()
	{
		global $tpl,$fn,$mysql;
		$tpl->loadTemplate("setup_account","templates/setup_account.tpl");
		$tpl->parseTemplate("setup_account",$setup_account_array,"No");
		$tpl->printTemplate("setup_account");	
	}
/**
* Tells the User they have finished the install
*
* Creates the user account, guest account and tells the user anything they need to know
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function finishedInstall()
	{
		global $tpl,$fn,$mysql;
		$mysql=new Mysql;
		$mysql->connect();
		$mysql->query("INSERT INTO `".$fn->CONFIG['db_prefix']."users` VALUES (1, '".$_POST['username']."', '".md5($_POST['password'])."', '@1@2@3@4@5@6@7@8@9@10@11@12@13@14@15@16@17@', 'admin@test.com', 0, '', '', '', 13, 5, 5, 7, 1, '')");
		$mysql->query("INSERT INTO `".$fn->CONFIG['db_prefix']."users` VALUES (2, 'Guest', 'DOIJSOIJXMXK', '@1', 'guest@guest.com', 0, '', '', '', 1, 0, 0, 0, 1, '')");
		$tpl->loadTemplate("finished_install","templates/finished_install.tpl");
		$tpl->parseTemplate("finished_install",$finished_install_array,"No");
		$tpl->printTemplate("finished_install");	
		
	}
}
?>