<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | functions/template.php                                               |
// +----------------------------------------------------------------------+
/**
* Templates Interface
*
* Does all of the template management.  Opens the files, parses them and prints them to the screen
* or saves them to a file for later use
* @author Tony Baird
* @version 2.0
* @access public
* @since 07-10-2004
*/
class Templates {
/**
* Constructor
*
*
* Does nothing right now maybe someday it'll do the skins
*/
function Templates()
{	
	// Maybe someday it'll be used for the skin setting or something	
}
	
	
	

/**
* Loads the template
*
* Opens up the file and grabs the info in it and sets any variables that might be needed
* @param $template_name just a name to keep track of it or any errors that happen
* @param $file the file that is the template
*/
	function loadTemplate($template_name,$file) {
		global $CONFIG;
		// Gives the Template an ID #
		$this->template_id++;
		if (!empty($CONFIG['script_path']))
		{
				$file=$CONFIG['script_path'].$file;
		}
		// Gives Filename #id filename
		$this->filename[$this->template_id]=$file;
		// Template name by ID #
		$this->templatename[$this->template_id]=$template_name;
		// Used to get id# back
		$this->get_template_id[$template_name]=$this->template_id;
		// Open File Get the content and such
		if (!$this->content[$this->template_id]=@file($this->filename[$this->template_id]))
		{
			$this->error("Unable to open template");
		}
		if (!$this->content[$this->template_id]=@implode("",$this->content[$this->template_id]))
		{
			$this->error("Unable to implode template");
		}
	}

/**
* Parses a Template
*
* Parses a template changes all the {vars} into the data provided by the 2D array that
* is sent to the function
* @param string $template_name The name of the template we're parsing
* @param array $data 2D array the first element is the variable in the template the second is the data
* @param boolean If its going to be looped or not
*/
	function parseTemplate($template_name,$data,$list_loop) {
		$template_id=$this->get_template_id[$template_name];
		if (!$template_id) 
		{
			$this->error("No Template with that name exists and you choose $template_name");
		}
		if (isset($data)) 
		{
			if ($list_loop) 
			{
				$this->final_content[$template_id].=$this->content[$template_id];
				foreach ($data as $k => $v) 
				{
					$this->final_content[$template_id]=str_replace("{".$k."}", $v,$this->final_content[$template_id]);
				}
			} 
			else 
			{
				$this->final_content[$template_id]=$this->content[$template_id];
				foreach ($data as $k => $v) 
				{
					$this->final_content[$template_id]=str_replace("{".$k."}", $v,$this->final_content[$template_id]);
				}
			}
		} 
		else 
		{
			$this->final_content[$template_id]=$this->content[$template_id];
		}
	}
/**
* Prints template
*
* Echo's the template right onto the screen can only be called once the template has been parsed
* or it will return errors
* @param $template_name just the name of the template that is printing
*/
	function printTemplate($template_name) 
	{
		$template_id=$this->get_template_id[$template_name];
		if (empty($this->final_content[$template_id])) 
		{
			$this->error("You need to Parse Before Printing you tryed to print $template_name");
		} 
		else 
		{
			echo $this->final_content[$template_id];
			return;
		}
	}
/**
* Saves the template
*
* Saves the final parsed template to a file
* @param $template_name just the name of the template that is being saved
* @return Final content of the template
*/
	function saveTemplate($template_name) 
	{
		$template_id=$this->get_template_id[$template_name];
		if (!$this->final_content[$template_id]) 
		{
			$this->error("You need to Parse Before Printing");
		} 
		else 
		{
			return $this->final_content[$template_id];
		}
	}
/**
* Error function
*
* Prints out any errors that happen with the templates
* @param $error The error that happened
*/
	function error($error) 
	{
		echo $error;
		exit();
	}
}
?>