<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | functions/functions.php                                              |
// +----------------------------------------------------------------------+
$version="2.1.5";
$release_type="Final";
/**
* Fantastic News Function Interface
*
* Does all the functions
* @author Tony Baird
* @version 2.0
* @access public
* @since 07-10-2004
*/

class FNews 
{
/**
* Functions Constructor
*
* Does all the function related stuff basically just sets variables
*/
	function FNews()
	{
		global $CONFIG,$mysql,$version;
		
		
		foreach ($CONFIG AS $k => $v)
		{
			$this->CONFIG[$k]=$v;
		}
		
	
		
		$this->version=$version;
		$this->time=time();
	}
/**
* Slashes an array
*
* Uses the addslashes php function through an entire array
* @param array $array The array that needs addslashed
* @return array $file the array with slashes in it now
*/
	function slashArray(&$array)
	{
		if (!get_magic_quotes_gpc()) {
			reset($array);
			while(list($key,$val)=each($array))
			{
				if(is_string($val)) 
				{
					$array[$key]=addslashes($val);
	
				} 
				elseif(is_array($val)) 
				{
					$array[$key]=$this->slashArray($val);
				}
			}
		}
		return $array;
	}
/**
* Strips Slashes
*
* Strips slashes from an array using the the built in php function stripslashes
* @param array $array The array that needs stripslashed
* @return array $file the array with the slashes gone
*/
	function stripArray(&$array) 
	{
		reset($array);
		while(list($key,$val)=each($array)) 
		{
			if(is_string($val)) 
			{
				$array[$key]=stripslashes($val);
			} 
			elseif(is_array($val))
			{
				$array[$key]=$this->stripArray($val);
			}
		}
		return $array;
	}
/**
* HTML's an array
*
* Switches all html characters such as < > into actual html code
* @param array $array The array that needs stripslashed
* @return array $file the array with the slashes gone
*/
	function htmlArray(&$array)
	{
		reset($array);
		while(list($key,$val)=each($array))
		{
			if(is_string($val)) 
			{
				$array[$key]=HTMLSpecialChars($val);

			} 
			elseif(is_array($val)) 
			{
				$array[$key]=$this->htmlArray($val);
			}
		}
		return $array;
	}
/**
* Divides Data
*
* Divides mySQL data so it can be later processed into multiple pages
* @param string $query the query that is being divided
* @param int $page The current page we're on
* @param int $data_per_page the amount of data per page
*/
	function divideData($query,$page,$data_per_page) 
	{
		global $mysql;
		$mysql->query($query);
		$show_count=mysql_fetch_array($mysql->result_id);
		if ($show_count[count] !=0) 
		{
			$this->data_bottom=($page-1)*$data_per_page;
			$this->data_per_page=$data_per_page;
			$num_data=$show_count[count];
			$num_pages=$num_data/$this->data_per_page;
			$this->num_pages=ceil($num_pages);
		} 
		else 
		{
			$this->num_pages=0;
			$this->data_per_page=0;
			$this->data_bottom=0;
			$this->hasdata="No";
		}
	}
/**
* Makes a Page List
*
* Creates a page list uses {var} for variables inside so that it can be formated correctly
* @param string $page_string the page string
* @param string $current_page_string the string for the current page stuff
* @param string $last_page_string the string for the last page stuff
* @param int $num_pages The number of pages in the page list
*/
	function makePages($page_string,$current_page_string,$first_page_string,$last_page_string,$page,$num_pages) 
	{
		$this->pages="";
		for ($eachpage=1; $eachpage<=$num_pages; $eachpage++) 
		{
			if ($page == $eachpage) 
			{
				$this->pages .=$current_page_string;
				$this->pages=str_replace("{page}",$page,$this->pages);
			} 
			else 
			{
				if ($eachpage>=$page-3 && $eachpage>1 && $num_page_first_displays<3) 
				{
					$num_page_first_displays++;
					$this->pages .= "$page_string";
				}
				elseif ($eachpage<$page && $page>4) 
				{
					if ($first_page !="Yes") 
					{
						$first_page="Yes";
						$this->pages .= "$first_page_string";
					}
					if ($first_last !="Yes") 
					{
						$first_last="Yes";
						$this->pages .="... ";
					}
					
				}
				elseif ($eachpage<=$page+3 && $eachpage>=$page-3) 
				{
					$this->pages .= "$page_string"; 
				}
				elseif ($eachpage==$num_pages) 
				{
					if ($last_last !="Yes" && $page>4) 
					{
						$last_last="Yes";
						$this->pages .="... ";
					}
					$this->pages .="$last_page_string";
					
				}
				elseif ($eachpage+1>=$page && $page==$num_pages) 
				{
					$old_each_page=$eachpage;
					$eachpage-=3;
					$this->pages .= "$page_string";
					$eachpage-=2;
					$this->pages .= "$page_string";
					$eachpage-=1;
					$this->pages .= "$page_string";
					$eachpage=$old_each_page;
				}
				$this->pages=str_replace("{page}",$page,$this->pages);
				$this->pages=str_replace("{eachpage}",$eachpage,$this->pages);
			}
		}
	}
/**
* Starts a timer
*
* Starts a timer that is used for page generation stuff
*/
	function startTimer() 
	{
        global $start_time;
        $mtime = microtime ();
        $mtime = explode (' ', $mtime);
        $mtime = $mtime[1] + $mtime[0];
        $start_time = $mtime;
    }
/**
* Stops a timer
*
* Stops the timer created by startTimer() and creates the variable total_time which is the total time used
*/
    function stopTimer() 
	{
        global $start_time;
        $mtime = microtime ();
        $mtime = explode (' ', $mtime);
        $mtime = $mtime[1] + $mtime[0];
        $end_time = $mtime;
        $this->total_time = round (($end_time - $start_time), 5);
    }
/**
* Displays Errors
*
* Displays the errors generated by opening a template and putting the error in and printing it out
* @param string $error The error
*/
	function error($error) 
	{
		global $tpl;
		$tpl->loadTemplate("Error","templates/error.tpl");
		$template_array = array(
			'error'            => $error
		);
		$tpl->parseTemplate("Error",$template_array,"No");
		$tpl->printTemplate("Error");
		$this->footer();
		exit();
	}
/**
* Displays Success
*
* Displays the success generated by opening a template and putting the success in and printing it
* @param string $success The message of success that should be printed
*/
	function success($success) 
	{
		global $tpl, $online;
		$tpl->loadTemplate("Success","templates/success.tpl");
		$template_array = array(
			'success'            => $success
		);
		$tpl->parseTemplate("Success",$template_array,"No");
		$tpl->printTemplate("Success");
	}
/**
* Redirects a user to another page after saying a success message
*
* Redirects the user to another page after specified amount of time
* @global object $tpl Instance of the template class
* @param string $page the page that they're being redirected to
* @param int $time the amount of time till redirection
* @param string $message The message before the redirection
* @return array $file the array with the slashes gone
*/
	function redirectionSuccess($page,$time,$message) 
	{
		global $tpl;
		$tpl->loadTemplate("redirection_success","templates/redirection_success.tpl");
		$redirection_success_array = array(
			'page'            => $page,
			'time'			=>$time,
			'message'		=>$message,
		);
		$tpl->parseTemplate("redirection_success",$redirection_success_array,"No");
		$tpl->printTemplate("redirection_success");
	}
/**
* Header
*
* Header for most pages just calls the header template and any vars needed
* @global object $template Instance of the template class
*/
	function header()
	{
		global $tpl;
		$tpl->loadTemplate("header","templates/header.tpl");
		if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
		{
			$options="[ <a href=\"news.php?action=logout\">Logout</a> | <a href=\"news.php?action=edit_profile\">Edit Profile</a> |
						<a href=\"news.php?action=newstip\">Submit Newstip</a>
			| <a href=\"news.php?action=search\">Search News</a> ]";
		}
		else
		{
			$options="[ <a href=\"news.php?action=login\">Login</a> |
					<a href=\"news.php?action=newstip\">Submit Newstip</a>
			| <a href=\"news.php?action=search\">Search News</a> ]";	
		}
		$header_array= Array(
			'options'=>$options,
		);
		$tpl->parseTemplate("header",$header_array,"No");
		$tpl->printTemplate("header");
	}
/**
* Footer
*
* Displays footer and does any ending script things
* @global object $tpl Instance of the template class
* @global object $mysql Instance of the mySQL class
* @global object $fg Instance of the guestbook functions class
* @global string $version The current version of the script
*/
	function footer()
	{
		global $tpl,$mysql,$fn,$version;
		$this->stopTimer();
		$tpl->loadTemplate("footer","templates/footer.tpl");
		$footer_array= Array(
			'num_queries'=>$mysql->query_count,
			'generation_time'=>$this->total_time,
			'version'=>$version,
		);
		$tpl->parseTemplate("footer",$footer_array,"No");
		$tpl->printTemplate("footer");
		$this->endScript();
		// Used for debugging purposes only
		//echo $mysql->sql; 
	}
/**
* Ends the script
*
* Ends the script
* @global object $tpl Instance of the template class
* @global object $mysql Instance of the mySQL class
* @global object $fg Instance of the guestbook functions class
* @global string $version The current version of the script
* @global array $CONFIG Stores all the configurations things
*/
	function endScript()
	{
		global $tpl,$fn,$mysql,$version,$CONFIG;
		$footer=$tpl->saveTemplate("footer");
		if (!strpos($footer,"Fantastic Scripts"))
		{
			$template_file=@fopen("templates/footer.tpl","w+");
			$text='<p align="center"> [ <b> Queries Used:</b> {num_queries} ] [ <b> Script Execution Time:</b> {generation_time} ]
<P align="center"><FONT face="Verdana"><FONT size="1">Powered by <A href="http://fscripts.com/" target="_blank">Fantastic News</A> v{version}  2004 <A href="http://fscripts.com" target=_blank>Fantastic Scripts</A></FONT></P>
</html></body>';
			@fwrite($template_file,$text);
			exit();
		}
	}
}
?>