<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on php file                                      |
// +----------------------------------------------------------------------+
// | comments.php                                                         |
// +----------------------------------------------------------------------+


/**
* Comments Class
*
* Does all the Comments related functions
* @author Tony Baird
* @version 2.0
* @access public
* @since 07-10-2004
*/
class Comments
{
/**
* Comments Constructor
*
* Figures out which Comments method we're using
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function Comments()
	{
		if (isset($_POST['postcomments']))
		{
			$this->postComments();
		}
		elseif ($_REQUEST['action']=="edit_comments")
		{
			$this->editCommentsForm();
		}
		elseif (isset($_REQUEST['edit_comments']))
		{
			$this->editComments();
		}
		elseif ($_REQUEST['action']=="delete_comments")
		{
			$this->deleteCommentsConfirm();
		}
		elseif ($_REQUEST['action']=="delete_comments_confirm")
		{
			$this->deleteComments();
		}
		elseif ($_REQUEST['action']=="undelete_comments")
		{
			$this->unDeleteCommentsConfirm();
		}
		elseif ($_REQUEST['action']=="undelete_comments_confirm")
		{
			$this->unDeleteComments();
		}
	
	}
/**
* Displays Comments
*
* Displays the comments for a specific news item
* @param int $news_id News item # for the comment page
* @param int $one_comments_page Whether all comments are on one page 0 - no 1 - yes
* @param int $page Page Number of current comments page
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function displayComments($news_id,$one_comments_page,$page)
	{
		global $mysql,$tpl,$fn;
		$this->commentsForm($news_id);
		if ($one_comments_page==1)
		{
			$mysql->query("SELECT u.*, c.* FROM  
				".$fn->CONFIG['db_prefix']."comments c 
			LEFT JOIN ".$fn->CONFIG['db_prefix']."users u ON u.user_id=c.user_id WHERE 
				c.news_id=$news_id
				ORDER BY c.date");
		}
		else
		{
			$fn->divideData("SELECT COUNT(*) AS count FROM ".$fn->CONFIG['db_prefix']."comments WHERE news_id=$news_id",$page,$fn->CONFIG['comments_per_page']);
			
			if ($fn->hasdata !="No")
			{
				$mysql->query("SELECT u.*, c.* FROM  
				".$fn->CONFIG['db_prefix']."comments c 
				LEFT JOIN ".$fn->CONFIG['db_prefix']."users u ON u.user_id=c.user_id WHERE 
				c.news_id=$news_id
				ORDER BY c.date LIMIT $fn->data_bottom,$fn->data_per_page");
			}
		}
		$tpl->loadTemplate("comments","templates/comments.tpl");
		if ($fn->hasdata !="No" || $one_comments_page==1)
		{
			while ($show_comments=mysql_fetch_array($mysql->result_id))
			{
				$options="";
				$options_temp="";
				$last_modified="";
				$fn->stripArray($show_comments);
				$got_comments=1;
				// Ok here we do a check if we use the Guest Username or the user account
				if (!empty($show_comments[comments_username]))
				{
					$username=$show_comments[comments_username];
				}
				else
				{
					$username=$show_comments[username];
				}
				// Incase the user has edit options
				if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
				{
					// Checking if they can edit
					if ($this->user_id==$show_comments[user_id] && preg_match("/@2/",$this->user_level))
					{
						$options_temp="[ <a href=\"news.php?action=edit_comments&id=$show_comments[comment_id]\">Edit Comment</a> ";
					}
					// If they're a super admin for comments
					elseif (preg_match("/@5/",$this->user_level))
					{
						$options_temp="[ <a href=\"news.php?action=edit_comments&id=$show_comments[comment_id]\">Edit Comment</a> ";
					}
					if (preg_match("/@6/",$this->user_level))
					{
						// We need to add the extra part to the start of the var
						if (!empty($options_temp))
						{
							if ($show_comments[deleted] !=1)
							{
								$options_temp .="| <a href=\"news.php?action=delete_comments&id=$show_comments[comment_id]\">Delete Comment</a> ]";
							}
							else
							{
								$options_temp .="| <a href=\"news.php?action=undelete_comments&id=$show_comments[comment_id]\">unDelete Comment</a> ]";
								
							}
						}
						else
						{
							if ($show_comments[deleted] !=1)
							{
								$options_temp .="[ <a href=\"news.php?action=delete_comments&id=$show_comments[comment_id]\">Delete Comment</a> ]";
							}
							else
							{
								$options_temp .="[ <a href=\"news.php?action=undelete_comments&id=$show_comments[comment_id]\">unDelete Comment</a> ]";
								
							}
						}
					}
					else
					{
						// Completing it if we dont got the delete option
						if (!empty($options_temp))
						{
							$options_temp .="]";
						}
					}
					if (!empty($options_temp))
					{
						$options="<br><br><b>Options:</b> $options_temp";
					}
				}
				// Checking if the comment has been modified
				if ($show_comments[last_modified] >0)
				{
					$last_modified="<br><br><small>Last Modified ".date($fn->CONFIG['date_format'],$show_comments[date]+$fn->CONFIG['time_offset'])."</small>";
				}
				// Sets the vars for the template
				$date=date($fn->CONFIG['date_format'],$show_comments[date]+$fn->CONFIG['time_offset']);
				if ($show_comments[deleted]==1)
				{
					$comments="<b>Comments Deleted By Moderator</b>";
					if (preg_match("/@6/",$this->user_level))
					{
						$comments .="<br><br>$show_comments[comments]";
					}
					$show_comments[comments]=$comments;
					
					
				}
				$comments_array= Array(
					'username'=>$username,
					'title'=>$show_comments[title],
					'options'=>$options,
					'last_modified'=>$last_modified,
					'comments'=>$show_comments[comments],
					'news_comment_id'=>$show_comments[news_comment_id],
					'user_id'=>$show_comments[user_id],
					'date'=>$date,
				);
				$tpl->parseTemplate("comments",$comments_array,"Yes");
			}
			// Double Check For one comment page
			if ($got_comments==1)
			{
				$tpl->loadTemplate("comments_top","templates/comments_top.tpl");
				$comments_top_array= Array(
					'blah'=>"test",
				);
				$tpl->parseTemplate("comments_top",$comments_bottom_array,"No");
				$tpl->printTemplate("comments_top");

				$tpl->printTemplate("comments");


				$tpl->loadTemplate("comments_bottom","templates/comments_bottom.tpl");
				$comments_bottom_array= Array(
					'category_list'=>$category_list,
				);
				$tpl->parseTemplate("comments_bottom",$comments_bottom_array,"No");
				$tpl->printTemplate("comments_bottom");
			}
		}
		else
		{
			$fn->error("There are currently no comments feel free to post some");
		}
		/*	Comments form variable it was used above we're just echoing it now
			Since we needed user information from when it does the form.  So we can
			figure out if the users can edit or wahtever. Since it didn't matter if we printed it or saved it made sense just to change that around rather than rework the way the user system
			in this class is built
		*/
		echo $this->comments_form;
	}
/**
* Comments Form
*
* Figures out everything for the comments form and displays it
* @param int $news_id News id# for the comments form
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function commentsForm($news_id)
	{
		global $mysql,$tpl,$fn;
		// Smiley List
		$smiley_list="";
		if ($fn->CONFIG['smilies']==1)
		{
			$mysql->Query("SELECT * FROM ".$fn->CONFIG['db_prefix']."smilies");
			while ($show_smiley=mysql_fetch_array($mysql->result_id))
			{
				$fn->stripArray($show_smiley);
				if ($show_smiley[uploaded_file]==0)
				{
					
					$smiley_list .="<a href=\"javascript:smile('$show_smiley[symbol]')\"><img src=\"$show_smiley[image_url]\" border=\"0\"></a> ";
				}
				else
				{
					$smiley_list .="<a href=\"javascript:smile('$show_smiley[symbol]')\"><img src=\"".$fn->CONFIG['smiley_url']."$show_smiley[filename]\" border=\"0\"></a> ";
				}
			}
		}
		if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
		{
			$this->checkCookie();
			
			if ($this->logged_in==1 && $this->can_post_comments==1)
			{
				// Make the form post_comments_logged_in.tpl
				$tpl->loadTemplate("post_comments_logged_in","templates/post_comments_logged_in.tpl");
				$post_comments_logged_in_array = array(
					'username'            => $this->username,
					'user_id'		=>$this->user_id,
					'news_id'=>$news_id,
					'smiley_list'=>$smiley_list,
				);
				$tpl->parseTemplate("post_comments_logged_in",$post_comments_logged_in_array,"No");
				$this->comments_form=$tpl->SaveTemplate("post_comments_logged_in");



			}
			else
			{
				if ($fn->CONFIG['guest_comments']==1)
				{
					$guest_comments="Guest comments are enabled<br>
									But we encourage you to <a href=\"news.php?action=register\">register</a><br>
									If you want to stay anonymous just put in<br>
									an username and no password";
					// Make the form but also have the login option
				}
				else
				{
					$guest_comments="Guest comments are disabled<br>
									We encourage you to <a href=\"news.php?action=register\">register</a><br>
									If you are register put your login information in when you post";
				}
				$tpl->loadTemplate("post_comments_not_logged_in","templates/post_comments_not_logged_in.tpl");
				$post_comments_not_logged_in_array = array(
					'news_id'=>$news_id,
					'guest_comments'=>$guest_comments,
					'smiley_list'=>$smiley_list,
				);
				$tpl->parseTemplate("post_comments_not_logged_in",$post_comments_not_logged_in_array,"No");
				$this->comments_form=$tpl->saveTemplate("post_comments_not_logged_in");


			}
		}
		else
		{
			if ($fn->CONFIG['guest_comments']==1)
			{
				$guest_comments="Guest comments are enabled<br>
								But we encourage you to <a href=\"news.php?action=register\">register</a><br>
								If you want to stay anonymous just put in<br>
								an username and no password";
				// Make the form but also have the login option
			}
			else
			{
				$guest_comments="Guest comments are disabled<br>
								We encourage you to <a href=\"news.php?action=register\">register</a><br>
								If you are register put your login information in when you post";
			}
			$tpl->loadTemplate("post_comments_not_logged_in","templates/post_comments_not_logged_in.tpl");
			$post_comments_not_logged_in_array = array(
				'news_id'=>$news_id,
				'guest_comments'=>$guest_comments,
				'smiley_list'=>$smiley_list,
			);
			$tpl->parseTemplate("post_comments_not_logged_in",$post_comments_not_logged_in_array,"No");
			$this->comments_form=$tpl->saveTemplate("post_comments_not_logged_in");
		}
	}
/**
* Checks Cookie
*
* Checks whether or not the cookie the user has matches an account in the database
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function checkCookie()
	{
		global $mysql,$tpl,$fn;
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."users WHERE username='".$_COOKIE['fn_username']."' AND password='".$_COOKIE['fn_password']."'");
		$show_user=mysql_fetch_array($mysql->result_id);
		if (isset($show_user[user_id]))
		{
			$this->logged_in=1;
			$this->user_level=$show_user[user_level];
			if (preg_match("/@1/",$this->user_level))
			{
				$this->can_post_comments=1;
				$this->user_id=$show_user[user_id];
				$this->username=$show_user[username];
			}
		}
	}
/**
* Logs User In
*
* Logs the user in then creates the cookie so they don't need to keep logging in
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function logUserIn()
	{
		global $mysql,$tpl,$fn;
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."users WHERE username='".$_POST['username']."' AND password='".md5($_POST['password'])."'");
		$show_user=mysql_fetch_array($mysql->result_id);
		if (isset($show_user[user_id]))
		{
			// Set the magical user cookie isn't it useful?
			setcookie("fn_username",$_POST['username'],$fn->time+$fn->CONFIG['user_cookie_time']);
			setcookie("fn_password",md5($_POST['password']),$fn->time+$fn->CONFIG['user_cookie_time']);

			$this->user_level=$show_user[user_level];
			if (preg_match("/@1/",$this->user_level))
			{
				$this->can_post_comments=1;
				$this->user_id=$show_user[user_id];
				$this->username=$show_user[username];
			}
		}
		else
		{
			$fn->error("The User Information you have given is incorrect please double check it");
		}
	}
/**
* Post Comments
*
* Posts Comments in the database and also does some user checks
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function postComments()
	{
		global $mysql,$tpl,$fn;
		// If the user has a cookie set already we're double checking it
		if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
		{
			$this->checkCookie();
			// Now since I built the CheckCookie function badly we do a check if it didnt set anything
			if (empty($this->username))
			{
				$fn->error("Your cookie does not match any accounts and has been deleted please relogin");
				setcookie("fn_username","",-1);
				setcookie("fn_password","",-1);
			}
		}
		// If the user chooses to be a Guest
		elseif ($fn->CONFIG['guest_comments']==1 && empty($_POST['password']))
		{
			$this->user_id=$fn->CONFIG['guest_user_id'];
			$this->comments_username=$_POST['username'];
			$this->can_post_comments=1;

		}
		elseif (!empty($_POST['username']) && !empty($_POST['password']))
		{
			$this->logUserIn();

		}
		elseif (empty($_POST['username']))
		{
			$fn->error("You need to enter a username");
		}
		/*
		Now we get into if they have permission to post we do checks on everything
		to make sure they filled out all the fields
		*/

		if ($this->can_post_comments==1)
		{
			// Do some comment junk
			if (empty($_POST['comment']))
			{
				$fn->error("Comments field left empty");
			}
			
			// Time to make sure they aren't flooding
			$flood_time=$fn->time-$fn->CONFIG['flood_time'];
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."comments WHERE ip='".$_SERVER['REMOTE_ADDR']."' AND date>$flood_time");
			$mysql->numRows();
			if ($mysql->num_rows >=1)
			{
				$fn->error("You are trying to post a comment less than ".$fn->CONFIG['flood_time']." seconds after your last comment please wait");
			}

			$this->comments=$_POST['comment'];
			// Time for some fun
			$this->parseComments();
			// Now we post the comment the best part :D
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."comments WHERE news_id=".$_POST['news_id']."");
			$mysql->numRows();
			$news_comment_id=$mysql->num_rows+1;
			$insert_array = array(
				'news_comment_id'          => $news_comment_id,
				'user_id'=>$this->user_id,
				'news_id'=>$_POST['news_id'],
				'comments_username'			=>$this->comments_username,
				'date'   => $fn->time,
				'comments' => $this->comments,
				'ip' =>$_SERVER['REMOTE_ADDR'],
			);
			$mysql->makeInsertString($insert_array);
			$mysql->query("INSERT INTO ".$fn->CONFIG['db_prefix']."comments ($mysql->insert_fields) VALUES 	($mysql->insert_values)");
			// Update the number of comments for the news post
			$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."news SET num_comments=num_comments+1 WHERE news_id=".$_POST['news_id']."");
			// Update the number of comments posted by a user if they are a logged in one
			if (empty($this->comments_username))
			{
				$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."users SET num_comments=num_comments+1 WHERE user_id=".$this->user_id."");
			}
		}
		else
		{
			// Looks like they've had their commenting ability disabled :P
			$fn->error("You aren't allowed to post comments");
		}
		$fn->redirectionSuccess("news.php?id=".$_POST['news_id']."",5,"You have successfully posted a comment you'll be redirected in 5 seconds back to the comments page");
	}
/**
* Edit Comments Form
*
* The edit comments form checks if the user has access then displays the form
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function editCommentsForm()
	{
		global $mysql,$tpl,$fn;
		$fn->header();
		if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
		{
			$this->checkCookie();
			// Now since I built the CheckCookie function badly we do a check if it didnt set anything
			if (empty($this->username))
			{
				$fn->error("Your cookie does not match any accounts and has been deleted please relogin");
				setcookie("fn_username",$_POST['username'],-1);
				setcookie("fn_password",md5($_POST['password']),-1);
			}
		}
		// Checking if they can edit
		if ($this->user_id==$show_comments[user_id] && preg_match("/@2/",$this->user_level))
		{
			$this->can_edit_comments=1;
			
		}
		// If they're a super admin for comments
		elseif (preg_match("/@5/",$this->user_level))
		{
			$this->can_edit_comments=1;
			
		}
		if ($this->can_edit_comments==1)
		{


			// Get data
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."comments WHERE comment_id=".$_REQUEST['id']."");
			$show_comments=mysql_fetch_array($mysql->result_id);
			if ($show_comments[deleted]==1)
			{
				$fn->error("Comment was deleted");
			}
			$this->comments=$show_comments[comments];
			$this->unParseComments();
			$tpl->loadTemplate("edit_comments_form","templates/edit_comments_form.tpl");
			$edit_comments_form_array= Array(
				'comments'=>$this->comments,
				'comment_id'=>$show_comments[comment_id],
				'news_id'=>$show_comments[news_id],
			);
			$tpl->parseTemplate("edit_comments_form",$edit_comments_form_array,"No");
			$tpl->printTemplate("edit_comments_form");
		}
		else
		{
			$fn->error("You do not have permission to edit these comments");
		}
		$fn->footer();
	}
/**
* Edit Comments
*
* Edits the comments in the database after making sure the user has access
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function editComments()
	{
		global $mysql,$tpl,$fn;
		if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
		{
			$this->checkCookie();
			// Now since I built the CheckCookie function badly we do a check if it didnt set anything
			if (empty($this->username))
			{
				$fn->error("Your cookie does not match any accounts and has been deleted please relogin");
				setcookie("fn_username",$_POST['username'],-1);
				setcookie("fn_password",md5($_POST['password']),-1);
			}
		}
		// Checking if they can edit
		if ($this->user_id==$show_comments[user_id] && preg_match("/@2/",$this->user_level))
		{
			$this->can_edit_comments=1;
			
		}
		// If they're a super admin for comments
		elseif (preg_match("/@5/",$this->user_level))
		{
			$this->can_edit_comments=1;
			
		}
		if ($this->can_edit_comments==1)
		{
			if (empty($_POST['comment']))
			{
				$fn->error("Comments field cannot be left empty");
			}
			$this->comments=$_POST['comment'];
			$this->parseComments();
			$update_array= Array(
				'comments'			=>$this->comments,
				'ip'   => $_SERVER['REMOTE_ADDR'],
				'last_modified' => $fn->time,
			);
			$mysql->makeUpdateString($update_array);
			$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."comments SET $mysql->update_string WHERE comment_id=".$_REQUEST['comment_id']."");
			$fn->redirectionSuccess("news.php?id=".$_REQUEST['news_id']."",5,"You have successfully modified this comment, you will be redirected to the comments page in 5 seconds");

		}
		else
		{
			$fn->error("You do not have permission to edit these comments");
		}
	}
/**
* Delte Comments Confirm
*
* Asks the user if they really want to nuke the comment
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function deleteCommentsConfirm()
	{
		global $mysql,$tpl,$fn;
		if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
		{
			$this->checkCookie();
			// Now since I built the CheckCookie function badly we do a check if it didnt set anything
			if (empty($this->username))
			{
				$fn->error("Your cookie does not match any accounts and has been deleted please relogin");
				setcookie("fn_username",$_POST['username'],-1);
				setcookie("fn_password",md5($_POST['password']),-1);
			}
		}
		// Checking if they can edit
		if ($this->user_id==$show_comments[user_id] && preg_match("/@3/",$this->user_level))
		{
			$this->can_delete_comments=1;
			
		}
		// If they're a super admin for comments
		elseif (preg_match("/@6/",$this->user_level))
		{
			$this->can_delete_comments=1;
			
		}
		if ($this->can_delete_comments==1)
		{
			$tpl->loadTemplate("delete_comments_confirm","templates/delete_comments_confirm.tpl");
			$delete_comments_confirm_array= Array(
				'comment_id'=>$_REQUEST['id'],
			);
			$tpl->parseTemplate("delete_comments_confirm",$delete_comments_confirm_array,"No");
			$tpl->printTemplate("delete_comments_confirm");
		}
		else
		{
			$fn->error("You do not have permission to delete these comments");
		}
	}
/**
* Delte Comments
*
* Nukes the comment after checking if the user is allowed to
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function deleteComments()
	{
		global $mysql,$tpl,$fn;
		if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
		{
			$this->checkCookie();
			// Now since I built the CheckCookie function badly we do a check if it didnt set anything
			if (empty($this->username))
			{
				$fn->error("Your cookie does not match any accounts and has been deleted please relogin");
				setcookie("fn_username",$_POST['username'],-1);
				setcookie("fn_password",md5($_POST['password']),-1);
			}
		}
		// Checking if they can edit
		if ($this->user_id==$show_comments[user_id] && preg_match("/@3/",$this->user_level))
		{
			$this->can_delete_comments=1;
			
		}
		// If they're a super admin for comments
		elseif (preg_match("/@6/",$this->user_level))
		{
			$this->can_delete_comments=1;
			
		}
		if ($this->can_delete_comments==1)
		{
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."comments WHERE comment_id=".$_REQUEST['id']."");
			$show_comments=mysql_fetch_array($mysql->result_id);

			$update_array= Array(
				'deleted'			=>1,
				'last_modified'=>0,
			);
			$mysql->makeUpdateString($update_array);
			$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."comments SET $mysql->update_string WHERE comment_id=".$_REQUEST['id']."");
			$fn->redirectionSuccess("news.php?id=".$show_comments[news_id]."",5,"You have successfully deleted this comment, you will be redirected to the comments page in 5 seconds");
		}
		else
		{
			$fn->error("You do not have permission to delete these comments");
		}
	}
/**
* Un Delete Comments Confirm Page
*
* Asks the user if they want to un nuke the comments
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function unDeleteCommentsConfirm()
	{
		global $mysql,$tpl,$fn;
		if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
		{
			$this->checkCookie();
			// Now since I built the CheckCookie function badly we do a check if it didnt set anything
			if (empty($this->username))
			{
				$fn->error("Your cookie does not match any accounts and has been deleted please relogin");
				setcookie("fn_username",$_POST['username'],-1);
				setcookie("fn_password",md5($_POST['password']),-1);
			}
		}
		// If they're a super admin for comments
		if (preg_match("/@6/",$this->user_level))
		{
			$this->can_delete_comments=1;
			
		}
		if ($this->can_delete_comments==1)
		{
			$tpl->loadTemplate("undelete_comments_confirm","templates/undelete_comments_confirm.tpl");
			$undelete_comments_confirm_array= Array(
				'comment_id'=>$_REQUEST['id'],
			);
			$tpl->parseTemplate("undelete_comments_confirm",$undelete_comments_confirm_array,"No");
			$tpl->printTemplate("undelete_comments_confirm");
		}
		else
		{
			$fn->error("You do not have permission to delete these comments");
		}
	}
/**
* Un Delete Comments
*
* Un Nukes comments after confirming the user is allowed to
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function unDeleteComments()
	{
		global $mysql,$tpl,$fn;
		if (isset($_COOKIE['fn_username']) || isset($_COOKIE['fn_password']))
		{
			$this->checkCookie();
			// Now since I built the CheckCookie function badly we do a check if it didnt set anything
			if (empty($this->username))
			{
				$fn->error("Your cookie does not match any accounts and has been deleted please relogin");
				setcookie("fn_username",$_POST['username'],-1);
				setcookie("fn_password",md5($_POST['password']),-1);
			}
		}
		// If they're a super admin for comments
		if (preg_match("/@6/",$this->user_level))
		{
			$this->can_delete_comments=1;
			
		}
		if ($this->can_delete_comments==1)
		{
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."comments WHERE comment_id=".$_REQUEST['id']."");
			$show_comments=mysql_fetch_array($mysql->result_id);

			$update_array= Array(
				'deleted'			=>0,
			);
			$mysql->makeUpdateString($update_array);
			$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."comments SET $mysql->update_string WHERE comment_id=".$_REQUEST['id']."");
			$fn->redirectionSuccess("news.php?id=".$show_comments[news_id]."",5,"You have successfully undeleted this comment, you will be redirected to the comments page in 5 seconds");
		}
		else
		{
			$fn->error("You do not have permission to delete these comments");
		}
	}
/**
* Parses Comments
*
* Calls all the parse comment methods so the comment can be formated properly
*/
	function parseComments()
	{
		// First we make so this code doesn't have HTML fun in it we don't need javascript exploits
		$this->comments=htmlentities($this->comments);
		// The fun plugins we can use to manipulate the comment
		$this->swearFilterCheck();
		$this->smileyReplace();
		$this->commentCode();

		// Makes newlines <br>'s
		$this->comments=str_replace("\n","<BR>", $this->comments);
		// Now we make this MySQL friendly
		$this->comments=addslashes($this->comments);
	}

/**
* Un Parses Comments
*
* Calls all the unparse methods
*/
	function unParseComments()
	{
		$this->swearFilterCheck();
		$this->unSmileyReplace();
		$this->unCommentCode();
		
		// Makes <br>'s new lines
		$this->comments=str_replace("<BR>","\n", $this->comments);
		// Takes away the annoying \'s
		$this->comments=stripslashes($this->comments);
	}
/**
* Swear Filter Check
*
* Changes all the swear words into their new version in the comments
* @global object $mysql instance of the mysql class
* @global object $fn instance of the Fantastic News function class
*/
	function swearFilterCheck()
	{
		global $mysql,$fn;

		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."badwords");
		while ($show_badword=mysql_fetch_array($mysql->result_id))
		{
			$this->comments=str_replace($show_badword[badword],$show_badword[newword],$this->comments);
		}
	}
/**
* Replaces Smilies
*
* Replaces smiley symbols with their images
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function smileyReplace()
	{
		global $mysql,$fn;
		if ($fn->CONFIG['smilies']==1)
		{
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."smilies");
			while ($show_smiley=mysql_fetch_array($mysql->result_id))
			{
				// Checks if the file was uploaded because if it was there is some
				// changes that need to be made to the url
				if ($show_smiley[uploaded_file]==1)
				{
					$this->comments=str_replace($show_smiley[symbol],"<img src=\"".$fn->CONFIG['smiley_url'].$show_smiley[filename]."\">",$this->comments);
				}
				else
				{
					$this->comments=str_replace($show_smiley[symbol],"<img src=\"$show_smiley[image_url]\">",$this->comments);
				}
			}
		}
	}
/**
* Turns Comment code in HTML
*
* Turns all the comment code into uppercase HTML code for it
*/
	function commentCode()
	{
		// [b] to Bold HTMl
		$this->comments=str_replace("[b]","<B>",$this->comments);
		$this->comments=str_replace("[/b]","</B>",$this->comments);
		
		// [i] to italics in HTML
		$this->comments=str_replace("[i]","<I>",$this->comments);
		$this->comments=str_replace("[/i]","<I>",$this->comments);
		
		// [u] to underline in HTML
		$this->comments=str_replace("[u]","<U>",$this->comments);
		$this->comments=str_replace("[/u]","<U>",$this->comments);
	}


/**
* Undoes the Swear Filter
*
* Changes everything back to what it was before the swear filter
*/
	function unSwearFilterCheck()
	{
		// Not needed right now
	}
/**
* Un Smiley Replace
*
* Changes all the smiley images back to their symbols
* @global object $mysql instance of the mysql class
* @global object $fn instance of the Fantastic News function class
*/
	function unSmileyReplace()
	{
		global $mysql,$fn;
		if ($fn->CONFIG['smilies']==1)
		{
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."smilies");
			while ($show_smiley=mysql_fetch_array($mysql->result_id))
			{
				// Checks if the file was uploaded because if it was there is some
				// changes that need to be made to the url
				if ($show_smiley[uploaded_file]==1)
				{
					$this->comments=str_replace("<img src=\"".$fn->CONFIG['smiley_url'].$show_smiley[filename]."\">",$show_smiley[symbol],$this->comments);
				}
				else
				{
					$this->comments=str_replace("<img src=\"$show_smiley[image_url]\">",$show_smiley[symbol],$this->comments);
				}
			}
		}
	}
/**
* UnComment Code
*
* Changes all the uppercase HTML back to comment code
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function unCommentCode()
	{
		// Bold in HTML to [b]
		$this->comments=str_replace("<B>","[b]",$this->comments);
		$this->comments=str_replace("</B>","[/b]",$this->comments);
		
		// italics in HTML to [i]
		$this->comments=str_replace("<I>","[i]",$this->comments);
		$this->comments=str_replace("</I>","[/i]",$this->comments);
		
		// underline in HTML to [u]
		$this->comments=str_replace("<U>","[U]",$this->comments);
		$this->comments=str_replace("</U>","[/U]",$this->comments);
	}







}
?>