<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | archive.php                                                          |
// +----------------------------------------------------------------------+
unset($CONFIG);
require_once("config.php");
require_once($CONFIG['script_path']."functions/functions.php");
require_once($CONFIG['script_path']."functions/mysql.php");
require_once($CONFIG['script_path']."functions/template.php");
if (empty($tpl))
{
	$tpl=new Templates;
	$mysql=new Mysql;
	$mysql->connect();
	$fn=new FNews;
}
$fn->startTimer();
$archive=new Archive;

/**
* Archive Class
*
* Does all the Archive related functions of Fantastic News
* @author Tony Baird
* @version 2.0
* @access public
* @since 07-10-2004
*/
class Archive
{
/**
* Archive Constructor
*
* Figures out what archive method we're using
* @global object $fn instance of the Fantastic News function class
*/
	function Archive()
	{
		global $fn;
		if (isset($_REQUEST['year']) || isset($_REQUEST['month']))
		{
			$this->displayArchivedNews();
			$this->pageList();
			
		}
		else
		{
			$this->listArchive();
		}
	}
/**
* Displays Archived News
*
* Grabs the archived news from the database and page splits it ect.
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function displayArchivedNews()
	{		
		global $mysql,$tpl,$fn;
		$fn->header();
		if (empty($_REQUEST['page'])) 
		{
			$_REQUEST['page']=1;
		}
		if (empty($_REQUEST['order_by']))
		{
			$order_by=$fn->CONFIG['news_order_by']." DESC";
		}
		if (isset($_REQUEST['month']))
		{
			$where .="WHERE date_month='".$_REQUEST['month']."'";
		}
		if (isset($_REQUEST['year']))
		{
			if (isset($_REQUEST['month']))
			{	
				$where .=" AND date_year='".$_REQUEST['year']."'";
			}
			else
			{
				$where .="WHERE date_year='".$_REQUEST['year']."'";
			}
		}
		// Divides news up so we got page stuff
		$fn->divideData("SELECT COUNT(*) AS count FROM ".$fn->CONFIG['db_prefix']."news $where" ,$_REQUEST['page'],$fn->CONFIG['news_per_page']);

		$tpl->loadTemplate("news","templates/news.tpl");
		// Now we make a better where statement and clear the old one
		$where="";
		if (isset($_REQUEST['month']))
		{
			$where .=" AND date_month='".$_REQUEST['month']."'";
		}
		if (isset($_REQUEST['year']))
		{
			$where .=" AND date_year='".$_REQUEST['year']."'";
		}
		$mysql->query("SELECT ".$fn->CONFIG['db_prefix']."news.*, ".$fn->CONFIG['db_prefix']."categories.*, ".$fn->CONFIG['db_prefix']."users.* FROM ".$fn->CONFIG['db_prefix']."news, ".$fn->CONFIG['db_prefix']."categories, ".$fn->CONFIG['db_prefix']."users WHERE ".$fn->CONFIG['db_prefix']."news.user_id=".$fn->CONFIG['db_prefix']."users.user_id AND ".$fn->CONFIG['db_prefix']."categories.category_id=".$fn->CONFIG['db_prefix']."news.category_id $where  ORDER BY $order_by LIMIT $fn->data_bottom,$fn->data_per_page");
		while ($show_news=mysql_fetch_array($mysql->result_id))
		{
			$read_more_link="";
			$fn->stripArray($show_news);
			// Decides if we need a read more news link and if so does the template and such
			if (!empty($show_news[read_more_news]))
			{
				$tpl->loadTemplate("news_read_more_link","templates/news_read_more_link.tpl");
				$news_read_more_link_array= Array(
					'news_id'=>$show_news[news_id],
					'size'=>strlen($show_news[read_more_news]),
				);
				$tpl->parseTemplate("news_read_more_link",$news_read_more_link_array,"Yes");
				$read_more_link=$tpl->saveTemplate("news_read_more_link");
			}
				
			$date=date($fn->CONFIG['date_format'],$show_news[date]+$fn->CONFIG['time_offset']);
			$news_array= Array(
				'subject'=>$show_news[subject],
				'content'=>$show_news[news],
				'category'=>$show_news[category],
				'category_image'=>$show_news[category_image],
				'name'=>$show_news[username],
				'email'=>$show_news[email],
				'user_id'=>$show_news[user_id],
				'attachment'=>$show_news[attachment],
				'num_comments'=>$show_news[num_comments],
				'news_id'=>$show_news[news_id],
				'date'=>$date,
				'read_more_link'=>$read_more_link
			);
			$tpl->parseTemplate("news",$news_array,"Yes");
		}
		$tpl->printTemplate("news");

	}
/**
* List Archive
*
* Lists the months that are in the archive
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function listArchive()
	{
		global $mysql,$tpl,$fn;
		$fn->header();
		$tpl->loadTemplate("archive","templates/archive.tpl");
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."news ORDER BY date_month AND date_year");
		
		while($show_archive=mysql_fetch_array($mysql->result_id))
		{
			if ($old_month[$show_archive[date_month]][$show_archive[date_year]]!="Yes") {
				$archive_array= Array(
					'year'=>$show_archive[date_year],
					'month'=>$show_archive[date_month],
				);
				$tpl->parseTemplate("archive",$archive_array,"Yes");
			}
			$old_month[$show_archive[date_month]][$show_archive[date_year]]="Yes";

		}
		$tpl->printTemplate("archive");
		$fn->footer();
	}
/**
* Page list
*
* Creates the page list for the news archive
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function pageList()
	{
		global $mysql,$tpl,$fn;
		$fn->makePages("<a href=\"archive.php?page={eachpage}&month=".$_REQUEST['month']."&year=".$_REQUEST['year']."\">{eachpage}</a>&nbsp;","<b>{page}</b>&nbsp;","<a href=\"archive.php?page=1&month=".$_REQUEST['month']."&year=".$_REQUEST['year']."\"> First Page</a>&nbsp;","<a href=\"archive.php?page={eachpage}&month=".$_REQUEST['month']."&year=".$_REQUEST['year']."\">Last Page </a>",$_REQUEST['page'],$fn->num_pages);
		$tpl->loadTemplate("news_bottom","templates/news_bottom.tpl");
		$news_bottom_array= Array(
			'page_list'=>$fn->pages,
			'num_pages'=>$fn->num_pages,
		);
		$tpl->parseTemplate("news_bottom",$news_bottom_array,"No");
		$tpl->printTemplate("news_bottom");
		$fn->footer();
		
	}
}
?>