<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | user.php                                                             |
// +----------------------------------------------------------------------+

/**
* User Class
*
* Controls all the user options in the admin area
* @author Tony Baird
* @version 2.0
* @access public
* @since 07-29-2004
*/
class User
{
/**
* User Decision Maker
*
* Figures out what user option we're using
*/
	function User($admin)
	{
		
		$this->admin=$admin;
		if ($_REQUEST['action']=="user_list")
		{
			$this->userList();
		}
		else if ($_REQUEST['action']=="delete_user")
		{
			$this->deleteUser();
		}
		else if ($_REQUEST['action']=="edit_user")
		{
			$this->editUserForm();
		}
		else if (isset($_REQUEST['edit_user']))
		{
			$this->editUser();
		}
	}
/**
* List of Users
*
* displays the current list of user accounts
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class
*/	
	function userList()
	{
		global $mysql,$tpl,$fn;
		$this->userListHeader();
		if (empty($_REQUEST['page'])) 
		{
			$_REQUEST['page']=1;
		}
		// Divides news up so we got page stuff
		$fn->divideData("SELECT COUNT(*) AS count FROM ".$fn->CONFIG['db_prefix']."users WHERE active=1 LIMIT 0,1" ,$_REQUEST['page'],20);
		$tpl->loadTemplate("user_list","templates/user_list.tpl");
		$mysql->Query("SELECT * FROM ".$fn->CONFIG['db_prefix']."users WHERE active=1 LIMIT $fn->data_bottom,$fn->data_per_page");
		while ($show_user=mysql_fetch_array($mysql->result_id))
		{
			$fn->stripArray($show_user);
			$user_list_array= Array(
				'username'=>$show_user[username],
				'user_id'=>$show_user[user_id],
				'email'=>$show_user[email],
			);
			$tpl->parseTemplate("user_list",$user_list_array,"Yes");
			$has_users=1;
		}
		
		if ($has_users==1)
		{
			$tpl->printTemplate("user_list");
		}
		else
		{
			$this->admin->error("There are currently no users in the database");
		}
		$this->userListFooter();
		
	}
/**
* User List Header
*
* Displays the header for the user list pages
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/		
	function userListHeader()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("user_list_header","templates/user_list_header.tpl");
		
		$user_list_header_array= Array(
			'error'=>$this->error,
		);
		
		$tpl->parseTemplate("user_list_header",$user_list_header_array,"No");
		$tpl->printTemplate("user_list_header");
		
	}
/**
* User List Footer
*
* Displays the footer for the user list pages
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function userListFooter()
	{
		global $mysql,$tpl,$fn;
		$fn->makePages("<a href=\"index.php?action=user_list&page={eachpage}\">{eachpage}</a>&nbsp;","<b>{page}</b>&nbsp;","<a href=\"index.php?action=user_list&page=1\"> First Page</a>&nbsp;","<a href=\"index.php?action=user_list&page={eachpage}\">Last Page </a>",$_REQUEST['page'],$fn->num_pages);
		$tpl->loadTemplate("user_list_footer","templates/user_list_footer.tpl");
		
		$user_list_footer_array= Array(
			'num_pages'=>$fn->num_pages,
			'page_list'=>$fn->pages,
		);
		
		$tpl->parseTemplate("user_list_footer",$user_list_footer_array,"No");
		$tpl->printTemplate("user_list_footer");
		
	}
/**
* Delete User
*
* Sets the user account's active to 0 which is the equivalent of disabling their account
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function deleteUser()
	{
		global $mysql,$tpl,$fn;
		$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."users SET active=0 WHERE user_id=".$_REQUEST['id']."");
		$fn->redirectionSuccess("index.php?action=user_list",10,"You have successfully deleted that user account you'll now be redirected to the user list page in 10 seconds");
	}
/**
* Edit User Form
*
* Edit User Form
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class
*/	
	function editUserForm()
	{
		global $mysql,$tpl,$fn;
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."users WHERE user_id=".$_REQUEST['id']."");
		$show_user=mysql_fetch_array($mysql->result_id);
		
		// All the user option list stuff wow this is a long list
		if (preg_match("/@1@/",$show_user[user_level]))
		{
			$post_comments_list="<option selected>Yes</option>
							<option>No</option>";
		}
		else
		{
			$post_comments_list="<option selected>No</option>
							<option>Yes</option>";	
		}
		
		if (preg_match("/@2/",$show_user[user_level]))
		{
			$edit_their_comments_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$edit_their_comments_list="<option selected>No</option>
							<option>Yes</option>";
			
		}
		
		if (preg_match("/@3/",$show_user[user_level]))
		{
			$delete_their_comments_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$delete_their_comments_list="<option selected>No</option>
							<option>Yes</option>";	
		}
		if (preg_match("/@4/",$show_user[user_level]))
		{
			$rate_news_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$rate_news_list="<option selected>No</option>
							<option>Yes</option>";
		}
		
		if (preg_match("/@5/",$show_user[user_level]))
		{
			$edit_others_comments_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$edit_others_comments_list="<option selected>No</option>
							<option>Yes</option>";
		}
		
		if (preg_match("/@6/",$show_user[user_level]))
		{
			$delete_others_comments_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$delete_others_comments_list="<option selected>No</option>
							<option>Yes</option>";
		}
		
		if (preg_match("/@7/",$show_user[user_level]))
		{
			$post_news_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$post_news_list="<option selected>No</option>
							<option>Yes</option>";
		}
		
		if (preg_match("/@8/",$show_user[user_level]))
		{
			$edit_their_news_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$edit_their_news_list="<option selected>No</option>
							<option>Yes</option>";
		}
		
		if (preg_match("/@9/",$show_user[user_level]))
		{
			$delete_their_news_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$delete_their_news_list="<option selected>No</option>
							<option>Yes</option>";
		}
		
		if (preg_match("/@10/",$show_user[user_level]))
		{
			$edit_others_news_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$edit_others_news_list="<option selected>No</option>
							<option>Yes</option>";
		}
		
		if (preg_match("/@11/",$show_user[user_level]))
		{
			$delete_others_news_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$delete_others_news_list="<option selected>No</option>
							<option>Yes</option>";
		}
		
		if (preg_match("/@12/",$show_user[user_level]))
		{
			$category_admin_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$category_admin_list="<option selected>No</option>
							<option>Yes</option>";
		}
		
		if (preg_match("/@13/",$show_user[user_level]))
		{
			$smiley_admin_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$smiley_admin_list="<option selected>No</option>
							<option>Yes</option>";
		}
		
		if (preg_match("/@14/",$show_user[user_level]))
		{
			$badword_admin_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$badword_admin_list="<option selected>No</option>
							<option>Yes</option>";
		}
		
		if (preg_match("/@15/",$show_user[user_level]))
		{
			$templates_admin_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$templates_admin_list="<option selected>No</option>
							<option>Yes</option>";
		}
		
		if (preg_match("/@16/",$show_user[user_level]))
		{
			$user_admin_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$user_admin_list="<option selected>No</option>
							<option>Yes</option>";
		}
		
		if (preg_match("/@17/",$show_user[user_level]))
		{
			$maintenance_admin_list="<option selected>Yes</option>
							<option>No</option>";
			
		}
		else
		{
			$maintenance_admin_list="<option selected>No</option>
							<option>Yes</option>";
		}
		// Time to load the template and what not
		$tpl->loadTemplate("edit_user_form","templates/edit_user_form.tpl");
		
		$edit_user_form_array= Array(
			'username'=>$show_user[username],
			'email'=>$show_user[email],
			'icq'=>$show_user[icq],
			'aim'=>$show_user[aim],
			'msn'=>$show_user[msn],
			'yahoo'=>$show_user[yahoo],
			'post_comments_list'=>$post_comments_list,
			'rate_news_list'=>$rate_news_list,
			'edit_their_comments_list'=>$edit_their_comments_list,
			'delete_their_comments_list'=>$delete_their_comments_list,
			'edit_others_comments_list'=>$edit_others_comments_list,
			'delete_others_comments_list'=>$delete_others_comments_list,
			'post_news_list'=>$post_news_list,
			'edit_their_news_list'=>$edit_their_news_list,
			'delete_their_news_list'=>$delete_their_news_list,
			'edit_others_news_list'=>$edit_others_news_list,
			'delete_others_news_list'=>$delete_others_news_list,
			'category_admin_list'=>$category_admin_list,
			'smiley_admin_list'=>$smiley_admin_list,
			'maintenance_admin_list'=>$maintenance_admin_list,
			'badword_admin_list'=>$badword_admin_list,
			'user_admin_list'=>$user_admin_list,
			'templates_admin_list'=>$templates_admin_list,
			'user_id'=>$show_user[user_id],
		);
		
		$tpl->parseTemplate("edit_user_form",$edit_user_form_array,"No");
		$tpl->printTemplate("edit_user_form");
	}
/**
* Edit User
*
* Edit's the users account based on what was put into the form 
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class
*/	
	function editUser()
	{
		global $mysql,$tpl,$fn;
		
		// Doing all the user level stuff
		if ($_REQUEST['post_comments']=="Yes")
		{
			$user_level .="@1";
		}
		if ($_REQUEST['edit_their_comments']=="Yes")
		{
			$user_level .="@2";
		}
		if ($_REQUEST['delete_their_comments']=="Yes")
		{
			$user_level .="@3";
		}
		if ($_REQUEST['rate_news']=="Yes")
		{
			$user_level .="@4";
		}
		if ($_REQUEST['edit_others_comments']=="Yes")
		{
			$user_level .="@5";
		}
		if ($_REQUEST['delete_others_comments']=="Yes")
		{
			$user_level .="@6";
		}
		if ($_REQUEST['post_news']=="Yes")
		{
			$user_level .="@7";
		}
		if ($_REQUEST['edit_their_news']=="Yes")
		{
			$user_level .="@8";
		}
		if ($_REQUEST['delete_their_news']=="Yes")
		{
			$user_level .="@9";
		}
		if ($_REQUEST['edit_others_news']=="Yes")
		{
			$user_level .="@10";
		}
		if ($_REQUEST['delete_others_news']=="Yes")
		{
			$user_level .="@11";
		}
		if ($_REQUEST['category_admin']=="Yes")
		{
			$user_level .="@12";
		}
		if ($_REQUEST['smiley_admin']=="Yes")
		{
			$user_level .="@13";
		}
		if ($_REQUEST['badword_admin']=="Yes")
		{
			$user_level .="@14";
		}
		if ($_REQUEST['templates_admin']=="Yes")
		{
			$user_level .="@15";
		}
		if ($_REQUEST['user_admin']=="Yes")
		{
			$user_level .="@16";
		}
		if ($_REQUEST['maintenance_admin']=="Yes")
		{
			$user_level .="@17";
		}
		if (!empty($_REQUEST['new_password']) && $_REQUEST['new_password']==$_REQUEST['confirm_new_password'])
		{
			$password=md5($_REQUEST['new_password']);
		}
		else
		{
			$mysql->query("SELECT password FROM ".$fn->CONFIG['db_prefix']."users WHERE user_id=".$_REQUEST['user_id']."");
			$show_user=mysql_fetch_array($mysql->result_id);
			$password=$show_user[password];
		}
		$update_array= Array(
			'email'=>$_POST['email'],
			'password'=>$password,
			'user_level'=>$user_level,
			'icq'=>$_POST['icq'],
			'aim'=>$_POST['aim'],
			'msn'=>$_POST['msn'],
			'yahoo'=>$_POST['yahoo'],	
		);
		$mysql->makeUpdateString($update_array);
		$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."users SET $mysql->update_string WHERE user_id=".$_REQUEST['user_id']."");
		$fn->redirectionSuccess("index.php?action=user_list",10,"You have successfully edited a user account you'll be redirected back to the user list in 10 seconds");
		
	}
}
?>