<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | template.php                                                         |
// +----------------------------------------------------------------------+

/**
* Template Class
*
* Does all maintenance related functions
* @author Tony Baird
* @version 2.0
* @access public
* @since 08-09-2004
*/
class Template
{
/**
* Template Constructor
*
* Figures out what template method we're using
*/
	function Template($admin)
	{
		$this->admin=$admin;
		if ($_REQUEST['action']=="template_list")
		{
			$this->templateList();
		}
		else if ($_REQUEST['action']=="edit_template")
		{
			$this->editTemplateForm();
		}
		else if (isset($_REQUEST['edit_template']))
		{
			$this->editTemplate();
		}
	}
/**
* Template List
*
* Grabs the list of files in the template directory and displays them
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function templateList()
	{
		global $tpl,$fn,$mysql;
		$this->templateListHeader();
		$tpl->loadTemplate("template_list","templates/template_list.tpl");
		$d = dir("../templates");
		$template_files = array();
		while (false != ($file = $d->read())) 
		{
			if (preg_match("/.tpl/",$file)) 
			{
				$file=preg_replace("/.tpl/","",$file);
				$template_list_array=Array(
					'filename'=>$file,
					'skin_id'=>$skin_id,
					'ext'=>"tpl",
				);
				$tpl->ParseTemplate("template_list",$template_list_array,"Yes");
			}
			else if (preg_match("/.css/",$file)) 
			{
				
				$file=preg_replace("/.css/","",$file);
				$template_list_array=Array(
					'filename'=>$file,
					'skin_id'=>$skin_id,
					'ext'=>"css",
				);
				$tpl->ParseTemplate("template_list",$template_list_array,"Yes");
				
				
			}		
		}
		$d->close();
		$tpl->printTemplate("template_list");	
		$this->templateListFooter();
	}
/**
* Template list Header
*
* Opens up the template list's header
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function templateListHeader()
	{
		global $tpl,$fn,$mysql;
		$tpl->loadTemplate("template_list_header","templates/template_list_header.tpl");
		/*
		$template_list_header_form_array= Array(
			'var'=>$var,
		);
		*/
		$tpl->parseTemplate("template_list_header",$template_list_header_array,"No");
		$tpl->printTemplate("template_list_header");	
	}
/**
* Template list Footer
*
* Opens up the template list's Footer
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function templateListFooter()
	{
		global $tpl,$fn,$mysql;
		$tpl->loadTemplate("template_list_footer","templates/template_list_footer.tpl");
		/*
		$template_list_footer_form_array= Array(
			'var'=>$var,
		);
		*/
		$tpl->parseTemplate("template_list_footer",$template_list_footer_array,"No");
		$tpl->printTemplate("template_list_footer");	
	}
/**
* Edit Template Form
*
* Opens up that template and then creates the form to edit it
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function editTemplateForm()
	{
		global $tpl,$fn,$mysql;
		$tpl->loadTemplate("edit_template_form","templates/edit_template_form.tpl");
		$filename=fopen("../templates/".$_REQUEST['file'].".".$_REQUEST['ext'],"r+");	
		$template_text=fread($filename,filesize("../templates/".$_REQUEST['file'].".".$_REQUEST['ext']));
		$template_text=stripslashes($template_text);
		$template_text=HTMLSpecialChars($template_text);
		$edit_template_form_array= Array(
			'template_text'=>$template_text,
			'ext'=>$_REQUEST['ext'],
			'file'=>$_REQUEST['file'],
		);
		
		$tpl->parseTemplate("edit_template_form",$edit_template_form_array,"No");
		$tpl->printTemplate("edit_template_form");	
		
	}
/**
* Edit Template
*
* Edits the template file to reflect the changes the user made
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function editTemplate()
	{
		global $mysql,$tpl,$fn;
		$file="../templates/".$_POST['file'].".".$_POST['ext'];
		$text=stripslashes($_POST['template_text']);
		if ($template_file=@fopen($file,"w+")) 
		{
			if(!fwrite($template_file,$text)) 
			{
				$this->admin->error("Failed to write to file");
			}
		} 
		else 
		{
			$this->admin->error("Failed to open file");
		}
		$fn->redirectionSuccess("index.php?action=template_list",10,"You have successfully modified that template you'll be redirected back to the template list in 10 seconds");	
		
	}
}
?>