<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | smiley.php                                                           |
// +----------------------------------------------------------------------+

/**
* Smiley Class
*
* Controls all the ban options in the admin area
* @author Tony Baird
* @version 2.0
* @access public
* @since 07-29-2004
*/
class Smiley
{
/**
* Avatar Decision Maker
*
* Figures out what ban option we're using
*/
	function Smiley($admin)
	{
		
		$this->admin=$admin;
		if ($_REQUEST['action']=="add_smiley")
		{
			$this->addSmileyForm();
		}
		else if (isset($_REQUEST['add_smiley']))
		{
			$this->addSmiley();
		}
		else if ($_REQUEST['action']=="smiley_list")
		{
			$this->smileyList();
		}
		else if ($_REQUEST['action']=="delete_smiley")
		{
			$this->deleteSmiley();
		}	
		else if ($_REQUEST['action']=="edit_smiley")
		{
			$this->editSmileyForm();
		}
		else if (isset($_REQUEST['edit_smiley']))
		{
			$this->editSmiley();
		}
	}
/**
* Add Smiley Form
*
* Opens the add smiley form template and displays it
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function addSmileyForm()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("add_smiley_form","templates/add_smiley_form.tpl");
		
		$add_smiley_form_array= Array(
			'error'=>$this->error,
		);
		
		$tpl->parseTemplate("add_smiley_form",$add_smiley_form_array,"No");
		$tpl->printTemplate("add_smiley_form");
		
		
	}
/**
* Add Smiley 
*
* Adds the smiley to the database and uploads it if needed
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function addSmiley()
	{
		global $mysql,$tpl,$fn;
		if (empty($_POST['symbol']))
		{
			$error .="Symbol left blank<br>";
		}
		
		if (empty($_POST['image_url']) && $_POST['upload_image']==0)
		{
			$error .="Image URL was left blank<br>";
		}
		if (empty($_FILES['filename']) && $_POST['upload_image']==1)
		{
			$error .="File was not uploaded<br>";
		}
		if (!empty($error))
		{
			$this->error="<b>You have the following errors</b><br><br>";
			$this->error .=$error;
			$this->admin->header();
			$this->addSmileyForm();
		}
		else
		{
			// Now we'll upload the file
			if ($_POST['upload_image']==1) 
			{
				if (!file_exists($fn->CONFIG['smiley_path'].$_FILES['filename']['name']."")) 
				{
					if (!move_uploaded_file($_FILES['filename']['tmp_name'],$fn->CONFIG['smiley_path'].$_FILES['filename']['name']."")) 
					{
						$error .="Unable to move image<br>";
					} 
					else 
					{
						$uploaded_image=1;
						@chmod($CONFIG['smiley_path'].$_FILES['filename']['name'],0644);
					}
				} 
				else 
				{
					$error .="Image with that name has already been uploaded<br>";
				}
			} 
			else 
			{
				$uploaded_image=0;
			}
			if (!empty($error))
			{
				if ($uploaded_image==1) {
					unlink($fn->CONFIG['smiley_path'].$_FILES['filename']['name']);
				}
				$this->error="<b>You have the following errors</b><br><br>";
				$this->error .=$error;
				$this->admin->header();
				$this->addSmileyForm();
			}
			else
			{	
				$insert_array= Array(
					'symbol'=>$_POST['symbol'],
					'uploaded_file'=>$_POST['upload_image'],
					'image_url'=>$_POST['image_url'],
					'filename'=>$_FILES['filename']['name'],
					
				);
				$mysql->makeInsertString($insert_array);
				$mysql->query("INSERT INTO ".$fn->CONFIG['db_prefix']."smilies ($mysql->insert_fields) VALUES 	($mysql->insert_values)");
				$fn->redirectionSuccess("index.php?action=main",10,"You have successfully added a smiley you'll be redirected to the main admin page in 10 seconds");
			}
		}
	}
/**
* List of Smilies
*
* Displays the current list of smilies and their corresponding image
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class
*/	
	function smileyList()
	{
		global $mysql,$tpl,$fn;
		$this->smileyListHeader();
		if (empty($_REQUEST['page'])) 
		{
			$_REQUEST['page']=1;
		}
		// Divides news up so we got page stuff
		
		$fn->divideData("SELECT COUNT(*) AS count FROM ".$fn->CONFIG['db_prefix']."smilies LIMIT 0,1" ,$_REQUEST['page'],20);
		$tpl->loadTemplate("smiley_list","templates/smiley_list.tpl");
		$mysql->Query("SELECT * FROM ".$fn->CONFIG['db_prefix']."smilies LIMIT $fn->data_bottom,$fn->data_per_page");
		while ($show_smiley=mysql_fetch_array($mysql->result_id))
		{
			$fn->stripArray($show_smiley);
			if ($show_smiley[uploaded_file]==0)
			{
				
				$image="<img src=\"$show_smiley[image_url]\">";
			}
			else
			{
				$image="<img src=\"".$fn->CONFIG['smiley_url']."$show_smiley[filename]\">";
				
			}
			$smiley_list_array= Array(
				'symbol'=>$show_smiley[symbol],
				'image'=>$image,
				'smiley_id'=>$show_smiley[smiley_id],
			);
			$tpl->parseTemplate("smiley_list",$smiley_list_array,"Yes");
			$has_smiley=1;
		}
		
		if ($has_smiley==1)
		{
			$tpl->printTemplate("smiley_list");
		}
		else
		{
			$this->admin->error("There are currently no smilies in the database");
		}
		$this->smileyListFooter();
		
	}
/**
* Smiley List Header
*
* Displays the header for the smiley list pages
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/		
	function smileyListHeader()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("smiley_list_header","templates/smiley_list_header.tpl");
		
		$smiley_list_header_array= Array(
			'error'=>$this->error,
		);
		
		$tpl->parseTemplate("smiley_list_header",$smiley_list_header_array,"No");
		$tpl->printTemplate("smiley_list_header");
		
	}
/**
* Smiley List Footer
*
* Displays the footer for the smiley list pages
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function smileyListFooter()
	{
		global $mysql,$tpl,$fn;
		$fn->makePages("<a href=\"index.php?action=smiley_list&page={eachpage}\">{eachpage}</a>&nbsp;","<b>{page}</b>&nbsp;","<a href=\"index.php?action=smiley_list&page=1\"> First Page</a>&nbsp;","<a href=\"index.php?action=smiley_list&page={eachpage}\">Last Page </a>",$_REQUEST['page'],$fn->num_pages);
		$tpl->loadTemplate("smiley_list_footer","templates/smiley_list_footer.tpl");
		
		$smiley_list_footer_array= Array(
			'num_pages'=>$fn->num_pages,
			'page_list'=>$fn->pages,
		);
		
		$tpl->parseTemplate("smiley_list_footer",$smiley_list_footer_array,"No");
		$tpl->printTemplate("smiley_list_footer");
		
	}
/**
* Delete Smiley
*
* Deletes the Smiley from the mysql database and the server if it was uploaded
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function deleteSmiley()
	{
		global $mysql,$tpl,$fn;
		$mysql->query("DELETE FROM ".$fn->CONFIG['db_prefix']."smilies WHERE smiley_id=".$_REQUEST['id']."");
		$fn->redirectionSuccess("index.php?action=smiley_list",10,"You have successfully deleted that smiley you'll be redirected to the smiley list again in 10 seconds");
		
	}
/**
* Edit Smiley Form
*
* The Edit Smiley Form
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function editSmileyForm()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("edit_smiley_form","templates/edit_smiley_form.tpl");
		
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."smilies WHERE smiley_id=".$_REQUEST['id']."");
		$show_smiley=mysql_fetch_array($mysql->result_id);
		$edit_smiley_form_array= Array(
			'error'=>$this->error,
			'symbol'=>$show_smiley[symbol],
			'image_url'=>$show_smiley[image_url],
			'smiley_id'=>$show_smiley[smiley_id],
		);
		
		$tpl->parseTemplate("edit_smiley_form",$edit_smiley_form_array,"No");
		$tpl->printTemplate("edit_smiley_form");
		
		
		
	}
/**
* Edit Smiley
*
* Edits the smiley in the mysql database and the server if it was uploaded
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function editSmiley()
	{
		global $mysql,$tpl,$fn;
		if (empty($_POST['symbol']))
		{
			$error .="Symbol left blank<br>";
		}
		if (!empty($error))
		{
			$this->error="<b>You have the following errors</b><br><br>";
			$this->error .=$error;
			$this->admin->header();
			$this->editSmileyForm();
		}
		else
		{
			// Time to grab some of the smilies info
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."smilies WHERE smiley_id=".$_POST['smiley_id']."");
			$show_smiley=mysql_fetch_array($mysql->result_id);
			// Now we'll upload the file
			if ($_POST['new_upload_image']==1) 
			{
				if (!file_exists($fn->CONFIG['smiley_path'].$_FILES['filename']['name']."") || $show_smiley[filename]==$_FILES['filename']['name']) 
				{
					if (!move_uploaded_file($_FILES['filename']['tmp_name'],$fn->CONFIG['smiley_path'].$_FILES['filename']['name']."")) 
					{
						$error .="Unable to move image<br>";
					} 
					else 
					{
						$uploaded_image=1;
						@chmod($CONFIG['avatar_path'].$_FILES['filename']['name'],0644);
					}
				} 
				else 
				{
					$error .="Image with that name has already been uploaded<br>";
				}
			} 
			else 
			{
				$uploaded_image=0;
			}
			if (!empty($error))
			{
				if ($uploaded_image==1) {
					unlink($fn->CONFIG['smiley_path'].$_FILES['filename']['name']);
				}
				$this->error="<b>You have the following errors</b><br><br>";
				$this->error .=$error;
				$this->admin->header();
				$this->editSmileyForm();
			}
			else
			{
				if ($_POST['new_upload_image']==1)
				{	
					$update_array= Array(
						'symbol'=>$_POST['symbol'],
						'image_url'=>$_POST['image_url'],
						'filename'=>$_FILES['filename']['name'],
						'uploaded_file'=>$_POST['new_upload_image'],
					);
					
				}
				else
				{
					$update_array= Array(
						'symbol'=>$_POST['symbol'],
						'image_url'=>$_POST['image_url'],
						
					);
				}
				$mysql->makeUpdateString($update_array);
				$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."smilies SET $mysql->update_string WHERE smiley_id=".$_REQUEST['smiley_id']."");
				$fn->redirectionSuccess("index.php?action=smiley_list",10,"You have successfully edited a smiley you'll be redirected to the smiley list page in 10 seconds");
			}
		}
	}	
}
?>