<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | newstip.php                                                          |
// +----------------------------------------------------------------------+

/**
* Newstip Class
*
* Does all News admin related stuff
* @author Tony Baird
* @version 2.0
* @access public
* @since 08-05-2004
*/
class Newstip
{
/**
* Newstip Constructor
*
* Figures out what newstip methods we're going to use
*/
	function Newstip($admin)
	{
		$this->admin=$admin;
		if ($_REQUEST['action']=="newstip_list")
		{
			$this->newstipList();
		}
		else if ($_REQUEST['action']=="use_newstip")
		{
			$this->useNewstip();
		}
		else if ($_REQUEST['action']=="delete_newstip")
		{
			$this->deleteNewstip();
		}
	}
/**
* News List
*
* Displays all the news currently in the database
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function newstipList()
	{
		global $tpl,$fn,$mysql;
		if (empty($_REQUEST['page']))
		{
			$_REQUEST['page']=1;
		}
		$fn->divideData("SELECT COUNT(*) AS count FROM ".$fn->CONFIG['db_prefix']."newstips WHERE active=1 LIMIT 0,1" ,$_REQUEST['page'],20);
		$tpl->loadTemplate("newstip_list","templates/newstip_list.tpl");
		$mysql->Query("SELECT newstip.*,user.* FROM ".$fn->CONFIG['db_prefix']."newstips newstip,".$fn->CONFIG['db_prefix']."users user WHERE newstip.active=1 AND newstip.user_id=user.user_id LIMIT $fn->data_bottom,$fn->data_per_page");
		while ($show_newstip=mysql_fetch_array($mysql->result_id))
		{
			$fn->stripArray($show_newstip);
			$newstip_list_array= Array(
				'username'=>$show_newstip[username],
				'newstip_id'=>$show_newstip[newstip_id],
				'source'=>$show_newstip[source],
			);
			$tpl->parseTemplate("newstip_list",$newstip_list_array,"Yes");
			$has_newstip=1;
		}
		$this->newstipListHeader();
		if ($has_newstip==1)
		{
			$tpl->printTemplate("newstip_list");
		}
		else
		{
			$this->admin->error("There are currently no newstips in the database");
		}
		$this->newstipListFooter();
	}
/**
* news List Header
*
* Opens up the news list header template and parses it
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function newstipListHeader()
	{
		global $tpl,$fn,$mysql;
		$tpl->loadTemplate("newstip_list_header","templates/newstip_list_header.tpl");
		/*
		$newstip_list_header_form_array= Array(
			'var'=>$var,
		);
		*/
		$tpl->parseTemplate("newstip_list_header",$newstip_list_header_array,"No");
		$tpl->printTemplate("newstip_list_header");	
	}
/**
* news List Footer
*
* Opens up the news list footer template and parses it
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function newstipListFooter()
	{
		global $tpl,$fn,$mysql;
		$fn->makePages("<a href=\"index.php?action=newstip_list&page={eachpage}\">{eachpage}</a>&nbsp;","<b>{page}</b>&nbsp;","<a href=\"index.php?action=newstip_list&page=1\"> First Page</a>&nbsp;","<a href=\"index.php?action=newstip_list&page={eachpage}\">Last Page </a>",$_REQUEST['page'],$fn->num_pages);
		$tpl->loadTemplate("newstip_list_footer","templates/newstip_list_footer.tpl");
		
		$newstip_list_footer_array= Array(
			'num_pages'=>$fn->num_pages,
			'page_list'=>$fn->pages,
		);
		
		$tpl->parseTemplate("newstip_list_footer",$newstip_list_footer_array,"No");
		$tpl->printTemplate("newstip_list_footer");	
	}
/**
* Delete Newstip
*
* Deletes the newstip entry from the database and updates some stats
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function deleteNewstip()
	{
		global $tpl,$fn,$mysql;
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."newstips WHERE newstip_id=".$_REQUEST['id']."");
		$show_newstip=mysql_fetch_array($mysql->result_id);
		$mysql->query("DELETE FROM ".$fn->CONFIG['db_prefix']."newstips WHERE newstip_id=".$_REQUEST['id']."");
		$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."users SET num_newstips=num_newstips-1 WHERE user_id=$show_newstip[user_id]");
		$fn->redirectionSuccess("index.php?action=newstip_list",10,"You have successfully deleted that newstip entry");	
	}
/**
* Use Newstip
*
* Displays the newstip then the post news form
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function useNewstip()
	{
		global $tpl,$fn,$mysql;
		$mysql->query("SELECT newstip.*,user.* FROM ".$fn->CONFIG['db_prefix']."newstips newstip, ".$fn->CONFIG['db_prefix']."users user WHERE newstip_id=".$_REQUEST['id']." AND newstip.user_id=user.user_id");
		$show_newstip=mysql_fetch_array($mysql->result_id);
		$tpl->loadTemplate("newstip","templates/newstip.tpl");
		require_once("news.php");
		$news=new News($this->admin);
		if ($fn->CONFIG['html_editor']==1 && (empty($_REQUEST['editor']) || $_REQUEST['editor'] !=0))
		{
			$html_editor=$news->generateEditor();
		}
		else
		{
			$html_editor="";
		}
		
		$newstip_array= Array(
			'source'=>$show_newstip[source],
			'html_editor'=>$html_editor,
			'newstip'=>$show_newstip[newstip],
			'username'=>$show_newstip[username],
		);
		// This is set so the post news function knows the newstip id and what to do with it
		$newstip_id=$show_newstip[newstip_id];
		$tpl->parseTemplate("newstip",$newstip_array,"No");
		$tpl->printTemplate("newstip");	
		$news->postNewsForm();
	}
}
?>