<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | news.php                                                             |
// +----------------------------------------------------------------------+
/**
* News Class
*
* Does all News admin related stuff
* @author Tony Baird
* @version 2.0
* @access public
* @since 07-28-2004
*/
class News
{
/**
* News Constructor
*
* Figures out what news methods we're going to use
*/
	function News($admin)
	{
		$this->admin=$admin;
		if ($_REQUEST['action']=="post_news")
		{
			if ($this->admin->checkAccess("@7"))
			{
				$this->postNewsForm();
			}
			else
			{
				$this->admin->error("Insufficient Access");
			}
			
		}
		else if (isset($_REQUEST['postnews']))
		{
			if ($this->admin->checkAccess("@7"))
			{
				$this->postNews();
			}
			else
			{
				$this->admin->error("Insufficient Access");
			}
		}
		else if ($_REQUEST['action']=="news_list")
		{
			if ($this->admin->checkAccess("@8") || $this->admin->checkAccess("@9") || $this->admin->checkAccess("@10") || $this->admin->checkAccess("@11"))
			{
				$this->newsList();
			}
			else
			{
				$this->admin->error("Insufficient Access");
			}
			
			
		}
		else if ($_REQUEST['action']=="edit_news")
		{
			if ($this->admin->checkAccess("@8") || $this->admin->checkAccess("@9"))
			{
				$this->editNewsForm();
			}
			else
			{
				$this->admin->error("Insufficient Access");
			}
		}
		else if (isset($_REQUEST['editnews']))
		{
			if ($this->admin->checkAccess("@8") || $this->admin->checkAccess("@9"))
			{
				$this->editNews();
			}
			else
			{
				$this->admin->error("Insufficient Access");
			}
		}
		else if ($_REQUEST['action']=="delete_news")
		{
			if ($this->admin->checkAccess("@9") || $this->admin->checkAccess("@11"))
			{
				$this->deleteNews();
			}
			else
			{
				$this->admin->error("Insufficient Access");
			}
		}
		else if ($_REQUEST['action']=="remove_attachment")
		{
			if ($this->admin->checkAccess("@8") || $this->admin->checkAccess("@9"))
			{
				$this->removeAttachment();
			}
			else
			{
				$this->admin->error("Insufficient Access");
			}
			
			
		}
	}
/**
* Post News Form
*
* Creates the post news form
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function postNewsForm()
	{
		global $tpl,$fn,$mysql,$newstip_id;
		// First we'll grab the news list from the database
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."categories ORDER BY category ASC");
		while ($show_category=mysql_fetch_array($mysql->result_id))
		{
			$category_list .="<option value=\"$show_category[category_id]\">$show_category[category]</option>";
		}
		$smiley_list="";
		// Smiley List
		$smiley_list="";
		if ($fn->CONFIG['smilies']==1)
		{
			$mysql->Query("SELECT * FROM ".$fn->CONFIG['db_prefix']."smilies");
			while ($show_smiley=mysql_fetch_array($mysql->result_id))
			{
				if ($fn->CONFIG['html_editor']==0)
				{
					if ($show_smiley[uploaded_file]==0)
					{
						
						$smiley_list .="<a href=\"javascript:smile('$show_smiley[symbol]')\"><img src=\"$show_smiley[image_url]\" border=\"0\"></a> ";
					}
					else
					{
						$smiley_list .="<a href=\"javascript:smile('$show_smiley[symbol]')\"><img src=\"".$fn->CONFIG['smiley_url']."$show_smiley[filename]\" border=\"0\"></a> ";
					}
				}
				else 
				{
					if ($show_smiley[uploaded_file]==0)
					{
						
						$smiley_list .="<img src=\"$show_smiley[image_url]\" border=\"0\">";
					}
					else
					{
						$smiley_list .="<img src=\"".$fn->CONFIG['smiley_url']."$show_smiley[filename]\" border=\"0\">";
					}	
				}
			}
		}
		$tpl->loadTemplate("post_news_form","templates/post_news_form.tpl");
		if ($fn->CONFIG['html_editor']==1 && (empty($_REQUEST['editor']) || $_REQUEST['editor'] !=0))
		{
			$form_news=$this->generateEditor("news","");
			$form_read_more_news=$this->generateEditor("read_more_news","");
			

		}
		else
		{
			
			$form_news='<textarea rows="50" name="news" cols="100"></textarea>';
			$form_read_more_news='<textarea rows="50" name="read_more_news" cols="100"></textarea>';
		}
		
		$post_news_form_array= Array(
			'category_list'=>$category_list,
			'newstip_id'=>$_REQUEST['id'],
			'smiley_list'=>$smiley_list,
			'form_news'=>$form_news,
			'form_read_more_news'=>$form_read_more_news,
		);
		$tpl->parseTemplate("post_news_form",$post_news_form_array,"No");
		$tpl->printTemplate("post_news_form");
	}
/**
* Post News 
*
* Adds News to the Database and also uploads a file if the user chose to upload one
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function postNews()
	{
		global $tpl,$fn,$mysql;
		if (empty($_POST['subject']))
		{
			$error .="Missing Subject<br>";
		}
		if (empty($_POST['news']))
		{
			$error .="Missing news<br>";
		}
		if (empty($_POST['category']))
		{
			$error .="Missing Category";
		}
		if (empty($_POST['news']))
		{
			$error .="Please add a news by using the add news option before using this feature<br>";
		}
		if (!empty($_FILES['file']['name'])) 
		{
			if (!file_exists($fn->CONFIG['uploads_path'].$_FILES['file']['name']."")) 
			{
				if (!move_uploaded_file($_FILES['file']['tmp_name'],$fn->CONFIG['uploads_path'].$_FILES['file']['name']."")) 
				{
					$error .="Unable to move file<br>";
				} 
				else 
				{
					$uploaded_file="Yes";
					@chmod($CONFIG['uploads_path'].$_FILES['file']['name'],0644);
				}
			} 
			else 
			{
				$error .="File with that name has already been uploaded<br>";
			}
		} 
		else 
		{
			$uploaded_file="No";
		}
		if (!empty($error))
		{
			
			$this->admin->error($error);
		}
		else
		{
			// Incase this was sent from the newstip thing
			if (!empty($_POST['newstip_id']))
			{
				$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."newstips SET active=0 WHERE newstip_id=".$_REQUEST['newstip_id']."");
			}
			// Date stuff for archive
			$actual_date=date("F j Y", $fn->time);
			$month=date("F", $fn->time);
			$year=date("Y", $fn->time);
			$_POST['news']=$this->parseNews($_POST['news']);
			$_POST['read_more_news']=$this->parseNews($_POST['read_more_news']);
			$_POST=$fn->slashArray($_POST);
			$insert_array= Array(
				'subject'=>$_POST['subject'],
				'date'=>$fn->time,
				'news_id'=>$_POST['news'],
				'category_id'=>$_POST['category'],
				'actual_date'=>$actual_date,
				'date_month'=>$month,
				'date_year'=>$year,
				'news'=>$_POST['news'],
				'upload_file'=>$upload_file,
				'read_more_news'=>$_POST['read_more_news'],
				'filename'=>$_FILES['file']['name'],
				'filesize'=>$_FILES['file']['size'],
				'upload_file'=>$uploaded_file,
				'user_id'=>$this->admin->user_id,
				'sticky'=>$_POST['sticky'],
					
			);
			$mysql->makeInsertString($insert_array);
			$mysql->query("INSERT INTO ".$fn->CONFIG['db_prefix']."news ($mysql->insert_fields) VALUES 	($mysql->insert_values)");
			$fn->redirectionSuccess("index.php?action=main",10,"You have successfully posted news you'll be redirected to the main page in 10 seconds");	
		}	
	}
/**
* News List
*
* Displays all the news currently in the database
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function newsList()
	{
		global $tpl,$fn,$mysql;
		$edit_self=0;
		$delete_self=0;
		$edit_others=0;
		$delete_others=0;
		
		$this->newsListHeader();
		if (empty($_REQUEST['page'])) 
		{
			$_REQUEST['page']=1;
		}
		// Figures out what where statement we need and also what kind of access the user has
		if ($this->admin->checkAccess("@8"))
		{
			$edit_self=1;
		}
		if ($this->admin->checkAccess("@9"))
		{
			$delete_self=1;
			
		}
		if ($this->admin->checkAccess("@10"))
		{
			$edit_others=1;
			
		}
		if ($this->admin->checkAccess("@11"))
		{
			$delete_others=1;
			
		}
		if (($edit_self==1 || $delete_self==1) && ($edit_others==0 && $delete_others==0))
		{
			$where="WHERE user_id=".$this->admin->user_id."";
			$second_sql_where="news.user_id=".$this->admin->user_id."";
			
		}
		else if (($edit_self==1 || $delete_self==1) && ($edit_others==1 || $delete_others==1))
		{
			$where="";
			$edit_others=1;
		}
		$fn->divideData("SELECT COUNT(*) AS count FROM ".$fn->CONFIG['db_prefix']."news $where LIMIT 0,1" ,$_REQUEST['page'],20);
		$tpl->loadTemplate("news_list","templates/news_list.tpl");
		$mysql->Query("SELECT news.*, category.* FROM ".$fn->CONFIG['db_prefix']."news news,".$fn->CONFIG['db_prefix']."categories category WHERE news.category_id=category.category_id $second_sql_where ORDER BY news.news_id DESC LIMIT $fn->data_bottom,$fn->data_per_page");
		while ($show_news=mysql_fetch_array($mysql->result_id))
		{
			$options="";
			$fn->stripArray($show_news);
			if ($show_news[user_id]==$this->admin->user_id)
			{
				if ($edit_self==1)
				{
					$options .="[ <a href=\"index.php?action=edit_news&id=$show_news[news_id]\">Edit News</a>";
				}
				if ($delete_self==1)
				{
					if ($edit_self==1)
					{
						$options .=" | <a href=\"index.php?action=delete_news&id=$show_news[news_id]\" onclick=\"return cAction('Are you sure you want to remove this news item?')\">Delete News</a> ]";
					}
					else
					{
						$options .="[ <a href=\"index.php?action=delete_news&id=$show_news[news_id]\">Delete News</a> ]";
					}	
				}
				
			}
			else
			{
				if ($edit_others==1)
				{
					$options .="[ <a href=\"index.php?action=edit_news&id=$show_news[news_id]\">Edit News</a>";
				}
				if ($delete_others==1)
				{
					if ($edit_others==1)
					{
						$options .=" || <a href=\"index.php?action=delete_news&id=$show_news[news_id]\" onclick=\"return cAction('Are you sure you want to remove this badword?')\">Delete News</a> ]";
					}
					else
					{
						$options .="[ <a href=\"index.php?action=delete_news&id=$show_news[news_id]\">Delete News</a> ]";
					}	
				}
				
				
			}
			$news_list_array= Array(
				'subject'=>$show_news[subject],
				'category'=>$show_news[category],
				'news_id'=>$show_news[news_id],
				'options'=>$options,
			);
			$tpl->parseTemplate("news_list",$news_list_array,"Yes");
			$has_news=1;
		}
		
		if ($has_news==1)
		{
			$tpl->printTemplate("news_list");
		}
		else
		{
			$this->admin->error("There are currently no categories in the database");
		}
		$this->newsListFooter();
	}
/**
* news List Header
*
* Opens up the news list header template and parses it
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function newsListHeader()
	{
		global $tpl,$fn,$mysql;
		$tpl->loadTemplate("news_list_header","templates/news_list_header.tpl");
		/*
		$news_list_header_form_array= Array(
			'var'=>$var,
		);
		*/
		$tpl->parseTemplate("news_list_header",$news_list_header_array,"No");
		$tpl->printTemplate("news_list_header");	
	}
/**
* news List Footer
*
* Opens up the news list footer template and parses it
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function newsListFooter()
	{
		global $tpl,$fn,$mysql;
		$fn->makePages("<a href=\"index.php?action=news_list&page={eachpage}\">{eachpage}</a>&nbsp;","<b>{page}</b>&nbsp;","<a href=\"index.php?action=news_list&page=1\"> First Page</a>&nbsp;","<a href=\"index.php?action=news_list&page={eachpage}\">Last Page </a>",$_REQUEST['page'],$fn->num_pages);
		$tpl->loadTemplate("news_list_footer","templates/news_list_footer.tpl");
		
		$news_list_footer_array= Array(
			'num_pages'=>$fn->num_pages,
			'page_list'=>$fn->pages,
		);
		
		$tpl->parseTemplate("news_list_footer",$news_list_footer_array,"No");
		$tpl->printTemplate("news_list_footer");	
	}
/**
* Delete News
*
* Deletes the news entry from the database and updates some stats
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function deleteNews()
	{
		global $tpl,$fn,$mysql;
		
		// fixing the number of comments the user has posted
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."comments WHERE news_id=".$_REQUEST['id']."");
		$update_sql=new Mysql;
		while ($show_comments=mysql_fetch_array($mysql->result_id))
		{
			$update_sql->query("UPDATE ".$fn->CONFIG['db_prefix']."users SET num_comments=num_comments-1 WHERE user_id=".$show_comments[user_id]."");
		}
		
		// updating the number of news posts the user has made who posted the news
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."news WHERE news_id=".$_REQUEST['id']."");
		$show_news=mysql_fetch_array($mysql->result_id);
		if ($show_news['upload_file']=="Yes")
		{
			if (!@unlink($fn->CONFIG['uploads_path'].$show_news[filename]))
			{
				echo "Unable to remove the attachment you may want to look into this";
			}
		}	
		$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."users SET num_news_posts=num_news_posts-1 WHERE user_id=$show_news[user_id]");
		
		// Deleting the news post
		$mysql->query("DELETE FROM ".$fn->CONFIG['db_prefix']."news WHERE news_id=".$_REQUEST['id']."");
		$this->rebuildXML();
		$fn->redirectionSuccess("index.php?action=news_list",10,"You have successfully deleted that news entry");	
	}
/**
* Edit News Form
*
* Gets the news and displays it on the form to edit
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function editNewsForm()
	{
		global $tpl,$fn,$mysql;
		
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."news WHERE news_id=".$_REQUEST['id']."");
		$show_news=mysql_fetch_array($mysql->result_id);
		if ($fn->CONFIG['html_editor']==1 && (empty($_REQUEST['editor']) || $_REQUEST['editor'] !=0))
		{
			$form_news=$this->generateEditor("news",$show_news['news']);
			$form_read_more_news=$this->generateEditor("read_more_news",$show_news['read_more_news']);
			

		}
		else
		{
			
			$form_news='<textarea rows="50" name="news" cols="100">'.$show_news['news'].'</textarea>';
			$form_read_more_news='<textarea rows="50" name="read_more_news" cols="100">'.$show_news['read_more_news'].'</textarea>';
		}
		if ($show_news[user_id]==$this->admin->user_id)
		{
			if (!$this->admin->checkAccess("@8"))
			{
				$this->admin->error("You do not have access to edit this news item");
			}
		}
		else
		{
			if (!$this->admin->checkAccess("@9"))
			{
				$this->admin->error("You do not have access to edit this news item");
				
			}
		}
		// Smiley List
		$smiley_list="";
		if ($fn->CONFIG['smilies']==1)
		{
			$mysql->Query("SELECT * FROM ".$fn->CONFIG['db_prefix']."smilies");
			while ($show_smiley=mysql_fetch_array($mysql->result_id))
			{
				if ($fn->CONFIG['html_editor']==0)
				{
					if ($show_smiley[uploaded_file]==0)
					{
						
						$smiley_list .="<a href=\"javascript:smile('$show_smiley[symbol]')\"><img src=\"$show_smiley[image_url]\" border=\"0\"></a> ";
					}
					else
					{
						$smiley_list .="<a href=\"javascript:smile('$show_smiley[symbol]')\"><img src=\"".$fn->CONFIG['smiley_url']."$show_smiley[filename]\" border=\"0\"></a> ";
					}
				}
				else 
				{
					if ($show_smiley[uploaded_file]==0)
					{
						
						$smiley_list .="<img src=\"$show_smiley[image_url]\" border=\"0\">";
					}
					else
					{
						$smiley_list .="<img src=\"".$fn->CONFIG['smiley_url']."$show_smiley[filename]\" border=\"0\">";
					}	
				}
			}
		}
		
		// Grabing the category list
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."categories ORDER BY category ASC");
		while ($show_category=mysql_fetch_array($mysql->result_id))
		{
			if ($show_news[category_id]==$show_category[category_id])
			{
				$category_list .="<option selected value=\"$show_category[category_id]\">$show_category[category]</option>";	
			}
			else
			{
				$category_list .="<option value=\"$show_category[category_id]\">$show_category[category]</option>";
			}
		}
		// Setting up the annoucement field
		if ($show_news[sticky]==1)
		{
			$annoucement_list="<option selected value=\"0\">Yes</option>
								<option value=\"1\">No</option>";
		}
		else
		{
			$annoucement_list="<option selected value=\"0\">No</option>
								<option value=\"1\">Yes</option>";
		}
		
		if ($show_news[upload_file]=="Yes")
		{
			$filename="$show_news[filename] (<a href=\"index.php?action=remove_attachment&id=$show_news[news_id]\">Remove</a>)";
		}
		else
		{
			$filename="None";
		}
		$tpl->loadTemplate("edit_news_form","templates/edit_news_form.tpl");
		$edit_news_form_array= Array(
			'category_list'=>$category_list,
			'news'=>$show_news[news],
			'news_id'=>$show_news[news_id],
			'read_more_news'=>$show_news[read_more_news],
			'subject'=>$show_news[subject],
			'annoucement_list'=>$annoucement_list,
			'filename'=>$filename,
			'form_news'=>$form_news,
			'form_read_more_news'=>$form_read_more_news,
			'smiley_list'=>$smiley_list,
		);
		$tpl->parseTemplate("edit_news_form",$edit_news_form_array,"No");
		$tpl->printTemplate("edit_news_form");
	}
/**
* Edit News 
*
* Edits the news and database and also does any attachment changes
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function editNews()
	{
		global $tpl,$fn,$mysql;
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."news WHERE news_id=".$_REQUEST['news_id']."");
		$show_news=mysql_fetch_array($mysql->result_id);
		if (empty($_POST['subject']))
		{
			$error .="Missing Subject<br>";
		}
		if (empty($_POST['news']))
		{
			$error .="Missing news<br>";
		}
		if (empty($_POST['news']))
		{
			$error .="Please add a news by using the add news option before using this feature<br>";
		}
		if (!empty($_FILES['file']['name'])) 
		{
			if (!file_exists($fn->CONFIG['uploads_path'].$_FILES['file']['name']."")) 
			{
				if (!move_uploaded_file($_FILES['file']['tmp_name'],$fn->CONFIG['uploads_path'].$_FILES['file']['name']."")) 
				{
					$error .="Unable to move file<br>";
				} 
				else 
				{
					$uploaded_file="Yes";
					@chmod($CONFIG['uploads_path'].$_FILES['file']['name'],0644);
				}
			} 
			else 
			{
				$error .="File with that name has already been uploaded<br>";
			}
		} 
		else 
		{
			$uploaded_file="No";
			$filename=$show_news[filename];
			$filesize=$show_news[filesize];
			$uploaded_file=$show_news[upload_file];
		}
		if (!empty($error))
		{
			
			$this->admin->error($error);
		}
		else
		{
			$_POST=$fn->slashArray($_POST);
			$update_array= Array(
				'subject'=>$_POST['subject'],
				'news'=>$_POST['news'],
				'category_id'=>$_POST['category'],
				'read_more_news'=>$_POST['read_more_news'],
				'filename'=>$filename,
				'filesize'=>$filesize,
				'upload_file'=>$uploaded_file,
				'sticky'=>$_POST['sticky'],
					
			);
			$mysql->makeUpdateString($update_array);
			$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."news SET $mysql->update_string WHERE news_id=".$_REQUEST['news_id']."");
			$this->rebuildXML();
			$fn->redirectionSuccess("index.php?action=news_list",10,"You have successfully edited that news item you'll now be redirected to the news list page in 10 seconds");	
		}	
	}
/**
* Remove Attachment 
*
* Removes the attachment from a news item and updates it's database
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function removeAttachment()
	{
		global $tpl,$fn,$mysql;
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."news WHERE news_id=".$_REQUEST['id']."");
		$show_news=mysql_fetch_array($mysql->result_id);
		if (!@unlink($fn->CONFIG['uploads_path'].$show_news[filename]))
		{
			$this->admin->error("Unable to remove the attachment");
		}
		else
		{
			$update_array= Array(
				'upload_file'=>"Yes",
				'filename'=>"",
				'filesize'=>0,
				'downloads'=>0,
					
			);
			$mysql->makeUpdateString($update_array);
			$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."news SET $mysql->update_string WHERE news_id=".$_REQUEST['id']."");
			$fn->redirectionSuccess("index.php?action=news_list",10,"You have successfully edited that news item you'll now be redirected to the news list page in 10 seconds");		
		}
	}
/**
* Generate Editor 
*
* Generates the HTML Editor
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function generateEditor($name,$value)
	{
		global $tpl,$fn,$mysql;
		include_once("FCKeditor/fckeditor.php");
		$$name = new FCKeditor($name) ;
		$$name->BasePath = 'FCKeditor/';
		$$name->Value = $value;
		$$name->Width  = '100%' ;
		$$name->Height = '600' ;

		return $$name->CreateHtml();
		
	}
/**
* Parses News items that werent made in the HTML editor
*
* Replaces smiley symbols with their images
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function parseNews($news)
	{
		global $mysql,$fn,$tpl;
		if ($fn->CONFIG['html_editor']==0)
		{
			$news=$this->smileyReplace($news);
			$news=nl2br($news);
		}
		return $news;
		
	}
	
/**
* Replaces Smilies
*
* Replaces smiley symbols with their images
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function smileyReplace($news)
	{
		global $mysql,$fn;
		if ($fn->CONFIG['smilies']==1)
		{
			$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."smilies");
			while ($show_smiley=mysql_fetch_array($mysql->result_id))
			{
				// Checks if the file was uploaded because if it was there is some
				// changes that need to be made to the url
				if ($show_smiley[uploaded_file]==1)
				{
					$news=str_replace($show_smiley[symbol],"<img src=\"".$fn->CONFIG['smiley_url'].$show_smiley[filename]."\">",$news);
				}
				else
				{
					$news=str_replace($show_smiley[symbol],"<img src=\"$show_smiley[image_url]\">",$news);
				}
			}
		}
		return $news;
	}
		/**
	* Rebuilds the XML
	*
	* Generates the XML
	* @global object $mysql instance of the mysql class
	* @global object $fn instance of the Fantastic News function class
	*/
	function rebuildXML()
	{
		global $mysql,$fn;
		
		// Stops issue with Broken configs messing up the query
		if ($fn->CONFIG['xml_amount']>0)
		{
			// First grab the data
			$mysql->Query("SELECT n.*, c.*, u.user_id,u.username FROM 
				".$fn->CONFIG['db_prefix']."news n,  
				".$fn->CONFIG['db_prefix']."users u LEFT JOIN 
				".$fn->CONFIG['db_prefix']."categories c
				ON c.category_id=n.category_id WHERE 
				n.user_id=u.user_id AND n.sticky=0  
				ORDER BY date DESC LIMIT ".$fn->CONFIG['xml_amount']."");
			if (!$xml_file=@fopen("../news.xml","w+"))
			{
				$this->admin->error("Unable to load xml file");
			}
			$data .='<?xml version="1.0" encoding="iso8859-1" ?>';
			$data .="\n\r";
			$data .='<news-list>';
			$data .="\n\r";
			while ($show_news=mysql_fetch_array($mysql->result_id))
			{
				// Generating XML
				
				$data .='<news newsid="'.utf8_encode($show_news['news_id']).'">';
				$data .="\n\r";
				$data .='<date>'.utf8_encode(date($fn->CONFIG['date_format'],$show_news['date'])).'</date>';
				$data .="\n\r";
				$data .='<subject>'.utf8_encode($show_news['subject']).'</subject>';
				$data .="\n\r";
				$data .='<author>'.utf8_encode($show_news['username']).'</author>';
				$data .="\n\r";
				if ($fn->CONFIG['xml_news']==1)
				{
					$show_news['news']=str_replace("\n","",$show_news['news']);
					$show_news['news']=str_replace("\r","",$show_news['news']);
					$show_news['news']=str_replace("<br>","\r\n",$show_news['news']);
					$show_news['news']=str_replace("<br/>","\r\n",$show_news['news']);
					$show_news['news']=str_replace("&nbsp;","",$show_news['news']);
					$data .='<body>'.strip_tags(utf8_encode($show_news['news'])).'</body>';
					$data .="\n\r";
					
				}
				
				if ($fn->CONFIG['xml_read_more_news']==1)
				{
					$show_news['read_more_news']=str_replace("\n","",$show_news['read_more_news']);
					$show_news['read_more_news']=str_replace("\r","",$show_news['read_more_news']);
					$show_news['read_more_news']=str_replace("<br>","\r\n",$show_news['read_more_news']);
					$show_news['read_more_news']=str_replace("<br/>","\r\n",$show_news['read_more_news']);
					
					$show_news['read_more_news']=str_replace("&nbsp;","",$show_news['read_more_news']);
					$data .='<body_more>'.strip_tags(utf8_encode($show_news['read_more_news'])).'</body_more>';
					$data .="\n\r";
					
				}
				$data .='</news>';
				$data .="\n\r";
			}
			$data .='</news-list>';
			if(!fwrite($xml_file,$data)) 
			{
				$this->admin->error("Unable to write to xml file");
			}
		}
	}
}


?>