<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | maintenance.php                                                      |
// +----------------------------------------------------------------------+

/**
* Maintenance Class
*
* Does all maintenance related functions
* @author Tony Baird
* @version 2.0
* @access public
* @since 08-07-2004
*/
class Maintenance
{
/**
* Maintenance Constructor
*
* Figures out what maintenance method we're using
*/
	function Maintenance($admin)
	{
		$this->admin=$admin;
		if ($_REQUEST['action']=="edit_settings")
		{
			$this->editSettingsForm();
		}
		else if (isset($_REQUEST['edit_settings']))
		{
			$this->editSettings();
		}
		else if ($_REQUEST['action']=="update")
		{
			$this->update();
		}
		else if ($_REQUEST['action']=="build_xml")
		{
			$this->buildXML();
		}
	}
/**
* Edit Settings Form
*
* Grabs all the settings and displays them on the form
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function editSettingsForm()
	{
		global $tpl,$fn,$mysql;
		$tpl->loadTemplate("edit_settings_form","templates/edit_settings_form.tpl");
		if ($fn->CONFIG['smilies']==1)
		{
			$smilies="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$smilies="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['gzip']==1)
		{
			$gzip="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$gzip="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['newstips']==1)
		{
			$newstips="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$newstips="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['include_news_php']==1)
		{
			$include_news_php="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$include_news_php="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['one_comments_page']==1)
		{
			$one_comments_page="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$one_comments_page="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['guest_comments']==1)
		{
			$guest_comments="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$guest_comments="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['guest_news_ratings']==1)
		{
			$guest_news_ratings="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$guest_news_ratings="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['search_news']==1)
		{
			$search_news="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$search_news="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['send_to_friend']==1)
		{
			$send_to_friend="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$send_to_friend="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		
		if ($fn->CONFIG['html_editor']==1)
		{
			$html_editor="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$html_editor="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		if ($fn->CONFIG['xml']==1)
		{
			$xml="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$xml="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		if ($fn->CONFIG['xml_news']==1)
		{
			$xml_news="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$xml_news="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		if ($fn->CONFIG['xml_read_more_news']==1)
		{
			$xml_read_more_news="<option selected value=\"1\">Yes</option>
						<option value=\"0\">No</option>";
		}
		else
		{
			$xml_read_more_news="<option selected value=\"0\">No</option>
						<option value=\"1\">Yes</option>";
		}
		//$fn->stripArray($fn->CONFIG);
		$edit_settings_form_array= Array(
			'mysql_username'=>$fn->CONFIG['mysql_username'],
			'mysql_password'=>$fn->CONFIG['mysql_password'],
			'mysql_db'=>$fn->CONFIG['mysql_db'],
			'mysql_host'=>$fn->CONFIG['mysql_host'],
			'db_prefix'=>$fn->CONFIG['db_prefix'],
			'news_per_page'=>$fn->CONFIG['news_per_page'],
			'num_headlines'=>$fn->CONFIG['num_headlines'],
			'news_order_by'=>$fn->CONFIG['news_order_by'],
			'smilies'=>$smilies,
			'date_format'=>$fn->CONFIG['date_format'],
			'uploads_path'=>$fn->CONFIG['uploads_path'],
			'uploads_url'=>$fn->CONFIG['uploads_url'],
			'time_offset'=>$fn->CONFIG['time_offset'],
			'gzip'=>$gzip,
			'script_path'=>$CONFIG['script_path'],
			'gzip_level'=>$fn->CONFIG['gzip_level'],
			'newstips'=>$newstips,
			'include_news_php'=>$include_news_php,
			'one_comments_page'=>$one_comments_page,
			'comments_per_page'=>$fn->CONFIG['comments_per_page'],
			'guest_comments'=>$guest_comments,
			'user_cookie_time'=>$fn->CONFIG['user_cookie_time'],
			'flood_time'=>$fn->CONFIG['flood_time'],
			'guest_news_ratings'=>$guest_news_ratings,
			'smiley_path'=>$fn->CONFIG['smiley_path'],
			'smiley_url'=>$fn->CONFIG['smiley_url'],
			'search_news'=>$search_news,
			'send_to_friend'=>$send_to_friend,
			'send_to_friend_flood_time'=>$fn->CONFIG['send_to_friend_flood_time'],
			'site_url'=>$fn->CONFIG['site_url'],
			'html_editor'=>$html_editor,
			'xml'=>$xml,
			'xml_amount'=>$fn->CONFIG['xml_amount'],
			'xml_news'=>$xml_news,
			'xml_read_more_news'=>$xml_read_more_news,
		);
		$tpl->parseTemplate("edit_settings_form",$edit_settings_form_array,"No");
		$tpl->printTemplate("edit_settings_form");	
	}
/**
* Edit Settings
*
* Updates the settings for the installation of FNews
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function editSettings()
	{
		global $tpl,$fn,$mysql;
		$fn->slashArray($_POST);
		$new_settings .="<?php\n";
		$new_settings .='$CONFIG[\'mysql_username\']="'.$_POST['mysql_username']."\";\n";
		$new_settings .='$CONFIG[\'mysql_password\']="'.$_POST['mysql_password']."\";\n";
		$new_settings .='$CONFIG[\'mysql_db\']="'.$_POST['mysql_db']."\";\n";
		$new_settings .='$CONFIG[\'mysql_host\']="'.$_POST['mysql_host']."\";\n";
		$new_settings .='$CONFIG[\'db_prefix\']="'.$_POST['db_prefix']."\";\n";
		$new_settings .='$CONFIG[\'news_per_page\']="'.$_POST['news_per_page']."\";\n";
		$new_settings .='$CONFIG[\'num_headlines\']="'.$_POST['num_headlines']."\";\n";
		$new_settings .='$CONFIG[\'news_order_by\']="'.$_POST['news_order_by']."\";\n";
		$new_settings .='$CONFIG[\'smilies\']="'.$_POST['smilies']."\";\n";
		$new_settings .='$CONFIG[\'date_format\']="'.$_POST['date_format']."\";\n";
		$new_settings .='$CONFIG[\'uploads_path\']="'.$_POST['uploads_path']."\";\n";
		$new_settings .='$CONFIG[\'uploads_url\']="'.$_POST['uploads_url']."\";\n";
		$new_settings .='$CONFIG[\'time_offset\']="'.$_POST['time_offset']."\";\n";
		$new_settings .='$CONFIG[\'gzip\']="'.$_POST['gzip']."\";\n";
		$new_settings .='$CONFIG[\'gzip_level\']="'.$_POST['gzip_level']."\";\n";
		$new_settings .='$CONFIG[\'newstips\']="'.$_POST['newstips']."\";\n";
		$new_settings .='$CONFIG[\'include_news_php\']="'.$_POST['include_news_php']."\";\n";
		$new_settings .='$CONFIG[\'one_comments_page\']="'.$_POST['one_comments_page']."\";\n";
		$new_settings .='$CONFIG[\'comments_per_page\']="'.$_POST['comments_per_page']."\";\n";
		$new_settings .='$CONFIG[\'guest_comments\']="'.$_POST['guest_comments']."\";\n";
		$new_settings .='$CONFIG[\'user_cookie_time\']="'.$_POST['user_cookie_time']."\";\n";
		$new_settings .='$CONFIG[\'flood_time\']="'.$_POST['flood_time']."\";\n";
		$new_settings .='$CONFIG[\'guest_news_ratings\']="'.$_POST['guest_news_ratings']."\";\n";
		$new_settings .='$CONFIG[\'smiley_path\']="'.$_POST['smiley_path']."\";\n";
		$new_settings .='$CONFIG[\'smiley_url\']="'.$_POST['smiley_url']."\";\n";
		$new_settings .='$CONFIG[\'search_news\']="'.$_POST['search_news']."\";\n";
		$new_settings .='$CONFIG[\'send_to_friend\']="'.$_POST['send_to_friend']."\";\n";
		$new_settings .='$CONFIG[\'send_to_friend_flood_time\']="'.$_POST['send_to_friend_flood_time']."\";\n";
		$new_settings .='$CONFIG[\'site_url\']="'.$_POST['site_url']."\";\n";
		$new_settings .='$CONFIG[\'html_editor\']="'.$_POST['html_editor']."\";\n";
		$new_settings .='$CONFIG[\'xml\']="'.$_POST['xml']."\";\n";
		$new_settings .='$CONFIG[\'xml_amount\']="'.$_POST['xml_amount']."\";\n";
		$new_settings .='$CONFIG[\'xml_news\']="'.$_POST['xml_news']."\";\n";
		$new_settings .='$CONFIG[\'xml_read_more_news\']="'.$_POST['xml_read_more_news']."\";\n";
		$new_settings .='$CONFIG[\'script_path\']="'.$_POST['script_path']."\";\n";
		
		$new_settings .="?>";
		if ($config_file=fopen("../config.php","w+")) 
		{
			if (!fwrite($config_file,$new_settings)) 
			{
				$this->admin->error("Unable To Write to configuration file");
			}
		} 
		else 
		{
			$this->admin->error("Failed to open config file");
		}
		$fn->redirectionSuccess("index.php?action=main",5,"You have successfully edited your settings you'll be redirected back to the main page in 5 seconds");
		
	}
/**
* Update FNews
*
* Updates FNews to the Latest version if it isn't up to date
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function update()
	{
		global $tpl,$fn,$mysql;
		$this->version_array=$this->admin->grabLatestVersionInfo();
		$this->version_array[1]=rtrim($this->version_array[1]);
		if ($this->version_array[0]{0}>$fn->version{0} || $this->version_array[0]{2}>$fn->version{2} || $this->version_array[0]{4}>$fn->version{4} || ($this->version_array[1]=="Beta" && $fn->release_type=="Alpha") || ($this->version_array[1]=="RC" && ($fn->release_type=="Beta" || $fn->release_type=="Alpha") ) || ($this->version_array[1]=="Final" && ($fn->release_type=="Beta" || $fn->release_type=="Alpha" || $fn->release_type=="RC")))
		{
			require_once("ftp.php");
			$ftp=new Ftp;
			// First for updating we download all the new files
			$ftp->connect("ftp.fscripts.com");
			$ftp->login("anonymous@fscripts.com","anonymous");
			$ftp->downloadFile("FNews/".$fn->version."/filelist.txt","filelist.txt","filelist.txt");
			$lines=file("filelist.txt");
			foreach ($lines as $line_num => $line) {
				$line=rtrim($line);
				if ($line=="update.php")
				{
					$ftp->downloadFile("FNews/".$fn->version."/$line","$line",$line);
				}
				else
				{
  		 			$ftp->downloadFile("FNews/".$fn->version."/$line","../$line",$line);
				}
			}
			$ftp->close();	
			/* 
				Now we run our little update script we download everytime we update
				it runs any changes to files, mysql what not
			*/
			require_once("update.php");
			if (!@unlink("update.php") || !@unlink("filelist.txt") )
			{
				echo "<br>Unable to delete update file please check your php configuration";
				
			}
			else
			{
				echo "<br>Fantastic News Is Now Up to date<br>";
			}
		}
		else
		{
			echo "<br>Fantastic News is up to date";
		}
		
		
	}
/**
* Builds XML
*
* Rebuilds the XML FIle
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function buildXML()
	{
		global $mysql,$tpl,$fn;
		require("news.php");
		$news=new News($this->admin);
		
		$news->rebuildXML();
		$fn->redirectionSuccess("index.php?action=main",5,"You have successfully rebuilt your XML you'll be redirected back to the main page in 5 seconds");
	}
}
?>