<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | index.php                                                            |
// +----------------------------------------------------------------------+
require_once("../config.php");
require_once("../functions/functions.php");
require_once("../functions/mysql.php");
require_once("../functions/template.php");
if (empty($tpl))
{
	$tpl=new Templates;
	$mysql=new Mysql;
	$mysql->Connect();
	$fn=new FNews;
}
if (file_exists("../install") || file_exists("../upgrade"))
{
	echo "You need to delete the install and upgrade directories before you can use Fantastic News";
	exit();
}
session_name("FNews");
session_start();
$fn->StartTimer();
$admin=new Admin;
/**
* Admin Class
*
* Does all Admin stuff
* @author Tony Baird
* @version 2.0
* @access public
* @since 07-10-2004
*/
class Admin
{
/**
* Admin Constructor
*
* Figures out what admin methods we're calling
*/
	function Admin()
	{
		if (isset($_REQUEST['login']))
		{
			$this->login();
			$this->checkLogin();
			$this->mainAdminArea();
		}
		else if ($_REQUEST['action']=="menu")
		{
			$this->checklogin();
			$this->menu();
		}
		else if ($_REQUEST['action']=="main")
		{
			$this->checkLogin();
			$this->header();
			$this->main();
			$this->footer();
		}
		else if ($_REQUEST['action']=="post_news" || isset($_REQUEST['postnews']) || $_REQUEST['action']=="news_list" || $_REQUEST['action']=="edit_news" || isset($_REQUEST['editnews']) || $_REQUEST['action']=="remove_attachment" || $_REQUEST['action']=="delete_news")
		{
			$this->checkLogin();	
			$this->header();
			require_once("news.php");
			$news=new News($this);
			$this->footer();
			
			
		}
		else if ($_REQUEST['action']=="add_category" || isset($_REQUEST['add_category']) || $_REQUEST['action']=="category_list" || $_REQUEST['action']=="delete_category" || $_REQUEST['action']=="edit_category" || isset($_REQUEST['editcategory']))
		{
			$this->checkLogin();
			if ($this->checkAccess("@12"))
			{
				$this->header();
				
				require_once("category.php");
				$category=new Category($this);
				$this->footer();
			}
			else
			{
				$this->error("Insufficient Access");
			}
			
			
		}
		else if ($_REQUEST['action']=="add_smiley" || isset($_REQUEST['add_smiley']) || $_REQUEST['action']=="smiley_list" || $_REQUEST['action']=="edit_smiley" || $_REQUEST['action']=="delete_smiley" || isset($_REQUEST['edit_smiley']))
		{
			$this->checkLogin();
			if ($this->checkAccess("@13"))
			{
				if (!isset($_REQUEST['add_smiley']) && !isset($_REQUEST['edit_smiley']))
				{
					$this->header();
				}
				require_once("smiley.php");
				$smiley=new Smiley($this);
				$this->footer();		
			}
			else
			{
				$this->error("Insufficient Access");
			}
		}
		else if ($_REQUEST['action']=="add_badword" || isset($_REQUEST['add_badword']) || $_REQUEST['action']=="badword_list" || $_REQUEST['action']=="edit_badword" || $_REQUEST['action']=="delete_badword" || isset($_REQUEST['edit_badword']))
		{
			$this->checkLogin();
			if ($this->checkAccess("@13"))
			{
				if (!isset($_REQUEST['add_badword']) && !isset($_REQUEST['edit_badword']))
				{
					$this->header();
				}
				require_once("badword.php");
				$badword=new Badword($this);
				$this->footer();
			}
			else
			{
				$this->error("Insufficient Access");
			}
			
			
		}
		else if ($_REQUEST['action']=="newstip_list" || $_REQUEST['action']=="delete_newstip" || $_REQUEST['action']=="use_newstip")
		{
			$this->checkLogin();
			if ($this->checkAccess("@7"))
			{
				$this->header();
				require_once("newstip.php");
				$newstip=new Newstip($this);
				$this->footer();
			}
			else
			{
				$this->error("Insufficient Access");
			}
		}
		else if ($_REQUEST['action']=="user_list" || $_REQUEST['action']=="edit_user" || isset($_REQUEST['edit_user']) || $_REQUEST['action']=="delete_user")
		{
			$this->checkLogin();
			if ($this->checkAccess("@16"))
			{
				if (!isset($_REQUEST['edit_user']) || $_REQUEST['action']=="delete_user")
				{
					$this->header();
				}
				require_once("user.php");
				$user=new User($this);
				$this->footer();
			}
			else
			{
				$this->error("Insufficient Access");
			}	
		}
		else if ($_REQUEST['action']=="add_ban" || isset($_REQUEST['add_ban']) || $_REQUEST['action']=="ban_list" || $_REQUEST['action']=="edit_ban" || $_REQUEST['action']=="delete_ban" || isset($_REQUEST['edit_ban']))
		{
			$this->checkLogin();
			if ($this->checkAccess("@16"))
			{
				if (!isset($_REQUEST['add_ban']) && !isset($_REQUEST['edit_ban']))
				{
					$this->header();
				}
				require_once("ban.php");
				$ban=new Ban($this);
				$this->footer();
			}
			else
			{
				$this->error("Insufficient Access");
			}
			
			
		}
		else if ($_REQUEST['action']=="edit_settings" || isset($_REQUEST['edit_settings']) || $_REQUEST['action']=="update" || $_REQUEST['action']=="build_xml")
		{
			$this->checkLogin();
			if ($this->checkAccess("@17"))
			{
				if (!isset($_REQUEST['edit_settings']))
				{
					$this->header();
				}
				require_once("maintenance.php");
				$maintenance=new Maintenance($this);
				$this->footer();
			}
			else
			{
				$this->error("Insufficient Access");
			}	
		}
		else if ($_REQUEST['action']=="template_list" || $_REQUEST['action']=="edit_template" || isset($_REQUEST['edit_template']))
		{
			$this->checkLogin();
			if ($this->checkAccess("@15"))
			{
				$this->header();
				require_once("template.php");
				$template=new Template($this);
				$this->footer();
			}
			else
			{
				$this->error("Insufficient Access");
			}	
		}
		else
		{
			$this->LoginPage();
		}
	}
/**
* Login Page
*
* Displays the Login Page
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function loginPage()
	{
		global $mysql,$tpl,$fn;
		$this->LoginHeader();
		$tpl->loadTemplate("login_page","templates/login_page.tpl");
		$tpl->parseTemplate("login_page",$login_page_array,"Yes");
		$tpl->printTemplate("login_page");
		// Displays the comments and the comment posting option
		$this->loginFooter();
	}
/**
* Header
*
* Displays the standard header for most admin pages
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function header()
	{
		global $tpl,$mysql,$fn;
		$tpl->loadTemplate("header","templates/header.tpl");
		
		$header_array= Array(
			'options'=>$options,
			'html_editor'=>$html_editor,
		);
		$tpl->parseTemplate("header",$header_array,"No");
		$tpl->printTemplate("header");


	}
/**
* Footer
*
* Displays the footer that is on most admin pages
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function footer()
	{
		global $tpl,$mysql,$fn;
		$tpl->loadTemplate("footer","templates/footer.tpl");
		$fn->stopTimer();
		$footer_array= Array(
			'num_queries'=>$mysql->query_count,
			'generation_time'=>$fn->total_time,
			'version'=>$fn->version,
		);
		$tpl->parseTemplate("footer",$footer_array,"No");
		$tpl->printTemplate("footer");
		//echo $mysql->sql; only used for debugging


	}
/**
* Login Header
*
* Displays the login page header
* @global object $tpl instance of the template class
*/
	function loginHeader()
	{
		global $tpl;
		$tpl->loadTemplate("login_header","templates/login_header.tpl");
		$login_header_array= Array(
			'options'=>$options,
		);
		$tpl->parseTemplate("login_header",$login_header_array,"No");
		$tpl->printTemplate("login_header");
	}
/**
* Login Footer
*
* Displays the login footer
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function loginFooter()
	{
		global $tpl,$mysql,$fn;
		$tpl->loadTemplate("login_footer","templates/login_footer.tpl");
		$fn->stopTimer();
		$login_footer_array= Array(
			'num_queries'=>$mysql->query_count,
			'generation_time'=>$fn->total_time,
			'version'=>$fn->version,
		);
		$tpl->parseTemplate("login_footer",$login_footer_array,"No");
		$tpl->printTemplate("login_footer");

	}
/**
* Logs a user into their session
*
* Sets the users session stuff
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function login()
	{
		$_SESSION['fn_username']=$_POST['username'];
		$_SESSION['fn_password']=md5($_POST['password']);
	}
/**
* Check Login
*
* Checks if a users session matches an account with sufficient access to the admin area
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function checkLogin()
	{
		global $mysql,$fn;
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."users WHERE username='".$_SESSION['fn_username']."' AND password='".$_SESSION['fn_password']."'");
		$show_user=mysql_fetch_array($mysql->result_id);
		if (isset($show_user[user_id]) && $show_user['username']==$_SESSION['fn_username'] && $show_user['password']==$_SESSION['fn_password'] )
		{
			$this->username=$show_user[username];
			$this->password=$show_user[password];
			$this->user_level=$show_user[user_level];
			$this->user_id=$show_user[user_id];
			// Now we check if they have any admin access
			if ($this->checkAccess("@7"))
			{

			}
			else
			{
				$this->error("You lack access to the admin area");
			}
		}
		else
		{
			$this->error("Your username or password was incorrect");
		}

	}
/**
* Displays Errors
*
* Displays error messages in the error template
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function error($error)
	{
		echo $error;
	}
/**
* Check Access
*
* Checks if the users user level has the specified access level
*/
	function checkAccess($access)
	{
		if (preg_match("/$access/",$this->user_level))
		{
			return true;
		}
		else
		{
			return false;
		}


	}
/**
* Main Admin Area
*
* Creates the Frames for the admin area
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function mainAdminArea()
	{
		global $tpl;
		$tpl->LoadTemplate("frames","templates/frames.tpl");
		$tpl->ParseTemplate("frames",$frames_array,"Yes");
		$tpl->PrintTemplate("frames");
		
	}
/**
* Menu
*
* Displays the Menu for the user
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function menu()
	{
		global $tpl,$fn;
		$tpl->loadTemplate("menu","templates/menu.tpl");
		if ($this->checkAccess("@7"))
		{
			$options .="<div align=\"center\">
						<table width=\"160\" id=\"table18\" bordercolor=\"#005EAA\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">
						<tr>
							<td bgcolor=\"#005EAA\"><font color=\"#FFFFFF\"><b>News Options</b></font></td>
						</tr>
						<tr>
						<td bgcolor=\"#E5E5E5\">
						<a href=\"index.php?action=newstip_list\">View Newstips</a><br><a href=\"index.php?action=post_news\">Post News</a><br>";
		}
		if ($this->checkAccess("@8") || $this->checkAccess("@9") || $this->checkAccess("@10") || $this->checkAccess("@11")  )
		{
			$options .="<a href=\"index.php?action=news_list\">News Item List</a><br>
						</tr></table></div><br>";

		}
		else if ($this->checkAccess("@7"))
		{
			$options .="</tr></table></div><br>";
			
			
		}
		if ($this->checkAccess("@12"))
		{
			$options .="<div align=\"center\">
						<table width=\"160\" id=\"table18\" bordercolor=\"#005EAA\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">
						<tr>
							<td bgcolor=\"#005EAA\"><font color=\"#FFFFFF\"><b>Category Options</b></font></td>
						</tr>
						<tr>
						<td bgcolor=\"#E5E5E5\"><a href=\"index.php?action=add_category\">Add Category</a><br><a href=\"index.php?action=category_list\">Category List</a><br></tr></table></div><br>";

		}
		if ($this->checkAccess("@13"))
		{
			$options .="<div align=\"center\">
						<table width=\"160\" id=\"table18\" bordercolor=\"#005EAA\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">
						<tr>
							<td bgcolor=\"#005EAA\"><font color=\"#FFFFFF\"><b>Smiley Options</b></font></td>
						</tr>
						<tr>
						<td bgcolor=\"#E5E5E5\"><a href=\"index.php?action=add_smiley\">Add Smiley</a><br><a href=\"index.php?action=smiley_list\">Smiley List</a><br></tr></table></div><br>";

		}
		if ($this->checkAccess("@14"))
		{
			$options .="<div align=\"center\">
						<table width=\"160\" id=\"table18\" bordercolor=\"#005EAA\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">
						<tr>
							<td bgcolor=\"#005EAA\"><font color=\"#FFFFFF\"><b>Smiley Options</b></font></td>
						</tr>
						<tr>
						<td bgcolor=\"#E5E5E5\"><a href=\"index.php?action=add_badword\">Add Bad word</a><br><a href=\"index.php?action=badword_list\">Bad Word List</a><br></tr></table></div><br>";

		}
		if ($this->checkAccess("@15"))
		{
			$options .="<div align=\"center\">
						<table width=\"160\" id=\"table18\" bordercolor=\"#005EAA\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">
						<tr>
							<td bgcolor=\"#005EAA\"><font color=\"#FFFFFF\"><b>Template Options</b></font></td>
						</tr>
						<tr>
						<td bgcolor=\"#E5E5E5\"><a href=\"index.php?action=template_list\">Templates List</a><br></tr></table></div><br>";

		}
		if ($this->checkAccess("@16"))
		{
			$options .="<div align=\"center\">
						<table width=\"160\" id=\"table18\" bordercolor=\"#005EAA\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">
						<tr>
							<td bgcolor=\"#005EAA\"><font color=\"#FFFFFF\"><b>User Options</b></font></td>
						</tr>
						<tr>
						<td bgcolor=\"#E5E5E5\"><a href=\"index.php?action=user_list\">User List</a><br>
			<a href=\"index.php?action=add_ban\">Add Ban</a><br>
			<a href=\"index.php?action=ban_list\">Ban List</a><br>
			</tr></table></div><br>";

		}
		if ($this->checkAccess("@17"))
		{
			$options .="<div align=\"center\">
						<table width=\"160\" id=\"table18\" bordercolor=\"#005EAA\" border=\"1\" cellspacing=\"0\" cellpadding=\"0\">
						<tr>
							<td bgcolor=\"#005EAA\"><font color=\"#FFFFFF\"><b>Maintenance Options</b></font></td>
						</tr>
						<tr>
						<td bgcolor=\"#E5E5E5\"><a href=\"index.php?action=edit_settings\">Edit Settings</a><br><a href=\"index.php?action=build_xml\">Build XML</a><br></tr></table></div><br>";

		}


		$menu_array= Array(
			'options'=>$options,
		);
		$tpl->parseTemplate("menu",$menu_array,"Yes");
		$tpl->printTemplate("menu");

	}
/**
* Displays the Main
*
* Actually logs the user into the account
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function main()
	{
		global $tpl,$fn,$mysql;
		// Gets Load Average
		if (file_exists('/proc/loadavg')) 
		{
        	if ($fh = @fopen( '/proc/loadavg', 'r' ))
        	{
	        	$data = @fread($fh,6);
	        	@fclose($fh);
				$load_avg = explode( " ", $data );
	        	$server_load=trim($load_avg[0]);
        	}
		} 
		else 
		{
			$server_load="N/A";
		}
		// Gets PHP Version and MySQL Version
		$php_version = phpversion();
		$mysql->query("SELECT VERSION() AS version");
		$show_version=mysql_fetch_array($mysql->result_id);
		$mysql_version=$show_version[version];
		
		
		$this->version_array=$this->grabLatestVersionInfo();
		if ($this->version_array[0]=="N/A")
		{
		}
		else
		{
			/* 	Break down the versions so we can compare them
				I honestly don't know a good way to do this there is probably
				a better way than substr so in the future I might change it
			*/
			// 
			$this->version_array[1]=rtrim($this->version_array[1]);
			if ($this->version_array[0]{0}>$fn->version{0} || $this->version_array[0]{2}>$fn->version{2} || $this->version_array[0]{4}>$fn->version{4} || ($this->version_array[1]=="Beta" && $fn->release_type=="Alpha") || ($this->version_array[1]=="RC" && ($fn->release_type=="Beta" || $fn->release_type=="Alpha") ) || ($this->version_array[1]=="Final" && ($fn->release_type=="Beta" || $fn->release_type=="Alpha" || $fn->release_type=="RC")))
			{
				$update="There is a newer version of Fantastic News Available";
				$latest="The latest version is ".$this->version_array[0]." ".$this->version_array[1]."<br><br>
				You're running $fn->version $fn->release_type";
				$update_link="<p align=\"center\"><a href=\"http://fscripts.com/\">Click Here To 
				Download Updates</a> Or use the Update Script Option on the Left";
				$critical="<br>".$this->version_array[2];
			}
			else
			{
				$update="You're up to date";
				$latest="Make sure you keep up to date with updates by checking this page daily";
				$update_link="Remember any bugs you find report them to the <a href=\"http://fscripts.com\">Fantastic Scripts Forums</a>";
			}		
		}
		
		// Grab Stats stuff
		
		$mysql->query("SELECT COUNT(*) AS count FROM ".$fn->CONFIG['db_prefix']."news");
		$show_news=mysql_fetch_array($mysql->result_id);
		
		$mysql->query("SELECT COUNT(*) AS count FROM ".$fn->CONFIG['db_prefix']."comments");
		$show_comments=mysql_fetch_array($mysql->result_id);
		
		$mysql->query("SELECT COUNT(*) AS count FROM ".$fn->CONFIG['db_prefix']."newstips");
		$show_newstips=mysql_fetch_array($mysql->result_id);
		
		$mysql->query("SELECT COUNT(*) AS count FROM ".$fn->CONFIG['db_prefix']."users");
		$show_users=mysql_fetch_array($mysql->result_id);
		
		$tpl->loadTemplate("main","templates/main.tpl");
		$main_array= Array(
			'update'=>$update,
			'critical'=>$critical,
			'latest'=>$latest,
			'update_link'=>$update_link,
			'critical'=>$critical,
			'version'=>$fn->version,
			'release_type'=>$fn->release_type,
			'server_load'=>$server_load,
			'php_version'=>$php_version,
			'mysql_version'=>$mysql_version,
			'total_news_posts'=>$show_news[count],
			'total_comments'=>$show_comments[count],
			'total_newstips'=>$show_newstips[count],
			'total_user_accounts'=>$show_users[count]-1,
		);
		$tpl->parseTemplate("main",$main_array,"No");
		$tpl->printTemplate("main");
		
		
		

	}
/**
* Grabs the latest version of FNews
*
* Opens a file from the fscripts website that has the latest version of FGuestbook
* @return array All the version information
*/
	function grabLatestVersionInfo()
	{
		if (@$file=file("http://fscripts.com/version/fnews.txt"))
		{
		}
		else
		{
			$file=Array(
				0,"N/A",
				1,"N/A",
				2,"Check Website",
			);
		}
		
		return $file;
				
			
		
		
	}
}
$mysql->Close();
?>