<?php
/**
* FTP Functions
*
* Does all the ftp functions required for updating of Fantastic Guestbook
* entires, signing ect.
* @author Tony Baird
* @version 2.0.0
* @access public
* @since 07-24-2004
*/
class Ftp
{
/**
* Connects to the server
*
* Connects to the server and if its unable to connect it gives our an error
* @param string $server The server that its suppose to be connecting to
*/
	function connect($server)
	{
		$this->server=$server;
		$this->connection_id=ftp_connect($this->server);
		if (!$this->connection_id)
		{
			$this->error("Unable to Connect to Server");
		}
		
	}
/**
* Logs into the server
*
* Logs into the server and if its unable to login gives out an error
* @param string $username The username that is required for logging into the ftp
* @param string $password The password that is required for logging into the ftp
*/
	function login($username,$password)
	{
		$this->username=$username;
		$this->password=$password;
		$this->login_result=ftp_login($this->connection_id, $this->username, $this->password);
		if (!$this->login_result)
		{
			$this->error("The username or password was wrong for the ftp");	
		}
		
		
	}
/**
* Downloads a File from the ftp
*
* Downloads a file from the ftp server
* @param string $filename The name of the file is going to be downloaded
*/
	function downloadFile($filename,$save_location,$file)
	{
		// Time junk for download speed
		$mtime = microtime();
        $mtime = explode (' ', $mtime);
        $mtime = $mtime[1] + $mtime[0];
        $start_time = $mtime;
		// Check if there is a file already there and if so deletes it so we can make the new one
		if (file_exists($save_location))
		{
			echo "It deleted $save_location <br>";
			unlink($save_location);
		}
		$ret = ftp_nb_get($this->connection_id, $save_location, $filename, FTP_BINARY);
		echo "<br>Started Downloading $file ";
		while ($ret == FTP_MOREDATA) 
       	{
   			//echo ".";
   			$ret = ftp_nb_continue($this->connection_id);
	   	}
	   	if ($ret != FTP_FINISHED) 
	   	{
	   		$this->error("Error Downloading File");
       		exit();
	   	}
	   	/* 	It uses a lot of variables but well it would be a huge mess
	   		and hard to understand if it wasnt so I broke it down like this
	   	*/
	   	$mtime = microtime ();
        $mtime = explode (' ', $mtime);
        $mtime = $mtime[1] + $mtime[0];
        $end_time = $mtime;
        $total_time = round(($end_time - $start_time), 5);
        $filesize=filesize($save_location);
        $download_speed=round($filesize/$total_time/1024,2);
	   	echo "Finished Download @ $download_speed KB/sec Time Elapsed: $total_time";  
	}
/**
* Closes FTP Connection
*
* Closes the FTP connection and is required
*/
	function close()
	{
		ftp_close($this->connection_id); 
		
		
	}
/**
* Error Printing
*
* Prints out any errors encountered and exits the script
*/
	function error($error)
	{
		echo $error;
		exit();
	}
}

?>