<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | category.php                                                         |
// +----------------------------------------------------------------------+

/**
* Category Class
*
* Does all category admin related stuff
* @author Tony Baird
* @version 2.0
* @access public
* @since 07-28-2004
*/
class Category
{
/**
* Category Constructor
*
* Figures out what category methods we're going to use
*/
	function Category($admin)
	{
		$this->admin=$admin;
		if ($_REQUEST['action']=="add_category")
		{
			$this->addCategoryForm();
			
		}
		else if (isset($_REQUEST['add_category']))
		{
			$this->addCategory();
		}
		else if ($_REQUEST['action']=="category_list")
		{
			$this->categoryList();
			
			
		}
		else if ($_REQUEST['action']=="delete_category")
		{
			$this->deleteCategory();
		}
		else if ($_REQUEST['action']=="edit_category")
		{
			$this->editCategoryForm();
		}
		else if (isset($_REQUEST['editcategory']))
		{
			$this->editCategory();
		}
	}
/**
* Add Category Form
*
* Creates the add category form page
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function addCategoryForm()
	{
		global $tpl,$fn,$mysql;
		$tpl->loadTemplate("add_category_form","templates/add_category_form.tpl");
		/*
		$add_category_form_array= Array(
			'var'=>$var,
		);
		*/
		$tpl->parseTemplate("add_category_form",$add_category_form_array,"No");
		$tpl->printTemplate("add_category_form");	
	}
/**
* Add Category
*
* Adds the category to the database after checking the form
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function addCategory()
	{
		global $tpl,$fn,$mysql;
		if (empty($_POST['category_name']))
		{
			$this->admin->error("Missing Category Name<br>");
		}
		else
		{
			$insert_array= Array(
				'category'=>$_POST['category_name'],
				'category_image'=>$_POST['category_image'],
					
			);
			$mysql->makeInsertString($insert_array);
			$mysql->query("INSERT INTO ".$fn->CONFIG['db_prefix']."categories ($mysql->insert_fields) VALUES 	($mysql->insert_values)");
			$fn->redirectionSuccess("index.php?action=main",10,"You have successfully added a category you'll be redirected to the main page in 10 seconds");	
			
			
		}
		
	}
/**
* Category List
*
* Displays all the categories currently in the database
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function categoryList()
	{
		global $tpl,$fn,$mysql;
		$this->categoryListHeader();
		if (empty($_REQUEST['page'])) 
		{
			$_REQUEST['page']=1;
		}
		// Divides news up so we got page stuff
		
		$fn->divideData("SELECT COUNT(*) AS count FROM ".$fn->CONFIG['db_prefix']."categories LIMIT 0,1" ,$_REQUEST['page'],20);
		$tpl->loadTemplate("category_list","templates/category_list.tpl");
		$mysql->Query("SELECT * FROM ".$fn->CONFIG['db_prefix']."categories LIMIT $fn->data_bottom,$fn->data_per_page");
		while ($show_category=mysql_fetch_array($mysql->result_id))
		{
			$fn->stripArray($show_category);
			if (!empty($show_category[category_image]))
			{
				$image="<img src=\"$show_category[category_image]\">";
			}
			else
			{
				$image="N/A";
			}
			$category_list_array= Array(
				'category_name'=>$show_category[category],
				'image'=>$image,
				'category_id'=>$show_category[category_id],
			);
			$tpl->parseTemplate("category_list",$category_list_array,"Yes");
			$has_category=1;
		}
		
		if ($has_category==1)
		{
			$tpl->printTemplate("category_list");
		}
		else
		{
			$this->admin->error("There are currently no categories in the database");
		}
		$this->categoryListFooter();
	}
/**
* Category List Header
*
* Opens up the category list header template and parses it
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function categoryListHeader()
	{
		global $tpl,$fn,$mysql;
		$tpl->loadTemplate("category_list_header","templates/category_list_header.tpl");
		/*
		$category_list_header_form_array= Array(
			'var'=>$var,
		);
		*/
		$tpl->parseTemplate("category_list_header",$category_list_header_array,"No");
		$tpl->printTemplate("category_list_header");	
	}
/**
* Category List Footer
*
* Opens up the category list footer template and parses it
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function categoryListFooter()
	{
		global $tpl,$fn,$mysql;
		$fn->makePages("<a href=\"index.php?action=category_list&page={eachpage}\">{eachpage}</a>&nbsp;","<b>{page}</b>&nbsp;","<a href=\"index.php?action=category_list&page=1\"> First Page</a>&nbsp;","<a href=\"index.php?action=category_list&page={eachpage}\">Last Page </a>",$_REQUEST['page'],$fn->num_pages);
		$tpl->loadTemplate("category_list_footer","templates/category_list_footer.tpl");
		
		$category_list_footer_array= Array(
			'num_pages'=>$fn->num_pages,
			'page_list'=>$fn->pages,
		);
		
		$tpl->parseTemplate("category_list_footer",$category_list_footer_array,"No");
		$tpl->printTemplate("category_list_footer");	
	}
/**
* Delete Category
*
* Opens up the category list footer template and parses it
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function deleteCategory()
	{
		global $tpl,$fn,$mysql;
		$mysql->query("DELETE FROM ".$fn->CONFIG['db_prefix']."categories WHERE category_id=".$_REQUEST['id']."");
		$fn->redirectionSuccess("index.php?action=category_list",10,"You have successfully deleted that category you'll be redirected to the category list in 10 seconds");	
	}
/**
* Edit Category Form
*
* Edit Category form grabs from the database then puts it onto the form
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function editCategoryForm()
	{
		global $tpl,$fn,$mysql;
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."categories WHERE category_id=".$_REQUEST['id']."");
		$show_category=mysql_fetch_array($mysql->result_id);
		$tpl->loadTemplate("edit_category_form","templates/edit_category_form.tpl");
		$edit_category_form_array= Array(
			'category_name'=>$show_category[category],
			'category_image'=>$show_category[category_image],
			'category_id'=>$show_category[category_id],
		);
		
		$tpl->parseTemplate("edit_category_form",$edit_category_form_array,"No");
		$tpl->printTemplate("edit_category_form");	
	}
/**
* Edit Category 
*
* Edits the category in the database
* @global object $mysql instance of the mysql class
* @global object $tpl instance of the template class
* @global object $fn instance of the Fantastic News function class
*/
	function editCategory()
	{
		global $tpl,$fn,$mysql;
		if (empty($_POST['category_name']))
		{
			$this->admin->error("Missing Category Name<br>");
		}
		else
		{
			$update_array= Array(
				'category'=>$_POST['category_name'],
				'category_image'=>$_POST['category_image'],
			);
			$mysql->makeUpdateString($update_array);
			$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."categories SET $mysql->update_string WHERE category_id=".$_REQUEST['category_id']."");
			$fn->redirectionSuccess("index.php?action=category_list",10,"You have successfully edited a category you'll be redirected to the category list page in 10 seconds");
		}
	}
	
}
?>