<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | ban.php                                                              |
// +----------------------------------------------------------------------+

/**
* Ban Class
*
* Controls all the ban options in the admin area
* @author Tony Baird
* @version 2.0
* @access public
* @since 08-15-2004
*/
class Ban
{
/**
* Nan Decision Maker
*
* Figures out what ban option we're using
*/
	function Ban($admin)
	{
		
		$this->admin=$admin;
		if ($_REQUEST['action']=="add_ban")
		{
			$this->addbanForm();
		}
		else if (isset($_REQUEST['add_ban']))
		{
			$this->addban();
		}
		else if ($_REQUEST['action']=="ban_list")
		{
			$this->banList();
		}
		else if ($_REQUEST['action']=="delete_ban")
		{
			$this->deleteban();
		}	
		else if ($_REQUEST['action']=="edit_ban")
		{
			$this->editbanForm();
		}
		else if (isset($_REQUEST['edit_ban']))
		{
			$this->editban();
		}
	}
/**
* Add Ban Form
*
* Opens the add ban form template and displays it
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function addbanForm()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("add_ban_form","templates/add_ban_form.tpl");
		$add_ban_form_array= Array(
			'error'=>$this->error,
		);
		$tpl->parseTemplate("add_ban_form",$add_ban_form_array,"No");
		$tpl->printTemplate("add_ban_form");
	}
/**
* Add ban 
*
* Adds the ban to the database
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function addban()
	{
		global $mysql,$tpl,$fn;
		if (empty($_POST['ip']))
		{
			$error .="IP left blank<br>";
		}
		
		if (empty($_POST['reason']))
		{
			$error .="reason left blank<br>";
		}
		if ($error)
		{
			$this->error="<b>You have the following errors</b><br><br>";
			$this->error .=$error;
			$this->admin->header();
			$this->addbanForm();
		}
		else
		{
			$insert_array= Array(
				'ip'=>$_POST['ip'],
				'reason'=>$_POST['reason'],
				
			);
			$mysql->makeInsertString($insert_array);
			$mysql->query("INSERT INTO ".$fn->CONFIG['db_prefix']."banned_ips ($mysql->insert_fields) VALUES 	($mysql->insert_values)");
			$fn->redirectionSuccess("index.php?action=main",10,"You have successfully added a ban you'll be redirected to the main admin page in 10 seconds");
		}
	}
/**
* List of bans
*
* Displays the current list of bans and their newwords
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class
*/	
	function banList()
	{
		global $mysql,$tpl,$fn;
		$this->banListHeader();
		if (empty($_REQUEST['page'])) 
		{
			$_REQUEST['page']=1;
		}
		// Divides news up so we got page stuff
		$fn->divideData("SELECT COUNT(*) AS count FROM ".$fn->CONFIG['db_prefix']."banned_ips LIMIT 0,1" ,$_REQUEST['page'],20);
		$tpl->loadTemplate("ban_list","templates/ban_list.tpl");
		$mysql->Query("SELECT * FROM ".$fn->CONFIG['db_prefix']."banned_ips LIMIT $fn->data_bottom,$fn->data_per_page");
		while ($show_ban=mysql_fetch_array($mysql->result_id))
		{
			$fn->stripArray($show_ban);
			$ban_list_array= Array(
				'ip'=>$show_ban[ip],
				'reason'=>$show_ban[reason],
				'ban_id'=>$show_ban[ban_id],
			);
			$tpl->parseTemplate("ban_list",$ban_list_array,"Yes");
			$has_bans=1;
		}
		
		if ($has_bans==1)
		{
			$tpl->printTemplate("ban_list");
		}
		else
		{
			$this->admin->error("There are currently no bans in the database");
		}
		$this->banListFooter();
		
	}
/**
* ban List Header
*
* Displays the header for the ban list pages
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/		
	function banListHeader()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("ban_list_header","templates/ban_list_header.tpl");
		
		$ban_list_header_array= Array(
			'error'=>$this->error,
		);
		
		$tpl->parseTemplate("ban_list_header",$ban_list_header_array,"No");
		$tpl->printTemplate("ban_list_header");
		
	}
/**
* ban List Footer
*
* Displays the footer for the ban list pages
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function banListFooter()
	{
		global $mysql,$tpl,$fn;
		$fn->makePages("<a href=\"index.php?action=ban_list&page={eachpage}\">{eachpage}</a>&nbsp;","<b>{page}</b>&nbsp;","<a href=\"index.php?action=ban_list&page=1\"> First Page</a>&nbsp;","<a href=\"index.php?action=ban_list&page={eachpage}\">Last Page </a>",$_REQUEST['page'],$fn->num_pages);
		$tpl->loadTemplate("ban_list_footer","templates/ban_list_footer.tpl");
		
		$ban_list_footer_array= Array(
			'num_pages'=>$fn->num_pages,
			'page_list'=>$fn->pages,
		);
		
		$tpl->parseTemplate("ban_list_footer",$ban_list_footer_array,"No");
		$tpl->printTemplate("ban_list_footer");
		
	}
/**
* Delete ban
*
* Deletes the ban from the mysql database
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function deleteban()
	{
		global $mysql,$tpl,$fn;
		$mysql->query("DELETE FROM ".$fn->CONFIG['db_prefix']."banned_ips WHERE ban_id=".$_REQUEST['id']."");
		$fn->redirectionSuccess("index.php?action=ban_list",10,"You have successfully deleted that ban you'll be redirected to the ban list again in 10 seconds");
		
	}
/**
* Edit ban Form
*
* The Edit ban Form
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function editbanForm()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("edit_ban_form","templates/edit_ban_form.tpl");
		
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."banned_ips WHERE ban_id=".$_REQUEST['id']."");
		$show_ban=mysql_fetch_array($mysql->result_id);
		$edit_ban_form_array= Array(
			'error'=>$this->error,
			'ip'=>$show_ban[ip],
			'reason'=>$show_ban[reason],
			'ban_id'=>$show_ban[ban_id],
		);
		
		$tpl->parseTemplate("edit_ban_form",$edit_ban_form_array,"No");
		$tpl->printTemplate("edit_ban_form");
		
		
		
	}
/**
* Edit ban
*
* Edits the ban in the mysql database
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function editban()
	{
		global $mysql,$tpl,$fn;
		if (empty($_POST['ip']))
		{
			$error .="ip left blank<br>";
		}
		
		if (empty($_POST['reason']))
		{
			$error .="reason left blank<br>";
		}
		if ($error)
		{
			$this->error="<b>You have the following errors</b><br><br>";
			$this->error .=$error;
			$this->admin->header();
			$this->editbanForm();
		}
		else
		{
			$update_array= Array(
				'ip'=>$_POST['ip'],
				'reason'=>$_POST['reason'],
				
			);
			$mysql->makeUpdateString($update_array);
			$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."banned_ips SET $mysql->update_string WHERE ban_id=".$_REQUEST['ban_id']."");
			$fn->redirectionSuccess("index.php?action=ban_list",10,"You have successfully edited a ban you'll be redirected to the ban list page in 10 seconds");
		}
	}	
}
?>