<?php
// +----------------------------------------------------------------------+
// |                         Fantastic News                               |
// +----------------------------------------------------------------------+
// |                          By Tony Baird                               |
// |                  Copyright (c) 2003 Fantastic Scripts                |
// |                          http://fscripts.com                         |
// +----------------------------------------------------------------------+
// | Fantastic News Can be modified freely as long as the copyright at    |
// | the bottom of every page and is visible.  This copyright header must |
// | also be left intact on each php file                                 |
// +----------------------------------------------------------------------+
// | badword.php                                                          |
// +----------------------------------------------------------------------+

/**
* Badword Class
*
* Controls all the badword options in the admin area
* @author Tony Baird
* @version 2.0
* @access public
* @since 07-29-2004
*/
class Badword
{
/**
* Badword Decision Maker
*
* Figures out what badword option we're using
*/
	function Badword($admin)
	{
		
		$this->admin=$admin;
		if ($_REQUEST['action']=="add_badword")
		{
			$this->addBadwordForm();
		}
		else if (isset($_REQUEST['add_badword']))
		{
			$this->addBadword();
		}
		else if ($_REQUEST['action']=="badword_list")
		{
			$this->badwordList();
		}
		else if ($_REQUEST['action']=="delete_badword")
		{
			$this->deleteBadword();
		}	
		else if ($_REQUEST['action']=="edit_badword")
		{
			$this->editBadwordForm();
		}
		else if (isset($_REQUEST['edit_badword']))
		{
			$this->editBadword();
		}
	}
/**
* Add Badword Form
*
* Opens the add badword form template and displays it
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function addBadwordForm()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("add_badword_form","templates/add_badword_form.tpl");
		
		$add_badword_form_array= Array(
			'error'=>$this->error,
		);
		
		$tpl->parseTemplate("add_badword_form",$add_badword_form_array,"No");
		$tpl->printTemplate("add_badword_form");
		
		
	}
/**
* Add Badword 
*
* Adds the badword to the database
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function addBadword()
	{
		global $mysql,$tpl,$fn;
		if (empty($_POST['badword']))
		{
			$error .="badword left blank<br>";
		}
		
		if (empty($_POST['newword']))
		{
			$error .="newword left blank<br>";
		}
		if ($error)
		{
			$this->error="<b>You have the following errors</b><br><br>";
			$this->error .=$error;
			$this->admin->header();
			$this->addBadwordForm();
		}
		else
		{
			$insert_array= Array(
				'badword'=>$_POST['badword'],
				'newword'=>$_POST['newword'],
				
			);
			$mysql->makeInsertString($insert_array);
			$mysql->query("INSERT INTO ".$fn->CONFIG['db_prefix']."badwords ($mysql->insert_fields) VALUES 	($mysql->insert_values)");
			$fn->redirectionSuccess("index.php?action=main",10,"You have successfully added a badword you'll be redirected to the main admin page in 10 seconds");
		}
	}
/**
* List of Badwords
*
* Displays the current list of badwords and their newwords
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class
*/	
	function badwordList()
	{
		global $mysql,$tpl,$fn;
		$this->badwordListHeader();
		if (empty($_REQUEST['page'])) 
		{
			$_REQUEST['page']=1;
		}
		// Divides news up so we got page stuff
		$fn->divideData("SELECT COUNT(*) AS count FROM ".$fn->CONFIG['db_prefix']."badwords LIMIT 0,1" ,$_REQUEST['page'],20);
		$tpl->loadTemplate("badword_list","templates/badword_list.tpl");
		$mysql->Query("SELECT * FROM ".$fn->CONFIG['db_prefix']."badwords LIMIT $fn->data_bottom,$fn->data_per_page");
		while ($show_badword=mysql_fetch_array($mysql->result_id))
		{
			$fn->stripArray($show_badword);
			$badword_list_array= Array(
				'badword'=>$show_badword[badword],
				'newword'=>$show_badword[newword],
				'word_id'=>$show_badword[word_id],
			);
			$tpl->parseTemplate("badword_list",$badword_list_array,"Yes");
			$has_badwords=1;
		}
		
		if ($has_badwords==1)
		{
			$tpl->printTemplate("badword_list");
		}
		else
		{
			$this->admin->error("There are currently no badwords in the database");
		}
		$this->badwordListFooter();
		
	}
/**
* Badword List Header
*
* Displays the header for the badword list pages
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/		
	function badwordListHeader()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("badword_list_header","templates/badword_list_header.tpl");
		
		$badword_list_header_array= Array(
			'error'=>$this->error,
		);
		
		$tpl->parseTemplate("badword_list_header",$badword_list_header_array,"No");
		$tpl->printTemplate("badword_list_header");
		
	}
/**
* Badword List Footer
*
* Displays the footer for the badword list pages
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function badwordListFooter()
	{
		global $mysql,$tpl,$fn;
		$fn->makePages("<a href=\"index.php?action=badword_list&page={eachpage}\">{eachpage}</a>&nbsp;","<b>{page}</b>&nbsp;","<a href=\"index.php?action=badword_list&page=1\"> First Page</a>&nbsp;","<a href=\"index.php?action=badword_list&page={eachpage}\">Last Page </a>",$_REQUEST['page'],$fn->num_pages);
		$tpl->loadTemplate("badword_list_footer","templates/badword_list_footer.tpl");
		
		$badword_list_footer_array= Array(
			'num_pages'=>$fn->num_pages,
			'page_list'=>$fn->pages,
		);
		
		$tpl->parseTemplate("badword_list_footer",$badword_list_footer_array,"No");
		$tpl->printTemplate("badword_list_footer");
		
	}
/**
* Delete Badword
*
* Deletes the badword from the mysql database
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function deleteBadword()
	{
		global $mysql,$tpl,$fn;
		$mysql->query("DELETE FROM ".$fn->CONFIG['db_prefix']."badwords WHERE word_id=".$_REQUEST['id']."");
		$fn->redirectionSuccess("index.php?action=badword_list",10,"You have successfully deleted that badword you'll be redirected to the badword list again in 10 seconds");
		
	}
/**
* Edit Badword Form
*
* The Edit Badword Form
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function editBadwordForm()
	{
		global $mysql,$tpl,$fn;
		$tpl->loadTemplate("edit_badword_form","templates/edit_badword_form.tpl");
		
		$mysql->query("SELECT * FROM ".$fn->CONFIG['db_prefix']."badwords WHERE word_id=".$_REQUEST['id']."");
		$show_badword=mysql_fetch_array($mysql->result_id);
		$edit_badword_form_array= Array(
			'error'=>$this->error,
			'badword'=>$show_badword[badword],
			'newword'=>$show_badword[newword],
			'word_id'=>$show_badword[word_id],
		);
		
		$tpl->parseTemplate("edit_badword_form",$edit_badword_form_array,"No");
		$tpl->printTemplate("edit_badword_form");
		
		
		
	}
/**
* Edit Badword
*
* Edits the badword in the mysql database
* @global object $mysql Instance of the mysql class
* @global object $tpl Instance of the template class
* @global object $fn Instance of the guestbook functions class

*/	
	function editBadword()
	{
		global $mysql,$tpl,$fn;
		if (empty($_POST['badword']))
		{
			$error .="Badword left blank<br>";
		}
		
		if (empty($_POST['newword']))
		{
			$error .="newword left blank<br>";
		}
		if ($error)
		{
			$this->error="<b>You have the following errors</b><br><br>";
			$this->error .=$error;
			$this->admin->header();
			$this->editBadwordForm();
		}
		else
		{
			$update_array= Array(
				'badword'=>$_POST['badword'],
				'newword'=>$_POST['newword'],
				
			);
			$mysql->makeUpdateString($update_array);
			$mysql->query("UPDATE ".$fn->CONFIG['db_prefix']."badwords SET $mysql->update_string WHERE word_id=".$_REQUEST['word_id']."");
			$fn->redirectionSuccess("index.php?action=badword_list",10,"You have successfully edited a badword you'll be redirected to the badword list page in 10 seconds");
		}
	}	
}
?>