<?php
/*
	Copyright UserCake
	http://usercake.com
	
	Developed by: Adam Davis
*/
function usernameExists($username)
{
	global $db;

 	if(returns_result("SELECT Active FROM Users WHERE Username_Clean = '".$db->sql_escape(sanitize($username))."' LIMIT 1") > 0)
		return true;
	else
		return false;
}

function emailExists($email)
{
	global $db;

	if(returns_result("SELECT Active FROM Users WHERE Email = '".$db->sql_escape(sanitize($email))."' LIMIT 1") > 0)
		return true;
	else
		return false;	
}

//Function lostpass var if set will check for an active account.
function validateActivationToken($token,$lostpass=NULL)
{
	global $db;
	
	if($lostpass == NULL) $sql = "SELECT ActivationToken FROM Users WHERE Active = 0 AND ActivationToken ='".$db->sql_escape(trim($token))."' LIMIT 1";
	else 			      $sql = "SELECT ActivationToken FROM Users WHERE Active = 1 AND ActivationToken ='".$db->sql_escape(trim($token))."' AND LostPasswordRequest = 1 LIMIT 1";
	
	if(returns_result($sql) > 0)
		return true;
	else
		return false;
}


function setUserActive($token)
{
	global $db;
	
	$sql = "UPDATE Users SET Active = 1 WHERE ActivationToken ='".$db->sql_escape(trim($token))."' LIMIT 1";
	
	$db->sql_query($sql);

	if($db->sql_affectedrows() <= 0) return false; else return true;
	
}

//You can use a activation token to also get user details here
function fetchUserDetails($username=NULL,$token=NULL)
{
	global $db; 
	
	if($username!=NULL)  $sql = "SELECT * FROM Users WHERE Username_Clean = '".$db->sql_escape(sanitize($username))."' LIMIT 1";
	else				 $sql = "SELECT * FROM Users WHERE ActivationToken = '".$db->sql_escape(sanitize($token))."' LIMIT 1";
	
	$result = $db->sql_query($sql);
	$row = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);

	return ($row);
}

function flagLostPasswordRequest($username,$value)
{
	global $db;
	
	$sql = "UPDATE Users SET LostPasswordRequest = '".$value."' WHERE Username_Clean ='".$db->sql_escape(sanitize($username))."' LIMIT 1";
	
	$db->sql_query($sql);

	if($db->sql_affectedrows() <= 0) return false; else return true;
}

function updatePasswordFromToken($pass,$token)
{
	global $db;
	
	$new_activation_token = generateActivationToken();
	
	$sql = "UPDATE Users SET Password = '".$db->sql_escape($pass)."', ActivationToken = '".$new_activation_token."' WHERE ActivationToken = '".$db->sql_escape(sanitize($token))."'";
	
	$db->sql_query($sql);
	
	if($db->sql_affectedrows() <= 0) return false; else return true;
}

function emailUsernameLinked($email,$username)
{
	global $db;
	
	if(returns_result("SELECT Username, Email FROM Users WHERE Username_Clean = '".$db->sql_escape(sanitize($username))."' AND Email = '".$db->sql_escape(sanitize($email))."' AND Active = 1") > 0)
		return true;
	else
		return false;
}


function isUserLoggedIn()
{
	global $loggedInUser,$db;
	
	if($loggedInUser == NULL)
		return false;
	else
	{
		//Query the database to ensure they haven't been removed or possibly banned?
	if(returns_result("SELECT User_ID,Password FROM Users WHERE User_ID = '".(int)$db->sql_escape($loggedInUser->user_id)."' AND Password = '".$db->sql_escape($loggedInUser->hash_pw)."' AND Active = 1 LIMIT 1") > 0)
			return true;
		else
		{
			//No result returned kill the user session, user banned or deleted
			userLogOut();
		
			return false;
		}
	}
}

//This function should be used like num_rows, since the PHPBB Dbal doesn't support num rows we create a workaround
function returns_result($sql)
{
	global $db;
	
	$count = 0;
 	$result = $db->sql_query($sql);
	
  	while ($row = $db->sql_fetchrow($result))
    {
      $count += 1;
    }
	$db->sql_freeresult($result);
	return ($count);
}

//Generate an activation key 
function generateActivationToken()
{
	$gen;

	do
	{
		$gen = md5(uniqid(mt_rand(), false));
	}
	while(validateActivationToken($gen));

	return $gen;
}


function userLogOut()
{
	$_SESSION['userCakeUser'] = NULL;
	unset($_SESSION['userCakeUser']);
	$loggedInUser = NULL;	
}

?>