<?
/*
*	YaLogin - Yet Another Login - basic auth with session
*	(c) 2003 - Lorenzo Noccioli noccioli@dada.it
*    	This program is free software; you can redistribute it and/or modify
*    	it under the terms of the GNU General Public License as published by
*   	 the Free Software Foundation; either version 2 of the License, or
*   	 (at your option) any later version.
*
*   	 This program is distributed in the hope that it will be useful,
*   	 but WITHOUT ANY WARRANTY; without even the implied warranty of
*   	 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   	 GNU General Public License for more details.
*
*   	 You should have received a copy of the GNU General Public License
*  	 along with this program; if not, write to the Free Software
*   	 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*
*
*	Utilizzo
*	Login - costruttore principale es. $mylogin=new Login();
*	Classi Pubbliche
*	loginLogout() - chiude la sessione es. $mylogin->loginLogout();
*	
*	checkLogin([$user],[$password]) - controlla il login, se riceve $user e $password in input
*	dopo il controllo della sessione fa il controllo sul db 
*	es. $mylogin->checkLogin(); controlla l'esistenza della sessione
*	$mylogin->checkLogin('user','pass'); controlla l'esistenza della sessione, se la sessione
*	non esiste controlla sul db
*
*	getLoginInfo () - restituisce l'array delle informazioni all'interno della session
*	salvo an che l'id che puo' essere utile per fare ricerche su tabelle correlate
*	
*/

/** 
 * Automatic Login Procedure using session and db auth
 * This Class does not have any set and get methods for single Fields due to its purpose
 *
 * @package Philer
 * @author Lorenzo Noccioli <noccioli@dada.it>
 * @version 1.0a
 * @since 1.0
 * @access public
 * @copyright Lorenzo Noccioli
 *
 */
Class Login {
	
	/** 
	 * User Id
	 *
	 * @var Int
	 * @access private
	 */
	var $id;
	
	/** 
	 * User Name
	 *
	 * @var String
	 * @access private
	 */
	var $username;
	
	/** 
	 * User Password
	 *
	 * @var String
	 * @access private
	 */
	var $password;
	
	/** 
	 * User Valid code
	 *
	 * @var Int
	 * @access private
	 */
	var $uvalid;
	
	/** 
	 * Database connection string (a pointer to PEAR)
	 *
	 * @var String
	 * @access private
	 */
	var $dsn;
	
	
	/** 
	 * cookie valueS
	 *
	 * @var String
	 * @access private
	 */
	var $cookie;
	
	/** 
	 * Main constructor, set the dsn string for DB connection
	 *
	 * @return void
	 * @access public
	 */

	function Login(&$db) {
		session_start();
		$this->dsn=$db;
	}
	
	/** 
	 * Logout the user, destroying the session but not the cookie, test purpose only
	 *
	 * @return void
	 * @access public
	 */
	function loginLogout() {
 		unset($_SESSION['username']);
		unset($_SESSION['id']);
		unset($_SESSION['valid']);
		unset($_SESSION['cookie']);
		session_destroy();
	}	
	
	/** 
	 * Logout the user, destroying the session and the cookie
	 *
	 * @return void
	 * @access public
	 */
	function loginLogoutFull() {
 		unset($_SESSION['username']);
		unset($_SESSION['id']);
		unset($_SESSION['valid']);
		unset($_SESSION['cookie']);
		session_destroy();
		setcookie('weblogin', $cookie, time()-3600 -1, '/');
	}	
	
	
	/** 
	 * Check, if cookie present, the consistence of cookie inside DB
	 *
	 * @return void
	 * @access public
	 * @param string cookie the cookie value stored in login cookie
	 */
	function checkRemember($cookie) {
		list($cookiesess,$username) = explode("|",$cookie);
		if (!$username or !$cookiesess) 
			return;
		$query = "SELECT * FROM f_users WHERE username = '$username' AND cookie = '$cookiesess|$username' and valid=1";
		$result = $this->dsn->getRow($query);
		if (is_object($result)) {
				$this->registerLogin($result);
		}
	}

	
	/** 
	 * Check for a login, first checking the presence of a uvalid session, 
	 * next checking for a cookie called weblogin
	 * next checking parameters against a DB
	 * Before Returining it Set the session 
	 *
	 * @param string $username User name (from a form)
	 * @param string $password Password (from a form)
	 * @param int $remember If set, it save the login in a persistent cookie
	 * @return boolean
	 * @access public
	 * @see registerLogin()
	 */
	function checkLogin ($username='', $password='',$remember='') {
		$this->password=$password;
		$this->username=$username;
		if (session_is_registered('valid')) {
			$this->username=$_SESSION['username'];
			$this->valid=$_SESSION['valid'];
			$this->id=$_SESSION['id'];
			$this->cookie=$_SESSION['cookie'];
			return 1;
		} elseif (isset($_COOKIE['weblogin']) ) {
			$this->checkRemember($_COOKIE['weblogin']);
			return 1;
		} else {
			$query="SELECT * FROM f_users WHERE username='$username' AND password='$password' and valid=1";
			$result = $this->dsn->getRow($query);
			if(is_object($result)) {
				$this->registerLogin($result,$remember);
				return 1;
			} 
			else {
				session_unset();
				session_destroy();
				return 0;
			}
			$db->disconnect();
		}	
	}
	/** 
	 * If Login is ok it sets the session if remember its present it save the cookie
	 *
	 * @return void
	 * @access private
	 * @see checkLogin()
	 * @param int remember Chek if saving to cookie or not
	 * @param Object values a row of values from db query
	 */
	function registerLogin (&$values,$remember='') {
		$_SESSION['username'] = $values->username;
		$_SESSION['id'] = $values->id;
		$_SESSION['valid']=1;
		$_SESSION['cookie']=$values->cookie;
		if ($remember)
			$this->updateCk($values->cookie,true);
		return 1;
			
		
	}
	
	/** 
	 * Update user cookie and db entry
	 *
	 * @return void
	 * @access private
	 * @see checkLogin()
	 * @param String cookie value of cookie
	 * @param Boolean save if its really going to save (debugging only!)
	 */
	function updateCk($cookie, $save) {
	 	if ($save) {
	 		
	 		mt_srand((double) microtime() * 1000000);
	    		 $this->cookie = md5(mt_rand())."|".$this->username;              
	     		 setcookie('weblogin', $this->cookie, time() + 31104000, '/');
	     		 $_SESSION['cookie'] = $this->cookie;
	     		 $query="UPDATE f_users set cookie='".$this->cookie."' where id=".$_SESSION['id'];
			 $this->dsn->query($query);
	     		 
	  	 }
	}
	
}

/** 
* this function return a pointer to DB connection
* params are self explanatory
*/
	function &db_connection() {
		require_once 'DB.php';
		PEAR::setErrorHandling(PEAR_ERROR_DIE);
		$host = 'localhost';
		$user = 'root';
		$dpass = '';
		$name = 'filer';
		$dsn_string = "mysql://$user:$pass@$host/$name";
		$db = DB::connect($dsn_string);
		$db->setFetchMode(DB_FETCHMODE_OBJECT);
		return $db;
	}
?>