#!/usr/local/bin/php -qC
<?php
	// Warning
	if ((int)implode('', explode('.', phpversion())) < 430) {
		echo 'This script requires PHP 4.3.x or higher!' . "\r\n";
		exit;
	}

	/**
    * Returns a list of files in the supplied directory,
	* or if the supplied arg is a file, an array containing
	* this filename.
    */
	function getFileList($filename)
	{
		$files = array();

		if (is_dir($filename)) {
			$dir = opendir($filename);
			while ($file = readdir($dir)) {
				if ($file == '.' OR $file == '..') continue;
				
				// Recurse
				if (is_dir($filename . DIRECTORY_SEPARATOR . $file)) {
					$files = array_merge($files, getFileList($filename . DIRECTORY_SEPARATOR . $file));
				} elseif (is_readable($filename . DIRECTORY_SEPARATOR . $file)) {
					$files[] = realpath($filename . DIRECTORY_SEPARATOR . $file);
				}
			}
			
		} else {
			$files[] = realpath($filename);
		}

		return $files;
	}

	/**
    * Script begins
    */

	// Correct arguments?
	if ($_SERVER['argc'] <= 1) {
		die('Please specify a file or directory to parse');
	}

	/**
    * Load translations
    */
	foreach (array('de', 'big5', 'br', 'es', 'fr', 'hu', 'id', 'it', 'mn', 'nl', 'pl', 'ru', 'se', 'template') as $language) {
		if (isset($LANG)) unset($LANG);
		include(dirname(__FILE__) . "/lang.$language.php");
		$LANGS[$language] = $LANG;
	}
	unset($LANG);

	/**
    * Get a list of files first
    */
	$filelist = getFileList($_SERVER['argv'][1]);

	/**
    * Loop thru files looking for lang()s
    */
	$allLangs  = array();

	foreach ($filelist as $file) {
		$contents = file_get_contents($file);
		preg_match_all("/lang\('(\\'|.+)'\)/U", $contents, $matches);
		
		$allLangs = array_merge($allLangs, $matches[1]);
	}
	
	$allLangs = array_values(array_unique($allLangs));
	sort($allLangs);

	/**
    * Unescape any values
    */
	foreach ($allLangs as $k => $v) {
		$allLangs[$k] = str_replace("\\'", "'", $v);
	}
	
	/**
    * Create the template file
    */
	$fp = fopen('lang.template.php', 'wb');
	fwrite($fp, "<?php\r\n");

	foreach ($allLangs as $value) {
		$line = str_pad(sprintf("\t\$LANG['%s']", str_replace("'", "\\'", $value)), 80, ' ') . ' = \'\';' . "\r\n";
		fwrite($fp, $line);
	}
	
	fwrite($fp, "?>");
	fclose($fp);
	
	/**
    * Update the LANGS variable with any phrases that
	* are new.
    */
	foreach ($LANGS as $language => $translations) {

		foreach ($allLangs as $langItem) {
			if (!isset($LANGS[$language][$langItem])) {
				$LANGS[$language][$langItem] = '';
			}
		}
		
		ksort($LANGS[$language]);
	}
	

	/**
    * Create the lang files
    */
	foreach ($LANGS as $language => $translations) {
		$filename = "lang.$language.php";
		$fp = fopen($filename, 'wb');
		fwrite($fp, "<?php\r\n");

		foreach ($translations as $k => $v) {
			$line = str_pad(sprintf("\t\$LANG['%s']", str_replace("'", "\\'", $k)), 80, ' ') . ' = \'' . str_replace("'", "\\'", $v) . '\';' . "\r\n";
			fwrite($fp, $line);
		}

		fwrite($fp, "?>");
		fclose($fp);
	}
?>