<?php
/**
* Filename.......: template.wrapper.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/28 15:19:23 $
* CVS Revision...: $Revision: 1.3 $
* Copyright......: 2001-2004 Richard Heyes
*/

/**
* Function to generate and send Etag: header
*/
	function sendEtagHeader($contents)
	{
		header('Etag: ' . ($etag = md5($contents)) );
		
		return $etag;
	}

/**
* Check some needed variables are set
*/
	$tpl_logged_in    = @$SESSION['login']['logged_in'];

	$tpl_folders      = auth::is_logged_in() ? $mailaccess->capabilities('folders') : false;
	$tpl_search       = auth::is_logged_in() ? $mailaccess->capabilities('search')  : false;
	$tpl_poll_mail    = auth::is_logged_in() ? ($HOSTINFO['allow_fetchmail'] AND $tpl_folders) : false;

	if(!isset($tpl_charset)) $tpl_charset = lang('ISO-8859-1');
	if(!isset($tpl_title))   $tpl_title   = $CONFIG['app_name'] . ' ' . $CONFIG['app_ver'];
	
	// Send X-Powered-By version header.
	if ($CONFIG['send_version_header']) {
		header('X-Powered-By: ' . $CONFIG['app_name'] . ' ' . $CONFIG['app_ver']);
	}

/**
* Include the template
*/
	$orig_template = $template;
	$template      = get_template($template);
	
	if($template !== FALSE) {

		// Ensure notices are off
		$error_reporting = error_reporting();
		error_reporting($error_reporting & ~E_NOTICE);

		// Send the content type header with charset parameter
		header('Content-Type: text/html; charset=' . $tpl_charset);
		header('Expires:');
		header('Cache-Control:');
		
		// Include the template file with or without gzip Compression
		if(@$HOSTINFO['http_compression']){
			ob_start('ob_gzhandler');

				// This ob_start() is to enable Etag: header computation
				ob_start();
					include($template);
					$contents = ob_get_contents();
				ob_end_clean();

				$etag = sendEtagHeader($contents);
				if (!empty($_SERVER['HTTP_IF_NONE_MATCH']) AND $_SERVER['HTTP_IF_NONE_MATCH'] == $etag) {
					header('HTTP/1.1 304 Not Modified');
					exit;
				} else {
					echo $contents;
				}
					
			ob_end_flush();
		} else {
			// This ob_start() is to enable Etag: header computation
			ob_start();
				include($template);
				$contents = ob_get_contents();
			ob_end_clean();

			$etag = sendEtagHeader($contents);
			if (!empty($_SERVER['HTTP_IF_NONE_MATCH']) AND $_SERVER['HTTP_IF_NONE_MATCH'] == $etag) {
				header('HTTP/1.1 304 Not Modified');
				exit;
			} else {
				echo $contents;
			}
		}


		// Put error_reporting back to it's original value
		error_reporting($error_reporting);

	}else{
		die('Coudln\'t find template: <b>'. $orig_template . '</b>');
	}
?>