<?php
/**
* Filename.......: prepend.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/02/02 22:24:15 $
* CVS Revision...: $Revision: 1.6 $
* Copyright......: 2001-2004 Richard Heyes
*/


    error_reporting(E_ALL ^ E_NOTICE);

/**
* If X-Moz set to prefetch, exit
*/
    if (strcasecmp(@$_SERVER['HTTP_X_MOZ'], 'prefetch') == 0) {
        exit;
    }

/**
* Customised config file?
*/
    if (file_exists('local.config.php')) {
        include('local.config.php');
    }

/**
* Includes
*/
    // FIXME Remove includes/input.php from cvs
    include_once($CONFIG['includes'] . 'common.php');
    include_once($CONFIG['includes'] . 'auth.php');
    include_once($CONFIG['includes'] . 'functions.php');
    include_once($CONFIG['pear_dir'] . 'HTML/TreeMenu.php'); // Must be before session.php
    include_once($CONFIG['includes'] . 'session.php');
    //include_once($CONFIG['includes'] . 'database.php');
    include_once($CONFIG['includes'] . 'mailaccess.php');
    include_once($CONFIG['includes'] . 'browser.php');
    include_once($CONFIG['includes'] . 'identities.php');
    include_once($CONFIG['includes'] . 'javascript.php');
    include_once($CONFIG['includes'] . 'addressbook.php');
    include_once($CONFIG['pear_dir'] . 'Log.php');
    include_once($CONFIG['pear_dir'] . 'Log/file.php');

/**
* Create the logging object
*/
    $logger = &new Log_file($CONFIG['log_dir'] . sprintf('error.%s.log', date('Y-m-d')), '', array(), $CONFIG['log_level']);
    
/**
* Set the error handler
*/
    set_error_handler('errorHandler');

/**
* Include hooks file?
*/
    if (file_exists($CONFIG['includes'] . 'local.hooks.php')) {
        include_once($CONFIG['includes'] . 'local.hooks.php');
    }

/**
* Parse configuration file
*/
    $configfile = $CONFIG['conf_dir'] . 'local.config.xml';
    if (!is_readable($configfile)) {
        $configfile = $CONFIG['conf_dir'] . 'config.xml';
    }

    require_once($CONFIG['includes'] . 'cachedConfig.php');
    $config = new cachedConfig($configfile, $CONFIG['tmp_dir']);
    $config->setBasePath('v-webmail/configuration/');

/**
 * If configuration file cannot be parsed, show error message.
 */
    if ($config->isError()) {
    	include($CONFIG['includes'] . 'config.checks.php');
    }

    // Map new configuration data to old
    $HOSTINFO  = $config->getValue('hostinfo');
    $HOSTINFO['default_tpl_set']   = $HOSTINFO['templates']['default'];

    $CONFIG['c-client']            = $config->getValue('general/c-client');
    $CONFIG['default_lang']        = $config->getValue('general/default_lang');
    $CONFIG['config_checks']       = $config->getValue('general/config_checks');
    $CONFIG['prefs_storage']       = $config->getValue('general/prefs_storage');
    $CONFIG['send_version_header'] = $config->getValue('general/send_version_header');

/**
* App name/version
*/
    $CONFIG['app_name'] = 'V-webmail';
    $CONFIG['app_ver']  = '1.6.4';
    $CONFIG['app_compiletime']  = '20060405';

/**
* Setup the $SESSION (no underscore) variable
*/
    if (ini_get('register_globals')) {
        $SESSION = &$session_global_var;
    } else {
        $SESSION = &$_SESSION['session_global_var'];
    }

/**
* Need to check ip address stored in session?
*/
    if (auth::is_logged_in() AND @$checkIP) {
        if (@$SESSION['login']['ip_address'] != common::getClientIP()) {
            $SESSION = array();
            session_destroy();
            common::redirect('login.php', lang('Your IP address appears to have changed. Please re-authenticate.'));
        }

        unset($ip_address);
        unset($checkIP);
    }

/**
* Clear any variables created thru
* register_globals
*/
    if (ini_get('register_globals')) {
        foreach ($_POST   as $key => $value) unset($$key);
        foreach ($_GET    as $key => $value) unset($$key);
        foreach ($_SERVER as $key => $value) unset($$key);
        foreach ($_ENV    as $key => $value) unset($$key);
    }

/**
* Create the userprefs var. Since
* it's a reference, it won't throw errors if
* not set.
*/
    $USERPREFS = &$SESSION['userprefs'];

/**
* Load the mailaccess stuff
*/
    if (auth::is_logged_in()) {
        $mailaccess = mailaccess::factory();
    }

/**
* Determine which language file to
* include. If default is english,
* don't need to include one.
*/
    if (isset($LANG)){
        unset($LANG);
    }

    // Include default lang file
    if ($CONFIG['default_lang'] != 'en' && !empty($CONFIG['default_lang'])) {
        include_once($CONFIG['lang_dir'] . 'lang.' . $CONFIG['default_lang'] . '.php');
    }

    // Include chosen lang file
    if (file_exists($CONFIG['lang_dir'] . 'lang.' . @$SESSION['common']['lang'] . '.php')) {
        include($CONFIG['lang_dir'] . 'lang.' . @$SESSION['common']['lang'] . '.php');
    }
    
/**
* Magic quotes
*/
    $_POST = stripslashes_r($_POST);
    $_GET  = stripslashes_r($_GET);

    ini_set('magic_quotes_runtime', '0');

/**
* Default mail polling to on
*/
    if (!isset($HOSTINFO['allow_fetchmail'])) {
        $HOSTINFO['allow_fetchmail'] = true;
    }

/**
* Create the browser object
*/
    $useragent = &new browser();

?>
