<?php
/**
* Filename.......: preferences/postgres.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

/**
* This class uses postgres to store preferences
* information. It uses a simple table of the
* format:

CREATE SEQUENCE userprefs_userprefs_id_seq;
CREATE TABLE userprefs (
	userprefs_id smallint DEFAULT nextval('userprefs_userprefs_id_seq') NOT NULL,
	userprefs_host varchar(128) DEFAULT '' NOT NULL,
	userprefs_user varchar(64) DEFAULT '' NOT NULL,
	userprefs_data text DEFAULT '' NOT NULL,
	PRIMARY KEY (userprefs_id)
);
CREATE UNIQUE INDEX host_user ON userprefs (userprefs_host, userprefs_user);

* Feel free to adjust the column sizes as required.
*/

class preferencesPostgres extends preferences
{
	var $connection;
	var $host;
	var $user;
	var $pass;
	var $dbas;
	var $tabl;

	/**
    * Constructor function. Takes the parameters
	* array passed to it from the factory function
    */
	function preferencesPostgres($driver)
	{
		$this->host = $driver['hostname'];
		$this->user = $driver['username'];
		$this->pass = $driver['password'];
		$this->dbas = $driver['database'];
		$this->tabl = !empty($driver['table']) ? $driver['table'] : 'userprefs';

		if (!empty($driver['hostname'])) $options[] = 'host='     . $driver['hostname'];
		if (!empty($driver['username'])) $options[] = 'user='     . $driver['username'];
		if (!empty($driver['password'])) $options[] = 'password=' . $driver['password'];
		if (!empty($driver['database'])) $options[] = 'dbname='   . $driver['database'];

		$this->connection = pg_connect(implode(' ', $options));
	}

	/**
    * This function returns the requested user
	* prefs from the database.
    */
	function read($unique_id, $default_file = 'default.user')
	{
		global $CONFIG, $SESSION;
		// FIXME logging would be nice here if queries fail

		$result = pg_exec($this->connection, sprintf("SELECT userprefs_data FROM %s WHERE userprefs_host = '%s' AND userprefs_user = '%s'", $this->tabl, addslashes($SESSION['email']['srvr']), addslashes($unique_id)));
		if ($result AND pg_numrows($result) == 1) {
			return @unserialize(current(pg_fetch_array($result, 0, PGSQL_ASSOC)));

		// Load default 
		} else {
			require($CONFIG['conf_dir'] . $default_file . '.php');
			@include($CONFIG['conf_dir'] . 'local.' . $default_file . '.php');

			if (!isset($DEFAULT)) {
				$DEFAULT = array();
			}

			pg_exec($this->connection, sprintf("INSERT INTO %s (userprefs_host, userprefs_user, userprefs_data) VALUES('%s', '%s', '%s')", $this->tabl, addslashes($SESSION['email']['srvr']), addslashes($unique_id), addslashes(serialize($DEFAULT))));

			return $DEFAULT;
		}
	}

	/**
    * This function writes the preferences
	* to a file.
    */
	function write($unique_id, $data)
	{
		global $SESSION;
		if (!$res = @pg_exec($this->connection, sprintf("INSERT INTO %s (userprefs_host, userprefs_user, userprefs_data) VALUES('%s', '%s', '%s')", $this->tabl, addslashes($SESSION['email']['srvr']), addslashes($unique_id), addslashes(serialize($data))))) {
			$res = pg_exec($this->connection, sprintf("UPDATE %s SET userprefs_data = '%s' WHERE userprefs_host = '%s' AND userprefs_user = '%s'", $this->tabl, addslashes(serialize($data)), addslashes($SESSION['email']['srvr']), addslashes($unique_id)));
		}
		
		return $res;
	}
}
?>