<?php
/**
* Filename.......: preferences/mysql.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/02/03 23:06:26 $
* CVS Revision...: $Revision: 1.4 $
* Copyright......: 2001-2004 Richard Heyes
*/

/**
* This class uses mysql to store preferences
* information. It uses a simple table of the
* format:

CREATE TABLE userprefs (
  userprefs_id mediumint(8) unsigned NOT NULL auto_increment,
  userprefs_host varchar(128) NOT NULL default '',
  userprefs_user varchar(64) NOT NULL default '',
  userprefs_data text NOT NULL,
  PRIMARY KEY  (userprefs_id),
  UNIQUE KEY host_user (userprefs_host,userprefs_user)
) TYPE=MyISAM;

* Feel free to adjust the column sizes as required.
*/

class preferencesMysql extends preferences
{
	var $connection;
	var $host;
	var $user;
	var $pass;
	var $dbas;
	var $tabl;

	/**
    * Constructor function. Takes the parameters
	* array passed to it from the factory function
    */
	function preferencesMysql($driver)
	{
		$this->host = $driver['hostname'];
		$this->user = $driver['username'];
		$this->pass = $driver['password'];
		$this->dbas = $driver['database'];
		$this->tabl = !empty($driver['table']) ? $driver['table'] : 'userprefs';

		$this->connection = mysql_connect($this->host, $this->user, $this->pass);
		if (!$this->connection) {
			$GLOBALS['logger']->log(sprintf('Failed to connect to MySQL: (%s)', mysql_error()), LOG_ERR);
		}
		mysql_select_db($this->dbas, $this->connection);
	}

	/**
    * This function returns the requested user
	* prefs from the database.
    */
	function read($unique_id, $default_file = 'default.user')
	{
		global $CONFIG, $SESSION;

		$result = mysql_query(sprintf("SELECT userprefs_data FROM %s WHERE userprefs_host = '%s' AND userprefs_user = '%s'", $this->tabl, mysql_escape_string($SESSION['email']['srvr']), mysql_escape_string($unique_id)), $this->connection);
		if ($result AND mysql_num_rows($result) == 1) {

			$data = mysql_fetch_array($result, MYSQL_ASSOC);
			return unserialize(current($data));

		// Load default
		} elseif ($result AND mysql_num_rows($result) == 0) {
			require($CONFIG['conf_dir'] . $default_file . '.php');
			@include($CONFIG['conf_dir'] . 'local.' . $default_file . '.php');

			if (!isset($DEFAULT)) {
				$DEFAULT = array();
			}

			mysql_query(sprintf("INSERT INTO %s (userprefs_host, userprefs_user, userprefs_data) VALUES('%s', '%s', '%s')", $this->tabl, mysql_escape_string($SESSION['email']['srvr']), mysql_escape_string($unique_id), mysql_escape_string(serialize($DEFAULT))), $this->connection);

			return $DEFAULT;

		// Error
		} else {
			$GLOBALS['logger']->log(sprintf('Preference selection query failed: (%s)', mysql_error()), LOG_ERR);
		}
	}

	/**
    * This function writes the preferences
	* to a file.
    */
	function write($unique_id, $data)
	{
		global $SESSION;
		if (!$res = mysql_query(sprintf("INSERT INTO %s (userprefs_host, userprefs_user, userprefs_data) VALUES('%s', '%s', '%s')", $this->tabl, mysql_escape_string($SESSION['email']['srvr']), mysql_escape_string($unique_id), mysql_escape_string(serialize($data))), $this->connection)) {
			$res = mysql_query(sprintf("UPDATE %s SET userprefs_data = '%s' WHERE userprefs_host = '%s' AND userprefs_user = '%s'", $this->tabl, mysql_escape_string(serialize($data)), mysql_escape_string($SESSION['email']['srvr']), mysql_escape_string($unique_id)), $this->connection);
		}

		return $res;
	}
}
?>