<?php
/**
* Filename.......: preferences/file.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

/**
* This class uses files to store and
* retrieve the prefs. Serialises the data
* first and then writes to a file. The files
* are held in a single level directory structure:
* <servername>/<username>
*/
class preferencesFile extends preferences
{
	var $data_dir;

	/**
    * Constructor function. Takes the parameters
	* array passed to it from the factory function
    */
	function preferencesFile($driver)
	{
		global $CONFIG;
		$this->data_dir = $CONFIG['data_dir'];
	}

	/**
    * This function reads the prefs in from 
	* a file. If the second argument is false
	* then the 3 level dir structure will not
	* be used, and the file will be read in
	* from {data_dir}
    */
	function read($unique_id, $default_file = 'default.user')
	{
		global $SESSION, $CONFIG;

		$path = $this->data_dir . $SESSION['email']['srvr'] . DIRECTORY_SEPARATOR . $unique_id;

		// If doesn't exist, create it
		if (!file_exists($path)) {
			if (!file_exists($this->data_dir . $SESSION['email']['srvr'])) {
				@mkdir($this->data_dir . $SESSION['email']['srvr'], 0770);
				@chmod($this->data_dir . $SESSION['email']['srvr'], 0770);
			}

			require($CONFIG['conf_dir'] . $default_file . '.php');
			@include($CONFIG['conf_dir'] . 'local.' . $default_file . '.php');

			if (!isset($DEFAULT)) {
				$DEFAULT = array();
			}

			// Write new prefs out			
			$fp = @fopen($path, 'w');
			if ($fp AND flock($fp, LOCK_EX)) {
				fseek($fp, 0);
				fwrite($fp, serialize($DEFAULT));
			} else {
				$GLOBALS['logger']->log(sprintf('Failed to open file: (%s) for writing. Check permissions.', $path), PEAR_LOG_ERR);
			}

			return $DEFAULT;
		}

		//Load it up
		if ($path) {
			$contents = fread(fopen($path, 'r'), filesize($path));

			if ($unserialized = @unserialize($contents)) {
				return $unserialized;

			} else {
				$GLOBALS['logger']->log(sprintf('Failed to unserialize() preferences. Prefs data: %s', $contents));
				return false;
			}

		} else {
			return false;
		}
	}

	/**
    * This function writes the preferences
	* to a file.
    */
	function write($unique_id, $data)
	{
		global $SESSION;

		$path       = $this->data_dir . $SESSION['email']['srvr'] . DIRECTORY_SEPARATOR . $unique_id;
		$serialized = serialize($data);

		if ($fp = @fopen($path, 'w')) {
			return @fwrite($fp, $serialized);
		} else {
			$GLOBALS['logger']->log(sprintf('Unable to write to preferences file, (is_writable() reports: %s)', is_writeable($path) ? 'true' : 'false'), LOG_ERR);
			return false;
		}
	}
}
?>