<?php
/**
* Filename.......: mailaccess.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

class mailaccess
{
	/**
    * Factory function creates the mailaccess object
    */
	function &factory($driver = null)
	{
		global $CONFIG;

		if (is_null($driver)) {
			$driver = mailaccess::getDriverName();
		}
		$class = 'mailaccess_' . $driver;

		require_once($CONFIG['includes'] . sprintf('mailaccess/%s.php', $driver));
		return new $class();
	}

	/**
	* Returns an appropriate object.
	*/
	function getDriverName()
	{
		global $SESSION, $CONFIG;

		$accountType = $SESSION['email']['type'];

		$capabilities['imapext'] = extension_loaded('imap');
		$capabilities['pop3']    = file_exists($CONFIG['includes'] . 'mailaccess/pop3/driver.php');

		switch(true){
			case (in($accountType, 'pop3', 'pop3/notls', 'pop3/ssl', 'pop3/ssl/novalidate-cert', 'imap', 'imap/notls', 'imap/ssl', 'imap/ssl/novalidate-cert') AND $capabilities['imapext']):
				return 'imapext';
				break;

			case (in($accountType, 'pop3', 'pop3/notls') AND $capabilities['pop3']):
				return 'pop3';
				break;

			default:
				@session_destroy();
				die('No mailaccess drivers available! You NEED the IMAP extension!');
		}
	}
    


    

	/**
    * Clears the cache
    */	
	function cacheClear()
	{
		global $SESSION;

		if (isset($SESSION['cache'])) {
			unset($SESSION['cache']);
		}
	}

	/**
    * Adds something to the cache
    */
	function cacheAdd($uid, $data)
	{
		global $SESSION;
		$SESSION['cache'][$uid] = $data;
	}
	
	/**
    * Removes an object from the cache
    */	
	function cacheRemove($uid)
	{
		global $SESSION;

		if (isset($SESSION['cache'][$uid])) {
			unset($SESSION['cache'][$uid]);
		}
	}

	/**
    * Retrieves an object from the cache
    */	
	function cacheGet($uid)
	{
		global $SESSION;
		return isset($SESSION['cache'][$uid]) ? $SESSION['cache'][$uid] : FALSE;
	}
}
?>