<?php
/***************************************
** Filename.......: class.input.inc
** Project........: V-webmail
** Last Modified..: 03 November 2001
** Copyright......: Richard Heyes 2001
***************************************/

class input{

	/***************************************
    ** Parses the flags parameter of validate()
    ***************************************/

	function parse_flags($flags){

		$flags = explode(',', $flags);
		for($i=0; $i<count($flags); $i++){
			$flags[$i] = explode('=', $flags[$i]);
		}
		return $flags;
	}

	/***************************************
    ** Parses the entries parameter of validate()
	** and init() and stripslashes()
    ***************************************/

	function parse_entries($entries){

		return (strpos($entries, ',') !== FALSE) ? explode(',', $entries) : array($entries);
	}

	/***************************************
    ** Performs the validation
    ***************************************/

	function validate(&$src, $entries, $flags = 'noempty', $extra = NULL){

		$entries = input::parse_entries($entries);
		$flags   = input::parse_flags($flags);

		if(isset($extra))
			$extra = (array)$extra;

		$result  = TRUE;

		foreach($entries as $entry){
			for($i=0; $i<count($flags); $i++){
				switch($flags[$i][0]){
					case 'noempty':
						if(!isset($src[$entry]) OR (empty($src[$entry]) AND $src[$entry] !== '0') )
							$result = FALSE;
						break;

					case 'regex':
						if(!isset($src[$entry]) OR !preg_match($extra[$flags[$i][1]], $src[$entry]))
							$result = FALSE;
						break;
						
					case 'comparewith':
						if(!isset($src[$entry]) OR $src[$entry] != $src[$flags[$i][1]])
							$result = FALSE;
						break;

					case 'init':
						$init_to = (isset($flags[$i][1])) ? $extra[$flags[$i][1]] : '';
						input::init($src, $entry, $init_to);
						break;
				}
			}
		}
		
		return $result;
	}

	/***************************************
    ** Initialise the $entries keys of $src
	** to $init_to
    ***************************************/

	function init(&$src, $entries, $init_to = ''){

		$entries = input::parse_entries($entries);

		foreach($entries as $entry){

			if(!isset($src[$entry]))
				$src[$entry] = $init_to;
		}
	}

	/***************************************
    ** *Conditionally* stripsslashes. If first
	** arg is not an array, then it will be
	** stripped, otherwise the stuff in the array
	** will be stripped, recursively
    ***************************************/

	function stripslashes(&$src, $entries = ''){

		if(is_array($src)){
			if(empty($keys)){
				foreach($src as $key => $value){
					input::stripslashes($src[$key]);
				}
			}else{
				$entries = $this->parse_entries($entries);
				for($i=0; $i<count($entries); $i++){
					input::stripslashes($src[$entries[$i]]);
				}
			}

		}else{
			$src = ini_get('magic_quotes_gpc') ? stripslashes($src) : $src;
		}

		if(is_array($src))
			reset($src);

		return $src;
	}

	/***************************************
    ** *Conditionally* addsslashes. This function
	** is reverse of above.
    ***************************************/

	function addslashes(&$src, $entries = ''){

		if(is_array($src)){
			if(empty($keys)){
				foreach($src as $key => $value){
					input::addslashes($src[$key]);
				}
			}else{
				$entries = $this->parse_entries($entries);
				for($i=0; $i<count($entries); $i++){
					input::addslashes($src[$entries[$i]]);
				}
			}

		}else{
			$src = ini_get('magic_quotes_gpc') ? $src : addslashes($src);
		}

		if(is_array($src))
			reset($src);

		return $src;
	}

	/***************************************
    ** Performs htmlspecialchars() function
	** in a manner similar to above two functions
    ***************************************/

	function htmlspecialchars(&$src, $entries = ''){

		if(is_array($src)){
			if(empty($keys)){
				foreach($src as $key => $value){
					input::htmlspecialchars($src[$key]);
				}
			}else{
				$entries = $this->parse_entries($entries);
				for($i=0; $i<count($entries); $i++){
					input::htmlspecialchars($src[$entries[$i]]);
				}
			}

		}else{
			$src = htmlspecialchars($src);
		}

		if(is_array($src))
			reset($src);

		return $src;
	}
}

?>