<?php
/**
* Filename.......: identities.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

class identities
{
	/**
    * Retrieves a list of identities
    */
	function getIdentityList($selected = 0)
	{
		$identities = array();

		if (!empty($GLOBALS['USERPREFS']['identities'])) {
			foreach ($GLOBALS['USERPREFS']['identities'] as $id => $identity) {
				$identities[$id] = $identity;
				if ($id == $selected) {
					$identities[$id]['selected'] = 'selected="selected"';
				}
			}
		}
		
		return $identities;
	}
	
	/**
    * Stores a property of an identitiy
    */
	function setProperty($identity, $property, $value)
	{
		if ($identity > 0 AND !empty($GLOBALS['USERPREFS']['identities'][$identity])) {
			$GLOBALS['USERPREFS']['identities'][$identity][$property] = $value;
		} else {
			$GLOBALS['USERPREFS']['settings'][$property] = $value;
		}
	}
	
	/**
    * Gets a property of an identity
    */
	function getProperty($identity, $property)
	{
		if ($identity > 0 AND !empty($GLOBALS['USERPREFS']['identities'][$identity])) {
			return $GLOBALS['USERPREFS']['identities'][$identity][$property];
		} else {
			return $GLOBALS['USERPREFS']['settings'][$property];
		}
	}
}

?>