<?php
/**
* Filename.......: hooks.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/03/07 11:13:05 $
* CVS Revision...: $Revision: 1.3 $
* Copyright......: 2001-2004 Richard Heyes
*/

/**
* What is the purpose of this file?
* 
* This file contains various "hooks", which
* are basically functions which, if defined,
* are called at particular times in the
* application. most are for easier extending
* and/or custumisation.
*
* IMPORTANT!
* Modifying this file WILL NOT work, make a copy,
* call it local.hooks.php and edit that instead.
*/

/**
* This function is called during login. It
* takes an argument of the username/password
* and returns a two element array of username
* and password eg:
* array('username, 'password')
* Amongst other things, it can be used in
* particular for doing username aliasing. An
* example of this is below. This is a basic
* example that could be extended to ldap/db
* lookups.
*/
	function hook_usernameLookup($username, $password)
	{
		$_users['publicj'] = 'actualusername_1';
		$_users['foobar']  = 'actualusername_2';
		
		if (!empty($_users[$username])) {
			return array($_users[$username], $password);
		} else {
			return array($username, $password);
		}
	}

/**
* This function is called during login. It is
* however only called if the users email_address
* preference is blank, (it's therefore not called
* if the option allow_changeable_email is Off).
* It allows you to set a default email address
* for the user, so they aren't confused when the
* system won't allow them to send mail. The function
* should return a single string, which is the
* intended email address.
*
* This default function uses the "domain" option
* of the current server (from the local.servers.php
* config file) and combines it with the username, to
* build the email address. You could, for example,
* use this function to lookup the email address in 
* a database, or perhaps an LDAP directory.
*/
	function hook_emailLookup($username)
	{
		global $_POST, $SERVERS;

		$domain = $SERVERS[@(int)$_POST['server_id']]['domain'];

		return !empty($domain) ? sprintf('%s@%s', $username, $domain) : '';
	}

/**
* This function is called every time when an URL
* which points to some V-Webmail component is
* built. Components include images and scripts.
*
* The default is to leave the URLs as they are.
*
* One possible use for this hook is to convert
* http-URLs to https-URLs, allowing for SSL 
* access to V-Webmail via an SSL proxy.
* For example:
*    $mangledURL = preg_replace('@http://.*?my-domain\.com/v-webmail@i', 'https://ssl.ssl-proxy.com/my-domain.com/v-webmail', $url, 1);
*/
	function hook_rewriteURL($url)
	{
		return $url;	// <- Remove this line to activate the hook.
		$mangledURL = preg_replace('@http://.*?my-domain\.com/v-webmail@i', 'https://ssl.ssl-proxy.com/my-domain.com/v-webmail', $url, 1);
		return $mangledURL;
	}
?>