<?php
/**
* Filename.......: functions.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

	/**
    * Parses and potentially caches a config
    * file.
	* 
	* @param string $conf_file The config file to parse
    */
	function config_file($conf_file)
	{
		global $CONFIG, $SERVERS, $HOSTS;

		$filename = file_exists($CONFIG['conf_dir'] . 'local.' . $conf_file) ? $CONFIG['conf_dir'] . 'local.' . $conf_file : $CONFIG['conf_dir'] . $conf_file;
		if(@filemtime($filename) > @filemtime($CONFIG['tmp_dir'] . $conf_file . '.tmp') OR @!include_once($CONFIG['tmp_dir'] . $conf_file . '.tmp')){
			include($CONFIG['includes'] . 'parse.ini.inc');
		}
	}
	
	/**
	* The error handler. Logs all errors php and otherwise to the
	* V-webmail error log.
	* 
	* @param int    $level   Error level of error
	* @param string $message Error message
	* @param string $file    Filename where error occurred
	* @param int    $line    Line number where error occurred
	*/
	function errorHandler($level, $message, $file, $line)
	{
		// Log the error (not notices)
		if ($level != 8 AND $level != 1024) {
			$GLOBALS['logger']->log(sprintf("ERROR: %s (%s)", $message, $file));
		}

		// Ensure we need to handle this error type
		if ((error_reporting() & $level) != $level) {
			return;
		}

		// Read the offending area of the file
		$fp = fopen($file, 'r');
		if ($fp) {
			for ($i=1; !feof($fp) AND $i<=($line + 5); ++$i) {
				// Only 5 lines previous to error line
				if ($i >= ($line - 5)) {
					$areaOfFile[] = "($i) " . fgets($fp, 1024);
					
					// Embolden the error line
					if ($i == $line) {
						$areaOfFile[count($areaOfFile) - 1] = '<strong style="border: 1px solid black; background-color: white">' . $areaOfFile[count($areaOfFile) - 1] . "</strong>";
					}
				} else {
					fgets($fp, 1024);
				}
			}
			fclose($fp);
		}

		// Determine the error level of the error
		switch ($level) {
			case 1:   $errorType = 'E_ERROR';			break;
			case 2:   $errorType = 'E_WARNING';			break;
			case 4:   $errorType = 'E_PARSE';			break;
			case 8:   $errorType = 'E_NOTICE';			break;
			case 16:  $errorType = 'E_CORE_ERROR';		break;
			case 32:  $errorType = 'E_CORE_WARNING';	break;
			case 64:  $errorType = 'E_COMPILE_ERROR';	break;
			case 128: $errorType = 'E_COMPILE_WARNING';	break;
			case 256: $errorType = 'E_USER_ERROR';		break;
			case 512: $errorType = 'E_USER_WARNING';	break;
			case 1024:$errorType = 'E_USER_NOTICE';		break;
		}
		?>
		<div style="background-color: #ffaaaa; border: 2px black dotted; margin: 5px; padding: 2px; font-family: monospace">
		<strong>
			Error:<br />
		</strong>
		<strong>Type.........:</strong> <?=$errorType?><br />
		<strong>Message......:</strong> <?=$message?><br />
		<strong>File.........:</strong> <?=$file?><br />
		<strong>Area in File.:</strong> (<?=$line?>) <?=implode("<br />\r\n.............: ", $areaOfFile)?>
		</div>
		<?php
	}

	/**
    * Returns a full path to a template
    */
	function get_template($template)
	{
		global $CONFIG, $SESSION, $TPL;
	
		if (isset($SESSION['common']['tpl_set'])) {
	
			// local. file present?
			if (file_exists($CONFIG['tpl_dir'] . $SESSION['common']['tpl_set'] . '/local.' . $template)) {
				return $CONFIG['tpl_dir'] . $SESSION['common']['tpl_set'] . '/local.' . $template;
	
			// Original file?
			} elseif (file_exists($CONFIG['tpl_dir'] . $SESSION['common']['tpl_set'] . '/' . $template)) {
				return $CONFIG['tpl_dir'] . $SESSION['common']['tpl_set'] . '/' . $template;
	
			// Fallback to templates/v-webmail/
			} else {
	
				// local. file present?
				if (file_exists($CONFIG['tpl_dir'] . 'v-webmail/local.' . $template)) {
					return $CONFIG['tpl_dir'] . 'v-webmail/local.' . $template;
	
				// Original file?
				} elseif (file_exists($CONFIG['tpl_dir'] . 'v-webmail/' . $template)) {
					return $CONFIG['tpl_dir'] . 'v-webmail/' . $template;
	
				} else {
					return FALSE;
				}
			}
	
		} elseif (isset($SESSION['common']['default_tpl_set'])) {

			// local. file
			if (file_exists($CONFIG['tpl_dir'] . $SESSION['common']['default_tpl_set'] . '/local.' . $template)) {
				return $CONFIG['tpl_dir'] . $SESSION['common']['default_tpl_set'] . '/local.' . $template;
	
			// Original file
			} elseif (file_exists($CONFIG['tpl_dir'] . $SESSION['common']['default_tpl_set'] . '/' . $template)) {
				return $CONFIG['tpl_dir'] . $SESSION['common']['default_tpl_set'] . '/' . $template;

			// Fallback to v-webmail
			} else {
				// local. file present?
				if (file_exists($CONFIG['tpl_dir'] . 'v-webmail/local.' . $template)) {
					return $CONFIG['tpl_dir'] . 'v-webmail/local.' . $template;
	
				// Original file?
				} elseif (file_exists($CONFIG['tpl_dir'] . 'v-webmail/' . $template)) {
					return $CONFIG['tpl_dir'] . 'v-webmail/' . $template;
	
				} else {
					return FALSE;
				}
			}
	
		} else {
			return FALSE;
		}
	}

	/**
    * Lang function returns the appropriate
	* text from $LANG given an identifier.
    */
	function lang($text)
	{
		if (@$GLOBALS['SESSION']['common']['lang'] == 'en') {
			return $text;

		} elseif (empty($GLOBALS['LANG'][$text])) {
			return $text;

		} else {
			return $GLOBALS['LANG'][$text];
		}
	}

	/**
    * Loads userprefs. Merges with default.user.php in config/
	* to make sure everybody has correct preferences.
    */
	function loadPrefs($id)
	{
		global $CONFIG;

		include_once($CONFIG['includes'] . 'preferences.php');
		$prefs = &preferences::factory($CONFIG['prefs_storage']);

		return $prefs->read($id, 'default.user');
	}

	/**
    * Saves preferences information
    */
	function savePrefs()
	{
		global $CONFIG, $SESSION, $USERPREFS;

		$uid  = $SESSION['login']['username'];
		$data = $USERPREFS;

		include_once($CONFIG['includes'] . 'preferences.php');
		$prefs = &preferences::factory($CONFIG['prefs_storage']);

		return $prefs->write($uid, $data);
	}

	/**
    * Loads addressbook data
    */
	function loadAddressbook()
	{
		global $CONFIG, $SESSION;

		include_once($CONFIG['includes'] . 'preferences.php');
		$prefs = &preferences::factory($CONFIG['prefs_storage']);

		$addressbook = $prefs->read($SESSION['login']['username'] . '.addressbook', 'default.addressbook');
		if (!$addressbook) {
			$addressbook = array();
		}
		// Migration code from old addressbook to new
		if (!isset($addressbook['addresses']) AND !isset($addressbook['groups'])) {
			$uid = 1;
			foreach ($addressbook as $key => $val) {
				$addressbook[$key]['uid'] = $uid++;
			}
			return array('addresses' => $addressbook, 'groups' => array(), 'uid' => $uid);
		} else {
			return $addressbook;
		}
	}

	/**
    * Saves addressbook information
    */
	function saveAddressbook($data)
	{
		global $CONFIG, $SESSION;

		include_once($CONFIG['includes'] . 'preferences.php');
		$prefs = &preferences::factory($CONFIG['prefs_storage']);

		return $prefs->write($SESSION['login']['username'] . '.addressbook', $data);
	}

	/**
    * Recursive htmlspecialchars
    */
	function htmlspecialchars_r($input)
	{
		return applyFunction($input, 'htmlspecialchars');
	}
	
	/**
    * Recursive CONDITIONAL stripslashes
    */
	function stripslashes_r($input)
	{
		return ini_get('magic_quotes_gpc') ? applyFunction($input, 'stripslashes') : $input;
	}

	/**
    * Recursively applies a function to an array
    */
	function applyFunction($input, $function)
	{
		if (is_array($input)) {
			foreach ($input as $key => $value) {
				$input[$key] = applyFunction($input[$key], $function);
			}
		} else {
			$input = $function($input);
		}

		return $input;
	}

	/**
    * Swaps to entries in an array
    */
	function array_swap($array, $a, $b)
	{
		if (isset($array[$a]) AND isset($array[$b])) {
			$data_a    = $array[$a];
			$array[$a] = $array[$b];
			$array[$b] = $data_a;
		}

		return $array;
	}
	
	/**
    * in() function. First argument is the thing that should be
	* checked in the later arguments.
    */
	function in()
	{
		if (count($args = func_get_args()) > 1) {
			for ($i=1; $i<count($args); $i++) {
				if ($args[0] == $args[$i]) {
					return true;
				}
			}
		}
		
		return false;
	}
?>
