<?php
/**
* Filename.......: email.list.search.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

/**
* Search routine
*/
	$tpl_is_search = true;

/**
* One folder...
*/
	if (!isset($SESSION['search']['folders']) OR count($SESSION['search']['folders']) == 1) {
		$SESSION['email']['mbox'] = $SESSION['search']['folders'][0];
		include($CONFIG['includes'] . 'email.list.normal.php');
		return;
	}

/**
* Normal list routine for mailbox
*/
	if ($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['search']['folders'][0])) {

		$SESSION['email']['mbox'] = '';

		/**
        * Get list of subscribed folders
        */
		if ($mailaccess->capabilities('folders')) {

			list($folders, $folderTree) = $mailaccess->getSubscribedFolders();
			for ($i=0; $i<count($folders); $i++) {
				if ($folders[$i]['noselect'] == true) {
					$folders[$i]['name'] = '';
				}
			}
			array_unshift($folders, array('name' => '', 'noselect' => '', 'name_htmlsafe' => '', 'name_urlsafe' => '', 'text' => ''));
		}

		/**
        * Perform search...
        */
		$_msg_ids   = array();
		$mail_list  = array();
		$total_msgs = 0;

		for ($i=0; $i<count($SESSION['search']['folders']); $i++) {
			if ($i != 0) {
				if(!$mailaccess->reconnect($SESSION['search']['folders'][$i])){
					continue;
				}
			}

			// Get msg_ids
			$msg_ids = $mailaccess->getMsgIds($order_by, $ascdesc, 1, 0, !empty($SESSION['search']['string']) ? $SESSION['search']['string'] : 'ALL', $num_msgs);
			$total_msgs	+= $num_msgs;
			// Add the msg_ids to the _msg_ids tmp var
			for ($j=0; $j<count($msg_ids); $j++) {
				$_msg_ids[] = array('mailbox' => $SESSION['search']['folders'][$i], 'msg_id' => $msg_ids[$j]);
			}

			unset($msg_ids);
		}

		/**
        * Store the above
        */
		$SESSION['email']['message_ids'] = $_msg_ids;

		/**
        * Init some vars
        */
		$num_msgs = $total_msgs;
		$_msg_ids = array_slice($_msg_ids, $start_msg - 1, $show_per_page);
		$_folders = array();
		$j   = -1;
		$row = 0;

		/**
	    * Include the code to parse the results
	    */
	    require($CONFIG['includes'] . 'email.list.buildsearchresults.php');

	} else {
		$logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
		die(lang('Failed to connect to account!'));
	}
?>
