<?php
/**
* Filename.......: email.list.quicksearch.php
* Project........: V-webmail
* Last Modified..: $Date: 2006/01/25 00:04:47 $
* CVS Revision...: $Revision: 1.2 $
* Copyright......: 2001-2004 Richard Heyes
*/

/**
* Search routine
*/
	$tpl_is_search = true;

/**
* Normal list routine for mailbox
*/
	if ($mailaccess->connect($SESSION['email']['srvr'], $SESSION['email']['user'], base64_decode($SESSION['email']['pass']), $SESSION['email']['port'], $SESSION['email']['type'], $SESSION['email']['mbox'])) {

		/**
        * Get list of subscribed folders
        */
		if ($mailaccess->capabilities('folders')) {

			list($folders, $folderTree) = $mailaccess->getSubscribedFolders();
			for ($i=0; $i<count($folders); $i++) {
				if ($folders[$i]['noselect'] == true) {
					$folders[$i]['name'] = '';
				}
			}
			array_unshift($folders, array('name' => '', 'noselect' => '', 'name_htmlsafe' => '', 'name_urlsafe' => '', 'text' => ''));
		}

		/**
		* Get all msg ids, otherwise we can't sort the results
		*/
		if (!isset($SESSION['quicksearch']['msg_ids'][$order_by][$ascdesc])) { // Must use isset as it can be empty

			$allMsgIDs = array_flip($mailaccess->getMsgIds($order_by, $ascdesc, 1, 0, 'ALL', $num_msgs));
			foreach ($allMsgIDs as $k => $v) {
				$allMsgIDs[$k] = 0;
			}

			/**
	        * Perform search
	        */
			$_msg_ids   = array();
			$mail_list  = array();
			$total_msgs = 0;

			foreach ($SESSION['quicksearch']['criteria'] as $criterion) {
				// Escape any quotes
				$criterion = strtr($criterion, array('"' => '\\"'));
				
				// Search all fields
				foreach (array('SUBJECT', 'BODY', 'FROM', 'TO', 'CC') as $searchField) {
					$msg_ids = $mailaccess->getMsgIds($order_by, $ascdesc, 1, 0, "$searchField $criterion", $num_msgs);
					foreach ($msg_ids as $msg_id) {
						$allMsgIDs[$msg_id] = true;
					}
				}
			}
			
			/**
			* Now walk through allMsgIDs and find those ids which are set to true
			* putting $_msg_ids into the correct format for the next part of the
			* code.
			*/
			foreach ($allMsgIDs as $k => $v) {
				if ($v) {
					$_msg_ids[] = array('mailbox' => $SESSION['email']['mbox'], 'msg_id' => $k);
				}
			}

		} else {
			$_msg_ids = $SESSION['quicksearch']['msg_ids'][$order_by][$ascdesc];
		}

		/**
        * Store the above for both caching the search, and
		* allowing for next/back on view message page.
        */
		$SESSION['email']['message_ids'] = $_msg_ids;
		$SESSION['quicksearch']['msg_ids'][$order_by][$ascdesc] = $_msg_ids;

		/**
        * Init some vars
        */
		$num_msgs = $total_msgs = count($_msg_ids);
		$_msg_ids = array_slice($_msg_ids, $start_msg - 1, $show_per_page);
		$_folders = array();
		$j   = -1;
		$row = 0;

		/**
	    * Include the code to parse the results
	    */
	    require($CONFIG['includes'] . 'email.list.buildsearchresults.php');

	} else {
		$logger->log(sprintf('Connection to mail server failed: %s', $mailaccess->getErrors()));
		die(lang('Failed to connect to account!'));
	}
?>
